/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.typeinference.evaluators.phpdoc;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.evaluation.types.MultiTypeType;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocBlock;
import org.eclipse.php.internal.core.compiler.ast.nodes.PHPDocTag;
import org.eclipse.php.internal.core.compiler.ast.nodes.UsePart;
import org.eclipse.php.internal.core.index.IPHPDocAwareElement;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;
import org.eclipse.php.internal.core.typeinference.PHPSimpleTypes;
import org.eclipse.php.internal.core.typeinference.PHPTypeInferenceUtils;
import org.eclipse.php.internal.core.typeinference.evaluators.AbstractMethodReturnTypeEvaluator;
import org.eclipse.php.internal.core.typeinference.goals.AbstractMethodReturnTypeGoal;

public class PHPDocMethodReturnTypeEvaluator
extends AbstractMethodReturnTypeEvaluator {
    private static final Pattern ARRAY_TYPE_PATTERN = Pattern.compile("array\\[.*\\]");
    private static final String SELF_RETURN_TYPE = "self";
    private static final Pattern PIPE_PATTERN = Pattern.compile("\\|");
    private final List<IEvaluatedType> evaluated = new LinkedList<IEvaluatedType>();

    public PHPDocMethodReturnTypeEvaluator(IGoal goal) {
        super(goal);
    }

    public IGoal[] init() {
        IMethod[] iMethodArray = this.getMethods();
        int n = iMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            String type;
            int n3;
            SimpleReference[] simpleReferenceArray;
            IMethod method = iMethodArray[n2];
            IType currentNamespace = PHPModelUtils.getCurrentNamespace((IModelElement)method);
            String[] typeNames = null;
            if (method instanceof IPHPDocAwareElement) {
                typeNames = ((IPHPDocAwareElement)method).getReturnTypes();
            } else {
                LinkedList<String> returnTypeList = new LinkedList<String>();
                PHPDocBlock docBlock = PHPModelUtils.getDocBlock(method);
                if (docBlock == null) {
                    return IGoal.NO_GOALS;
                }
                PHPDocTag[] tags = docBlock.getTags(6);
                if (tags != null && tags.length > 0) {
                    PHPDocTag[] pHPDocTagArray = tags;
                    int n4 = tags.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        PHPDocTag phpDocTag = pHPDocTagArray[n5];
                        if (phpDocTag.getReferences() != null && phpDocTag.getReferences().length > 0) {
                            simpleReferenceArray = phpDocTag.getReferences();
                            n3 = simpleReferenceArray.length;
                            int n6 = 0;
                            while (n6 < n3) {
                                SimpleReference ref = simpleReferenceArray[n6];
                                type = ref.getName();
                                if (type != null) {
                                    returnTypeList.add(type);
                                }
                                ++n6;
                            }
                        }
                        ++n5;
                    }
                }
                typeNames = returnTypeList.toArray(new String[returnTypeList.size()]);
            }
            if (typeNames != null) {
                String[] stringArray = typeNames;
                int n7 = typeNames.length;
                int n8 = 0;
                while (n8 < n7) {
                    String typeName = stringArray[n8];
                    Matcher m = ARRAY_TYPE_PATTERN.matcher(typeName);
                    if (m.find()) {
                        int offset = 0;
                        try {
                            offset = method.getSourceRange().getOffset();
                        }
                        catch (ModelException modelException) {}
                        this.evaluated.add((IEvaluatedType)this.getArrayType(m.group(), currentNamespace, offset));
                    } else {
                        AbstractMethodReturnTypeGoal goal = (AbstractMethodReturnTypeGoal)this.getGoal();
                        IType[] types = goal.getTypes();
                        if (typeName.equals(SELF_RETURN_TYPE) && types != null) {
                            simpleReferenceArray = types;
                            n3 = types.length;
                            int n9 = 0;
                            while (n9 < n3) {
                                SimpleReference t = simpleReferenceArray[n9];
                                type = this.getEvaluatedType(t.getElementName(), currentNamespace);
                                if (type != null) {
                                    this.evaluated.add((IEvaluatedType)type);
                                }
                                ++n9;
                            }
                        } else {
                            IEvaluatedType type2;
                            if (currentNamespace != null) {
                                String prefix;
                                String fullName;
                                Map<String, UsePart> result;
                                PHPDocBlock docBlock = PHPModelUtils.getDocBlock(method);
                                ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)currentNamespace.getSourceModule());
                                if (typeName.indexOf(92) > 0) {
                                    String prefix2 = typeName.substring(0, typeName.indexOf(92));
                                    result = PHPModelUtils.getAliasToNSMap(prefix2, moduleDeclaration, docBlock.sourceStart(), currentNamespace, true);
                                    if (result.containsKey(prefix2)) {
                                        fullName = result.get(prefix2).getNamespace().getFullyQualifiedName();
                                        typeName = typeName.replace(prefix2, fullName);
                                    }
                                } else if (typeName.indexOf(92) < 0 && (result = PHPModelUtils.getAliasToNSMap(prefix = typeName, moduleDeclaration, docBlock.sourceStart(), currentNamespace, true)).containsKey(prefix)) {
                                    typeName = fullName = result.get(prefix).getNamespace().getFullyQualifiedName();
                                }
                            }
                            if ((type2 = this.getEvaluatedType(typeName, currentNamespace)) != null) {
                                this.evaluated.add(type2);
                            }
                        }
                    }
                    ++n8;
                }
            }
            ++n2;
        }
        return IGoal.NO_GOALS;
    }

    private MultiTypeType getArrayType(String type, IType currentNamespace, int offset) {
        String[] typeNames;
        int beginIndex = type.indexOf("[") + 1;
        int endIndex = type.lastIndexOf("]");
        type = type.substring(beginIndex, endIndex);
        MultiTypeType arrayType = new MultiTypeType();
        Matcher m = ARRAY_TYPE_PATTERN.matcher(type);
        if (m.find()) {
            arrayType.addType((IEvaluatedType)this.getArrayType(m.group(), currentNamespace, offset));
            type = m.replaceAll("");
        }
        String[] stringArray = typeNames = type.split(",");
        int n = typeNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (!"".equals(name)) {
                if (name.indexOf(92) > 0 && currentNamespace != null) {
                    ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)currentNamespace.getSourceModule());
                    String prefix = name.substring(0, name.indexOf(92));
                    Map<String, UsePart> result = PHPModelUtils.getAliasToNSMap(prefix, moduleDeclaration, offset, currentNamespace, true);
                    if (result.containsKey(prefix)) {
                        String fullName = result.get(prefix).getNamespace().getFullyQualifiedName();
                        name = name.replace(prefix, fullName);
                    }
                }
                arrayType.addType(this.getEvaluatedType(name, currentNamespace));
            }
            ++n2;
        }
        return arrayType;
    }

    private IEvaluatedType getEvaluatedType(String typeName, IType currentNamespace) {
        Object type = PHPSimpleTypes.fromString(typeName);
        if (type == null) {
            if (typeName.indexOf(92) != -1 || currentNamespace == null) {
                type = new PHPClassType(typeName);
            } else if (currentNamespace != null) {
                type = new PHPClassType(currentNamespace.getElementName(), typeName);
            }
        }
        return type;
    }

    public Object produceResult() {
        return PHPTypeInferenceUtils.combineTypes(this.evaluated);
    }

    public IGoal[] subGoalDone(IGoal subgoal, Object result, GoalState state) {
        return IGoal.NO_GOALS;
    }
}

