/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.highlighters;

import java.util.Map;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.FunctionInvocation;
import org.eclipse.php.internal.core.ast.nodes.FunctionName;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.NamespaceDeclaration;
import org.eclipse.php.internal.core.model.PhpModelAccess;
import org.eclipse.php.internal.core.search.AbstractOccurrencesFinder;
import org.eclipse.php.internal.ui.editor.highlighter.AbstractSemanticApply;
import org.eclipse.php.internal.ui.editor.highlighter.AbstractSemanticHighlighting;
import org.eclipse.php.internal.ui.editor.highlighter.ModelUtils;
import org.eclipse.php.internal.ui.editor.highlighters.AbstractSemanticApplyWithNS;
import org.eclipse.swt.graphics.RGB;

public class InternalFunctionHighlighting
extends AbstractSemanticHighlighting {
    public AbstractSemanticApply getSemanticApply() {
        return new InternalFunctionApply(this.getSourceModule());
    }

    public void initDefaultPreferences() {
        this.getStyle().setEnabledByDefault(false).setDefaultTextColor(new RGB(0, 0, 192));
    }

    public String getDisplayName() {
        return "Internal functions";
    }

    public int getPriority() {
        return 110;
    }

    protected class InternalFunctionApply
    extends AbstractSemanticApplyWithNS {
        public InternalFunctionApply(ISourceModule sourceModule) {
            super(sourceModule);
        }

        public boolean visit(FunctionInvocation functionInvocation) {
            Expression functionName = functionInvocation.getFunctionName().getName();
            int invocationParent = functionInvocation.getParent().getType();
            if ((functionName.getType() == 33 || functionName.getType() == 65) && invocationParent != 53) {
                Identifier identifier = (Identifier)functionName;
                this.dealIdentifier(identifier);
            }
            return true;
        }

        private void dealIdentifier(Identifier identifier) {
            String fullName = AbstractOccurrencesFinder.getFullName((Identifier)identifier, (Map)this.fLastUseParts, (NamespaceDeclaration)this.fCurrentNamespace);
            IMethod[] elements = PhpModelAccess.getDefault().findMethods(fullName, ISearchEngine.MatchRule.EXACT, 0, 0, this.createSearchScope(), null);
            if (elements != null && elements.length == 1 && elements[0] != null && ModelUtils.isExternalElement((IModelElement)elements[0])) {
                InternalFunctionHighlighting.this.highlight((ASTNode)identifier);
            }
        }

        private boolean isInternalFunction(FunctionName functionName) {
            try {
                ISourceModule module = InternalFunctionHighlighting.this.getSourceModule();
                IModelElement[] elements = module.codeSelect(functionName.getStart(), functionName.getLength());
                if (elements.length == 1 && elements[0] != null) {
                    IModelElement element = elements[0];
                    return ModelUtils.isExternalElement(element);
                }
            }
            catch (ModelException e) {
                Logger.logException((Throwable)e);
            }
            return false;
        }
    }
}

