/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.etfw.tau;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ptp.core.util.LaunchUtils;
import org.eclipse.ptp.etfw.AbstractToolDataManager;
import org.eclipse.ptp.etfw.IBuildLaunchUtils;
import org.eclipse.ptp.etfw.internal.BuildLaunchUtils;
import org.eclipse.ptp.etfw.internal.RemoteBuildLaunchUtils;
import org.eclipse.ptp.etfw.tau.ITAULaunchConfigurationConstants;
import org.eclipse.ptp.etfw.tau.MultiFieldDialog;
import org.eclipse.ptp.etfw.tau.TAUPortalUploadDialog;
import org.eclipse.ptp.etfw.tau.messages.Messages;
import org.eclipse.ptp.etfw.tau.perfdmf.PerfDMFUIPlugin;
import org.eclipse.ptp.etfw.tau.perfdmf.views.PerfDMFView;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.MessageConsole;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TAUPerformanceDataManager
extends AbstractToolDataManager {
    private static String tbpath = null;
    boolean useExt = false;
    private IBuildLaunchUtils utilBlob = null;
    private IFileStore ppkFile = null;
    private IFileStore xmlFile = null;
    private List<IFileStore> profiles = null;
    private static final String PARAPROFCONSOLE = "TAU Profile Output";
    private static final String PROFDOT = "profile.";
    private static final String PROFXML = "tauprofile.xml";
    private static final String MULTI = "MULTI__";
    private static final String UNIX_SLASH = "/";

    private static String getTauMakefile(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("tau_makefile.performance.options.configuration_id_", null);
    }

    public void cleanup() {
    }

    public void setExternalTarget(boolean useExt) {
        this.useExt = useExt;
    }

    private static boolean madeProfiles(ILaunchConfiguration configuration, String projtype) throws CoreException {
        boolean profout;
        boolean tracout = configuration.getAttribute("use_epilog", false) || configuration.getAttribute("use_vampirtrace", false) || configuration.getAttribute("use_tau_tracing", false) || configuration.getAttribute("use_perf_library", false) || projtype.indexOf("-trace") >= 0;
        boolean bl = profout = configuration.getAttribute("use_callpath_profiling", false) || configuration.getAttribute("use_tau_phases", false) || configuration.getAttribute("use_memory_profiling", false) || projtype.indexOf("-profile") >= 0 || projtype.indexOf("-headroom") >= 0;
        return !tracout || profout;
    }

    private String[] findProfIDs(ILaunchConfiguration configuration) throws CoreException {
        String makename = TAUPerformanceDataManager.getTauMakefile(configuration);
        int tauDex = makename.lastIndexOf("tau-");
        String projtype = null;
        projtype = tauDex < 0 ? "tau" : makename.substring(tauDex + 4);
        String projtrial = BuildLaunchUtils.getNow();
        String expAppend = configuration.getAttribute("string that will override the default experiment identifier used in perfdmf storage", null);
        if (expAppend != null && expAppend.length() > 0) {
            projtype = String.valueOf(projtype) + "_" + expAppend;
        }
        String[] IDs = new String[]{projtype, projtrial};
        return IDs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkDirectory(String directory, IBuildLaunchUtils utils) {
        IFileStore d = utils.getFile(directory);
        boolean check = d.fetchInfo().exists();
        if (!check) {
            return false;
        }
        try {
            String[] children = d.childNames(0, null);
            int i = 0;
            while (true) {
                if (i >= children.length) {
                    return false;
                }
                if (children[i].contains(PROFXML)) return true;
                if (children[i].contains("profile.0.0.0")) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void process(String projname, ILaunchConfiguration configuration, String directory) throws CoreException {
        String perfexScript;
        boolean useperfex;
        boolean haveprofiles;
        String tmpDir;
        boolean dirgood;
        String projectDirectory = directory;
        boolean profsummary = configuration.getAttribute("print_profile_summary_only", false);
        BuildLaunchUtils tmpub = new BuildLaunchUtils();
        String pppath = tmpub.checkToolEnvPath("paraprof");
        boolean hasLocalParaprof = true;
        if (pppath == null || !tmpub.getFile(pppath).fetchInfo().exists()) {
            profsummary = true;
            hasLocalParaprof = false;
        }
        this.utilBlob = !(dirgood = this.checkDirectory(directory, (IBuildLaunchUtils)tmpub)) && LaunchUtils.getRemoteServicesId((ILaunchConfiguration)configuration) != null ? new RemoteBuildLaunchUtils(configuration) : tmpub;
        if (!dirgood && (tmpDir = this.utilBlob.getWorkingDirectory()) != null) {
            directory = tmpDir;
        }
        tbpath = this.utilBlob.getToolPath(Messages.TAUPerformanceDataManager_0);
        this.profiles = this.getProfiles(directory);
        this.xmlFile = this.utilBlob.getFile(directory).getChild(PROFXML);
        if (!this.xmlFile.fetchInfo().exists()) {
            this.xmlFile = null;
        }
        String projtype = null;
        String projtrial = null;
        if (this.useExt || projname == null) {
            String[] profIDs = TAUPerformanceDataManager.requestProfIDs();
            if (profIDs == null) {
                return;
            }
            projname = profIDs[0];
            projtype = profIDs[1];
            projtrial = profIDs[2];
        } else {
            String[] IDs = this.findProfIDs(configuration);
            projtype = IDs[0];
            projtrial = IDs[1];
        }
        boolean runtauinc = configuration.getAttribute("use_tauinc_script", false);
        boolean usePortal = configuration.getAttribute("upload_profiles_to_portal", false);
        if (this.xmlFile == null && this.profiles != null && this.profiles.size() > 0 || usePortal) {
            this.ppkFile = this.getPPKFile(directory, projname, projtype, projtrial);
        }
        if ((runtauinc || profsummary) && this.xmlFile != null && this.profiles != null && this.profiles.size() < 1) {
            ArrayList<String> xcon = new ArrayList<String>();
            xcon.add("paraprof");
            xcon.add("--dump");
            xcon.add(this.xmlFile.toURI().getPath());
            this.utilBlob.runToolGetOutput(xcon, null, directory);
            this.profiles = this.getProfiles(directory);
        }
        boolean bl = haveprofiles = this.useExt || TAUPerformanceDataManager.madeProfiles(configuration, projtype);
        if (!this.useExt && projtype.indexOf("-perf") > 0) {
            this.managePerfFiles(directory);
        }
        if (!haveprofiles) {
            return;
        }
        if ((this.profiles == null || this.profiles.size() < 1) && this.xmlFile == null && this.ppkFile == null) {
            TAUPerformanceDataManager.printNoProfsError();
            return;
        }
        boolean keepprofs = configuration.getAttribute("keep_profile_files", false);
        boolean useParametric = configuration.getAttribute("use the parametric analysis system", false);
        if (profsummary) {
            this.displayProfileSummary(directory);
        }
        if (runtauinc) {
            this.runTAUInc(directory, directory, projname, projtype, projtrial);
        }
        boolean hasdb = false;
        String database = null;
        if (hasLocalParaprof) {
            String xmlMetaData = configuration.getAttribute("string representation of xml metadata file for perfexplorer", null);
            database = PerfDMFView.extractDatabaseName((String)configuration.getAttribute("perfdmf_database_configuration", null));
            if (this.xmlFile != null) {
                hasdb = TAUPerformanceDataManager.addToDatabase(this.xmlFile, database, projname, projtype, projtrial, xmlMetaData);
            } else if (this.ppkFile != null) {
                hasdb = TAUPerformanceDataManager.addToDatabase(this.ppkFile, database, projname, projtype, projtrial, xmlMetaData);
            }
            if (!hasdb && !useParametric) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.TAUPerformanceDataManager_TAUWarning, (String)Messages.TAUPerformanceDataManager_AddingDataPerfDBFailed);
                    }
                });
            }
        }
        if (usePortal && this.ppkFile != null && this.ppkFile.fetchInfo().exists()) {
            TAUPerformanceDataManager.runPortal(this.ppkFile);
        }
        if (keepprofs || !hasdb || profsummary) {
            if (this.ppkFile != null) {
                this.movePakFile(projectDirectory, projtype, projtrial, this.ppkFile);
            }
            if (this.xmlFile != null) {
                this.movePakFile(projectDirectory, projtype, projtrial, this.xmlFile);
            }
        } else {
            if (this.ppkFile != null) {
                this.ppkFile.delete(0, null);
            }
            if (this.xmlFile != null) {
                this.xmlFile.delete(0, null);
            }
        }
        TAUPerformanceDataManager.removeProfiles(this.profiles);
        if (hasLocalParaprof && database != null && (useperfex = configuration.getAttribute("launch perfexplorer along with other tau profile management activity", false)) && (perfexScript = configuration.getAttribute("path to the perfexplorer script to use in parametric study", null)) != null && perfexScript.length() > 0) {
            this.runPerfEx(directory, database, projname, projtype, perfexScript);
        }
    }

    private static void printNoProfsError() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.TAUPerformanceDataManager_TAUWarning, (String)Messages.TAUPerformanceDataManager_NoProfData);
            }
        });
    }

    private void displayProfileSummary(String directory) {
        if (this.profiles == null || this.profiles.size() < 1) {
            TAUPerformanceDataManager.printNoProfsError();
            return;
        }
        ArrayList<String> ppl = new ArrayList<String>();
        ppl.add("pprof");
        ppl.add("-s");
        byte[] ppout = null;
        MessageConsole mc = this.findConsole(PARAPROFCONSOLE);
        mc.clearConsole();
        IOConsoleOutputStream os = mc.newOutputStream();
        if (!this.profiles.get(0).fetchInfo().isDirectory()) {
            ppout = this.utilBlob.runToolGetOutput(ppl, null, directory);
            try {
                os.write(ppout);
                os.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                int i = 0;
                while (i < this.profiles.size()) {
                    os.write(this.profiles.get(i).getName().getBytes());
                    ppout = this.utilBlob.runToolGetOutput(ppl, null, this.profiles.get(i).toURI().getPath());
                    os.write(ppout);
                    ++i;
                }
                os.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        mc.activate();
    }

    private MessageConsole findConsole(String name) {
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager conMan = plugin.getConsoleManager();
        IConsole[] existing = conMan.getConsoles();
        int i = 0;
        while (i < existing.length) {
            if (name.equals(existing[i].getName())) {
                return (MessageConsole)existing[i];
            }
            ++i;
        }
        MessageConsole myConsole = new MessageConsole(name, null);
        conMan.addConsoles(new IConsole[]{myConsole});
        return myConsole;
    }

    public void view() {
    }

    private static String[] requestProfIDs() {
        final String[] queries = new String[]{Messages.TAUPerformanceDataManager_AppName, Messages.TAUPerformanceDataManager_ExpName, Messages.TAUPerformanceDataManager_TrialName};
        final String[] values = new String[3];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                MultiFieldDialog mfd = new MultiFieldDialog(shell, queries);
                mfd.open();
                String[] outvals = mfd.getValues();
                int i = 0;
                while (i < values.length) {
                    values[i] = outvals[i];
                    ++i;
                }
            }
        });
        return values;
    }

    private List<IFileStore> getProfiles(String directory) {
        IFileStore[] profiles = null;
        IFileStore dir = this.utilBlob.getFile(directory);
        try {
            profiles = dir.childStores(0, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        ArrayList<IFileStore> profs = new ArrayList<IFileStore>();
        ArrayList<IFileStore> dirs = new ArrayList<IFileStore>();
        int i = 0;
        while (i < profiles.length) {
            IFileInfo proinfo = profiles[i].fetchInfo();
            if (!proinfo.isDirectory() && proinfo.getName().startsWith(PROFDOT)) {
                profs.add(profiles[i]);
            } else if (proinfo.isDirectory() && proinfo.getName().startsWith(MULTI)) {
                dirs.add(profiles[i]);
            }
            ++i;
        }
        if (profs.size() > 0) {
            return profs;
        }
        if (dirs.size() > 0) {
            return dirs;
        }
        return null;
    }

    private IFileStore getPPKFile(String directory, String projname, String projtype, String projtrial) {
        class PpPaker
        implements Runnable {
            public String ppk;
            private final /* synthetic */ String val$projname;
            private final /* synthetic */ String val$projtype;
            private final /* synthetic */ String val$projtrial;
            private final /* synthetic */ String val$directory;

            PpPaker(String string, String string2, String string3, String string4) {
                this.val$projname = string;
                this.val$projtype = string2;
                this.val$projtrial = string3;
                this.val$directory = string4;
            }

            public void run() {
                ArrayList<String> paraCommand = new ArrayList<String>();
                String ppkname = String.valueOf(this.val$projname) + "_" + this.val$projtype + "_" + this.val$projtrial + ".ppk";
                String paraprof = "";
                if (tbpath != null && tbpath.length() > 0) {
                    TAUPerformanceDataManager.this.utilBlob.getFile(tbpath);
                    paraprof = String.valueOf(paraprof) + tbpath + TAUPerformanceDataManager.UNIX_SLASH;
                }
                paraprof = String.valueOf(paraprof) + "paraprof";
                String pack = "--pack ";
                System.out.println(String.valueOf(paraprof) + " " + pack);
                this.ppk = String.valueOf(this.val$directory) + TAUPerformanceDataManager.UNIX_SLASH + ppkname;
                paraCommand.add(paraprof);
                paraCommand.add(pack);
                paraCommand.add(ppkname);
                TAUPerformanceDataManager.this.utilBlob.runTool(paraCommand, null, this.val$directory);
            }
        }
        PpPaker ppp = new PpPaker(projname, projtype, projtrial, directory);
        Display.getDefault().syncExec((Runnable)ppp);
        return this.utilBlob.getFile(ppp.ppk);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean addToDatabase(IFileStore profileFile, String database, String projname, String projtype, String projtrial, String xmlMetaData) {
        boolean hasdb = false;
        try {
            IFileStore local;
            if (database == null) return hasdb;
            if (database.equals(ITAULaunchConfigurationConstants.NODB)) return hasdb;
            if (!profileFile.fetchInfo().exists()) {
                return false;
            }
            File tmpprof = null;
            if (!profileFile.getFileSystem().equals(EFS.getLocalFileSystem())) {
                File f = profileFile.toLocalFile(4096, null);
                if (!f.exists()) {
                    return false;
                }
                tmpprof = new File(String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + profileFile.getName());
                TAUPerformanceDataManager.copyFile(f, tmpprof);
                String s = tmpprof.getCanonicalPath();
                URI suri = URI.create(s);
                local = EFS.getLocalFileSystem().getStore(suri);
            } else {
                local = profileFile;
            }
            class DBView
            implements Runnable {
                boolean hasdb = false;
                private final /* synthetic */ String val$projname;
                private final /* synthetic */ String val$projtype;
                private final /* synthetic */ String val$projtrial;
                private final /* synthetic */ IFileStore val$local;
                private final /* synthetic */ String val$database;

                DBView(String string, String string2, String string3, IFileStore iFileStore, String string4) {
                    this.val$projname = string;
                    this.val$projtype = string2;
                    this.val$projtrial = string3;
                    this.val$local = iFileStore;
                    this.val$database = string4;
                }

                public void run() {
                    this.hasdb = PerfDMFUIPlugin.addPerformanceData((String)this.val$projname, (String)this.val$projtype, (String)this.val$projtrial, (IFileStore)this.val$local, (String)this.val$database);
                }
            }
            DBView dbv = new DBView(projname, projtype, projtrial, local, database);
            Display.getDefault().syncExec((Runnable)dbv);
            hasdb = dbv.hasdb;
            if (tmpprof == null) return hasdb;
            tmpprof.delete();
            return hasdb;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static void copyFile(File sourceFile, File destFile) throws IOException {
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    private void movePakFile(String destDirectory, String projtype, String projtrial, IFileStore profileFile) {
        IFileStore profdir = this.utilBlob.getFile(destDirectory).getChild("Profiles").getChild(projtype).getChild(projtrial);
        try {
            profdir.mkdir(2, null);
            IFileStore dest = profdir.getChild(profileFile.getName());
            profileFile.move(dest, 2, null);
            MessageConsole mc = this.findConsole(PARAPROFCONSOLE);
            IOConsoleOutputStream os = mc.newOutputStream();
            os.write(("Moving profile data to: " + profileFile.toString()).getBytes());
            os.close();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void removeProfiles(List<IFileStore> remprofs) {
        if (remprofs == null || remprofs.size() == 0) {
            return;
        }
        boolean multipapi = remprofs.get(0).fetchInfo().isDirectory();
        try {
            int i = 0;
            while (i < remprofs.size()) {
                if (multipapi) {
                    IFileStore[] profs = remprofs.get(i).childStores(0, null);
                    int j = 0;
                    while (j < profs.length) {
                        profs[j].delete(0, null);
                        ++j;
                    }
                }
                remprofs.get(i).delete(0, null);
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void runTAUInc(String projDirectory, final String runDirectory, final String projname, final String projtype, final String projtrial) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                String mpilistname = String.valueOf(projname) + "_" + projtype + "_" + projtrial + ".includelist";
                String tauinc = "cd " + runDirectory + " ; ";
                if (tbpath != null && tbpath.length() > 0) {
                    tauinc = String.valueOf(tauinc) + tbpath + TAUPerformanceDataManager.UNIX_SLASH;
                }
                tauinc = String.valueOf(tauinc) + "tauinc.pl > " + mpilistname + " ; ";
                tauinc = String.valueOf(tauinc) + "cp " + mpilistname + " projDirectory";
                System.out.println(tauinc);
                try {
                    ArrayList<String> cmd = new ArrayList<String>();
                    cmd.add("sh");
                    cmd.add("-c");
                    cmd.add(tauinc);
                    TAUPerformanceDataManager.this.utilBlob.runTool(cmd, null, runDirectory);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void runPerfEx(String directory, String database, String projname, String projtype, String perfExScript) {
        ArrayList<String> script = new ArrayList<String>();
        script.add(perfExScript);
        script.add(" -c " + database);
        script.add(" -p app=" + projname + ",exp=" + projtype);
        this.utilBlob.runTool(script, null, directory);
    }

    private static boolean runPortal(final IFileStore ppkFile) {
        boolean hasdb = true;
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    TAUPortalUploadDialog pwDialog = new TAUPortalUploadDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), ppkFile);
                    int result = pwDialog.open();
                    if (result != 0 && result != 1) {
                        MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.TAUPerformanceDataManager_TAUWarning, (String)Messages.TAUPerformanceDataManager_AddingOnlineDBFailed);
                    }
                }
                catch (Exception exception) {
                    MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.TAUPerformanceDataManager_TAUWarning, (String)Messages.TAUPerformanceDataManager_AddingOnlineDBFailed);
                }
            }
        });
        return hasdb;
    }

    private void managePerfFiles(String directory) throws CoreException {
        IFileStore dir = this.utilBlob.getFile(directory);
        IFileStore[] perfdir = dir.childStores(0, null);
        if (perfdir == null || perfdir.length < 1) {
            return;
        }
        int count = 0;
        int i = 0;
        while (i < perfdir.length) {
            if (perfdir[i].fetchInfo().getName().startsWith("perf_data.")) {
                ++count;
            }
            ++i;
        }
        if (count == 0) {
            return;
        }
        ArrayList<String> command = new ArrayList<String>();
        String perf2tau = "";
        if (tbpath != null && tbpath.length() > 0) {
            perf2tau = String.valueOf(perf2tau) + UNIX_SLASH;
        }
        perf2tau = String.valueOf(perf2tau) + "perf2tau";
        command.add(perf2tau);
        this.utilBlob.runTool(command, null, directory);
    }

    public String getName() {
        return "process-TAU-data";
    }
}

