/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.pldt.openmp.core.actions;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ptp.pldt.common.Artifact;
import org.eclipse.ptp.pldt.common.ArtifactMarkingVisitor;
import org.eclipse.ptp.pldt.common.ScanReturn;
import org.eclipse.ptp.pldt.common.actions.RunAnalyseHandlerBase;
import org.eclipse.ptp.pldt.common.util.ViewActivator;
import org.eclipse.ptp.pldt.openmp.analysis.OpenMPError;
import org.eclipse.ptp.pldt.openmp.core.OpenMPArtifactMarkingVisitor;
import org.eclipse.ptp.pldt.openmp.core.OpenMPPlugin;
import org.eclipse.ptp.pldt.openmp.core.OpenMPScanReturn;
import org.eclipse.ui.texteditor.MarkerUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunAnalyseOpenMPcommandHandler
extends RunAnalyseHandlerBase {
    private static final String EXTENSION_POINT_ID = "org.eclipse.ptp.pldt.openmp.core.artifactAnalysis";
    private static final boolean traceOn = false;

    public RunAnalyseOpenMPcommandHandler() {
        super("OpenMP", (ArtifactMarkingVisitor)new OpenMPArtifactMarkingVisitor("org.eclipse.ptp.pldt.openmp.core.openMPMarker"), "org.eclipse.ptp.pldt.openmp.core.openMPMarker");
    }

    public ScanReturn doArtifactAnalysis(ITranslationUnit tu, List<String> includes) {
        boolean allowPrefixOnlyMatch = OpenMPPlugin.getDefault().getPreferenceStore().getBoolean("openmpRecognizeAPIsByPrefixAlone");
        return this.runArtifactAnalysisFromExtensionPoint(EXTENSION_POINT_ID, tu, includes, allowPrefixOnlyMatch);
    }

    protected void processResults(ScanReturn results, IResource resource) {
        assert (results instanceof OpenMPScanReturn);
        OpenMPScanReturn osr = (OpenMPScanReturn)results;
        List<Artifact> artifacts = osr.getOpenMPList();
        this.visitor.visitFile(resource, artifacts);
        this.removeProblemMarkers(resource);
        LinkedList<OpenMPError> problems = osr.getProblems();
        try {
            Iterator i = problems.iterator();
            while (i.hasNext()) {
                this.processProblem((OpenMPError)i.next(), resource);
            }
        }
        catch (CoreException e) {
            System.out.println("RunAnalysisOpenMP.processResults exception: " + (Object)((Object)e));
            e.printStackTrace();
        }
    }

    private void processProblem(OpenMPError problem, IResource resource) throws CoreException {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("description", problem.getDescription());
        attrs.put("resource", problem.getFilename());
        attrs.put("infoldername", problem.getPath());
        attrs.put("location", new Integer(problem.getLineno()));
        attrs.put("problem", problem);
        MarkerUtilities.createMarker((IResource)resource, attrs, (String)"org.eclipse.ptp.pldt.openmp.ui.pv.openMPProblemMarker");
    }

    private void removeProblemMarkers(IResource resource) {
        try {
            resource.deleteMarkers("org.eclipse.ptp.pldt.openmp.ui.pv.openMPProblemMarker", false, 2);
        }
        catch (CoreException e) {
            System.out.println((Object)e);
            System.out.println(e.toString());
            System.out.println("Problem deleting markers on OMP Problems: " + resource.getProjectRelativePath());
        }
    }

    protected List<String> getIncludePath() {
        return OpenMPPlugin.getDefault().getIncludeDirs();
    }

    protected void activateArtifactView() {
        ViewActivator.activateView((String)"org.eclipse.ptp.pldt.openmp.core.views.OpenMPArtifactView");
    }

    protected void activateProblemsView() {
        ViewActivator.activateView((String)"org.eclipse.ptp.pldt.openmp.ui.pv.views.OpenMPProblemsView");
    }
}

