/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.sync.core;

import java.util.Map;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.IRemoteServices;
import org.eclipse.ptp.remote.core.PTPRemoteCorePlugin;

public class BuildScenario {
    private static final String ATTR_SYNC_PROVIDER = "sync-provider";
    private static final String ATTR_REMOTE_CONNECTION_ID = "remote-connection-id";
    private static final String ATTR_LOCATION = "location";
    private static final String ATTR_REMOTE_SERVICES_ID = "remote-services-id";
    final String syncProvider;
    final IRemoteConnection remoteConnection;
    final String location;

    public BuildScenario(String sp, IRemoteConnection rc, String l) {
        this.syncProvider = sp;
        this.remoteConnection = rc;
        this.location = l;
    }

    public String getSyncProvider() {
        return this.syncProvider;
    }

    public IRemoteConnection getRemoteConnection() {
        return this.remoteConnection;
    }

    @Deprecated
    public String getLocation() {
        return this.location;
    }

    public String getLocation(IProject project) {
        return BuildScenario.resolveString(project, this.location);
    }

    public static String resolveString(IProject project, String path) {
        if (!path.startsWith("${") || !path.endsWith("}")) {
            return path;
        }
        String newPath = path.substring(2, path.length() - 1);
        String variable = newPath.split(":")[0];
        IPathVariableManager pvm = project.getPathVariableManager();
        String value = pvm.getURIValue(variable.toUpperCase()).toString();
        if (value == null) {
            return path;
        }
        if ((value = value.replaceFirst("file:", "")).endsWith("/") || value.endsWith("\\")) {
            value = value.substring(0, path.length() - 1);
        }
        return newPath.replaceFirst(String.valueOf(variable) + ":*", value);
    }

    public void saveScenario(Map<String, String> map) {
        if (this.syncProvider != null) {
            map.put(ATTR_SYNC_PROVIDER, this.syncProvider);
        }
        map.put(ATTR_REMOTE_CONNECTION_ID, this.remoteConnection.getName());
        map.put(ATTR_LOCATION, this.location);
        map.put(ATTR_REMOTE_SERVICES_ID, this.remoteConnection.getRemoteServices().getId());
    }

    public static BuildScenario loadScenario(Map<String, String> map) {
        String sp = map.get(ATTR_SYNC_PROVIDER);
        String rc = map.get(ATTR_REMOTE_CONNECTION_ID);
        String l = map.get(ATTR_LOCATION);
        String rs = map.get(ATTR_REMOTE_SERVICES_ID);
        if (rc == null || l == null || rs == null) {
            return null;
        }
        IRemoteServices remoteService = PTPRemoteCorePlugin.getDefault().getRemoteServices(rs);
        if (remoteService == null) {
            return null;
        }
        IRemoteConnection remoteConnection = remoteService.getConnectionManager().getConnection(rc);
        if (remoteConnection == null) {
            return null;
        }
        return new BuildScenario(sp, remoteConnection, l);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.location == null ? 0 : this.location.hashCode());
        result = 31 * result + (this.remoteConnection == null ? 0 : this.remoteConnection.hashCode());
        result = 31 * result + (this.syncProvider == null ? 0 : this.syncProvider.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BuildScenario other = (BuildScenario)obj;
        if (this.location == null ? other.location != null : !this.location.equals(other.location)) {
            return false;
        }
        if (this.remoteConnection == null ? other.remoteConnection != null : !this.remoteConnection.equals(other.remoteConnection)) {
            return false;
        }
        return !(this.syncProvider == null ? other.syncProvider != null : !this.syncProvider.equals(other.syncProvider));
    }
}

