/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.sync.ui;

import java.util.EnumSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ptp.rdt.sync.core.ISyncExceptionHandler;
import org.eclipse.ptp.rdt.sync.core.SyncFlag;
import org.eclipse.ptp.rdt.sync.core.SyncManager;
import org.eclipse.ptp.rdt.sync.core.resources.RemoteSyncNature;
import org.eclipse.ptp.rdt.sync.ui.CommonSyncExceptionHandler;
import org.eclipse.ptp.rdt.sync.ui.RDTSyncUIPlugin;
import org.eclipse.ptp.rdt.sync.ui.messages.Messages;

public class ResourceChangeListener {
    private static IResourceChangeListener resourceListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            if (event.getType() == 4) {
                IProject project = (IProject)event.getResource();
                if (!RemoteSyncNature.hasNature((IProject)project)) {
                    return;
                }
                SyncManager.setSyncMode((IProject)project, (SyncManager.SYNC_MODE)SyncManager.SYNC_MODE.UNAVAILABLE);
                return;
            }
            IResourceDelta[] iResourceDeltaArray = event.getDelta().getAffectedChildren();
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta delta = iResourceDeltaArray[n2];
                IProject project = delta.getResource().getProject();
                if (project == null) {
                    return;
                }
                if (RemoteSyncNature.hasNature((IProject)project)) {
                    SyncManager.SYNC_MODE syncMode = SyncManager.getSyncMode((IProject)project);
                    boolean syncOn = true;
                    if (!SyncManager.getSyncAuto() || syncMode == SyncManager.SYNC_MODE.NONE) {
                        syncOn = false;
                    }
                    try {
                        if (event.getType() == 16 && event.getBuildKind() != 9) {
                            if (syncOn && syncMode != SyncManager.SYNC_MODE.UNAVAILABLE) {
                                if (syncMode == SyncManager.SYNC_MODE.ALL) {
                                    SyncManager.syncAll(null, (IProject)project, (EnumSet)SyncFlag.FORCE, (ISyncExceptionHandler)new CommonSyncExceptionHandler(true, true));
                                } else if (syncMode == SyncManager.SYNC_MODE.ACTIVE) {
                                    SyncManager.sync(null, (IProject)project, (EnumSet)SyncFlag.FORCE, (ISyncExceptionHandler)new CommonSyncExceptionHandler(true, true));
                                }
                            }
                        } else if (delta.getKind() == 4 && syncMode != SyncManager.SYNC_MODE.UNAVAILABLE) {
                            if (!syncOn) {
                                SyncManager.sync((IResourceDelta)delta, (IProject)project, (EnumSet)SyncFlag.NO_SYNC, null);
                            } else if (syncMode == SyncManager.SYNC_MODE.ALL) {
                                SyncManager.syncAll((IResourceDelta)delta, (IProject)project, (EnumSet)SyncFlag.NO_FORCE, (ISyncExceptionHandler)new CommonSyncExceptionHandler(true, false));
                            } else if (syncMode == SyncManager.SYNC_MODE.ACTIVE) {
                                SyncManager.sync((IResourceDelta)delta, (IProject)project, (EnumSet)SyncFlag.NO_FORCE, (ISyncExceptionHandler)new CommonSyncExceptionHandler(true, false));
                            }
                        }
                    }
                    catch (CoreException e) {
                        RDTSyncUIPlugin.log(Messages.ResourceChangeListener_0, e);
                    }
                }
                ++n2;
            }
        }
    };

    private ResourceChangeListener() {
    }

    public static void startListening() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(resourceListener, 21);
    }

    public static void stopListening() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(resourceListener);
    }
}

