/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.ibm.pe.ui.wizards;

import java.util.StringTokenizer;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ptp.remote.core.IRemoteFileManager;
import org.eclipse.ptp.remote.ui.IRemoteUIFileManager;
import org.eclipse.ptp.remote.ui.IRemoteUIServices;
import org.eclipse.ptp.remote.ui.PTPRemoteUIPlugin;
import org.eclipse.ptp.rm.core.rmsystem.IRemoteResourceManagerConfiguration;
import org.eclipse.ptp.rm.ibm.pe.core.rmsystem.PEResourceManagerConfiguration;
import org.eclipse.ptp.rm.ibm.pe.ui.messages.Messages;
import org.eclipse.ptp.rm.ui.wizards.AbstractProxyOptions;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class PEResourceManagerOptions
extends AbstractProxyOptions {
    private static final String SUSPEND_AT_STARTUP_OPTION = "--suspend_at_startup";
    private static final String USE_LOADLEVELER_OPTION = "--useloadleveler";
    private static final String MULTICLUSTER_OPTION = "--multicluster";
    private static final String NODE_POLL_MIN_OPTION = "--node_polling_min";
    private static final String NODE_POLL_MAX_OPTION = "--node_polling_max";
    private static final String JOB_POLL_OPTION = "--job_polling";
    private static final String LIB_OVERRIDE_OPTION = "--lib_override";
    private static final String TRACE_OPTION = "--trace";
    private static final String RUN_MINIPROXY_OPTION = "--runMiniproxy";
    private Composite optionsPane;
    private Button loadLevelerOption;
    private Button suspendOption;
    private Button runMiniproxy;
    private Button libOverrideBrowse;
    private Text nodePollMinInterval;
    private Text nodePollMaxInterval;
    private Text jobPollInterval;
    private Text libOverridePath;
    private Combo llMode;
    private Composite llOverrideBox;
    private Combo debugLevel;
    private Label debugLabel;
    private Label libOverrideLabel;
    private Label llModeLabel;
    private Label nodePollMinLabel;
    private Label nodePollMaxLabel;
    private Label jobPollLabel;
    private IRemoteUIServices remoteUIService;
    private EventMonitor eventMonitor;

    public PEResourceManagerOptions(WizardPage wizardPage, PEResourceManagerConfiguration config) {
        super(wizardPage, (IRemoteResourceManagerConfiguration)config);
        this.setInitialOptions();
    }

    protected PEResourceManagerConfiguration getConfiguration() {
        return (PEResourceManagerConfiguration)super.getConfiguration();
    }

    private void setInitialOptions() {
        StringTokenizer options = new StringTokenizer(this.getConfiguration().getInvocationOptionsStr(), " ");
        this.getConfiguration().setSuspendProxy("N");
        this.getConfiguration().setRunMiniproxy("N");
        while (options.hasMoreTokens()) {
            String[] currentToken = options.nextToken().split("=");
            if (currentToken.length == 1) {
                if (currentToken[0].equals(SUSPEND_AT_STARTUP_OPTION)) {
                    this.getConfiguration().setSuspendProxy("Y");
                    continue;
                }
                if (currentToken[0].equals(RUN_MINIPROXY_OPTION)) {
                    this.getConfiguration().setRunMiniproxy("Y");
                    continue;
                }
                if (!currentToken[0].equals(USE_LOADLEVELER_OPTION)) continue;
                this.getConfiguration().setUseLoadLeveler("Y");
                continue;
            }
            if (currentToken[0].equals(MULTICLUSTER_OPTION)) {
                this.getConfiguration().setLoadLevelerMode(currentToken[1]);
                continue;
            }
            if (currentToken[0].equals(NODE_POLL_MIN_OPTION)) {
                this.getConfiguration().setNodeMinPollInterval(currentToken[1]);
                continue;
            }
            if (currentToken[0].equals(NODE_POLL_MAX_OPTION)) {
                this.getConfiguration().setNodeMaxPollInterval(currentToken[1]);
                continue;
            }
            if (currentToken[0].equals(JOB_POLL_OPTION)) {
                this.getConfiguration().setJobPollInterval(currentToken[1]);
                continue;
            }
            if (currentToken[0].equals(LIB_OVERRIDE_OPTION)) {
                this.getConfiguration().setLibraryOverride(currentToken[1]);
                continue;
            }
            if (!currentToken[0].equals(TRACE_OPTION)) continue;
            this.getConfiguration().setDebugLevel(currentToken[1]);
        }
    }

    private void setLLWidgetEnableState(boolean state) {
        this.llMode.setEnabled(state);
        this.nodePollMinInterval.setEnabled(state);
        this.nodePollMaxInterval.setEnabled(state);
        this.jobPollInterval.setEnabled(state);
        this.libOverridePath.setEnabled(state);
        this.libOverrideBrowse.setEnabled(state);
    }

    protected Composite createContents(Composite parent) {
        this.setShell(parent.getShell());
        this.eventMonitor = new EventMonitor();
        this.optionsPane = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, true);
        this.optionsPane.setLayout((Layout)layout);
        this.optionsPane.setLayoutData((Object)new GridData(4, 4, true, true));
        this.loadLevelerOption = new Button(this.optionsPane, 32);
        this.loadLevelerOption.setText(Messages.getString("PEDialogs.LoadLevelerOptionLabel"));
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        this.loadLevelerOption.setLayoutData((Object)gd);
        String preferenceValue = this.getConfiguration().getUseLoadLeveler();
        if (preferenceValue != null && preferenceValue.equals("Y")) {
            this.loadLevelerOption.setSelection(true);
        }
        Composite llComp = new Composite(this.optionsPane, 0);
        layout = new GridLayout(2, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        llComp.setLayout((Layout)layout);
        gd = new GridData(4, 4, true, true);
        gd.horizontalIndent = 20;
        gd.horizontalSpan = 2;
        llComp.setLayoutData((Object)gd);
        this.llModeLabel = new Label(llComp, 0);
        this.llModeLabel.setText(Messages.getString("PEDialogs.LLRunMode"));
        this.llMode = new Combo(llComp, 8);
        this.llMode.add(Messages.getString("PEDialogs.llModeLocal"));
        this.llMode.add(Messages.getString("PEDialogs.llModeMulticluster"));
        this.llMode.add(Messages.getString("PEDialogs.llModeDefault"));
        preferenceValue = this.getConfiguration().getLoadLevelerMode();
        if (preferenceValue != null) {
            if (preferenceValue.equals("y")) {
                this.llMode.select(1);
            } else if (preferenceValue.equals("n")) {
                this.llMode.select(0);
            } else {
                this.llMode.select(2);
            }
        } else {
            this.llMode.select(2);
        }
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        this.llMode.setLayoutData((Object)gd);
        this.nodePollMinLabel = new Label(llComp, 0);
        this.nodePollMinLabel.setText(Messages.getString("PEDialogs.minNodePollInterval"));
        this.nodePollMinInterval = new Text(llComp, 2052);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.nodePollMinInterval.setLayoutData((Object)gd);
        preferenceValue = this.getConfiguration().getNodeMinPollInterval();
        if (preferenceValue != null) {
            this.nodePollMinInterval.setText(preferenceValue);
        }
        this.nodePollMaxLabel = new Label(llComp, 0);
        this.nodePollMaxLabel.setText(Messages.getString("PEDialogs.maxNodePollInterval"));
        this.nodePollMaxInterval = new Text(llComp, 2052);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.nodePollMaxInterval.setLayoutData((Object)gd);
        preferenceValue = this.getConfiguration().getNodeMaxPollInterval();
        if (preferenceValue != null) {
            this.nodePollMaxInterval.setText(preferenceValue);
        }
        this.jobPollLabel = new Label(llComp, 0);
        this.jobPollLabel.setText(Messages.getString("PEDialogs.jobPollInterval"));
        this.jobPollInterval = new Text(llComp, 2052);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.jobPollInterval.setLayoutData((Object)gd);
        preferenceValue = this.getConfiguration().getJobPollInterval();
        if (preferenceValue != null) {
            this.jobPollInterval.setText(preferenceValue);
        }
        this.libOverrideLabel = new Label(llComp, 0);
        this.libOverrideLabel.setText(Messages.getString("PEDialogs.libOverrideLabel"));
        this.llOverrideBox = new Composite(llComp, 0);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.llOverrideBox.setLayoutData((Object)gd);
        layout = new GridLayout(2, false);
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginWidth = 0;
        this.llOverrideBox.setLayout((Layout)layout);
        this.libOverridePath = new Text(this.llOverrideBox, 2052);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.libOverridePath.setLayoutData((Object)gd);
        this.libOverrideBrowse = new Button(this.llOverrideBox, 8);
        this.libOverrideBrowse.setText(Messages.getString("PEDialogs.browse"));
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = false;
        this.libOverrideBrowse.setLayoutData((Object)gd);
        preferenceValue = this.getConfiguration().getLibraryOverride();
        if (preferenceValue != null) {
            this.libOverridePath.setText(preferenceValue);
        }
        this.runMiniproxy = new Button(this.optionsPane, 32);
        this.runMiniproxy.setText(Messages.getString("PEDialogs.MiniproxyLabel"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.runMiniproxy.setLayoutData((Object)gd);
        preferenceValue = this.getConfiguration().getRunMiniproxy();
        if (preferenceValue != null && preferenceValue.equals("Y")) {
            this.runMiniproxy.setSelection(true);
        }
        this.debugLabel = new Label(this.optionsPane, 0);
        this.debugLabel.setText(Messages.getString("PEDialogs.TraceLevelLabel"));
        this.debugLevel = new Combo(this.optionsPane, 8);
        this.debugLevel.add("None");
        this.debugLevel.add("Function");
        this.debugLevel.add("Detail");
        preferenceValue = this.getConfiguration().getDebugLevel();
        if (preferenceValue != null) {
            this.debugLevel.setText(preferenceValue);
        }
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        this.debugLevel.setLayoutData((Object)gd);
        this.suspendOption = new Button(this.optionsPane, 32);
        this.suspendOption.setText(Messages.getString("PEDialogs.SuspendLabel"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.suspendOption.setLayoutData((Object)gd);
        preferenceValue = this.getConfiguration().getSuspendProxy();
        if (preferenceValue != null && preferenceValue.equals("Y")) {
            this.suspendOption.setSelection(true);
        }
        if (!this.loadLevelerOption.getSelection()) {
            this.setLLWidgetEnableState(false);
        }
        this.loadLevelerOption.addSelectionListener((SelectionListener)this.eventMonitor);
        this.suspendOption.addSelectionListener((SelectionListener)this.eventMonitor);
        this.llMode.addSelectionListener((SelectionListener)this.eventMonitor);
        this.nodePollMinInterval.addModifyListener((ModifyListener)this.eventMonitor);
        this.nodePollMaxInterval.addModifyListener((ModifyListener)this.eventMonitor);
        this.jobPollInterval.addModifyListener((ModifyListener)this.eventMonitor);
        this.libOverridePath.addModifyListener((ModifyListener)this.eventMonitor);
        this.libOverrideBrowse.addSelectionListener((SelectionListener)this.eventMonitor);
        this.runMiniproxy.addSelectionListener((SelectionListener)this.eventMonitor);
        this.suspendOption.addSelectionListener((SelectionListener)this.eventMonitor);
        this.debugLevel.addSelectionListener((SelectionListener)this.eventMonitor);
        this.validateInput(null);
        return this.optionsPane;
    }

    protected boolean validateInput(Object eventSource) {
        this.getWizardPage().setErrorMessage(null);
        if (this.loadLevelerOption.getSelection()) {
            String widgetValue = this.nodePollMinInterval.getText().trim();
            if (widgetValue.length() > 0) {
                try {
                    Integer.valueOf(widgetValue).intValue();
                }
                catch (NumberFormatException numberFormatException) {
                    this.getWizardPage().setErrorMessage(Messages.getString("PEDialogs.invalidMinPollInterval"));
                    return false;
                }
            }
            if ((widgetValue = this.nodePollMaxInterval.getText().trim()).length() > 0) {
                try {
                    Integer.valueOf(widgetValue).intValue();
                }
                catch (NumberFormatException numberFormatException) {
                    this.getWizardPage().setErrorMessage(Messages.getString("PEDialogs.invalidMaxPollInterval"));
                    return false;
                }
            }
            if ((widgetValue = this.jobPollInterval.getText().trim()).length() > 0) {
                try {
                    Integer.valueOf(widgetValue).intValue();
                }
                catch (NumberFormatException numberFormatException) {
                    this.getWizardPage().setErrorMessage(Messages.getString("PEDialogs.invalidJobPollInterval"));
                    return false;
                }
            }
            if (eventSource == this.libOverridePath) {
                widgetValue = this.libOverridePath.getText().trim();
                if (widgetValue.length() > 0) {
                    IRemoteFileManager fileMgr;
                    IFileStore remoteResource;
                    IFileInfo fileInfo;
                    Path testPath = new Path(widgetValue);
                    if (!testPath.isValidPath(widgetValue)) {
                        this.getWizardPage().setErrorMessage(Messages.getString("PEDialogs.invalidLibraryPath"));
                    }
                    if (!(fileInfo = (remoteResource = (fileMgr = this.getRemoteConnection().getRemoteServices().getFileManager(this.getRemoteConnection())).getResource(testPath.toString())).fetchInfo()).exists() || !fileInfo.isDirectory()) {
                        this.getWizardPage().setErrorMessage(Messages.getString("PEDialogs.invalidLibraryPath"));
                    }
                } else {
                    this.getWizardPage().setErrorMessage(Messages.getString("PEDialogs.invalidLibraryPath"));
                }
            }
        }
        return true;
    }

    public void save() {
        String proxyOptions = "";
        if (this.loadLevelerOption.getSelection()) {
            proxyOptions = String.valueOf(proxyOptions) + "--useloadleveler ";
            this.getConfiguration().setUseLoadLeveler("Y");
            proxyOptions = String.valueOf(proxyOptions) + "--multicluster=";
            String multiclusterMode = "y";
            if (this.llMode.getText().equals(Messages.getString("PEDialogs.llModeDefault"))) {
                multiclusterMode = "d";
            } else if (this.llMode.getText().equals(Messages.getString("PEDialogs.llModeLocal"))) {
                multiclusterMode = "n";
            }
            proxyOptions = String.valueOf(proxyOptions) + multiclusterMode + " ";
            this.getConfiguration().setLoadLevelerMode(multiclusterMode);
            String widgetValue = this.nodePollMinInterval.getText().trim();
            proxyOptions = String.valueOf(proxyOptions) + "--node_polling_min=" + widgetValue + " ";
            this.getConfiguration().setNodeMinPollInterval(widgetValue);
            widgetValue = this.nodePollMaxInterval.getText().trim();
            proxyOptions = String.valueOf(proxyOptions) + "--node_polling_max=" + widgetValue + " ";
            this.getConfiguration().setNodeMaxPollInterval(widgetValue);
            widgetValue = this.jobPollInterval.getText().trim();
            proxyOptions = String.valueOf(proxyOptions) + "--job_polling=" + widgetValue + " ";
            this.getConfiguration().setJobPollInterval(widgetValue);
            widgetValue = this.libOverridePath.getText().trim();
            proxyOptions = String.valueOf(proxyOptions) + "--lib_override=" + widgetValue + " ";
            this.getConfiguration().setLibraryOverride(widgetValue);
        } else {
            this.getConfiguration().setUseLoadLeveler("N");
        }
        String traceOpt = this.debugLevel.getText();
        proxyOptions = String.valueOf(proxyOptions) + "--trace=" + traceOpt + " ";
        this.getConfiguration().setDebugLevel(traceOpt);
        if (this.suspendOption.getSelection()) {
            proxyOptions = String.valueOf(proxyOptions) + SUSPEND_AT_STARTUP_OPTION;
            this.getConfiguration().setSuspendProxy("Y");
        } else {
            this.getConfiguration().setSuspendProxy("N");
        }
        if (this.runMiniproxy.getSelection()) {
            proxyOptions = String.valueOf(proxyOptions) + "--runMiniproxy ";
            this.getConfiguration().setRunMiniproxy("Y");
        } else {
            this.getConfiguration().setRunMiniproxy("N");
        }
        this.getConfiguration().setInvocationOptions(proxyOptions);
    }

    private class EventMonitor
    implements SelectionListener,
    ModifyListener {
        public void modifyText(ModifyEvent e) {
            PEResourceManagerOptions.this.validateInput(e.getSource());
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            if (e.getSource() == PEResourceManagerOptions.this.loadLevelerOption) {
                if (PEResourceManagerOptions.this.loadLevelerOption.getSelection()) {
                    PEResourceManagerOptions.this.setLLWidgetEnableState(true);
                } else {
                    PEResourceManagerOptions.this.setLLWidgetEnableState(false);
                }
            }
            if (e.getSource() == PEResourceManagerOptions.this.libOverrideBrowse) {
                String selectedFile = null;
                if (PEResourceManagerOptions.this.remoteUIService == null) {
                    PEResourceManagerOptions.this.remoteUIService = PTPRemoteUIPlugin.getDefault().getRemoteUIServices(PEResourceManagerOptions.this.getRemoteConnection().getRemoteServices());
                }
                if (PEResourceManagerOptions.this.remoteUIService != null) {
                    IRemoteUIFileManager fmgr = PEResourceManagerOptions.this.remoteUIService.getUIFileManager();
                    fmgr.setConnection(PEResourceManagerOptions.this.getRemoteConnection());
                    selectedFile = fmgr.browseDirectory(PEResourceManagerOptions.this.getShell(), Messages.getString("PEDialogs.librarySelectorTitle"), "/", 0).toString();
                }
                if (selectedFile != null) {
                    PEResourceManagerOptions.this.libOverridePath.setText(selectedFile);
                }
            } else {
                PEResourceManagerOptions.this.validateInput(e.getSource());
            }
        }
    }
}

