/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.jaxb.control.ui.utils;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ptp.ems.ui.EnvManagerConfigButton;
import org.eclipse.ptp.remote.core.IRemoteConnection;
import org.eclipse.ptp.remote.core.RemoteServicesDelegate;
import org.eclipse.ptp.remote.ui.RemoteUIServicesUtils;
import org.eclipse.ptp.rm.jaxb.control.ui.ICellEditorUpdateModel;
import org.eclipse.ptp.rm.jaxb.control.ui.IUpdateModel;
import org.eclipse.ptp.rm.jaxb.control.ui.JAXBControlUIPlugin;
import org.eclipse.ptp.rm.jaxb.control.ui.cell.SpinnerCellEditor;
import org.eclipse.ptp.rm.jaxb.control.ui.handlers.ValueUpdateHandler;
import org.eclipse.ptp.rm.jaxb.control.ui.launch.IJAXBLaunchConfigurationTab;
import org.eclipse.ptp.rm.jaxb.control.ui.launch.IJAXBParentLaunchConfigurationTab;
import org.eclipse.ptp.rm.jaxb.control.ui.model.AbstractUpdateModel;
import org.eclipse.ptp.rm.jaxb.control.ui.model.ButtonGroupUpdateModel;
import org.eclipse.ptp.rm.jaxb.control.ui.model.ButtonUpdateModel;
import org.eclipse.ptp.rm.jaxb.control.ui.model.ComboUpdateModel;
import org.eclipse.ptp.rm.jaxb.control.ui.model.EnvConfigButtonUpdateModel;
import org.eclipse.ptp.rm.jaxb.control.ui.model.SpinnerUpdateModel;
import org.eclipse.ptp.rm.jaxb.control.ui.model.TableRowUpdateModel;
import org.eclipse.ptp.rm.jaxb.control.ui.model.TextUpdateModel;
import org.eclipse.ptp.rm.jaxb.control.ui.model.ValueTreeNodeUpdateModel;
import org.eclipse.ptp.rm.jaxb.control.ui.model.ViewerUpdateModel;
import org.eclipse.ptp.rm.jaxb.control.ui.utils.LaunchTabBuilder;
import org.eclipse.ptp.rm.jaxb.core.IVariableMap;
import org.eclipse.ptp.rm.jaxb.core.data.AttributeType;
import org.eclipse.ptp.rm.jaxb.core.data.AttributeViewerType;
import org.eclipse.ptp.rm.jaxb.core.data.BrowseType;
import org.eclipse.ptp.rm.jaxb.core.data.ButtonActionType;
import org.eclipse.ptp.rm.jaxb.core.data.ButtonGroupType;
import org.eclipse.ptp.rm.jaxb.core.data.ColumnDataType;
import org.eclipse.ptp.rm.jaxb.core.data.ControlStateType;
import org.eclipse.ptp.rm.jaxb.core.data.FontType;
import org.eclipse.ptp.rm.jaxb.core.data.LayoutDataType;
import org.eclipse.ptp.rm.jaxb.core.data.PushButtonType;
import org.eclipse.ptp.rm.jaxb.core.data.WidgetType;
import org.eclipse.ptp.rm.jaxb.ui.util.WidgetBuilderUtils;
import org.eclipse.ptp.utils.ui.swt.SWTUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateModelFactory {
    public static IUpdateModel createModel(ButtonGroupType bGroupDescriptor, Composite bGroup, IJAXBLaunchConfigurationTab tab, IVariableMap rmVarMap, Map<String, Button> sources, Map<ControlStateType, Control> targets) {
        List bWidgets = bGroupDescriptor.getButton();
        ArrayList<Button> buttons = new ArrayList<Button>();
        for (WidgetType widget : bWidgets) {
            ControlStateType cst;
            ControlDescriptor cd = new ControlDescriptor(widget, rmVarMap);
            Control control = UpdateModelFactory.createControl(bGroup, cd, tab);
            if (control instanceof Button) {
                Button b = (Button)control;
                buttons.add(b);
                String id = widget.getButtonId();
                if (id != null) {
                    sources.put(id, b);
                }
            }
            if ((cst = widget.getControlState()) == null) continue;
            targets.put(cst, control);
        }
        return new ButtonGroupUpdateModel(bGroupDescriptor.getAttribute(), tab.getParent().getUpdateHandler(), bGroup, buttons);
    }

    public static ViewerUpdateModel createModel(ColumnViewer viewer, AttributeViewerType descriptor, IJAXBLaunchConfigurationTab tab) {
        return new ViewerUpdateModel(descriptor.getName(), descriptor.isInitialAllChecked(), tab.getParent().getUpdateHandler(), (ICheckable)viewer, descriptor.getValue());
    }

    public static IUpdateModel createModel(Composite parent, BrowseType browse, IJAXBLaunchConfigurationTab tab, IVariableMap rmVarMap, Map<ControlStateType, Control> targets) {
        ControlDescriptor cd = new ControlDescriptor(browse, rmVarMap);
        Text control = UpdateModelFactory.createBrowse(parent, browse, cd, tab, targets);
        String attr = browse.getAttribute();
        ValueUpdateHandler handler = tab.getParent().getUpdateHandler();
        TextUpdateModel model = null;
        if (control instanceof Text && attr != null && !"".equals(attr)) {
            model = new TextUpdateModel(attr, handler, control);
        }
        if (attr != null && !"".equals(attr)) {
            UpdateModelFactory.maybeAddValidator(model, rmVarMap.get(attr), tab.getParent());
        }
        return model;
    }

    public static IUpdateModel createModel(Composite parent, WidgetType widget, IJAXBLaunchConfigurationTab tab, IVariableMap rmVarMap, Map<String, Button> sources, Map<ControlStateType, Control> targets) {
        ControlStateType cst;
        ControlDescriptor cd = new ControlDescriptor(widget, rmVarMap);
        Control control = UpdateModelFactory.createControl(parent, cd, tab);
        String id = widget.getButtonId();
        if (id != null && control instanceof Button) {
            sources.put(id, (Button)control);
        }
        if ((cst = widget.getControlState()) != null) {
            targets.put(cst, control);
        }
        if (control instanceof Label) {
            return null;
        }
        String attr = widget.getAttribute();
        List dynamic = null;
        WidgetType.DynamicText dt = widget.getDynamicText();
        if (dt != null) {
            dynamic = dt.getArg();
        }
        ValueUpdateHandler handler = tab.getParent().getUpdateHandler();
        AbstractUpdateModel model = null;
        if (control instanceof Text) {
            if (attr != null && !"".equals(attr)) {
                model = new TextUpdateModel(attr, handler, (Text)control);
            }
            if (dynamic != null) {
                model = new TextUpdateModel(dynamic, handler, (Text)control);
            }
        } else if (control instanceof Combo) {
            model = new ComboUpdateModel(attr, cd.itemsFrom, handler, (Combo)control);
        } else if (control instanceof Spinner) {
            model = new SpinnerUpdateModel(attr, handler, (Spinner)control);
        } else if (control instanceof Button) {
            model = new ButtonUpdateModel(attr, handler, (Button)control, cd.translateBooleanAs);
        } else if (control instanceof EnvManagerConfigButton) {
            model = new EnvConfigButtonUpdateModel(attr, handler, (EnvManagerConfigButton)control);
        }
        if (attr != null && !"".equals(attr)) {
            UpdateModelFactory.maybeAddValidator(model, rmVarMap.get(attr), tab.getParent());
        }
        return model;
    }

    public static ICellEditorUpdateModel createModel(AttributeType data, ColumnViewer viewer, List<ColumnDataType> columnData, IJAXBLaunchConfigurationTab tab) {
        ICellEditorUpdateModel model = null;
        model = viewer instanceof TableViewer ? UpdateModelFactory.createModel(data, (TableViewer)viewer, columnData, tab) : UpdateModelFactory.createModel(data, (TreeViewer)viewer, columnData, tab);
        UpdateModelFactory.maybeAddValidator(model, data, tab.getParent());
        return model;
    }

    public static void createPushButton(Composite parent, PushButtonType button, IJAXBLaunchConfigurationTab tab, IVariableMap rmVarMap, Map<ControlStateType, Control> targets) {
        ControlStateType cst;
        ControlDescriptor cd = new ControlDescriptor(button, rmVarMap);
        Control c = UpdateModelFactory.createActionButton(parent, cd, tab);
        if (c != null) {
            if (!"".equals(cd.tooltip)) {
                c.setToolTipText(cd.tooltip);
            }
            if (cd.foreground != null) {
                c.setForeground(WidgetBuilderUtils.getColor((String)cd.foreground));
            }
            if (cd.background != null) {
                c.setBackground(WidgetBuilderUtils.getColor((String)cd.background));
            }
            if (cd.font != null) {
                c.setFont(WidgetBuilderUtils.getFont((FontType)cd.font));
            }
        }
        if ((cst = button.getControlState()) != null) {
            targets.put(cst, c);
        }
    }

    private static Control createActionButton(Composite parent, final ControlDescriptor cd, final IJAXBLaunchConfigurationTab tab) {
        Button b = WidgetBuilderUtils.createButton((Composite)parent, (Object)cd.layoutData, (String)cd.title, (Integer)8, (SelectionListener)new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                try {
                    tab.run(cd.action);
                }
                catch (Throwable t) {
                    JAXBControlUIPlugin.log(t);
                }
            }
        });
        SWTUtil.setButtonDimensionHint((Button)b);
        return null;
    }

    private static Text createBrowse(final Composite parent, BrowseType d, final ControlDescriptor cd, final IJAXBLaunchConfigurationTab tab, Map<ControlStateType, Control> targets) {
        ControlStateType cst;
        final Text t = WidgetBuilderUtils.createText((Composite)parent, (Integer)cd.style, (Object)cd.layoutData, (Boolean)cd.readOnly, (String)"");
        Button b = WidgetBuilderUtils.createButton((Composite)parent, (Object)cd.subLayoutData, (String)cd.title, (Integer)0, (SelectionListener)new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                try {
                    String initial = t.getText();
                    URI uri = null;
                    uri = "".equals(initial) ? tab.getParent().getRemoteServicesDelegate().getRemoteHome() : new URI(initial);
                    uri = RemoteUIServicesUtils.browse((Shell)parent.getShell(), (URI)uri, (RemoteServicesDelegate)tab.getParent().getRemoteServicesDelegate(), (!cd.localOnly ? 1 : 0) != 0, (boolean)cd.readOnly, (boolean)cd.directory);
                    if (uri != null) {
                        if (cd.returnUri) {
                            t.setText(uri.toString());
                        } else {
                            t.setText(uri.getPath());
                        }
                    } else {
                        t.setText("");
                    }
                }
                catch (Throwable t2) {
                    JAXBControlUIPlugin.log(t2);
                }
            }
        });
        SWTUtil.setButtonDimensionHint((Button)b);
        if (!"".equals(cd.tooltip)) {
            t.setToolTipText(cd.tooltip);
        }
        if (cd.foreground != null) {
            t.setForeground(WidgetBuilderUtils.getColor((String)cd.foreground));
        }
        if (cd.background != null) {
            t.setBackground(WidgetBuilderUtils.getColor((String)cd.background));
        }
        if (cd.font != null) {
            t.setFont(WidgetBuilderUtils.getFont((FontType)cd.font));
        }
        if ((cst = d.getTextControlState()) != null) {
            targets.put(cst, (Control)t);
        }
        if ((cst = d.getButtonControlState()) != null) {
            targets.put(cst, (Control)b);
        }
        return t;
    }

    private static Combo createCombo(Composite parent, ControlDescriptor cd) {
        String[] items = null;
        if (cd.choice != null) {
            items = cd.choice.split(",");
        }
        if (items == null) {
            items = new String[]{};
        } else if (items.length > 0) {
            items = WidgetBuilderUtils.normalizeComboItems((String[])items);
        }
        return WidgetBuilderUtils.createCombo((Composite)parent, (Integer)cd.style, (Object)cd.layoutData, (String[])items, (String)"", (String)cd.title, (String)cd.tooltip, null);
    }

    private static EnvManagerConfigButton createEnvConfig(Composite parent, ControlDescriptor cd, IRemoteConnection conn) {
        return WidgetBuilderUtils.createEnvConfig((Composite)parent, (Integer)cd.style, (Object)cd.layoutData, (String)"", (String)cd.title, (String)cd.tooltip, null, (IRemoteConnection)conn);
    }

    private static Control createControl(Composite parent, ControlDescriptor cd, IJAXBLaunchConfigurationTab tab) {
        Text c = null;
        if ("label".equals(cd.widgetType)) {
            c = WidgetBuilderUtils.createLabel((Composite)parent, (String)cd.fixedText, (Integer)cd.style, (Object)cd.layoutData);
        } else if ("text".equals(cd.widgetType)) {
            c = UpdateModelFactory.createText(parent, cd);
        } else if ("radiobutton".equals(cd.widgetType)) {
            if (cd.style == 0) {
                cd.style = 16;
            } else {
                ControlDescriptor controlDescriptor = cd;
                controlDescriptor.style = controlDescriptor.style | 0x10;
            }
            c = WidgetBuilderUtils.createButton((Composite)parent, (Object)cd.layoutData, (String)cd.title, (Integer)cd.style, null);
        } else if ("checkbox".equals(cd.widgetType)) {
            if (cd.style == 0) {
                cd.style = 32;
            } else {
                ControlDescriptor controlDescriptor = cd;
                controlDescriptor.style = controlDescriptor.style | 0x20;
            }
            c = WidgetBuilderUtils.createButton((Composite)parent, (Object)cd.layoutData, (String)cd.title, (Integer)cd.style, null);
        } else if ("spinner".equals(cd.widgetType)) {
            c = WidgetBuilderUtils.createSpinner((Composite)parent, (int)cd.style, (Object)cd.layoutData, (String)cd.title, (Integer)cd.min, (Integer)cd.max, (Integer)cd.min, null);
        } else if ("combo".equals(cd.widgetType)) {
            c = UpdateModelFactory.createCombo(parent, cd);
        } else if ("envconfig".equals(cd.widgetType)) {
            c = UpdateModelFactory.createEnvConfig(parent, cd, tab.getRemoteConnection());
        }
        if (c != null) {
            if (!"".equals(cd.tooltip)) {
                c.setToolTipText(cd.tooltip);
            }
            if (cd.foreground != null) {
                c.setForeground(WidgetBuilderUtils.getColor((String)cd.foreground));
            }
            if (cd.background != null) {
                c.setBackground(WidgetBuilderUtils.getColor((String)cd.background));
            }
            if (cd.font != null) {
                c.setFont(WidgetBuilderUtils.getFont((FontType)cd.font));
            }
        }
        return c;
    }

    private static CellEditor createEditor(CellDescriptor cd, Object data, Composite parent) {
        Object editor = null;
        if (cd.type == CellEditorType.TEXT) {
            editor = new TextCellEditor(parent);
        } else if (cd.type == CellEditorType.CHECK) {
            editor = new CheckboxCellEditor(parent);
        } else if (cd.type == CellEditorType.SPINNER) {
            editor = new SpinnerCellEditor(parent, cd.min, cd.max);
        } else if (cd.type == CellEditorType.COMBO) {
            if (data instanceof AttributeType) {
                if (cd.choice != null) {
                    cd.choice = cd.choice.trim();
                    cd.items = cd.choice.split(",");
                } else {
                    cd.items = new String[0];
                }
            }
            editor = new ComboBoxCellEditor(parent, cd.items, 8);
        }
        return editor;
    }

    private static ICellEditorUpdateModel createModel(AttributeType data, TableViewer viewer, List<ColumnDataType> columnData, IJAXBLaunchConfigurationTab tab) {
        CellDescriptor cd = new CellDescriptor(data, columnData);
        CellEditor editor = UpdateModelFactory.createEditor(cd, data, (Composite)viewer.getTable());
        ValueUpdateHandler handler = tab.getParent().getUpdateHandler();
        TableRowUpdateModel model = new TableRowUpdateModel(cd.name, handler, editor, cd.items, cd.itemsFrom, cd.translateBooleanAs, cd.readOnly, data);
        if (model != null) {
            model.setBackground(cd.background);
            model.setFont(cd.font);
            model.setForeground(cd.foreground);
        }
        return model;
    }

    private static ICellEditorUpdateModel createModel(AttributeType data, TreeViewer viewer, List<ColumnDataType> columnData, IJAXBLaunchConfigurationTab tab) {
        CellDescriptor cd = new CellDescriptor(data, columnData);
        CellEditor editor = UpdateModelFactory.createEditor(cd, data, (Composite)viewer.getTree());
        ValueUpdateHandler handler = tab.getParent().getUpdateHandler();
        Object[] properties = viewer.getColumnProperties();
        boolean inValueCol = properties.length == 2;
        ValueTreeNodeUpdateModel model = new ValueTreeNodeUpdateModel(cd.name, handler, editor, cd.items, cd.itemsFrom, cd.translateBooleanAs, cd.readOnly, inValueCol, data);
        if (model != null) {
            model.setBackground(cd.background);
            model.setFont(cd.font);
            model.setForeground(cd.foreground);
        }
        return model;
    }

    private static Text createText(Composite parent, ControlDescriptor cd) {
        return WidgetBuilderUtils.createText((Composite)parent, (Integer)cd.style, (Object)cd.layoutData, (Boolean)cd.readOnly, (String)"");
    }

    private static void maybeAddValidator(IUpdateModel model, AttributeType data, IJAXBParentLaunchConfigurationTab tab) {
        if (data != null) {
            model.setValidator(data.getValidator(), tab);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CellDescriptor {
        private final String name;
        private String tooltip;
        private String description;
        private String choice;
        private final String itemsFrom;
        private final String translateBooleanAs;
        private final Integer min;
        private final Integer max;
        private final boolean readOnly;
        private final CellEditorType type;
        private String[] items;
        protected Color[] foreground;
        protected Color[] background;
        protected Font[] font;

        private CellDescriptor(AttributeType data, List<ColumnDataType> columnData) {
            this.type = CellEditorType.getType(data);
            this.name = data.getName();
            this.choice = data.getChoice();
            this.itemsFrom = data.getItemsFrom();
            this.translateBooleanAs = data.getTranslateBooleanAs();
            this.min = data.getMin();
            this.max = data.getMax();
            this.readOnly = data.isReadOnly();
            this.tooltip = data.getTooltip();
            this.tooltip = this.tooltip == null ? "" : WidgetBuilderUtils.removeTabOrLineBreak((String)this.tooltip);
            this.description = data.getDescription();
            if (this.description == null) {
                this.description = "";
            }
            int cols = columnData.size();
            this.foreground = new Color[cols];
            this.background = new Color[cols];
            this.font = new Font[cols];
            int i = 0;
            while (i < columnData.size()) {
                String attr = columnData.get(i).getForeground();
                this.foreground[i] = attr != null ? WidgetBuilderUtils.getColor((String)attr) : null;
                attr = columnData.get(i).getBackground();
                this.background[i] = attr != null ? WidgetBuilderUtils.getColor((String)attr) : null;
                FontType fd = columnData.get(i).getFont();
                this.font[i] = fd != null ? WidgetBuilderUtils.getFont((FontType)fd) : null;
                ++i;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CellEditorType {
        TEXT,
        COMBO,
        SPINNER,
        CHECK;


        public static CellEditorType getType(Object object) {
            if (object instanceof AttributeType) {
                AttributeType a = (AttributeType)object;
                if (a.getTranslateBooleanAs() != null) {
                    return CHECK;
                }
                if (a.getChoice() != null || a.getItemsFrom() != null) {
                    return COMBO;
                }
                String clzz = a.getType();
                if (clzz != null) {
                    return CellEditorType.getTypeFromClass(clzz);
                }
                Object value = a.getValue();
                if (value != null) {
                    return CellEditorType.getType(value);
                }
            }
            return TEXT;
        }

        private static CellEditorType getTypeFromClass(String clzz) {
            if (clzz.indexOf("nt") > 0) {
                return SPINNER;
            }
            if (clzz.indexOf("bool") >= 0) {
                return CHECK;
            }
            return TEXT;
        }
    }

    private static class ControlDescriptor {
        private String widgetType;
        private String title;
        private Object layoutData;
        private Object subLayoutData;
        private boolean readOnly;
        private boolean localOnly;
        private boolean directory;
        private boolean returnUri;
        private int style;
        private String background;
        private String foreground;
        private FontType font;
        private Integer min;
        private Integer max;
        private String tooltip;
        private String choice;
        private String fixedText;
        private ButtonActionType action;
        private String itemsFrom;
        private String translateBooleanAs;

        private ControlDescriptor(BrowseType browse, IVariableMap rmMap) {
            this.setControlData(browse);
            this.setMapDependentData(browse, rmMap);
        }

        private ControlDescriptor(PushButtonType button, IVariableMap rmMap) {
            this.setControlData(button);
            this.setMapDependentData(button, rmMap);
        }

        private ControlDescriptor(WidgetType widget, IVariableMap rmMap) {
            this.setControlData(widget);
            this.setMapDependentData(widget, rmMap);
            String s = widget.getItemsFrom();
            if (s != null) {
                this.itemsFrom = s;
            }
        }

        private void setControlData(BrowseType browse) {
            this.widgetType = "browse";
            this.title = browse.getTitle();
            this.style = WidgetBuilderUtils.getStyle((String)browse.getTextStyle());
            LayoutDataType layout = browse.getTextLayoutData();
            this.layoutData = LaunchTabBuilder.createLayoutData(layout);
            layout = browse.getButtonLayoutData();
            this.subLayoutData = LaunchTabBuilder.createLayoutData(layout);
            this.directory = browse.isDirectory();
            this.returnUri = browse.isUri();
            this.localOnly = browse.isLocalOnly();
            this.background = browse.getBackground();
            this.foreground = browse.getForeground();
            this.font = browse.getFont();
            this.tooltip = browse.getTooltip();
        }

        private void setControlData(PushButtonType button) {
            this.widgetType = "action";
            this.title = button.getTitle();
            LayoutDataType layout = button.getLayoutData();
            this.layoutData = LaunchTabBuilder.createLayoutData(layout);
            this.background = button.getBackground();
            this.foreground = button.getForeground();
            this.font = button.getFont();
            this.tooltip = button.getTooltip();
            this.action = button.getButtonAction();
        }

        private void setControlData(WidgetType widget) {
            this.widgetType = widget.getType();
            this.title = widget.getTitle();
            LayoutDataType layout = widget.getLayoutData();
            this.layoutData = LaunchTabBuilder.createLayoutData(layout);
            this.style = WidgetBuilderUtils.getStyle((String)widget.getStyle());
            this.readOnly = widget.isReadOnly();
            if (this.readOnly) {
                this.style |= 8;
            }
            this.background = widget.getBackground();
            this.foreground = widget.getForeground();
            this.font = widget.getFont();
            this.tooltip = widget.getTooltip();
            this.fixedText = widget.getFixedText();
        }

        private void setData(AttributeType data) {
            AttributeType a = data;
            this.choice = a.getChoice();
            this.itemsFrom = a.getItemsFrom();
            this.min = a.getMin();
            this.max = a.getMax();
            this.translateBooleanAs = a.getTranslateBooleanAs();
        }

        private void setMapDependentData(Object widget, IVariableMap rmMap) {
            AttributeType data;
            this.tooltip = this.tooltip == null ? "" : WidgetBuilderUtils.removeTabOrLineBreak((String)rmMap.getString(this.tooltip));
            if (this.fixedText != null) {
                this.fixedText = rmMap.getString(this.fixedText);
            }
            String attr = null;
            if (widget instanceof WidgetType) {
                attr = ((WidgetType)widget).getAttribute();
            } else if (widget instanceof BrowseType) {
                attr = ((BrowseType)widget).getAttribute();
            }
            if (attr != null && (data = rmMap.get(attr)) != null) {
                this.setData(data);
            }
        }
    }
}

