/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml.internal.core.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.ptp.rm.lml.core.messages.Messages;
import org.eclipse.ptp.rm.lml.internal.core.elements.DataElement;
import org.eclipse.ptp.rm.lml.internal.core.elements.DataElement1;
import org.eclipse.ptp.rm.lml.internal.core.elements.DataElement2;
import org.eclipse.ptp.rm.lml.internal.core.elements.DataElement3;
import org.eclipse.ptp.rm.lml.internal.core.elements.DataElement4;
import org.eclipse.ptp.rm.lml.internal.core.elements.DataElement5;
import org.eclipse.ptp.rm.lml.internal.core.elements.DataElement6;
import org.eclipse.ptp.rm.lml.internal.core.elements.DataElement7;
import org.eclipse.ptp.rm.lml.internal.core.elements.DataElement8;
import org.eclipse.ptp.rm.lml.internal.core.elements.DataElement9;
import org.eclipse.ptp.rm.lml.internal.core.elements.DataType;
import org.eclipse.ptp.rm.lml.internal.core.elements.GobjectType;
import org.eclipse.ptp.rm.lml.internal.core.elements.LguiType;
import org.eclipse.ptp.rm.lml.internal.core.elements.Nodedisplay;
import org.eclipse.ptp.rm.lml.internal.core.elements.Nodedisplayelement;
import org.eclipse.ptp.rm.lml.internal.core.elements.Nodedisplayelement0;
import org.eclipse.ptp.rm.lml.internal.core.elements.Nodedisplayelement1;
import org.eclipse.ptp.rm.lml.internal.core.elements.Nodedisplayelement2;
import org.eclipse.ptp.rm.lml.internal.core.elements.Nodedisplayelement3;
import org.eclipse.ptp.rm.lml.internal.core.elements.Nodedisplayelement4;
import org.eclipse.ptp.rm.lml.internal.core.elements.Nodedisplayelement5;
import org.eclipse.ptp.rm.lml.internal.core.elements.Nodedisplayelement6;
import org.eclipse.ptp.rm.lml.internal.core.elements.Nodedisplayelement7;
import org.eclipse.ptp.rm.lml.internal.core.elements.Nodedisplayelement8;
import org.eclipse.ptp.rm.lml.internal.core.elements.Nodedisplayelement9;
import org.eclipse.ptp.rm.lml.internal.core.elements.NodedisplaylayoutType;
import org.eclipse.ptp.rm.lml.internal.core.elements.SchemeElement;
import org.eclipse.ptp.rm.lml.internal.core.elements.SchemeElement1;
import org.eclipse.ptp.rm.lml.internal.core.elements.SchemeElement2;
import org.eclipse.ptp.rm.lml.internal.core.elements.SchemeElement3;
import org.eclipse.ptp.rm.lml.internal.core.elements.SchemeElement4;
import org.eclipse.ptp.rm.lml.internal.core.elements.SchemeElement5;
import org.eclipse.ptp.rm.lml.internal.core.elements.SchemeElement6;
import org.eclipse.ptp.rm.lml.internal.core.elements.SchemeElement7;
import org.eclipse.ptp.rm.lml.internal.core.elements.SchemeElement8;
import org.eclipse.ptp.rm.lml.internal.core.elements.SchemeElement9;
import org.eclipse.ptp.rm.lml.internal.core.elements.SchemeType;
import org.eclipse.ptp.rm.lml.internal.core.model.ErrorList;
import org.eclipse.ptp.rm.lml.internal.core.model.LguiItem;

public class LMLCheck {
    public static void addAllowedNames(ErrorList errList, HashSet<String> names, Object schemeElement, String name) {
        List<? extends SchemeElement> elements = LMLCheck.getLowerSchemeElements(schemeElement);
        if (elements == null) {
            return;
        }
        int i = 0;
        while (i < elements.size()) {
            SchemeElement element = elements.get(i);
            if (element.getMin() != null) {
                int min;
                int max = min = element.getMin().intValue();
                if (element.getMax() != null) {
                    max = element.getMax().intValue();
                }
                int step = element.getStep().intValue();
                if (min > max) {
                    errList.addError(String.valueOf(Messages.LMLCheck_1) + name + Messages.LMLCheck_2 + min + Messages.LMLCheck_3 + max);
                }
                int j = min;
                while (j <= max) {
                    String thisName = String.valueOf(name) + LMLCheck.getLevelName(element, j);
                    names.add(thisName);
                    LMLCheck.addAllowedNames(errList, names, element, thisName);
                    j += step;
                }
            } else if (element.getList() != null) {
                int[] numbers;
                int[] nArray = numbers = LMLCheck.getNumbersFromNumberlist(element.getList());
                int n = numbers.length;
                int n2 = 0;
                while (n2 < n) {
                    int number = nArray[n2];
                    String thisName = String.valueOf(name) + LMLCheck.getLevelName(element, number);
                    names.add(thisName);
                    LMLCheck.addAllowedNames(errList, names, element, thisName);
                    ++n2;
                }
            }
            ++i;
        }
    }

    public static void checkDataNodesinScheme(ErrorList errList, Object dataNode, ArrayList<Integer> upperLevelNumbers, Object scheme) {
        if (dataNode == null) {
            return;
        }
        List<? extends DataElement> elementsData = LMLCheck.getLowerDataElements(dataNode);
        if (elementsData == null) {
            return;
        }
        int i = 0;
        while (i < elementsData.size()) {
            String levelString;
            SchemeAndData schemeAndData;
            DataElement elementData = elementsData.get(i);
            if (elementData.getMin() != null) {
                int min;
                int max = min = elementData.getMin().intValue();
                if (elementData.getMax() != null) {
                    max = elementData.getMax().intValue();
                }
                upperLevelNumbers.add(min);
                SchemeAndData first = LMLCheck.getSchemeAndDataByLevels(min, dataNode, scheme);
                if (first == null) {
                    String levelString2 = LMLCheck.getLevelString(upperLevelNumbers);
                    errList.addError(String.valueOf(Messages.LMLCheck_4) + levelString2 + Messages.LMLCheck_5);
                } else {
                    LMLCheck.checkDataNodesinScheme(errList, elementData, upperLevelNumbers, first.scheme);
                    int step = first.scheme.getStep().intValue();
                    int j = min + step;
                    while (j <= max) {
                        upperLevelNumbers.set(upperLevelNumbers.size() - 1, j);
                        schemeAndData = LMLCheck.getSchemeAndDataByLevels(j, dataNode, scheme);
                        if (schemeAndData == null) {
                            levelString = LMLCheck.getLevelString(upperLevelNumbers);
                            errList.addError(String.valueOf(Messages.LMLCheck_6) + levelString + Messages.LMLCheck_7);
                        } else {
                            LMLCheck.checkDataNodesinScheme(errList, elementData, upperLevelNumbers, schemeAndData.scheme);
                        }
                        j += step;
                    }
                }
                upperLevelNumbers.remove(upperLevelNumbers.size() - 1);
            } else if (elementData.getList() != null) {
                int[] elements;
                upperLevelNumbers.add(0);
                int[] nArray = elements = LMLCheck.getNumbersFromNumberlist(elementData.getList());
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    int number = nArray[n2];
                    upperLevelNumbers.set(upperLevelNumbers.size() - 1, number);
                    schemeAndData = LMLCheck.getSchemeAndDataByLevels(number, dataNode, scheme);
                    if (schemeAndData == null) {
                        levelString = LMLCheck.getLevelString(upperLevelNumbers);
                        errList.addError(String.valueOf(Messages.LMLCheck_8) + levelString + Messages.LMLCheck_9);
                    } else {
                        LMLCheck.checkDataNodesinScheme(errList, elementData, upperLevelNumbers, schemeAndData.scheme);
                    }
                    ++n2;
                }
                upperLevelNumbers.remove(upperLevelNumbers.size() - 1);
            }
            ++i;
        }
    }

    public static void checkNamesAllowed(ErrorList errList, HashSet<String> names, Object dataRefElement) {
        List<? extends DataElement> elements = LMLCheck.getLowerDataElements(dataRefElement);
        if (elements == null) {
            return;
        }
        int i = 0;
        while (i < elements.size()) {
            DataElement element = elements.get(i);
            String refName = element.getRefid();
            if (refName != null && !names.contains(refName)) {
                errList.addError(String.valueOf(Messages.LMLCheck_10) + refName + Messages.LMLCheck_11);
            }
            LMLCheck.checkNamesAllowed(errList, names, element);
            ++i;
        }
    }

    public static ErrorList checkNodedisplays(LguiType lgui) {
        ErrorList result = new ErrorList();
        List<GobjectType> gobjects = new LguiItem(lgui).getOverviewAccess().getGraphicalObjects();
        for (GobjectType gobject : gobjects) {
            if (!(gobject instanceof Nodedisplay)) continue;
            Nodedisplay nodedisplay = (Nodedisplay)gobject;
            result.addMessage(String.valueOf(Messages.LMLCheck_12) + nodedisplay.getId());
            LMLCheck.checkDataNodesinScheme(result, nodedisplay.getData(), new ArrayList<Integer>(), nodedisplay.getScheme());
        }
        return result;
    }

    public static ArrayList<Integer> copyArrayList(ArrayList<Integer> origin) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int i = 0;
        while (i < origin.size()) {
            result.add(origin.get(i));
            ++i;
        }
        return result;
    }

    public static int getDataLevel(Object element) {
        if (element instanceof DataType) {
            return 0;
        }
        if (element instanceof DataElement1) {
            return 1;
        }
        if (element instanceof DataElement2) {
            return 2;
        }
        if (element instanceof DataElement3) {
            return 3;
        }
        if (element instanceof DataElement4) {
            return 4;
        }
        if (element instanceof DataElement5) {
            return 5;
        }
        if (element instanceof DataElement6) {
            return 6;
        }
        if (element instanceof DataElement7) {
            return 7;
        }
        if (element instanceof DataElement8) {
            return 8;
        }
        if (element instanceof DataElement9) {
            return 9;
        }
        if (element instanceof DataElement) {
            return 10;
        }
        return -1;
    }

    public static int getDeepestSchemeLevel(Object schemeElement) {
        if (schemeElement == null) {
            return 0;
        }
        List<? extends SchemeElement> elements = LMLCheck.getLowerSchemeElements(schemeElement);
        if (elements == null) {
            return 1;
        }
        int max = 0;
        int i = 0;
        while (i < elements.size()) {
            int height = LMLCheck.getDeepestSchemeLevel(elements.get(i));
            if (height > max) {
                max = height;
            }
            ++i;
        }
        return max + (schemeElement instanceof SchemeType ? 0 : 1);
    }

    public static String getImplicitName(ArrayList<Integer> ids, Object scheme) {
        if (ids == null || ids.size() == 0) {
            return "";
        }
        ArrayList<Integer> id = new ArrayList<Integer>();
        id.add(ids.get(0));
        SchemeElement subScheme = LMLCheck.getSchemeByLevels(LMLCheck.copyArrayList(id), scheme);
        if (subScheme == null) {
            return "";
        }
        String subName = LMLCheck.getLevelName(subScheme, id.get(0));
        ids.remove(0);
        return String.valueOf(subName) + LMLCheck.getImplicitName(ids, subScheme);
    }

    public static String getLevelName(SchemeElement scheme, int levelId) {
        if (scheme.getMap() == null) {
            return String.format(scheme.getMask(), levelId);
        }
        String[] names = scheme.getMap().split(",");
        if (scheme.getMin() != null) {
            int step;
            int min = scheme.getMin().intValue();
            int namesPosition = (levelId - min) / (step = scheme.getStep().intValue());
            if (namesPosition < names.length) {
                return names[namesPosition];
            }
        } else {
            int[] numbers = LMLCheck.getNumbersFromNumberlist(scheme.getList());
            int i = 0;
            while (i < numbers.length) {
                if (numbers[i] == levelId) {
                    return names[i];
                }
                ++i;
            }
        }
        return "";
    }

    public static String getLevelString(ArrayList<Integer> levels) {
        String levelString = "";
        int j = 1;
        while (j <= levels.size()) {
            levelString = String.valueOf(levelString) + "el" + j + "=" + levels.get(j - 1) + " ";
            ++j;
        }
        return levelString;
    }

    public static List<? extends DataElement> getLowerDataElements(Object element) {
        if (element instanceof DataType) {
            return ((DataType)element).getEl1();
        }
        if (element instanceof DataElement1) {
            return ((DataElement1)element).getEl2();
        }
        if (element instanceof DataElement2) {
            return ((DataElement2)element).getEl3();
        }
        if (element instanceof DataElement3) {
            return ((DataElement3)element).getEl4();
        }
        if (element instanceof DataElement4) {
            return ((DataElement4)element).getEl5();
        }
        if (element instanceof DataElement5) {
            return ((DataElement5)element).getEl6();
        }
        if (element instanceof DataElement6) {
            return ((DataElement6)element).getEl7();
        }
        if (element instanceof DataElement7) {
            return ((DataElement7)element).getEl8();
        }
        if (element instanceof DataElement8) {
            return ((DataElement8)element).getEl9();
        }
        if (element instanceof DataElement9) {
            return ((DataElement9)element).getEl10();
        }
        return new ArrayList();
    }

    public static List<? extends Nodedisplayelement> getLowerNodedisplayElements(Object element) {
        if (element instanceof NodedisplaylayoutType) {
            ArrayList<Nodedisplayelement0> justOneElement = new ArrayList<Nodedisplayelement0>();
            justOneElement.add(((NodedisplaylayoutType)element).getEl0());
            return justOneElement;
        }
        if (element instanceof Nodedisplayelement0) {
            return ((Nodedisplayelement0)element).getEl1();
        }
        if (element instanceof Nodedisplayelement1) {
            return ((Nodedisplayelement1)element).getEl2();
        }
        if (element instanceof Nodedisplayelement2) {
            return ((Nodedisplayelement2)element).getEl3();
        }
        if (element instanceof Nodedisplayelement3) {
            return ((Nodedisplayelement3)element).getEl4();
        }
        if (element instanceof Nodedisplayelement4) {
            return ((Nodedisplayelement4)element).getEl5();
        }
        if (element instanceof Nodedisplayelement5) {
            return ((Nodedisplayelement5)element).getEl6();
        }
        if (element instanceof Nodedisplayelement6) {
            return ((Nodedisplayelement6)element).getEl7();
        }
        if (element instanceof Nodedisplayelement7) {
            return ((Nodedisplayelement7)element).getEl8();
        }
        if (element instanceof Nodedisplayelement8) {
            return ((Nodedisplayelement8)element).getEl9();
        }
        if (element instanceof Nodedisplayelement9) {
            return ((Nodedisplayelement9)element).getEl10();
        }
        return new ArrayList();
    }

    public static List<? extends SchemeElement> getLowerSchemeElements(Object element) {
        if (element instanceof SchemeType) {
            return ((SchemeType)element).getEl1();
        }
        if (element instanceof SchemeElement1) {
            return ((SchemeElement1)element).getEl2();
        }
        if (element instanceof SchemeElement2) {
            return ((SchemeElement2)element).getEl3();
        }
        if (element instanceof SchemeElement3) {
            return ((SchemeElement3)element).getEl4();
        }
        if (element instanceof SchemeElement4) {
            return ((SchemeElement4)element).getEl5();
        }
        if (element instanceof SchemeElement5) {
            return ((SchemeElement5)element).getEl6();
        }
        if (element instanceof SchemeElement6) {
            return ((SchemeElement6)element).getEl7();
        }
        if (element instanceof SchemeElement7) {
            return ((SchemeElement7)element).getEl8();
        }
        if (element instanceof SchemeElement8) {
            return ((SchemeElement8)element).getEl9();
        }
        if (element instanceof SchemeElement9) {
            return ((SchemeElement9)element).getEl10();
        }
        return new ArrayList();
    }

    public static Nodedisplayelement getNodedisplayElementByLevels(ArrayList<Integer> numbers, Nodedisplayelement nodeElement) {
        if (numbers == null || numbers.size() == 0) {
            return null;
        }
        if (nodeElement == null) {
            return null;
        }
        int number0 = numbers.get(0);
        numbers.remove(0);
        List<? extends Nodedisplayelement> schemeElements = LMLCheck.getLowerNodedisplayElements(nodeElement);
        Nodedisplayelement scheme = null;
        int i = 0;
        while (i < schemeElements.size()) {
            Nodedisplayelement minScheme = schemeElements.get(i);
            if (minScheme.getMin() != null) {
                int minValue;
                int maxValue = minValue = minScheme.getMin().intValue();
                if (minScheme.getMax() != null) {
                    maxValue = minScheme.getMax().intValue();
                }
                if (number0 >= minValue && number0 <= maxValue) {
                    scheme = minScheme;
                    break;
                }
            } else if (minScheme.getList() != null) {
                int[] listElements;
                int[] nArray = listElements = LMLCheck.getNumbersFromNumberlist(minScheme.getList());
                int n = listElements.length;
                int n2 = 0;
                while (n2 < n) {
                    int number = nArray[n2];
                    if (number == number0) {
                        scheme = minScheme;
                        break;
                    }
                    ++n2;
                }
                if (scheme != null) break;
            }
            ++i;
        }
        if (scheme == null) {
            return null;
        }
        if (numbers.size() == 0) {
            return scheme;
        }
        Nodedisplayelement result = LMLCheck.getNodedisplayElementByLevels(numbers, scheme);
        return result;
    }

    public static int[] getNumbersFromNumberlist(String numberList) {
        String[] parts = numberList.split(",");
        int[] result = new int[parts.length];
        int i = 0;
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            result[i++] = Integer.parseInt(part.trim());
            ++n2;
        }
        return result;
    }

    public static SchemeAndData getSchemeAndDataByLevels(ArrayList<Integer> numbers, Object dataElement, Object schemeElement) {
        if (numbers == null || numbers.size() == 0) {
            return null;
        }
        if (schemeElement == null) {
            return null;
        }
        int number0 = numbers.get(0);
        numbers.remove(0);
        List<? extends DataElement> elements = LMLCheck.getLowerDataElements(dataElement);
        List<? extends SchemeElement> schemeElements = LMLCheck.getLowerSchemeElements(schemeElement);
        int i = 0;
        while (i < elements.size()) {
            block23: {
                DataElement element;
                block22: {
                    int[] listElements;
                    block21: {
                        int min;
                        element = elements.get(i);
                        if (element.getMin() == null) break block21;
                        int max = min = element.getMin().intValue();
                        if (element.getMax() != null) {
                            max = element.getMax().intValue();
                        }
                        if (min <= number0 && max >= number0) break block22;
                        break block23;
                    }
                    if (element.getList() == null) break block22;
                    boolean found = false;
                    int[] nArray = listElements = LMLCheck.getNumbersFromNumberlist(element.getList());
                    int n = listElements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int number = nArray[n2];
                        if (number == number0) {
                            found = true;
                            break;
                        }
                        ++n2;
                    }
                    if (!found) break block23;
                }
                SchemeElement scheme = null;
                int j = 0;
                while (j < schemeElements.size()) {
                    SchemeElement aScheme = schemeElements.get(j);
                    if (aScheme.getMin() != null) {
                        int min;
                        int max = min = aScheme.getMin().intValue();
                        if (aScheme.getMax() != null) {
                            max = aScheme.getMax().intValue();
                        }
                        int step = aScheme.getStep().intValue();
                        if (number0 >= min && number0 <= max && (number0 - min) % step == 0) {
                            scheme = aScheme;
                            break;
                        }
                    } else if (aScheme.getList() != null) {
                        int[] listElements;
                        int[] nArray = listElements = LMLCheck.getNumbersFromNumberlist(aScheme.getList());
                        int n = listElements.length;
                        int n3 = 0;
                        while (n3 < n) {
                            int number = nArray[n3];
                            if (number == number0) {
                                scheme = aScheme;
                                break;
                            }
                            ++n3;
                        }
                        if (scheme != null) break;
                    }
                    ++j;
                }
                if (scheme != null) {
                    if (numbers.size() == 0) {
                        return new SchemeAndData(element, scheme);
                    }
                    SchemeAndData result = LMLCheck.getSchemeAndDataByLevels(numbers, (Object)element, scheme);
                    if (result != null) {
                        return result;
                    }
                }
            }
            ++i;
        }
        if (dataElement instanceof DataType) {
            return null;
        }
        return new SchemeAndData((DataElement)dataElement, (SchemeElement)schemeElement);
    }

    public static SchemeAndData getSchemeAndDataByLevels(int number, Object dataElement, Object schemeElement) {
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        numbers.add(number);
        return LMLCheck.getSchemeAndDataByLevels(numbers, dataElement, schemeElement);
    }

    public static SchemeElement getSchemeByLevels(ArrayList<Integer> numbers, Object schemeElement) {
        if (numbers == null || numbers.size() == 0) {
            return null;
        }
        if (schemeElement == null) {
            return null;
        }
        int number0 = numbers.get(0);
        numbers.remove(0);
        List<? extends SchemeElement> schemeElements = LMLCheck.getLowerSchemeElements(schemeElement);
        SchemeElement scheme = null;
        int i = 0;
        while (i < schemeElements.size()) {
            SchemeElement aScheme = schemeElements.get(i);
            if (aScheme.getMin() != null) {
                int min;
                int max = min = aScheme.getMin().intValue();
                if (aScheme.getMax() != null) {
                    max = aScheme.getMax().intValue();
                }
                int aStep = aScheme.getStep().intValue();
                if (number0 >= min && number0 <= max && (number0 - min) % aStep == 0) {
                    scheme = aScheme;
                    break;
                }
            } else if (aScheme.getList() != null) {
                int[] listElements;
                int[] nArray = listElements = LMLCheck.getNumbersFromNumberlist(aScheme.getList());
                int n = listElements.length;
                int n2 = 0;
                while (n2 < n) {
                    int number = nArray[n2];
                    if (number == number0) {
                        scheme = aScheme;
                        break;
                    }
                    ++n2;
                }
                if (scheme != null) break;
            }
            ++i;
        }
        if (scheme == null) {
            return null;
        }
        if (numbers.size() == 0) {
            return scheme;
        }
        SchemeElement result = LMLCheck.getSchemeByLevels(numbers, scheme);
        return result;
    }

    public static int getSchemeLevel(Object element) {
        if (element instanceof SchemeType) {
            return 0;
        }
        if (element instanceof SchemeElement1) {
            return 1;
        }
        if (element instanceof SchemeElement2) {
            return 2;
        }
        if (element instanceof SchemeElement3) {
            return 3;
        }
        if (element instanceof SchemeElement4) {
            return 4;
        }
        if (element instanceof SchemeElement5) {
            return 5;
        }
        if (element instanceof SchemeElement6) {
            return 6;
        }
        if (element instanceof SchemeElement7) {
            return 7;
        }
        if (element instanceof SchemeElement8) {
            return 8;
        }
        if (element instanceof SchemeElement9) {
            return 9;
        }
        if (element instanceof SchemeElement) {
            return 10;
        }
        return -1;
    }

    public static DataElement isSchemenodeInThisData(int number, Object dataElement) {
        List<? extends DataElement> elements = LMLCheck.getLowerDataElements(dataElement);
        if (elements == null) {
            return null;
        }
        int i = 0;
        while (i < elements.size()) {
            DataElement element = elements.get(i);
            if (element.getMin() != null) {
                int min;
                int max = min = element.getMin().intValue();
                if (element.getMax() != null) {
                    max = element.getMax().intValue();
                }
                if (number >= min && number <= max) {
                    return element;
                }
            } else if (element.getList() != null) {
                int[] listElements;
                int[] nArray = listElements = LMLCheck.getNumbersFromNumberlist(element.getList());
                int n = listElements.length;
                int n2 = 0;
                while (n2 < n) {
                    int listElement = nArray[n2];
                    if (listElement == number) {
                        return element;
                    }
                    ++n2;
                }
            }
            ++i;
        }
        return null;
    }

    public static class SchemeAndData {
        public DataElement data;
        public SchemeElement scheme;

        public SchemeAndData(DataElement data, SchemeElement scheme) {
            this.data = data;
            this.scheme = scheme;
        }
    }
}

