/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rm.lml.internal.core.model;

import java.util.Comparator;
import org.eclipse.ptp.rm.lml.internal.core.elements.CellType;
import org.eclipse.ptp.rm.lml.internal.core.elements.RowType;

public class TableSorter
implements Comparator<RowType> {
    private final int up;
    private final int sortIndex;
    private final int sortDirection;
    private final String sortType;

    public TableSorter(String sortType, int up, int sortIndex, int sortDirection) {
        this.up = up;
        this.sortIndex = sortIndex;
        this.sortDirection = sortDirection;
        this.sortType = sortType;
    }

    @Override
    public int compare(RowType a, RowType b) {
        CellType aCell = a.getCell().get(this.sortIndex);
        String aValue = null;
        if (aCell != null) {
            aValue = aCell.getValue();
        }
        CellType bCell = b.getCell().get(this.sortIndex);
        String bValue = null;
        if (bCell != null) {
            bValue = bCell.getValue();
        }
        if (aCell == null && bCell == null || aValue != null && aValue.equals("?") && bValue != null && bValue.equals("?")) {
            return 0;
        }
        if (aCell == null || aValue == null || aValue.equals("?")) {
            return this.sortDirection == this.up ? -1 : 1;
        }
        if (bCell == null || bValue == null || bValue.equals("?")) {
            return this.sortDirection == this.up ? 1 : -1;
        }
        if (aValue.equals(bValue)) {
            return 0;
        }
        if (this.sortType.equals("numeric")) {
            if (this.sortDirection == this.up) {
                return Integer.parseInt(aValue) < Integer.parseInt(bValue) ? -1 : 1;
            }
            return Integer.parseInt(aValue) < Integer.parseInt(bValue) ? 1 : -1;
        }
        if (this.sortDirection == this.up) {
            return aValue.compareTo(bValue) < 0 ? -1 : 1;
        }
        return aValue.compareTo(bValue) < 0 ? 1 : -1;
    }
}

