/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.supplemental.fileupload.internal;

import org.apache.commons.io.FileCleaningTracker;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.service.ISessionStore;
import org.eclipse.rwt.service.SessionStoreEvent;
import org.eclipse.rwt.service.SessionStoreListener;

class CleaningTrackerUtil {
    static final String TRACKER_ATTR = CleaningTrackerUtil.class.getName().concat("#cleaningTrackerInstance");
    private static final FileUploadCleanupHandler LISTENER = new FileUploadCleanupHandler();

    private CleaningTrackerUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileCleaningTracker getCleaningTracker(boolean create) {
        FileCleaningTracker tracker;
        ISessionStore store;
        ISessionStore iSessionStore = store = RWT.getSessionStore();
        synchronized (iSessionStore) {
            tracker = (FileCleaningTracker)store.getAttribute(TRACKER_ATTR);
            if (tracker == null && create) {
                tracker = new FileCleaningTracker();
                store.setAttribute(TRACKER_ATTR, (Object)tracker);
                store.addSessionStoreListener((SessionStoreListener)LISTENER);
            }
        }
        return tracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void stopCleaningTracker(ISessionStore store) {
        ISessionStore iSessionStore = store;
        synchronized (iSessionStore) {
            FileCleaningTracker tracker = (FileCleaningTracker)store.getAttribute(TRACKER_ATTR);
            if (tracker != null) {
                tracker.exitWhenFinished();
                store.removeAttribute(TRACKER_ATTR);
            }
        }
    }

    private static class FileUploadCleanupHandler
    implements SessionStoreListener {
        private FileUploadCleanupHandler() {
        }

        public void beforeDestroy(SessionStoreEvent event) {
            CleaningTrackerUtil.stopCleaningTracker(event.getSessionStore());
        }
    }
}

