/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp.calls.net;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.recommenders.commons.bayesnet.BayesianNetwork;
import org.eclipse.recommenders.commons.bayesnet.Node;
import org.eclipse.recommenders.internal.completion.rcp.calls.net.IObjectMethodCallsNet;
import org.eclipse.recommenders.internal.utils.codestructs.DefinitionSite;
import org.eclipse.recommenders.internal.utils.codestructs.ObjectUsage;
import org.eclipse.recommenders.jayes.BayesNet;
import org.eclipse.recommenders.jayes.BayesNode;
import org.eclipse.recommenders.jayes.inference.junctionTree.JunctionTreeAlgorithm;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.Constants;
import org.eclipse.recommenders.utils.Tuple;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.eclipse.recommenders.utils.names.VmMethodName;

public class BayesNetWrapper
implements IObjectMethodCallsNet {
    private final ITypeName typeName;
    private JunctionTreeAlgorithm junctionTreeAlgorithm;
    private BayesNet bayesNet;
    private BayesNode callgroupNode;
    private BayesNode contextNode;
    private BayesNode kindNode;
    private BayesNode definitionNode;
    private final HashMap<IMethodName, BayesNode> callNodes;

    public BayesNetWrapper(ITypeName name, BayesianNetwork network) {
        this.typeName = name;
        this.callNodes = new HashMap();
        this.initializeNetwork(network);
    }

    private void initializeNetwork(BayesianNetwork network) {
        this.bayesNet = new BayesNet();
        this.initializeNodes(network);
        this.initializeArcs(network);
        this.initializeProbabilities(network);
        this.junctionTreeAlgorithm = new JunctionTreeAlgorithm();
        this.junctionTreeAlgorithm.setNetwork(this.bayesNet);
    }

    private void initializeNodes(BayesianNetwork network) {
        Collection nodes = network.getNodes();
        for (Node node : nodes) {
            BayesNode bayesNode = new BayesNode(node.getIdentifier());
            String[] states = node.getStates();
            int i = 0;
            while (i < states.length) {
                bayesNode.addOutcome(states[i]);
                ++i;
            }
            this.bayesNet.addNode(bayesNode);
            if (node.getIdentifier().equals("contexts")) {
                this.contextNode = bayesNode;
                continue;
            }
            if (node.getIdentifier().equals("patterns")) {
                this.callgroupNode = bayesNode;
                continue;
            }
            if (node.getIdentifier().equals("kinds")) {
                this.kindNode = bayesNode;
                continue;
            }
            if (node.getIdentifier().equals("definitions")) {
                this.definitionNode = bayesNode;
                continue;
            }
            VmMethodName vmMethodName = VmMethodName.get((String)node.getIdentifier());
            this.callNodes.put((IMethodName)vmMethodName, bayesNode);
        }
    }

    private void initializeArcs(BayesianNetwork network) {
        Collection nodes = network.getNodes();
        for (Node node : nodes) {
            Node[] parents = node.getParents();
            BayesNode children = this.bayesNet.getNode(node.getIdentifier());
            LinkedList<BayesNode> bnParents = new LinkedList<BayesNode>();
            int i = 0;
            while (i < parents.length) {
                bnParents.add(this.bayesNet.getNode(parents[i].getIdentifier()));
                ++i;
            }
            children.setParents(bnParents);
        }
    }

    private void initializeProbabilities(BayesianNetwork network) {
        Collection nodes = network.getNodes();
        for (Node node : nodes) {
            BayesNode bayesNode = this.bayesNet.getNode(node.getIdentifier());
            bayesNode.setProbabilities(node.getProbabilities());
        }
    }

    @Override
    public ITypeName getType() {
        return this.typeName;
    }

    @Override
    public void clearEvidence() {
        this.junctionTreeAlgorithm.setEvidence(new HashMap());
    }

    @Override
    public void setMethodContext(IMethodName newActiveMethodContext) {
        String identifier = newActiveMethodContext == null ? Constants.UNKNOWN_METHOD.getIdentifier() : newActiveMethodContext.getIdentifier();
        if (this.contextNode.getOutcomes().contains(identifier)) {
            this.junctionTreeAlgorithm.addEvidence(this.contextNode, identifier);
        }
    }

    @Override
    public void setKind(DefinitionSite.Kind newKind) {
        if (newKind == null) {
            this.clearEvidence();
            return;
        }
        String identifier = newKind.toString();
        if (this.kindNode.getOutcomes().contains(identifier)) {
            this.junctionTreeAlgorithm.addEvidence(this.kindNode, identifier);
        }
    }

    @Override
    public void setDefinition(IMethodName newDefinition) {
        String identifier;
        String string = identifier = newDefinition == null ? Constants.N_STATE_DUMMY_DEF : newDefinition.getIdentifier();
        if (this.definitionNode.getOutcomes().contains(identifier)) {
            this.junctionTreeAlgorithm.addEvidence(this.definitionNode, identifier);
        }
    }

    @Override
    public void setObservedMethodCalls(ITypeName rebaseType, Set<IMethodName> invokedMethods) {
        for (IMethodName invokedMethod : invokedMethods) {
            IMethodName rebased = rebaseType == null ? invokedMethod : VmMethodName.rebase((ITypeName)rebaseType, (IMethodName)invokedMethod);
            this.setCalled(rebased);
        }
        if (rebaseType != null) {
            VmMethodName no = VmMethodName.rebase((ITypeName)rebaseType, (IMethodName)Constants.NO_METHOD);
            this.setCalled((IMethodName)no, "false");
        }
    }

    @Override
    public void setQuery(ObjectUsage query) {
        this.clearEvidence();
        this.setMethodContext(query.contextFirst);
        this.setKind(query.kind);
        if (query.definition != null && !query.definition.equals(Constants.UNKNOWN_METHOD)) {
            this.setDefinition(query.definition);
        }
        this.setObservedMethodCalls(query.type, query.calls);
    }

    @Override
    public void setCalled(IMethodName calledMethod) {
        this.setCalled(calledMethod, "true");
    }

    public void setCalled(IMethodName calledMethod, String state) {
        BayesNode node = this.bayesNet.getNode(calledMethod.getIdentifier());
        if (node != null) {
            this.junctionTreeAlgorithm.addEvidence(node, state);
        }
    }

    @Override
    public SortedSet<Tuple<IMethodName, Double>> getRecommendedMethodCalls(double minProbabilityThreshold) {
        TreeSet<Tuple<IMethodName, Double>> res = this.createSortedSet();
        for (IMethodName method : this.callNodes.keySet()) {
            BayesNode bayesNode = this.callNodes.get(method);
            boolean isAlreadyUsedAsEvidence = this.junctionTreeAlgorithm.getEvidence().containsKey(bayesNode);
            if (isAlreadyUsedAsEvidence) continue;
            int indexForTrue = bayesNode.getOutcomeIndex("true");
            double[] probabilities = this.junctionTreeAlgorithm.getBeliefs(bayesNode);
            double probability = probabilities[indexForTrue];
            if (!(probability >= minProbabilityThreshold)) continue;
            res.add((Tuple<IMethodName, Double>)Tuple.newTuple((Object)method, (Object)probability));
        }
        return res;
    }

    private TreeSet<Tuple<IMethodName, Double>> createSortedSet() {
        TreeSet res = Sets.newTreeSet((Comparator)new Comparator<Tuple<IMethodName, Double>>(){

            @Override
            public int compare(Tuple<IMethodName, Double> o1, Tuple<IMethodName, Double> o2) {
                int probabilityCompare = Double.compare((Double)o2.getSecond(), (Double)o1.getSecond());
                return probabilityCompare != 0 ? probabilityCompare : ((IMethodName)o1.getFirst()).compareTo((Object)((IMethodName)o2.getFirst()));
            }
        });
        return res;
    }

    @Override
    public SortedSet<Tuple<IMethodName, Double>> getRecommendedMethodCalls(double minProbabilityThreshold, int maxNumberOfRecommendations) {
        SortedSet<Tuple<IMethodName, Double>> recommendations = this.getRecommendedMethodCalls(minProbabilityThreshold);
        if (recommendations.size() <= maxNumberOfRecommendations) {
            return recommendations;
        }
        Tuple firstExcludedRecommendation = (Tuple)Iterables.get(recommendations, (int)maxNumberOfRecommendations);
        SortedSet<Tuple<IMethodName, Double>> res = recommendations.headSet((Tuple<IMethodName, Double>)firstExcludedRecommendation);
        Checks.ensureEquals((Object)res.size(), (Object)maxNumberOfRecommendations, (String)"filter op did not return expected number of compilationUnits2recommendationsIndex");
        return res;
    }

    @Override
    public List<Tuple<String, Double>> getPatternsWithProbability() {
        double[] probs = this.junctionTreeAlgorithm.getBeliefs(this.callgroupNode);
        ArrayList res = Lists.newArrayListWithCapacity((int)probs.length);
        Set outcomes = this.callgroupNode.getOutcomes();
        for (String outcome : outcomes) {
            int probIndex = this.callgroupNode.getOutcomeIndex(outcome);
            double p = probs[probIndex];
            if (0.01 > p) continue;
            res.add(Tuple.newTuple((Object)outcome, (Object)p));
        }
        return res;
    }

    @Override
    public void setPattern(String patternName) {
        this.junctionTreeAlgorithm.addEvidence(this.callgroupNode, patternName);
    }

    @Override
    public Collection<IMethodName> getMethodCalls() {
        return new LinkedList<IMethodName>(this.callNodes.keySet());
    }

    @Override
    public Collection<IMethodName> getContexts() {
        Set outcomes = this.contextNode.getOutcomes();
        LinkedList<IMethodName> result = new LinkedList<IMethodName>();
        for (String outcome : outcomes) {
            result.add((IMethodName)VmMethodName.get((String)outcome));
        }
        return result;
    }

    @Override
    public IMethodName getActiveContext() {
        return this.computeMethodNameFromState(this.contextNode);
    }

    private IMethodName computeMethodNameFromState(BayesNode node) {
        String stateId = (String)this.junctionTreeAlgorithm.getEvidence().get(node);
        if (stateId == null) {
            return VmMethodName.NULL;
        }
        return VmMethodName.get((String)stateId);
    }

    @Override
    public IMethodName getActiveDefinition() {
        return this.computeMethodNameFromState(this.definitionNode);
    }

    @Override
    public DefinitionSite.Kind getActiveKind() {
        String stateId = (String)this.junctionTreeAlgorithm.getEvidence().get(this.kindNode);
        if (stateId == null) {
            return DefinitionSite.Kind.UNKNOWN;
        }
        return DefinitionSite.Kind.valueOf((String)stateId);
    }

    @Override
    public Set<IMethodName> getActiveCalls() {
        TreeSet res = Sets.newTreeSet();
        Map evidence = this.junctionTreeAlgorithm.getEvidence();
        for (BayesNode methodNode : this.callNodes.values()) {
            if (!evidence.containsKey(methodNode) || !((String)evidence.get(methodNode)).equals("true")) continue;
            res.add(VmMethodName.get((String)methodNode.getName()));
        }
        res.remove(VmMethodName.NULL);
        return res;
    }

    @Override
    public Set<Tuple<String, Double>> getDefinitions() {
        HashSet res = Sets.newHashSet();
        double[] beliefs = this.junctionTreeAlgorithm.getBeliefs(this.definitionNode);
        int i = this.definitionNode.getOutcomeCount();
        while (i-- > 0) {
            String outcomeName;
            if (!(beliefs[i] > 0.05) || (outcomeName = this.definitionNode.getOutcomeName(i)).equals("LNone.none()V") || outcomeName.equals(Constants.UNKNOWN_METHOD.getIdentifier())) continue;
            res.add(Tuple.newTuple((Object)outcomeName, (Object)beliefs[i]));
        }
        return res;
    }
}

