/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp.calls.preferences;

import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.recommenders.rcp.ClasspathEntryInfo;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.Tuple;
import org.eclipse.swt.graphics.Image;

public class VersionLabelProvider
extends ColumnLabelProvider {
    public static final String NLS_UNKNOWN = "Some details are unknown for this dependency";
    public static final String NLS_KNOWN = "Name and version of dependency is known";
    private final Image versionUnknownImage;
    private final Image versionImage;

    public VersionLabelProvider(Image versionUnknownImage, Image versionImage) {
        this.versionUnknownImage = versionUnknownImage;
        this.versionImage = versionImage;
    }

    public Image getImage(Object element) {
        return this.hasDependencyInformation(element) ? this.versionImage : this.versionUnknownImage;
    }

    public String getToolTipText(Object element) {
        return this.hasDependencyInformation(element) ? NLS_KNOWN : NLS_UNKNOWN;
    }

    private boolean hasDependencyInformation(Object element) {
        Tuple e = (Tuple)Checks.cast((Object)element);
        ClasspathEntryInfo cpei = (ClasspathEntryInfo)e.getFirst();
        return !StringUtils.isEmpty((CharSequence)cpei.getSymbolicName()) && !cpei.getVersion().isUnknown();
    }
}

