/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp.calls.wiring;

import com.google.inject.AbstractModule;
import com.google.inject.BindingAnnotation;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import java.io.File;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.recommenders.internal.completion.rcp.calls.net.IObjectMethodCallsNet;
import org.eclipse.recommenders.internal.completion.rcp.calls.wiring.CallsCompletionPlugin;
import org.eclipse.recommenders.internal.completion.rcp.calls.wiring.ManualModelStoreWiring;
import org.eclipse.recommenders.internal.rcp.models.IModelArchiveStore;
import org.eclipse.recommenders.internal.rcp.models.store.DefaultModelArchiveStore;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class CallsCompletionModule
extends AbstractModule {
    public static final String MODEL_VERSION = "0.5";
    public static TypeLiteral<IModelArchiveStore<IType, IObjectMethodCallsNet>> STORE = new TypeLiteral<IModelArchiveStore<IType, IObjectMethodCallsNet>>(){};
    public static TypeLiteral<DefaultModelArchiveStore<IType, IObjectMethodCallsNet>> STORE_IMPL = new TypeLiteral<DefaultModelArchiveStore<IType, IObjectMethodCallsNet>>(){};

    protected void configure() {
        IPath stateLocation = Platform.getStateLocation((Bundle)FrameworkUtil.getBundle(((Object)((Object)this)).getClass()));
        File index = new File(stateLocation.toFile(), String.format("call-models-%s.json", MODEL_VERSION));
        this.bind(File.class).annotatedWith(CallCompletion.class).toInstance((Object)index);
        this.bind(STORE).to(ManualModelStoreWiring.CallModelArchiveStore.class).in(Scopes.SINGLETON);
        IPreferenceStore prefStore = CallsCompletionPlugin.getDefault().getPreferenceStore();
        this.bind(IPreferenceStore.class).annotatedWith(CallCompletion.class).toInstance((Object)prefStore);
    }

    @BindingAnnotation
    @Target(value={ElementType.PARAMETER, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface CallCompletion {
    }
}

