/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp.templates;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.ITypeName;

public final class PatternRecommendation
implements Comparable<PatternRecommendation> {
    private final String name;
    private final ITypeName type;
    private final ImmutableList<IMethodName> methods;
    private final double probability;

    public PatternRecommendation(String name, ITypeName type, Collection<IMethodName> methods, double probability) {
        this.name = (String)Checks.ensureIsNotNull((Object)name);
        this.type = (ITypeName)Checks.ensureIsNotNull((Object)type);
        this.methods = ImmutableList.copyOf(methods);
        this.probability = probability;
    }

    public String getName() {
        return this.name;
    }

    public ITypeName getType() {
        return this.type;
    }

    public ImmutableList<IMethodName> getMethods() {
        return this.methods;
    }

    public double getProbability() {
        return this.probability;
    }

    public int hashCode() {
        return this.methods.hashCode();
    }

    @Override
    public int compareTo(PatternRecommendation other) {
        return Double.valueOf(this.probability).compareTo(other.probability);
    }

    public boolean equals(Object object) {
        return object instanceof PatternRecommendation && this.methods.equals(((PatternRecommendation)object).methods);
    }
}

