/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp.templates;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang3.CharUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.internal.codeassist.ISearchRequestor;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnMemberAccess;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnQualifiedNameReference;
import org.eclipse.jdt.internal.codeassist.complete.CompletionOnSingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.SuperTypeHierarchyCache;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposalComputer;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.recommenders.completion.rcp.IRecommendersCompletionContext;
import org.eclipse.recommenders.completion.rcp.IRecommendersCompletionContextFactory;
import org.eclipse.recommenders.internal.completion.rcp.DisableContentAssistCategoryJob;
import org.eclipse.recommenders.internal.completion.rcp.calls.engine.AstBasedObjectUsageResolver;
import org.eclipse.recommenders.internal.completion.rcp.calls.net.IObjectMethodCallsNet;
import org.eclipse.recommenders.internal.completion.rcp.templates.PatternRecommendation;
import org.eclipse.recommenders.internal.completion.rcp.templates.ProposalBuilder;
import org.eclipse.recommenders.internal.rcp.models.IModelArchiveStore;
import org.eclipse.recommenders.internal.utils.codestructs.DefinitionSite;
import org.eclipse.recommenders.internal.utils.codestructs.ObjectUsage;
import org.eclipse.recommenders.rcp.RecommendersPlugin;
import org.eclipse.recommenders.utils.Throws;
import org.eclipse.recommenders.utils.Tuple;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.VmMethodName;
import org.eclipse.recommenders.utils.rcp.JavaElementResolver;
import org.eclipse.recommenders.utils.rcp.JdtUtils;
import org.eclipse.recommenders.utils.rcp.ast.MethodDeclarationFinder;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class TemplatesCompletionProposalComputer
implements IJavaCompletionProposalComputer {
    private static final String CATEGORY_ID = "org.eclipse.recommenders.completion.rcp.templates.category";
    private final IRecommendersCompletionContextFactory ctxFactory;
    private IRecommendersCompletionContext rCtx;
    private IMethod enclosingMethod;
    private Set<IType> candidates;
    private String variableName;
    private boolean requiresConstructor;
    private String methodPrefix;
    private CompletionMode mode;
    private final IModelArchiveStore<IType, IObjectMethodCallsNet> store;
    private final JavaElementResolver elementResolver;
    private Image icon;

    @Inject
    public TemplatesCompletionProposalComputer(IRecommendersCompletionContextFactory ctxFactory, IModelArchiveStore<IType, IObjectMethodCallsNet> store, JavaElementResolver elementResolver) {
        this.ctxFactory = ctxFactory;
        this.store = store;
        this.elementResolver = elementResolver;
        this.loadImage();
    }

    private void loadImage() {
        Bundle bundle = FrameworkUtil.getBundle(TemplatesCompletionProposalComputer.class);
        this.icon = null;
        if (bundle != null) {
            ImageDescriptor desc = AbstractUIPlugin.imageDescriptorFromPlugin((String)bundle.getSymbolicName(), (String)"metadata/icon2.gif");
            this.icon = desc.createImage();
        }
    }

    @VisibleForTesting
    public CompletionMode getCompletionMode() {
        return this.mode;
    }

    @VisibleForTesting
    public String getVariableName() {
        return this.variableName;
    }

    @VisibleForTesting
    public String getMethodPrefix() {
        return this.methodPrefix;
    }

    public List computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        if (!this.shouldMakeProposals()) {
            return Collections.EMPTY_LIST;
        }
        this.rCtx = this.ctxFactory.create((JavaContentAssistInvocationContext)context);
        if (!this.findEnclosingMethod()) {
            return Collections.emptyList();
        }
        if (!this.findCompletionMode()) {
            return Collections.emptyList();
        }
        if (!this.findPotentialTypes()) {
            return Collections.emptyList();
        }
        ProposalBuilder proposalBuilder = new ProposalBuilder(this.icon, this.rCtx, this.elementResolver, this.variableName);
        for (IType t : this.candidates) {
            this.addPatternsForType(t, proposalBuilder);
        }
        return proposalBuilder.createProposals();
    }

    @VisibleForTesting
    protected boolean shouldMakeProposals() {
        Object[] excluded = PreferenceConstants.getExcludedCompletionProposalCategories();
        HashSet ex = Sets.newHashSet((Object[])excluded);
        if (!ex.contains(CATEGORY_ID)) {
            new DisableContentAssistCategoryJob(CATEGORY_ID).schedule();
            return false;
        }
        return true;
    }

    private void addPatternsForType(IType t, ProposalBuilder proposalBuilder) {
        Optional optModel = this.store.aquireModel((Object)t);
        if (!optModel.isPresent()) {
            return;
        }
        IObjectMethodCallsNet model = (IObjectMethodCallsNet)optModel.get();
        ObjectUsage query = this.createQuery(t);
        model.setQuery(query);
        List<Tuple<String, Double>> callgroups = this.getMostLikelyPatternsSortedByProbability(model);
        for (Tuple<String, Double> p : callgroups) {
            String patternId = (String)p.getFirst();
            model.setPattern(patternId);
            for (Tuple def : model.getDefinitions()) {
                Collection<IMethodName> calls = this.getCallsForDefinition(model, (IMethodName)VmMethodName.get((String)((String)def.getFirst())));
                calls.removeAll(query.calls);
                if (calls.size() < 2) continue;
                PatternRecommendation pattern = new PatternRecommendation(patternId, model.getType(), calls, (Double)p.getSecond());
                proposalBuilder.addPattern(pattern);
            }
        }
        this.store.releaseModel((Object)model);
    }

    private Collection<IMethodName> getCallsForDefinition(IObjectMethodCallsNet model, IMethodName definition) {
        boolean constructorAdded = false;
        TreeSet calls = Sets.newTreeSet();
        SortedSet rec = model.getRecommendedMethodCalls(0.2);
        if (rec.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.requiresConstructor && definition.isInit()) {
            calls.add(definition);
            constructorAdded = true;
        }
        if (this.requiresConstructor && !constructorAdded) {
            return Collections.emptyList();
        }
        for (Tuple pair : rec) {
            calls.add((IMethodName)pair.getFirst());
        }
        if (!this.containsCallWithMethodPrefix(calls)) {
            return Collections.emptyList();
        }
        return calls;
    }

    private boolean containsCallWithMethodPrefix(TreeSet<IMethodName> calls) {
        for (IMethodName call : calls) {
            if (!call.getName().startsWith(this.methodPrefix)) continue;
            return true;
        }
        return false;
    }

    private ObjectUsage createQuery(IType t) {
        Optional<ObjectUsage> optUsage;
        ObjectUsage query = new ObjectUsage();
        query.type = this.elementResolver.toRecType(t);
        this.setContextOnQuery(query);
        query.kind = DefinitionSite.Kind.NEW;
        this.requiresConstructor = true;
        if ((this.mode == CompletionMode.THIS || this.mode == CompletionMode.MEMBER_ACCESS) && (optUsage = this.findCompletionObjectUsage()).isPresent()) {
            ObjectUsage usage = (ObjectUsage)optUsage.get();
            query.calls = usage.calls;
            if (usage.kind != null) {
                query.kind = usage.kind;
                boolean bl = this.requiresConstructor = query.kind == DefinitionSite.Kind.UNKNOWN;
            }
            if (usage.definition != null) {
                query.definition = usage.definition;
                Optional def = this.rCtx.getMethodDef();
                if (def.isPresent()) {
                    query.definition = (IMethodName)def.get();
                    query.kind = DefinitionSite.Kind.METHOD_RETURN;
                    this.requiresConstructor = false;
                }
            }
        }
        return query;
    }

    private Optional<ObjectUsage> findCompletionObjectUsage() {
        IMethod jdtMethod;
        IMethodName recMethod;
        Optional astMethod;
        CompilationUnit ast = this.rCtx.getAST();
        Optional enclosingMethod = this.rCtx.getEnclosingMethod();
        if (enclosingMethod.isPresent() && (astMethod = MethodDeclarationFinder.find((CompilationUnit)ast, (IMethodName)(recMethod = (IMethodName)this.elementResolver.toRecMethod(jdtMethod = (IMethod)enclosingMethod.get()).or((Object)VmMethodName.NULL)))).isPresent()) {
            AstBasedObjectUsageResolver r = new AstBasedObjectUsageResolver();
            return Optional.of((Object)r.findObjectUsage(this.variableName, (MethodDeclaration)astMethod.get()));
        }
        return Optional.absent();
    }

    private void setContextOnQuery(ObjectUsage query) {
        Optional ovrMethod = JdtUtils.findOverriddenMethod((IMethod)this.enclosingMethod);
        query.contextSuper = (IMethodName)this.elementResolver.toRecMethod((IMethod)ovrMethod.orNull()).orNull();
        IMethod firstMethod = JdtUtils.findFirstDeclaration((IMethod)this.enclosingMethod);
        query.contextFirst = (IMethodName)this.elementResolver.toRecMethod(firstMethod).orNull();
    }

    private List<Tuple<String, Double>> getMostLikelyPatternsSortedByProbability(IObjectMethodCallsNet net) {
        List p = net.getPatternsWithProbability();
        Collections.sort(p, new Comparator<Tuple<String, Double>>(){

            @Override
            public int compare(Tuple<String, Double> o1, Tuple<String, Double> o2) {
                return ((Double)o2.getSecond()).compareTo((Double)o1.getSecond());
            }
        });
        return p;
    }

    private boolean findCompletionMode() {
        this.variableName = "";
        this.methodPrefix = "";
        this.mode = null;
        ASTNode n = this.rCtx.getCompletionNode();
        if (n instanceof CompletionOnSingleNameReference) {
            if (this.isPotentialClassName((CompletionOnSingleNameReference)n)) {
                this.mode = CompletionMode.TYPE_NAME;
            } else {
                this.mode = CompletionMode.THIS;
                this.methodPrefix = this.rCtx.getReceiverName();
            }
        } else if (n instanceof CompletionOnQualifiedNameReference) {
            if (this.isPotentialClassName((CompletionOnQualifiedNameReference)n)) {
                this.mode = CompletionMode.TYPE_NAME;
            } else {
                this.mode = CompletionMode.MEMBER_ACCESS;
                this.variableName = this.rCtx.getReceiverName();
                this.methodPrefix = this.rCtx.getPrefix();
            }
        } else if (n instanceof CompletionOnMemberAccess) {
            Expression ma = ((CompletionOnMemberAccess)n).receiver;
            this.mode = ma.isImplicitThis() || ma.isSuper() || ma.isThis() ? CompletionMode.THIS : CompletionMode.MEMBER_ACCESS;
        }
        return this.mode != null;
    }

    private boolean findPotentialTypes() {
        if (this.mode == CompletionMode.TYPE_NAME) {
            ASTNode n = this.rCtx.getCompletionNode();
            CompletionOnSingleNameReference c = null;
            if (n instanceof CompletionOnSingleNameReference) {
                c = (CompletionOnSingleNameReference)n;
                this.candidates = this.findTypesBySimpleName(c.token);
            }
        } else if (this.mode == CompletionMode.THIS) {
            this.createCandidatesFromOptional(this.getSupertypeOfThis());
        } else {
            this.createCandidatesFromOptional((Optional<IType>)this.rCtx.getReceiverType());
        }
        return this.candidates != null;
    }

    private Optional<IType> getSupertypeOfThis() {
        try {
            IMethod m = (IMethod)this.rCtx.getEnclosingMethod().orNull();
            if (m == null || JdtFlags.isStatic((IMember)m)) {
                return Optional.absent();
            }
            IType type = m.getDeclaringType();
            ITypeHierarchy hierarchy = SuperTypeHierarchyCache.getTypeHierarchy((IType)type);
            return Optional.of((Object)hierarchy.getSuperclass(type));
        }
        catch (Exception e) {
            RecommendersPlugin.logError((Exception)e, (String)"Failed to resolve super type of %s", (Object[])new Object[]{this.rCtx.getEnclosingElement()});
            return Optional.absent();
        }
    }

    private void createCandidatesFromOptional(Optional<IType> optType) {
        if (optType.isPresent()) {
            this.candidates = Sets.newHashSet((Object[])new IType[]{(IType)optType.get()});
        }
    }

    private boolean isPotentialClassName(CompletionOnQualifiedNameReference c) {
        char[] name = c.completionIdentifier;
        return name != null && name.length > 0 && CharUtils.isAsciiAlphaUpper((char)name[0]);
    }

    private boolean isPotentialClassName(CompletionOnSingleNameReference c) {
        return c.token != null && c.token.length > 0 && CharUtils.isAsciiAlphaUpper((char)c.token[0]);
    }

    private boolean findEnclosingMethod() {
        this.enclosingMethod = (IMethod)this.rCtx.getEnclosingMethod().orNull();
        return this.enclosingMethod != null;
    }

    public void sessionStarted() {
    }

    public List<IContextInformation> computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return Collections.emptyList();
    }

    public String getErrorMessage() {
        return null;
    }

    public void sessionEnded() {
    }

    public Set<IType> findTypesBySimpleName(char[] simpleTypeName) {
        final HashSet result = Sets.newHashSet();
        try {
            final JavaProject project = (JavaProject)this.rCtx.getProject();
            SearchableEnvironment environment = project.newSearchableNameEnvironment((WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
            environment.findExactTypes(simpleTypeName, false, 0, new ISearchRequestor(){

                public void acceptConstructor(int modifiers, char[] simpleTypeName, int parameterCount, char[] signature, char[][] parameterTypes, char[][] parameterNames, int typeModifiers, char[] packageName, int extraFlags, String path, AccessRestriction access) {
                }

                public void acceptType(char[] packageName, char[] typeName, char[][] enclosingTypeNames, int modifiers, AccessRestriction accessRestriction) {
                    try {
                        IType res = project.findType(String.valueOf(packageName), String.valueOf(typeName));
                        if (res != null) {
                            result.add(res);
                        }
                    }
                    catch (JavaModelException e) {
                        e.printStackTrace();
                    }
                }

                public void acceptPackage(char[] packageName) {
                }
            });
        }
        catch (JavaModelException e) {
            Throws.throwUnhandledException((Exception)((Object)e));
        }
        return result;
    }

    public static enum CompletionMode {
        TYPE_NAME,
        MEMBER_ACCESS,
        THIS;

    }
}

