/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.extdoc.rcp.providers.examples;

import javax.inject.Inject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.recommenders.extdoc.CodeExamples;
import org.eclipse.recommenders.extdoc.CodeSnippet;
import org.eclipse.recommenders.extdoc.rcp.providers.ExtdocProvider;
import org.eclipse.recommenders.extdoc.rcp.providers.JavaSelectionSubscriber;
import org.eclipse.recommenders.internal.extdoc.rcp.ui.ExtdocUtils;
import org.eclipse.recommenders.rcp.events.JavaSelectionEvent;
import org.eclipse.recommenders.utils.rcp.JavaElementResolver;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public final class ExamplesProvider
extends ExtdocProvider {
    private final JavaElementResolver resolver;

    @Inject
    public ExamplesProvider(JavaElementResolver resolver) {
        this.resolver = resolver;
    }

    @JavaSelectionSubscriber
    public ExtdocProvider.Status onTypeRootSelection(ITypeRoot root, JavaSelectionEvent event, Composite parent) {
        IType type = root.findPrimaryType();
        if (type != null) {
            return this.onTypeSelection(type, event, parent);
        }
        return ExtdocProvider.Status.NOT_AVAILABLE;
    }

    @JavaSelectionSubscriber
    public ExtdocProvider.Status onTypeSelection(IType type, JavaSelectionEvent event, Composite parent) {
        this.resolver.toRecType(type);
        return ExtdocProvider.Status.NOT_AVAILABLE;
    }

    private class TypeSelfcallDirectivesRenderer
    implements Runnable {
        private final CodeExamples examples;
        private final Composite parent;
        private Composite container;

        public TypeSelfcallDirectivesRenderer(IType type, CodeExamples examples, Composite parent) {
            this.examples = examples;
            this.parent = parent;
        }

        @Override
        public void run() {
            this.createContainer();
            this.addDirectives();
        }

        private void createContainer() {
            this.container = new Composite(this.parent, 0);
            ExtdocUtils.setInfoBackgroundColor((Control)this.container);
            this.container.setLayout((Layout)new GridLayout());
        }

        private void addDirectives() {
            CodeSnippet[] codeSnippetArray = this.examples.getExamples();
            int n = codeSnippetArray.length;
            int n2 = 0;
            while (n2 < n) {
                CodeSnippet snippet = codeSnippetArray[n2];
                ExtdocUtils.createSourceCodeArea(this.container, snippet.getCode());
                ++n2;
            }
        }
    }
}

