/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.extdoc.rcp.scheduling;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.eclipse.recommenders.extdoc.rcp.providers.ExtdocProvider;
import org.eclipse.recommenders.internal.extdoc.rcp.scheduling.Events;
import org.eclipse.recommenders.internal.extdoc.rcp.scheduling.SubscriptionManager;
import org.eclipse.recommenders.internal.extdoc.rcp.ui.ProviderContentPart;
import org.eclipse.recommenders.rcp.events.JavaSelectionEvent;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.Executors;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class ProviderExecutionScheduler {
    protected static int RENDER_TIMEOUT_IN_MS = 4000;
    private static final int NUMBER_OF_THREADS = 7;
    private static int poolId;
    private final ListeningExecutorService pool;
    private final Map<ExtdocProvider, Future<?>> futures;
    private final List<ExtdocProvider> providers;
    private final SubscriptionManager subscriptionManager;
    private final ProviderContentPart contentPart;
    private EventBus extdocBus;
    private Boolean isAlreadyRendered = false;
    private JavaSelectionEvent currentSelection;
    private final CountDownLatch latch;

    private static ListeningExecutorService createListeningThreadPool(int numberOfThreads) {
        String threadPoolId = "Recommenders-extdoc-pool-" + poolId++ + "thread-";
        ThreadPoolExecutor pool = Executors.coreThreadsTimoutExecutor((int)7, (int)1, (String)threadPoolId);
        ListeningExecutorService listeningPool = MoreExecutors.listeningDecorator((ExecutorService)pool);
        return listeningPool;
    }

    public ProviderExecutionScheduler(List<ExtdocProvider> providers, SubscriptionManager subscriptionManager, ProviderContentPart contentPart, EventBus extdocBus) {
        this.providers = providers;
        this.extdocBus = extdocBus;
        this.subscriptionManager = subscriptionManager;
        this.contentPart = contentPart;
        this.pool = ProviderExecutionScheduler.createListeningThreadPool(7);
        this.futures = Maps.newHashMap();
        extdocBus.register((Object)this);
        this.latch = new CountDownLatch(providers.size());
    }

    public void scheduleOnSelection(JavaSelectionEvent selection) {
        this.currentSelection = selection;
        this.createNewRenderingPanelInUiThread();
        this.postInUiThread(new Events.NewSelectionEvent(selection));
        for (ExtdocProvider provider : this.providers) {
            if (!provider.isEnabled()) {
                this.latch.countDown();
                continue;
            }
            Composite composite = this.contentPart.getRenderingArea(provider);
            Optional<Method> optMethod = this.subscriptionManager.findSubscribedMethod(provider, selection);
            if (optMethod.isPresent()) {
                OnSelectionCallable callable = new OnSelectionCallable(provider, (Method)optMethod.get(), selection, composite, this.latch);
                try {
                    ListenableFuture future = this.pool.submit((Callable)callable);
                    this.futures.put(provider, (Future<?>)future);
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    this.latch.countDown();
                }
                continue;
            }
            this.postInUiThread(new Events.ProviderNotAvailableEvent(provider));
            this.latch.countDown();
        }
        this.blockUntilAllFinishedOrRenderTimeout();
        this.postProviderDelayedEventsForLateProviders();
        this.triggerRenderNow();
    }

    private void createNewRenderingPanelInUiThread() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ProviderExecutionScheduler.this.contentPart.createNewRenderingPanel();
            }
        });
    }

    protected void blockUntilAllFinishedOrRenderTimeout() {
        try {
            this.latch.await(RENDER_TIMEOUT_IN_MS, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void postProviderDelayedEventsForLateProviders() {
        for (ExtdocProvider provider : this.providers) {
            Future<?> future = this.futures.get(provider);
            if (future == null || future.isDone()) continue;
            this.postInUiThread(new Events.ProviderDelayedEvent(provider));
        }
    }

    private void triggerRenderNow() {
        this.postInUiThread(new Events.RenderNowEvent());
        this.isAlreadyRendered = true;
    }

    @Subscribe
    public void onEvent(Events.ProviderActivationEvent e) {
        if (this.isRunning(e.provider)) {
            return;
        }
        Composite composite = this.contentPart.getRenderingArea(e.provider);
        Optional<Method> optMethod = this.subscriptionManager.findSubscribedMethod(e.provider, this.currentSelection);
        if (optMethod.isPresent()) {
            OnActivationCallable callable = new OnActivationCallable(e.provider, (Method)optMethod.get(), this.currentSelection, composite);
            if (this.pool.isShutdown()) {
                return;
            }
            ListenableFuture future = this.pool.submit((Callable)callable);
            this.futures.put(e.provider, (Future<?>)future);
        } else {
            this.postInUiThread(new Events.ProviderNotAvailableEvent(e.provider));
        }
    }

    private boolean isRunning(ExtdocProvider p) {
        return this.futures.containsKey(p);
    }

    @Subscribe
    public void onEvent(Events.ProviderDeactivationEvent e) {
        Future<?> future = this.futures.get(e.provider);
        if (future != null) {
            future.cancel(true);
        }
    }

    public void dispose() {
        this.pool.shutdownNow();
        this.extdocBus.unregister((Object)this);
        this.extdocBus = new EventBus();
        this.countLatchToZero();
    }

    private void countLatchToZero() {
        int i = 0;
        while (i < this.providers.size()) {
            this.latch.countDown();
            ++i;
        }
    }

    private void postInUiThread(Object event) {
        this.extdocBus.post(event);
    }

    private class OnActivationCallable
    implements Callable<Void> {
        private final ExtdocProvider provider;
        private final Method method;
        private final JavaSelectionEvent selection;
        private final Composite composite;

        public OnActivationCallable(ExtdocProvider provider, Method method, JavaSelectionEvent selection, Composite composite) {
            this.provider = provider;
            this.method = method;
            this.selection = selection;
            this.composite = composite;
        }

        @Override
        public Void call() throws Exception {
            ProviderExecutionScheduler.this.postInUiThread(new Events.ProviderStartedEvent(this.provider));
            try {
                ExtdocProvider.Status returnStatus = this.invokeProvider();
                if (ExtdocProvider.Status.NOT_AVAILABLE.equals((Object)returnStatus)) {
                    ProviderExecutionScheduler.this.postInUiThread(new Events.ProviderNotAvailableEvent(this.provider, this.isTooLate()));
                } else if (this.isTooLate()) {
                    ProviderExecutionScheduler.this.postInUiThread(new Events.ProviderFinishedLateEvent(this.provider));
                } else {
                    ProviderExecutionScheduler.this.postInUiThread(new Events.ProviderFinishedEvent(this.provider));
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException e) {
                ProviderExecutionScheduler.this.postInUiThread(new Events.ProviderFailedEvent(this.provider, e.getTargetException()));
            }
            catch (Exception e) {
                ProviderExecutionScheduler.this.postInUiThread(new Events.ProviderFailedEvent(this.provider, e));
            }
            ProviderExecutionScheduler.this.futures.remove(this.provider);
            return null;
        }

        protected boolean isTooLate() {
            return false;
        }

        private ExtdocProvider.Status invokeProvider() throws Exception {
            if (!this.method.isAccessible()) {
                this.method.setAccessible(true);
            }
            Object returnValue = this.method.invoke((Object)this.provider, this.selection.getElement(), this.selection, this.composite);
            ExtdocProvider.Status status = (ExtdocProvider.Status)((Object)Checks.cast((Object)returnValue));
            return status;
        }
    }

    private class OnSelectionCallable
    extends OnActivationCallable {
        private final CountDownLatch latch;

        public OnSelectionCallable(ExtdocProvider provider, Method method, JavaSelectionEvent selection, Composite composite, CountDownLatch latch) {
            super(provider, method, selection, composite);
            this.latch = latch;
        }

        @Override
        public Void call() throws Exception {
            try {
                super.call();
                return null;
            }
            finally {
                this.latch.countDown();
            }
        }

        @Override
        protected boolean isTooLate() {
            return ProviderExecutionScheduler.this.isAlreadyRendered;
        }
    }
}

