/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.extdoc.rcp.ui;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class OrderChangeHandler
extends DropTargetAdapter
implements DragSourceListener {
    private final Table table;
    private TableItem dragSourceItem;
    private final List<OrderChangedListener> listeners = Lists.newArrayList();

    public static OrderChangeHandler enable(Table table) {
        return new OrderChangeHandler(table);
    }

    private OrderChangeHandler(Table table) {
        this.table = table;
        Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
        DragSource source = new DragSource((Control)table, 7);
        source.setTransfer(types);
        source.addDragListener((DragSourceListener)this);
        DropTarget target = new DropTarget((Control)table, 7);
        target.setTransfer(types);
        target.addDropListener((DropTargetListener)this);
    }

    public void addListener(OrderChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(OrderChangedListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyAll(int oldIndex, int newIndex) {
        for (OrderChangedListener listener : this.listeners) {
            listener.orderChanged(oldIndex, newIndex);
        }
    }

    public void dragStart(DragSourceEvent event) {
        TableItem[] selection = this.table.getSelection();
        this.dragSourceItem = selection[0];
    }

    public void dragSetData(DragSourceEvent event) {
        event.data = this.dragSourceItem.getText();
    }

    public void dragFinished(DragSourceEvent event) {
        this.table.deselectAll();
        this.dragSourceItem = null;
    }

    public void dragOver(DropTargetEvent event) {
        event.feedback = 2;
    }

    public void drop(DropTargetEvent event) {
        boolean isDraggingFromWithinTable;
        boolean bl = isDraggingFromWithinTable = this.dragSourceItem != null;
        if (isDraggingFromWithinTable) {
            Widget dropTargetItem = event.item;
            int selIndex = this.findIndex((Widget)this.dragSourceItem, this.table);
            int dropIndex = this.findIndex(dropTargetItem, this.table);
            if (dropIndex > selIndex) {
                --dropIndex;
            }
            if (dropIndex != selIndex) {
                this.notifyAll(selIndex, dropIndex);
            }
        }
    }

    private int findIndex(Widget dropTarget, Table table) {
        int index = 0;
        TableItem[] tableItemArray = table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.equals(dropTarget)) {
                return index;
            }
            ++index;
            ++n2;
        }
        return index;
    }

    public static interface OrderChangedListener {
        public void orderChanged(int var1, int var2);
    }
}

