/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.jayes.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.recommenders.jayes.BayesNet;
import org.eclipse.recommenders.jayes.BayesNode;

public class BayesUtils {
    private static void DFS(BayesNode n, Set<BayesNode> visited, List<BayesNode> finished) {
        if (visited.contains(n)) {
            return;
        }
        visited.add(n);
        for (BayesNode c : n.getChildren()) {
            BayesUtils.DFS(c, visited, finished);
        }
        finished.add(n);
    }

    public static List<BayesNode> topsort(List<BayesNode> list) {
        LinkedList<BayesNode> result = new LinkedList<BayesNode>();
        HashSet<BayesNode> visited = new HashSet<BayesNode>();
        for (BayesNode n : list) {
            BayesUtils.DFS(n, visited, result);
        }
        Collections.reverse(result);
        return result;
    }

    public static List<Integer> getNodeAndParentIds(BayesNode n) {
        ArrayList<Integer> nodeAndParents = new ArrayList<Integer>(n.getParents().size() + 1);
        nodeAndParents.add(n.getId());
        for (BayesNode p : n.getParents()) {
            nodeAndParents.add(p.getId());
        }
        return nodeAndParents;
    }

    public static Map<Integer, Integer> toIntegerMap(Map<BayesNode, String> evidence) {
        HashMap<Integer, Integer> intMap = new HashMap<Integer, Integer>();
        for (Map.Entry<BayesNode, String> entry : evidence.entrySet()) {
            BayesNode node = entry.getKey();
            intMap.put(node.getId(), node.getOutcomeIndex(entry.getValue()));
        }
        return intMap;
    }

    public static Map<BayesNode, String> toNodeMap(BayesNet net, Map<Integer, Integer> evidence) {
        HashMap<BayesNode, String> result = new HashMap<BayesNode, String>();
        for (Map.Entry<Integer, Integer> entry : evidence.entrySet()) {
            BayesNode node = net.getNode(entry.getKey());
            result.put(node, node.getOutcomeName(entry.getValue()));
        }
        return result;
    }
}

