/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.rcp.models.archive;

import com.google.common.base.Optional;
import com.google.common.io.ByteStreams;
import com.google.gson.reflect.TypeToken;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.recommenders.internal.rcp.models.archive.ZipPoolableModelFactory;
import org.eclipse.recommenders.utils.IOUtils;
import org.eclipse.recommenders.utils.Zips;
import org.eclipse.recommenders.utils.gson.GsonUtil;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.eclipse.recommenders.utils.rcp.JavaElementResolver;

public class MemberGsonZipPoolableModelFactory<T>
extends ZipPoolableModelFactory<IMember, T> {
    private final Type type;
    private JavaElementResolver jdtResolver;

    public MemberGsonZipPoolableModelFactory(ZipFile file, TypeToken<T> type, JavaElementResolver jdtResolver) throws IOException {
        super(file);
        this.jdtResolver = jdtResolver;
        this.type = type.getType();
    }

    public MemberGsonZipPoolableModelFactory(File file, TypeToken<T> type, JavaElementResolver jdtResolver) throws IOException {
        this(new ZipFile(file), type, jdtResolver);
    }

    public MemberGsonZipPoolableModelFactory(ZipFile file, Class<T> type, JavaElementResolver jdtResolver) throws IOException {
        super(file);
        this.type = type;
        this.jdtResolver = jdtResolver;
    }

    public MemberGsonZipPoolableModelFactory(File file, Class<T> type, JavaElementResolver jdtResolver) throws IOException {
        this(new ZipFile(file), type, jdtResolver);
    }

    @Override
    public boolean hasModel(IMember key) {
        ZipEntry entry = this.getEntry(key);
        return entry != null;
    }

    private ZipEntry getEntry(IMember m) {
        String name = null;
        switch (m.getElementType()) {
            case 7: {
                ITypeName rType = this.jdtResolver.toRecType((IType)m);
                name = Zips.path((ITypeName)rType, (String)".json");
                break;
            }
            case 9: {
                Optional opt = this.jdtResolver.toRecMethod((IMethod)m);
                if (!opt.isPresent()) break;
                name = Zips.path((IMethodName)((IMethodName)opt.get()), (String)".json");
            }
        }
        return this.zip.getEntry(name);
    }

    @Override
    public T createModel(IMember key) throws Exception {
        Object object;
        InputStream is = null;
        try {
            ZipEntry entry = this.getEntry(key);
            is = this.zip.getInputStream(entry);
            String data = new String(ByteStreams.toByteArray((InputStream)is));
            object = GsonUtil.deserialize((String)data, (Type)this.type);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)is);
        return (T)object;
    }
}

