/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.rcp.models.store;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Inject;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.recommenders.internal.rcp.models.IModelArchive;
import org.eclipse.recommenders.internal.rcp.models.IModelArchiveStore;
import org.eclipse.recommenders.internal.rcp.models.ModelArchiveMetadata;
import org.eclipse.recommenders.internal.rcp.models.store.IDependenciesFactory;
import org.eclipse.recommenders.internal.rcp.repo.RepositoryUtils;
import org.eclipse.recommenders.internal.rcp.wiring.RecommendersModule;
import org.eclipse.recommenders.rcp.repo.IModelRepository;
import org.eclipse.recommenders.utils.gson.GsonUtil;
import org.eclipse.recommenders.utils.rcp.JdtUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.aether.artifact.Artifact;

@RecommendersModule.AutoCloseOnWorkbenchShutdown
public class DefaultModelArchiveStore<K extends IMember, V>
implements Closeable,
IModelArchiveStore<K, V> {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private Map<File, ModelArchiveMetadata<K, V>> mappings;
    private File store;
    private final String classifier;
    private Map<V, IModelArchive<K, V>> pool = Maps.newHashMap();
    private IModelRepository repository;
    private IDependenciesFactory factory;

    @Inject
    public DefaultModelArchiveStore(File store, String classifier, IModelRepository repository, IDependenciesFactory factory) {
        this.store = store;
        this.classifier = classifier;
        this.repository = repository;
        this.factory = factory;
        this.open();
    }

    public void open() {
        this.mappings = this.store.exists() ? (Map)GsonUtil.deserialize((File)this.store, (Type)new TypeToken<Map<File, ModelArchiveMetadata<K, V>>>(){}.getType()) : Maps.newHashMap();
    }

    @Override
    public Optional<V> aquireModel(K key) {
        try {
            Optional<IPackageFragmentRoot> pkgRoot = this.findPackageFragmentRoot(key);
            if (!pkgRoot.isPresent()) {
                return Optional.absent();
            }
            Optional<File> location = this.getLocation((IPackageFragmentRoot)pkgRoot.get());
            if (!location.isPresent()) {
                return Optional.absent();
            }
            Optional<IModelArchive<K, V>> archive = this.findModelArchive((File)location.get());
            if (!archive.isPresent()) {
                return Optional.absent();
            }
            Optional<V> model = this.findModel(key, (IModelArchive)archive.get());
            if (!model.isPresent()) {
                return Optional.absent();
            }
            return Optional.of((Object)model.get());
        }
        catch (Exception e) {
            this.log.warn("Loading model for '" + JavaElementLabels.getElementLabel(key, (long)JavaElementLabels.ALL_DEFAULT) + "' failed with exception.", (Throwable)e);
            return Optional.absent();
        }
    }

    @VisibleForTesting
    protected Optional<File> getLocation(IPackageFragmentRoot root) {
        return JdtUtils.getLocation((IPackageFragmentRoot)root);
    }

    private Optional<IPackageFragmentRoot> findPackageFragmentRoot(K key) {
        IPackageFragmentRoot pkgRoot = (IPackageFragmentRoot)key.getAncestor(3);
        return Optional.fromNullable((Object)pkgRoot);
    }

    private Optional<IModelArchive<K, V>> findModelArchive(File location) throws IOException {
        ModelArchiveMetadata<K, V> meta = this.findOrCreateMetadata(location);
        switch (meta.getStatus()) {
            case UNRESOLVED: {
                this.requestModelResolution(meta);
            }
            case PROHIBITED: 
            case FAILED: 
            case UNINITIALIZED: {
                return Optional.absent();
            }
        }
        if (StringUtils.isEmpty((CharSequence)meta.getCoordinate())) {
            return Optional.absent();
        }
        IModelArchive<K, V> model = meta.getModelArchive();
        if (model == null) {
            model = this.loadModel(meta);
        }
        return Optional.fromNullable(model);
    }

    private IModelArchive<K, V> loadModel(ModelArchiveMetadata<K, V> meta) throws IOException {
        IModelArchive model = null;
        Artifact modelArtifact = RepositoryUtils.newArtifact(meta.getCoordinate());
        File file = this.repository.location(modelArtifact);
        if (file.exists()) {
            model = this.factory.newModelArchive(file);
            meta.setModelArchive(model);
        } else {
            meta.setStatus(ModelArchiveMetadata.ModelArchiveResolutionStatus.UNRESOLVED);
            this.requestModelResolution(meta);
        }
        return model;
    }

    private void requestModelResolution(ModelArchiveMetadata<K, V> meta) {
        if (!meta.isResolutionRequestedSinceStartup()) {
            meta.setResolutionRequestedSinceStartup(true);
            this.factory.newResolutionJob(meta, this.classifier).schedule();
        }
    }

    private Optional<V> findModel(K key, IModelArchive<K, V> archive) {
        if (!archive.hasModel(key)) {
            return Optional.absent();
        }
        Object model = archive.acquireModel(key).orNull();
        this.pool.put((IModelArchive<K, V>)model, (IModelArchive<Object, IModelArchive<K, V>>)archive);
        return Optional.fromNullable((Object)model);
    }

    @Override
    public ModelArchiveMetadata<K, V> findOrCreateMetadata(File f) {
        ModelArchiveMetadata<K, V> ref = this.mappings.get(f);
        if (ref == null) {
            ref = new ModelArchiveMetadata();
            ref.setStatus(ModelArchiveMetadata.ModelArchiveResolutionStatus.UNRESOLVED);
            ref.setLocation(f);
            this.mappings.put(f, ref);
        }
        return ref;
    }

    @Override
    public void close() throws IOException {
        Files.createParentDirs((File)this.store);
        GsonUtil.serialize(this.mappings, (File)this.store);
    }

    @Override
    public void releaseModel(V model) {
        IModelArchive<K, V> archive = this.pool.get(model);
        if (archive != null) {
            archive.releaseModel(model);
        }
    }

    @Override
    public Collection<ModelArchiveMetadata<K, V>> getMetadata() {
        return this.mappings.values();
    }
}

