/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.rcp.providers;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.io.Files;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.recommenders.internal.rcp.wiring.RecommendersModule;
import org.eclipse.recommenders.rcp.ClasspathEntryInfo;
import org.eclipse.recommenders.rcp.IClasspathEntryInfoProvider;
import org.eclipse.recommenders.rcp.events.JavaModelEvents;
import org.eclipse.recommenders.rcp.events.NewClasspathEntryFound;
import org.eclipse.recommenders.utils.Executors;
import org.eclipse.recommenders.utils.Version;
import org.eclipse.recommenders.utils.archive.ArchiveDetailsExtractor;
import org.eclipse.recommenders.utils.gson.GsonUtil;
import org.eclipse.recommenders.utils.parser.OsgiVersionParser;
import org.eclipse.recommenders.utils.rcp.JdtUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@RecommendersModule.AutoCloseOnWorkbenchShutdown
public class ClasspathEntryInfoProvider
implements IClasspathEntryInfoProvider {
    private final ExecutorService pool = Executors.coreThreadsTimoutExecutor((int)1, (int)1, (String)"Recommenders-Dependency-Info-Service-");
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<File, ClasspathEntryInfo> cpeInfos = Maps.newHashMap();
    private final File state;
    private final EventBus bus;

    @Inject
    public ClasspathEntryInfoProvider(File state, IWorkspaceRoot workspace, EventBus bus) {
        this.state = state;
        this.bus = bus;
        this.initialize(workspace);
    }

    @VisibleForTesting
    protected void initialize(final IWorkspaceRoot workspace) {
        new Job(""){
            {
                super($anonymous0);
                this.setSystem(true);
                this.setPriority(30);
                this.schedule();
            }

            protected IStatus run(IProgressMonitor monitor) {
                ClasspathEntryInfoProvider.this.initializeIndex();
                ClasspathEntryInfoProvider.this.scanOpenProjects(workspace);
                return Status.OK_STATUS;
            }
        };
    }

    private void initializeIndex() {
        if (!this.state.exists()) {
            return;
        }
        TypeToken<List<ClasspathEntryInfo>> token = new TypeToken<List<ClasspathEntryInfo>>(){};
        try {
            List data = (List)GsonUtil.deserialize((File)this.state, (Type)token.getType());
            for (ClasspathEntryInfo info : data) {
                this.cpeInfos.put(info.getLocation(), info);
                this.ensureFileInfosStillConsistent(info);
            }
        }
        catch (Exception e) {
            this.log.warn("Exception during deserialization of cached classpath infos. Discaring old state.", (Throwable)e);
        }
    }

    private void scanOpenProjects(IWorkspaceRoot workspace) {
        IProject[] iProjectArray = workspace.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject p = iProjectArray[n2];
            if (JavaProject.hasJavaNature((IProject)p)) {
                IJavaProject javaProject = JavaCore.create((IProject)p);
                this.onEvent(new JavaModelEvents.JavaProjectOpened(javaProject));
            }
            ++n2;
        }
    }

    @Override
    public Optional<ClasspathEntryInfo> getInfo(File file) {
        ClasspathEntryInfo res = this.cpeInfos.get(file);
        this.ensureFileInfosStillConsistent(res);
        return Optional.fromNullable((Object)res);
    }

    @Override
    public Set<File> getFiles() {
        return new HashSet<File>(this.cpeInfos.keySet());
    }

    private void ensureFileInfosStillConsistent(ClasspathEntryInfo info) {
        if (info == null) {
            return;
        }
        File location = info.getLocation();
        if (location == null) {
            return;
        }
        if (location.lastModified() != info.getModificationDate().getTime()) {
            this.cpeInfos.remove(location);
        }
    }

    @Override
    public void close() {
        try {
            Files.createParentDirs((File)this.state);
            GsonUtil.serialize(this.cpeInfos.values(), (File)this.state);
        }
        catch (Exception e) {
            this.log.error("Failed to store classpath info state.", (Throwable)e);
        }
    }

    @Subscribe
    public void onEvent(JavaModelEvents.JavaProjectOpened e) {
        this.mapSourcePluginProjects(e);
        try {
            IClasspathEntry[] iClasspathEntryArray = e.project.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 5) {
                    boolean isJREContainer = entry.getPath().toString().contains("org.eclipse.jdt.launching.JRE_CONTAINER");
                    IPackageFragmentRoot[] iPackageFragmentRootArray = e.project.findPackageFragmentRoots(entry);
                    int n3 = iPackageFragmentRootArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IPackageFragmentRoot sub = iPackageFragmentRootArray[n4];
                        Optional location = JdtUtils.getLocation((IPackageFragmentRoot)sub);
                        if (this.isInterestingPackageFragmentRoot(sub, (Optional<File>)location)) {
                            this.resolve(sub, (File)location.get(), isJREContainer);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            iClasspathEntryArray = e.project.getAllPackageFragmentRoots();
            n = iClasspathEntryArray.length;
            n2 = 0;
            while (n2 < n) {
                IClasspathEntry r = iClasspathEntryArray[n2];
                Optional location = JdtUtils.getLocation((IPackageFragmentRoot)r);
                if (this.isInterestingPackageFragmentRoot((IPackageFragmentRoot)r, (Optional<File>)location)) {
                    this.resolve((IPackageFragmentRoot)r, (File)location.get(), false);
                }
                ++n2;
            }
        }
        catch (JavaModelException x) {
            this.log.error("Exception occurred while resolving project dependencies for " + e.project, (Throwable)x);
        }
    }

    private void mapSourcePluginProjects(JavaModelEvents.JavaProjectOpened e) {
        try {
            IResource mf = e.project.getProject().findMember((IPath)new Path("META-INF/MANIFEST.MF"));
            if (mf != null && mf.exists() && mf.getType() == 1) {
                Manifest mf_ = new Manifest(((IFile)mf).getContents());
                Attributes attributes = mf_.getMainAttributes();
                String symbolicName = StringUtils.substringBefore((String)attributes.getValue("Bundle-SymbolicName"), (String)";");
                String version = attributes.getValue("Bundle-Version");
                Version osgiversion = null;
                if (version != null) {
                    osgiversion = new OsgiVersionParser().parse(version);
                }
                IPackageFragmentRoot[] iPackageFragmentRootArray = e.project.getPackageFragmentRoots();
                int n = iPackageFragmentRootArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                    if (!root.isArchive()) {
                        ClasspathEntryInfo res = new ClasspathEntryInfo();
                        res.setSymbolicName(symbolicName);
                        res.setVersion(osgiversion);
                        File file = (File)JdtUtils.getLocation((IPackageFragmentRoot)root).get();
                        res.setModificationDate(new Date(file.lastModified()));
                        res.setLocation(file);
                        this.cpeInfos.put(file, res);
                        this.bus.post((Object)new NewClasspathEntryFound(root, file, res));
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e1) {
            this.log.warn("failed to read bundle manifest for project " + e.project.getElementName(), (Throwable)e1);
        }
    }

    private void resolve(final IPackageFragmentRoot r, final File file, final boolean isPartOfJavaRuntime) {
        this.pool.submit(new Runnable(){

            @Override
            public void run() {
                if (ClasspathEntryInfoProvider.this.cpeInfos.containsKey(file)) {
                    return;
                }
                if (r.isArchive()) {
                    try {
                        ArchiveDetailsExtractor extractor = new ArchiveDetailsExtractor(file);
                        ClasspathEntryInfo res = new ClasspathEntryInfo();
                        res.setSymbolicName(extractor.extractName());
                        res.setVersion(extractor.extractVersion());
                        res.setFingerprint(extractor.createFingerprint());
                        res.setModificationDate(new Date(file.lastModified()));
                        res.setLocation(file);
                        res.setJavaRuntime(isPartOfJavaRuntime);
                        if (isPartOfJavaRuntime) {
                            res.setSymbolicName("jre");
                            res.setVersion(Version.create((int)1, (int)0));
                        }
                        ClasspathEntryInfoProvider.this.cpeInfos.put(file, res);
                        ClasspathEntryInfoProvider.this.bus.post((Object)new NewClasspathEntryFound(r, file, res));
                    }
                    catch (Exception e) {
                        ClasspathEntryInfoProvider.this.log.error("Extracing jar information failed with exception.", (Throwable)e);
                    }
                }
            }
        });
    }

    @Subscribe
    public void onEvent(JavaModelEvents.JarPackageFragmentRootAdded e) throws JavaModelException {
        JarPackageFragmentRoot r = e.root;
        IJavaProject p = r.getJavaProject();
        IClasspathEntry[] iClasspathEntryArray = p.getResolvedClasspath(true);
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.getEntryKind() == 5) {
                System.out.println();
            }
            ++n2;
        }
        Optional location = JdtUtils.getLocation((IPackageFragmentRoot)r);
        if (this.isInterestingPackageFragmentRoot((IPackageFragmentRoot)r, (Optional<File>)location)) {
            this.resolve((IPackageFragmentRoot)r, (File)location.get(), false);
        }
    }

    private boolean isInterestingPackageFragmentRoot(IPackageFragmentRoot r, Optional<File> location) {
        return location.isPresent() && r.isArchive() && this.isNewLocation(location);
    }

    private boolean isNewLocation(Optional<File> location) {
        return !this.cpeInfos.containsKey(location.get());
    }
}

