/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.utils.codestructs;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.eclipse.recommenders.utils.names.IFieldName;
import org.eclipse.recommenders.utils.names.IMethodName;

public class DefinitionSite {
    public Kind kind;
    public IMethodName sourceMethod;
    public IFieldName definedByField;
    public int lineNumber;
    public IMethodName definedByMethod;

    public static DefinitionSite newSite(Kind definitionKind, IMethodName sourceMethod, int lineNumber, IMethodName definedByMethod) {
        DefinitionSite res = new DefinitionSite();
        res.kind = definitionKind;
        res.sourceMethod = sourceMethod;
        res.lineNumber = lineNumber;
        res.definedByMethod = definedByMethod;
        return res;
    }

    public static DefinitionSite newSite(Kind definitionKind) {
        return DefinitionSite.newSite(definitionKind, null, -1, null);
    }

    public static DefinitionSite create(IFieldName definedByField) {
        DefinitionSite res = new DefinitionSite();
        res.kind = Kind.FIELD;
        res.definedByField = definedByField;
        return res;
    }

    protected DefinitionSite() {
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }

    public static enum Kind {
        METHOD_RETURN,
        NEW,
        FIELD,
        PARAMETER,
        THIS,
        UNKNOWN;

    }
}

