/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.recommenders.utils.Bag;

public class HashBag<T>
implements Bag<T> {
    protected Map<T, Integer> index = new HashMap<T, Integer>();

    public static <T> HashBag<T> newHashBag() {
        return new HashBag<T>();
    }

    public static <T, S extends T> Bag<T> create(Bag<S> bagToCopy) {
        HashBag<S> copy = new HashBag<S>();
        for (S key : bagToCopy.elements()) {
            copy.add(key, bagToCopy.count(key));
        }
        return copy;
    }

    public static <T, S extends T> Bag<T> newHashBag(Collection<S> elements) {
        HashBag<S> res = HashBag.newHashBag();
        res.addAll(elements);
        return res;
    }

    protected HashBag() {
    }

    public int absElementsCount() {
        int res = 0;
        for (T t : this.index.keySet()) {
            res += this.count(t);
        }
        return res;
    }

    @Override
    public void add(T obj) {
        this.add(obj, 1);
    }

    @Override
    public void add(T key, int frequency) {
        Integer curFrequency = this.index.get(key);
        if (curFrequency == null) {
            this.index.put(key, new Integer(frequency));
        } else {
            this.index.put(key, curFrequency + frequency);
        }
    }

    @Override
    public void addAll(Collection<? extends T> col) {
        this.addAll(col, 1);
    }

    @Override
    public void addAll(Collection<? extends T> col, int count) {
        for (T elem : col) {
            this.add(elem, count);
        }
    }

    @Override
    public void addAll(Map<? extends T, Integer> col) {
        for (Map.Entry<T, Integer> pair : col.entrySet()) {
            this.add(pair.getKey(), pair.getValue());
        }
    }

    @Override
    public void addAll(T ... elements) {
        T[] TArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            T element = TArray[n2];
            this.add(element, 1);
            ++n2;
        }
    }

    @Override
    public void addAll(Bag<? extends T> bag) {
        for (T element : bag) {
            this.add(element, bag.count(element));
        }
    }

    @Override
    public int count(Object element) {
        Integer count = this.index.get(element);
        return count == null ? 0 : count;
    }

    @Override
    public Set<T> elements() {
        return new HashSet<T>(this.index.keySet());
    }

    @Override
    public int elementsCount() {
        return this.index.size();
    }

    public List<T> elementsOrderedByFrequency() {
        ArrayList<T> res = new ArrayList<T>(this.index.keySet());
        Collections.sort(res, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return HashBag.this.count(o2) - HashBag.this.count(o1);
            }
        });
        return res;
    }

    public boolean equals(Object obj) {
        Set<T> thisElements;
        if (!(obj instanceof Bag)) {
            return false;
        }
        Bag other = (Bag)obj;
        Set otherElements = other.elements();
        if (!otherElements.equals(thisElements = this.elements())) {
            return false;
        }
        for (T element : thisElements) {
            int otherCount;
            int thisCount = this.count(element);
            if (thisCount == (otherCount = other.count(element))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.index.hashCode();
    }

    @Override
    public Iterator<T> iterator() {
        return this.index.keySet().iterator();
    }

    @Override
    public void remove(T key, int frequency) {
        Integer curFrequency = this.index.get(key);
        if (curFrequency != null) {
            if (curFrequency == frequency) {
                this.index.remove(key);
            } else {
                this.index.put(key, curFrequency - frequency);
            }
        }
    }

    @Override
    public void remove(Bag<? extends T> bag) {
        for (T element : bag) {
            this.remove(element, bag.count(element));
        }
    }

    @Override
    public void removeAll(T element) {
        this.index.remove(element);
    }

    @Override
    public List<T> topElements(int numberOfMaxTopElements) {
        List<T> sortedKeys = this.elementsOrderedByFrequency();
        int minElementsCount = Math.min(numberOfMaxTopElements, sortedKeys.size());
        List<T> topList = sortedKeys.subList(0, minElementsCount);
        return topList;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.elementsCount()).append(" keys, ").append(this.totalElementsCount()).append(" total entries\n");
        sb.append(this.elementsCount()).append(" keys, ").append(this.absElementsCount()).append(" total entries\n");
        for (T elem : this.index.keySet()) {
            sb.append(elem).append(" : ").append(this.index.get(elem)).append("\n");
        }
        return sb.toString();
    }

    @Override
    public int totalElementsCount() {
        int res = 0;
        for (T t : this.index.keySet()) {
            res += this.count(t);
        }
        return res;
    }

    @Override
    public boolean contains(T element) {
        return this.index.containsKey(element);
    }

    @Override
    public Map<T, Integer> asMap() {
        return Maps.newHashMap(this.index);
    }

    @Override
    public boolean isEmpty() {
        return this.index.isEmpty();
    }
}

