/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.utils.parser;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.recommenders.utils.Throws;
import org.eclipse.recommenders.utils.Version;
import org.eclipse.recommenders.utils.parser.IVersionParser;

public class MavenVersionParser
implements IVersionParser {
    @Override
    public boolean canParse(String version) {
        try {
            this.parse(version);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    @Override
    public Version parse(String version) throws IllegalArgumentException {
        int major = 0;
        int minor = 0;
        int micro = 0;
        String qualifier = "";
        try {
            StringTokenizer tokenizer = new StringTokenizer(version, ".-", true);
            major = MavenVersionParser.parseInt(tokenizer);
            if (tokenizer.hasMoreTokens()) {
                MavenVersionParser.consumeDelimiter(tokenizer, ".");
                minor = MavenVersionParser.parseInt(tokenizer);
                if (tokenizer.hasMoreTokens()) {
                    MavenVersionParser.consumeDelimiter(tokenizer, ".");
                    micro = MavenVersionParser.parseInt(tokenizer);
                    if (tokenizer.hasMoreTokens()) {
                        MavenVersionParser.consumeDelimiter(tokenizer, "-", ".");
                        qualifier = MavenVersionParser.parseString(tokenizer);
                        while (tokenizer.hasMoreElements()) {
                            qualifier = String.valueOf(qualifier) + tokenizer.nextToken();
                        }
                    }
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            Throws.throwIllegalArgumentException("couldn't convert string into version: '%s'", version);
        }
        return Version.create(major, minor, micro, qualifier);
    }

    private static String parseString(StringTokenizer st) {
        return st.nextToken();
    }

    private static int parseInt(StringTokenizer st) {
        return Integer.parseInt(st.nextToken());
    }

    private static void consumeDelimiter(StringTokenizer st, String ... allowedDelimiters) {
        String delimiter = st.nextToken();
        String[] stringArray = allowedDelimiters;
        int n = allowedDelimiters.length;
        int n2 = 0;
        while (n2 < n) {
            String allowedDelimiter = stringArray[n2];
            if (delimiter.equals(allowedDelimiter)) {
                return;
            }
            ++n2;
        }
        Throws.throwIllegalArgumentException("Unexpected delimiter '%s'; Expected delimiters '%s'", delimiter, StringUtils.join((Object[])allowedDelimiters, (String)"','"));
    }
}

