/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rephraserengine.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rephraserengine.core.resources.DefaultResourceFilter;
import org.eclipse.rephraserengine.core.resources.IResourceFilter;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class WorkbenchSelectionInfo {
    private IResourceFilter resourceFilter;
    private String errorMsg;
    private IEditorPart activeEditor;
    private IFile fileInEditor;
    private ISelection selection;
    private List<IResource> selectedResources;
    private List<IFile> allFilesInSelectedResources;
    private ITextSelection selectionInEditor;
    private Boolean someFilesAreSelected;

    public WorkbenchSelectionInfo() {
        this((IResourceFilter)new DefaultResourceFilter());
    }

    public WorkbenchSelectionInfo(IResourceFilter resourceFilter) {
        this(resourceFilter, Workbench.getInstance().getActiveWorkbenchWindow());
    }

    public WorkbenchSelectionInfo(IWorkbenchWindow workbenchWindow) {
        this((IResourceFilter)new DefaultResourceFilter(), workbenchWindow);
    }

    public WorkbenchSelectionInfo(IResourceFilter resourceFilter, IWorkbenchWindow workbenchWindow) {
        IWorkbenchPage activePage;
        this.resourceFilter = resourceFilter;
        this.selection = null;
        this.selectedResources = Collections.emptyList();
        this.activeEditor = null;
        this.fileInEditor = null;
        this.selectionInEditor = null;
        if (workbenchWindow == null) {
            return;
        }
        this.selection = workbenchWindow.getSelectionService().getSelection();
        if (this.selection instanceof IStructuredSelection) {
            this.selectedResources = this.getResourcesSelectedIn((IStructuredSelection)this.selection);
            this.allFilesInSelectedResources = null;
        }
        if ((activePage = workbenchWindow.getActivePage()) == null) {
            return;
        }
        this.activeEditor = activePage.getActiveEditor();
        if (this.activeEditor == null) {
            return;
        }
        IEditorInput input = this.activeEditor.getEditorInput();
        if (!(input instanceof IFileEditorInput)) {
            return;
        }
        IFileEditorInput fileInput = (IFileEditorInput)input;
        this.fileInEditor = fileInput.getFile();
        if (!resourceFilter.shouldProcess((IResource)this.fileInEditor)) {
            this.errorMsg = resourceFilter.getError((IResource)this.fileInEditor);
            this.fileInEditor = null;
        }
        if (this.selection instanceof ITextSelection) {
            this.selectionInEditor = (ITextSelection)this.selection;
            if (this.fileInEditor != null) {
                this.selectedResources = Collections.singletonList(this.fileInEditor);
                this.allFilesInSelectedResources = Collections.singletonList(this.fileInEditor);
            }
        }
    }

    private List<IResource> getResourcesSelectedIn(IStructuredSelection selection) {
        ArrayList<IResource> result = new ArrayList<IResource>();
        for (Object selectedItem : selection.toList()) {
            IAdaptable item;
            IResource res;
            if (!(selectedItem instanceof IAdaptable) || (res = (IResource)(item = (IAdaptable)selectedItem).getAdapter(IResource.class)) == null) continue;
            if (this.resourceFilter.shouldProcess(res)) {
                result.add(res);
                continue;
            }
            this.errorMsg = this.resourceFilter.getError(res);
        }
        if (!result.isEmpty()) {
            this.errorMsg = null;
        }
        return result;
    }

    public boolean someFilesAreSelected(boolean canGuess) {
        if (this.someFilesAreSelected == null) {
            this.someFilesAreSelected = this.internalSomeFilesAreSelected(canGuess);
        }
        return this.someFilesAreSelected;
    }

    public boolean someFilesAreSelected() {
        return this.someFilesAreSelected(false);
    }

    private boolean internalSomeFilesAreSelected(boolean canGuess) {
        if (this.allFilesInSelectedResources != null) {
            return !this.allFilesInSelectedResources.isEmpty();
        }
        return this.internalSomeFilesAreSelected(this.selectedResources.toArray(new IResource[this.selectedResources.size()]), canGuess);
    }

    private boolean internalSomeFilesAreSelected(IResource[] resources, boolean canGuess) {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource r = iResourceArray[n2];
            if (this.resourceFilter.shouldProcess(r)) {
                if (r instanceof IFile) {
                    return true;
                }
                if ((r instanceof IFolder || r instanceof IProject) && r.isAccessible()) {
                    if (canGuess) {
                        return this.resourceFilter.shouldProcess((IResource)r.getProject());
                    }
                    try {
                        if (this.internalSomeFilesAreSelected(((IContainer)r).members(), canGuess)) {
                            return true;
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
            }
            ++n2;
        }
        return false;
    }

    public boolean editingAnIFile() {
        return this.fileInEditor != null;
    }

    public IEditorPart getActiveEditor() {
        return this.activeEditor;
    }

    public ITextEditor getActiveTextEditor() {
        return this.activeEditor instanceof ITextEditor ? (ITextEditor)this.activeEditor : null;
    }

    public IFile getFileInEditor() {
        return this.fileInEditor;
    }

    public boolean isTextSelectedInEditor() {
        return this.selectionInEditor != null;
    }

    public ITextSelection getSelectionInEditor() {
        return this.selectionInEditor;
    }

    public String getEditorContents() {
        if (this.activeEditor == null || !(this.activeEditor instanceof ITextEditor)) {
            return null;
        }
        ITextEditor textEditor = (ITextEditor)this.activeEditor;
        IDocumentProvider dp = textEditor.getDocumentProvider();
        if (dp == null) {
            return null;
        }
        IDocument doc = dp.getDocument((Object)textEditor.getEditorInput());
        if (doc == null) {
            return null;
        }
        return doc.get();
    }

    public List<IResource> getSelectedResources() {
        return this.selectedResources;
    }

    public List<IFile> getAllFilesInSelectedResources() {
        if (this.allFilesInSelectedResources == null) {
            this.allFilesInSelectedResources = this.findAllFilesIn(this.selectedResources);
        }
        return this.allFilesInSelectedResources;
    }

    private List<IFile> findAllFilesIn(Collection<IResource> resources) {
        return this.findAllFilesIn(resources.toArray(new IResource[resources.size()]));
    }

    private List<IFile> findAllFilesIn(IResource[] resources) {
        ArrayList<IFile> files = new ArrayList<IFile>();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource r = iResourceArray[n2];
            if (this.resourceFilter.shouldProcess(r)) {
                if (r instanceof IFile) {
                    files.add((IFile)r);
                } else if ((r instanceof IFolder || r instanceof IProject) && r.isAccessible()) {
                    try {
                        files.addAll(this.findAllFilesIn(((IContainer)r).members()));
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
            }
            ++n2;
        }
        return files;
    }

    public String getErrorMessage() {
        return this.errorMsg;
    }
}

