/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rtp.httpdeployer.feature;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.eclipse.rtp.httpdeployer.feature.FeatureInstallException;
import org.eclipse.rtp.httpdeployer.feature.FeatureManager;
import org.eclipse.rtp.httpdeployer.feature.FeatureModificationResult;
import org.eclipse.rtp.httpdeployer.internal.AbstractHttpDeployerServlet;
import org.eclipse.rtp.httpdeployer.internal.CommonConstants;
import org.eclipse.rtp.httpdeployer.internal.HttpDeployerUtils;
import org.eclipse.rtp.httpdeployer.internal.RequestResults;
import org.eclipse.rtp.httpdeployer.repository.RepositoryManager;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class FeatureServlet
extends AbstractHttpDeployerServlet {
    private static final long serialVersionUID = 8439160853108236583L;
    private final FeatureManager featureManager;
    private final RepositoryManager repositoryManager;

    public FeatureServlet(FeatureManager featureManager, RepositoryManager repositoryManager) {
        this.featureManager = featureManager;
        this.repositoryManager = repositoryManager;
    }

    @Override
    public Document parsePostRequest(Document requestDocument) {
        return this.parseRequest(requestDocument, "feature", CommonConstants.Action.INSTALL);
    }

    @Override
    public Document parseDeleteRequest(Document requestDocument) {
        return this.parseRequest(requestDocument, "feature", CommonConstants.Action.UNINSTALL);
    }

    @Override
    public Document parseMultipartPostRequest(HttpServletRequest request) throws Exception {
        List<FileItem> files = HttpDeployerUtils.parseMultipartRequest(request);
        if (files.size() != 2) {
            throw new FileUploadException("Files not found");
        }
        InputStream repository = this.getRepositoryFromMultipart(files);
        this.repositoryManager.addRepository(repository);
        Document feature = this.getFeatureRequestFromMultipart(files);
        Document installRequest = this.parseRequest(feature, "feature", CommonConstants.Action.INSTALL);
        return installRequest;
    }

    private Document getFeatureRequestFromMultipart(List<FileItem> files) throws JDOMException, IOException {
        String feature = files.get(0).isFormField() ? files.get(0).getString() : files.get(1).getString();
        SAXBuilder builder = new SAXBuilder();
        return builder.build((Reader)new StringReader(feature));
    }

    private InputStream getRepositoryFromMultipart(List<FileItem> files) throws IOException {
        if (files.get(0).isFormField()) {
            return files.get(1).getInputStream();
        }
        return files.get(0).getInputStream();
    }

    @Override
    public void handleOperation(RequestResults result, Element currentElement, CommonConstants.Action action) {
        String name = currentElement.getChildText("name");
        String version = currentElement.getChildText("version");
        if (action == CommonConstants.Action.UNINSTALL) {
            version = null;
        }
        this.handleOperation(result, name, version, action);
    }

    private void handleOperation(RequestResults result, String name, String version, CommonConstants.Action action) {
        try {
            if (action.equals((Object)CommonConstants.Action.INSTALL)) {
                this.featureManager.installFeature(name, version);
                result.addResult(new FeatureModificationResult(name, version, action));
            } else if (action.equals((Object)CommonConstants.Action.UNINSTALL)) {
                this.featureManager.uninstallFeature(name, version);
                result.addResult(new FeatureModificationResult(name, version, action));
            }
        }
        catch (FeatureInstallException e) {
            result.addResult(new FeatureModificationResult(name, version, action, e));
        }
    }
}

