/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.sapphire.modeling.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Status {
    public static final String TYPE_MISC_OK = "Sapphire.Miscellaneous.Ok";
    public static final String TYPE_MISC_PROBLEM = "Sapphire.Miscellaneous.Problem";
    private static final Status OK_STATUS = new Status(Severity.OK, "Sapphire.Miscellaneous.Ok", Resources.defaultOkMessage, null, Collections.<Status>emptyList());
    private final Severity severity;
    private final String type;
    private final String message;
    private final Throwable exception;
    private final List<Status> children;

    public static Status createOkStatus() {
        return OK_STATUS;
    }

    public static Status createInfoStatus(String message) {
        return Status.createStatus(Severity.INFO, message);
    }

    public static Status createWarningStatus(String message) {
        return Status.createStatus(Severity.WARNING, message);
    }

    public static Status createErrorStatus(String message) {
        return Status.createErrorStatus(message, null);
    }

    public static Status createErrorStatus(Throwable exception) {
        String message = exception.getMessage();
        if (message == null) {
            message = Resources.defaultErrorMessage;
        }
        return Status.createErrorStatus(message, exception);
    }

    public static Status createErrorStatus(String message, Throwable exception) {
        return Status.createStatus(Severity.ERROR, message, exception);
    }

    public static Status createStatus(Severity severity, String message, Throwable exception) {
        return Status.factoryForLeaf().severity(severity).message(message).exception(exception).create();
    }

    public static Status createStatus(Severity severity, String message) {
        return Status.createStatus(severity, message, null);
    }

    public static LeafStatusFactory factoryForLeaf() {
        return new LeafStatusFactory();
    }

    public static CompositeStatusFactory factoryForComposite() {
        return new CompositeStatusFactory();
    }

    private Status(Severity severity, String type, String message, Throwable exception, List<Status> children) {
        this.severity = severity;
        this.type = type == null ? (severity == Severity.OK ? TYPE_MISC_OK : TYPE_MISC_PROBLEM) : type;
        this.message = message;
        this.exception = exception;
        this.children = children;
    }

    public boolean ok() {
        return this.severity == Severity.OK;
    }

    public Severity severity() {
        return this.severity;
    }

    public String type() {
        return this.type;
    }

    public String message() {
        return this.message;
    }

    public Throwable exception() {
        return this.exception;
    }

    public List<Status> children() {
        return this.children;
    }

    public boolean equals(Object obj) {
        Status st;
        if (obj == this) {
            return true;
        }
        if (obj instanceof Status && (st = (Status)obj).severity() == this.severity() && st.children().size() == this.children().size() && st.exception() == this.exception() && st.message().equals(this.message())) {
            Iterator<Status> itr1 = st.children().iterator();
            Iterator<Status> itr2 = this.children().iterator();
            while (itr1.hasNext()) {
                if (itr1.next().equals(itr2.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.severity().code() ^ this.message().hashCode();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.severity().name());
        buf.append(" : ");
        buf.append(this.message());
        Throwable e = this.exception();
        if (e != null) {
            buf.append(System.getProperty("line.separator"));
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            buf.append(sw.toString());
        }
        return buf.toString();
    }

    /* synthetic */ Status(Severity severity, String string, String string2, Throwable throwable, List list, Status status) {
        this(severity, string, string2, throwable, list);
    }

    public static final class CompositeStatusFactory {
        private Severity severity = Severity.OK;
        private String message = "";
        private Throwable exception = null;
        private final List<Status> children = new ArrayList<Status>();

        private CompositeStatusFactory() {
        }

        public CompositeStatusFactory merge(Status status) {
            if (status != null) {
                List<Status> children = status.children();
                if (children.isEmpty()) {
                    Severity sev = status.severity();
                    if (sev != Severity.OK && !this.children.contains(status)) {
                        if (sev.code() > this.severity.code()) {
                            this.severity = sev;
                            this.message = status.message();
                            this.exception = status.exception();
                        }
                        this.children.add(status);
                    }
                } else {
                    for (Status st : children) {
                        this.merge(st);
                    }
                }
            }
            return this;
        }

        public Status create() {
            int count = this.children.size();
            if (count == 0) {
                return Status.createOkStatus();
            }
            if (count == 1) {
                return this.children.get(0);
            }
            return new Status(this.severity, Status.TYPE_MISC_PROBLEM, this.message, this.exception, Collections.unmodifiableList(this.children), null);
        }
    }

    public static final class LeafStatusFactory {
        private Severity severity;
        private String type;
        private String message;
        private Throwable exception;

        private LeafStatusFactory() {
        }

        public LeafStatusFactory severity(Severity severity) {
            this.severity = severity;
            return this;
        }

        public LeafStatusFactory type(String type) {
            this.type = type;
            return this;
        }

        public LeafStatusFactory message(String message) {
            this.message = message;
            return this;
        }

        public LeafStatusFactory exception(Throwable exception) {
            this.exception = exception;
            return this;
        }

        public Status create() {
            if (this.severity == null) {
                throw new IllegalStateException();
            }
            if (this.message == null) {
                throw new IllegalStateException();
            }
            return new Status(this.severity, this.type, this.message, this.exception, Collections.emptyList(), null);
        }
    }

    private static final class Resources
    extends NLS {
        public static String defaultErrorMessage;
        public static String defaultOkMessage;

        static {
            Resources.initializeMessages(Status.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Severity {
        OK(0),
        INFO(1),
        WARNING(2),
        ERROR(4);

        private int code;

        private Severity(int code) {
            this.code = code;
        }

        public int code() {
            return this.code;
        }
    }
}

