/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.sapphire.modeling.ExtensionsLocator;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionContext;
import org.eclipse.sapphire.modeling.el.TypeCast;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ServiceFactory;
import org.eclipse.sapphire.services.ServiceFactoryProxy;
import org.eclipse.sapphire.util.ReadOnlySetFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SapphireModelingExtensionSystem {
    private static final String EL_SERVICE = "service";
    private static final String EL_FUNCTION = "function";
    private static final String EL_NAME = "name";
    private static final String EL_TYPE = "type";
    private static final String EL_FACTORY = "factory";
    private static final String EL_IMPL = "impl";
    private static final String EL_ID = "id";
    private static final String EL_OVERRIDES = "overrides";
    private static final String EL_CONTEXT = "context";
    private static final String EL_SOURCE = "source";
    private static final String EL_TARGET = "target";
    private static final String EL_TYPE_CAST = "type-cast";
    private static boolean initialized = false;
    private static List<ServiceFactoryProxy> serviceFactories;
    private static Map<String, FunctionFactory> functionFactories;
    private static List<TypeCast> typeCasts;

    public static List<ServiceFactoryProxy> getServiceFactories() {
        SapphireModelingExtensionSystem.initialize();
        return serviceFactories;
    }

    public static Function createFunction(String name, Function ... operands) {
        SapphireModelingExtensionSystem.initialize();
        FunctionFactory factory = functionFactories.get(name.toLowerCase());
        if (factory != null) {
            return factory.create(operands);
        }
        return null;
    }

    public static List<TypeCast> getTypeCasts() {
        SapphireModelingExtensionSystem.initialize();
        return typeCasts;
    }

    private static synchronized void initialize() {
        if (!initialized) {
            initialized = true;
            serviceFactories = new ArrayList<ServiceFactoryProxy>();
            functionFactories = new HashMap<String, FunctionFactory>();
            typeCasts = new ArrayList<TypeCast>();
            for (ExtensionsLocator.Handle handle : ExtensionsLocator.instance().find()) {
                Element root = SapphireModelingExtensionSystem.parse(handle.extension());
                if (root == null) continue;
                NodeList nodes = root.getChildNodes();
                int i = 0;
                int n = nodes.getLength();
                while (i < n) {
                    Node node = nodes.item(i);
                    if (node instanceof Element) {
                        Element el = (Element)node;
                        String elname = el.getLocalName();
                        try {
                            if (elname.equals(EL_SERVICE)) {
                                String id = SapphireModelingExtensionSystem.value(el, EL_ID);
                                Class serviceType = handle.findClass(SapphireModelingExtensionSystem.value(el, EL_TYPE));
                                Class serviceFactory = handle.findClass(SapphireModelingExtensionSystem.value(el, EL_FACTORY));
                                Set<String> contexts = SapphireModelingExtensionSystem.set(el, EL_CONTEXT);
                                Set<String> overrides = SapphireModelingExtensionSystem.set(el, EL_OVERRIDES);
                                if (serviceType != null && serviceFactory != null) {
                                    serviceFactories.add(new ServiceFactoryProxyImpl(id, serviceType, serviceFactory, contexts, overrides));
                                }
                            } else if (elname.equals(EL_FUNCTION)) {
                                String name = SapphireModelingExtensionSystem.value(el, EL_NAME);
                                Class impl = handle.findClass(SapphireModelingExtensionSystem.value(el, EL_IMPL));
                                functionFactories.put(name.toLowerCase(), new FunctionFactory(impl));
                            } else if (elname.equals(EL_TYPE_CAST)) {
                                Class source = handle.findClass(SapphireModelingExtensionSystem.value(el, EL_SOURCE));
                                Class target = handle.findClass(SapphireModelingExtensionSystem.value(el, EL_TARGET));
                                Class impl = handle.findClass(SapphireModelingExtensionSystem.value(el, EL_IMPL));
                                typeCasts.add(new TypeCastProxy(source, target, impl));
                            }
                        }
                        catch (InvalidExtensionException invalidExtensionException) {}
                    }
                    ++i;
                }
            }
        }
    }

    private static Element parse(URL url) {
        Element element;
        InputStream in = url.openStream();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            factory.setIgnoringComments(false);
            DocumentBuilder docbuilder = factory.newDocumentBuilder();
            docbuilder.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicID, String systemID) {
                    return new InputSource(new StringReader(""));
                }
            });
            Document document = docbuilder.parse(in);
            element = document.getDocumentElement();
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            catch (Exception exception) {
                return null;
            }
        }
        try {
            in.close();
        }
        catch (IOException iOException) {}
        return element;
    }

    private static String value(Element element) {
        StringBuilder buf = new StringBuilder();
        NodeList nodes = element.getChildNodes();
        int i = 0;
        int n = nodes.getLength();
        while (i < n) {
            Node node = nodes.item(i);
            if (node instanceof Text) {
                buf.append(((Text)node).getData());
            }
            ++i;
        }
        return buf.toString().trim();
    }

    private static String value(Element element, String valueElementName) {
        NodeList nodes = element.getChildNodes();
        int i = 0;
        int n = nodes.getLength();
        while (i < n) {
            Element el;
            Node node = nodes.item(i);
            if (node instanceof Element && valueElementName.equals((el = (Element)node).getLocalName())) {
                return SapphireModelingExtensionSystem.value(el);
            }
            ++i;
        }
        throw new InvalidExtensionException();
    }

    private static Set<String> set(Element root, String entryElementName) {
        ReadOnlySetFactory<String> factory = ReadOnlySetFactory.create();
        NodeList nodes = root.getChildNodes();
        int i = 0;
        int n = nodes.getLength();
        while (i < n) {
            String text;
            Node node = nodes.item(i);
            if (node instanceof Element && node.getLocalName().equals(entryElementName) && (text = SapphireModelingExtensionSystem.value((Element)node)).length() > 0) {
                factory.add(text);
            }
            ++i;
        }
        return factory.export();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FunctionFactory {
        private final Class<? extends Function> functionClass;
        private boolean functionInstantiationFailed;

        public FunctionFactory(Class<? extends Function> functionClass) {
            this.functionClass = functionClass;
        }

        public Function create(Function ... operands) {
            Function function = null;
            if (!this.functionInstantiationFailed) {
                try {
                    function = this.functionClass.newInstance();
                    function.init(operands);
                }
                catch (Exception e) {
                    LoggingService.log(e);
                    function = null;
                    this.functionInstantiationFailed = true;
                }
            }
            return function;
        }
    }

    public static final class InvalidExtensionException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ServiceFactoryProxyImpl
    extends ServiceFactoryProxy {
        private final String id;
        private final Class<? extends Service> type;
        private final Class<? extends ServiceFactory> factoryClass;
        private ServiceFactory factoryInstance;
        private boolean factoryInstantiationFailed;
        private final Set<String> contexts;
        private final Set<String> overrides;

        public ServiceFactoryProxyImpl(String id, Class<? extends Service> type, Class<? extends ServiceFactory> factoryClass, Set<String> contexts, Set<String> overrides) {
            this.id = id;
            this.type = type;
            this.factoryClass = factoryClass;
            this.contexts = contexts;
            this.overrides = overrides;
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public Class<? extends Service> type() {
            return this.type;
        }

        @Override
        public Set<String> overrides() {
            return this.overrides;
        }

        @Override
        protected boolean applicableHandOff(ServiceContext context, Class<? extends Service> service) {
            boolean result = false;
            ServiceFactory factory = this.factory();
            if (factory != null && this.contexts.contains(context.type())) {
                result = factory.applicable(context, service);
            }
            return result;
        }

        @Override
        protected Service createHandOff(ServiceContext context, Class<? extends Service> service) {
            Service result = null;
            ServiceFactory factory = this.factory();
            if (factory != null) {
                result = factory.create(context, service);
            }
            return result;
        }

        private synchronized ServiceFactory factory() {
            if (this.factoryInstance == null && !this.factoryInstantiationFailed) {
                try {
                    this.factoryInstance = this.factoryClass.newInstance();
                }
                catch (Exception e) {
                    LoggingService.log(e);
                    this.factoryInstantiationFailed = true;
                }
            }
            return this.factoryInstance;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TypeCastProxy
    extends TypeCast {
        private final Class<?> source;
        private final Class<?> target;
        private final Class<? extends TypeCast> implClass;
        private TypeCast implInstance;
        private boolean implInstantiationFailed;

        public TypeCastProxy(Class<?> source, Class<?> target, Class<? extends TypeCast> implementation) {
            this.source = source;
            this.target = target;
            this.implClass = implementation;
        }

        @Override
        public boolean applicable(FunctionContext context, Function requestor, Object value, Class<?> target) {
            if (!(this.implInstantiationFailed || target != this.target || value != null && value.getClass() != this.source)) {
                if (this.implInstance == null) {
                    try {
                        this.implInstance = this.implClass.newInstance();
                    }
                    catch (Exception e) {
                        LoggingService.log(e);
                        this.implInstantiationFailed = true;
                    }
                }
                if (!this.implInstantiationFailed) {
                    return this.implInstance.applicable(context, requestor, value, target);
                }
            }
            return false;
        }

        @Override
        public Object evaluate(FunctionContext context, Function requestor, Object value, Class<?> target) {
            if (this.implInstance == null || this.implInstantiationFailed) {
                throw new IllegalStateException();
            }
            return this.implInstance.evaluate(context, requestor, value, target);
        }
    }
}

