/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.modeling.internal.SapphireModelingExtensionSystem;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceFactoryProxy;
import org.eclipse.sapphire.util.ReadOnlyListFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceContext {
    public static final String ID_ELEMENT_INSTANCE = "Sapphire.Element.Instance";
    public static final String ID_ELEMENT_METAMODEL = "Sapphire.Element.MetaModel";
    public static final String ID_PROPERTY_INSTANCE = "Sapphire.Property.Instance";
    public static final String ID_PROPERTY_METAMODEL = "Sapphire.Property.MetaModel";
    private final String type;
    private final ServiceContext parent;
    private final Map<Class<? extends Service>, List<Service>> services = new HashMap<Class<? extends Service>, List<Service>>();
    private boolean disposed = false;

    public ServiceContext(String type, ServiceContext parent) {
        this.type = type;
        this.parent = parent;
    }

    public final String type() {
        return this.type;
    }

    public final ServiceContext parent() {
        return this.parent;
    }

    public <T> T find(Class<T> type) {
        return null;
    }

    public final <S extends Service> S service(Class<S> serviceType) {
        if (this.disposed) {
            throw new IllegalStateException();
        }
        List<S> services = this.services(serviceType);
        return (S)(services.isEmpty() ? null : (Service)services.get(0));
    }

    public final synchronized <S extends Service> List<S> services(Class<S> serviceType) {
        if (this.disposed) {
            throw new IllegalStateException();
        }
        List<Service> services = this.services.get(serviceType);
        if (services == null) {
            Service service;
            HashMap<String, ServiceFactoryProxy> applicable = new HashMap<String, ServiceFactoryProxy>();
            for (ServiceFactoryProxy factory : SapphireModelingExtensionSystem.getServiceFactories()) {
                if (!factory.applicable(this, serviceType)) continue;
                applicable.put(factory.id(), factory);
            }
            for (ServiceFactoryProxy factory : new ArrayList(applicable.values())) {
                for (String overriddenServiceId : factory.overrides()) {
                    applicable.remove(overriddenServiceId);
                }
            }
            ReadOnlyListFactory<Service> servicesListFactory = ReadOnlyListFactory.create();
            for (ServiceFactoryProxy factory : this.local()) {
                if (!factory.applicable(this, serviceType)) continue;
                service = null;
                try {
                    service = factory.create(this, serviceType);
                    service.init(this, factory.parameters());
                }
                catch (Exception e) {
                    LoggingService.log(e);
                }
                if (service == null) continue;
                for (String overriddenServiceId : factory.overrides()) {
                    applicable.remove(overriddenServiceId);
                }
                servicesListFactory.add(service);
            }
            for (ServiceFactoryProxy factory : applicable.values()) {
                service = null;
                try {
                    service = factory.create(this, serviceType);
                    service.init(this, factory.parameters());
                }
                catch (Exception e) {
                    LoggingService.log(e);
                }
                if (service == null) continue;
                servicesListFactory.add(service);
            }
            services = servicesListFactory.export();
            this.services.put(serviceType, services);
            for (Service service2 : services) {
                try {
                    service2.init();
                }
                catch (Exception e) {
                    LoggingService.log(e);
                }
            }
        }
        if (services.isEmpty() && this.parent != null) {
            services = this.parent.services(serviceType);
        }
        return services;
    }

    protected List<ServiceFactoryProxy> local() {
        return Collections.emptyList();
    }

    public final void dispose() {
        this.disposed = true;
        for (List<Service> services : this.services.values()) {
            for (Service service : services) {
                try {
                    service.dispose();
                }
                catch (Exception e) {
                    LoggingService.log(e);
                }
            }
        }
        this.services.clear();
    }
}

