/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services;

import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.LoggingService;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ValueSerializationService;

public final class ValueSerializationMasterService
extends Service {
    private ValueSerializationService valueSerializationService;

    protected void init() {
        super.init();
        IModelElement element = this.context(IModelElement.class);
        ValueProperty property = this.context(ValueProperty.class);
        Class<?> type = property.getTypeClass();
        if (type != String.class) {
            this.valueSerializationService = this.context().service(ValueSerializationService.class);
            if (this.valueSerializationService == null) {
                String message = NLS.bind(Resources.noSerializationService, element.type().getModelElementClass().getName(), property.getName(), type.getName());
                LoggingService.log(Status.createErrorStatus(message));
            }
        }
    }

    public String encode(Object value) {
        String result = null;
        if (value != null) {
            result = this.valueSerializationService == null ? value.toString() : this.valueSerializationService.encode(value);
        }
        return result;
    }

    public Object decode(String value) {
        Object result = null;
        if (value != null) {
            result = this.valueSerializationService == null ? value : this.valueSerializationService.decode(value.trim());
        }
        return result;
    }

    private static final class Resources
    extends NLS {
        public static String noSerializationService;

        static {
            Resources.initializeMessages(ValueSerializationMasterService.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

