/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.sdk.build.processor.internal;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.Messager;
import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.ArrayType;
import com.sun.mirror.type.ClassType;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.type.MirroredTypeException;
import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.type.VoidType;
import com.sun.mirror.util.SourcePosition;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.sapphire.modeling.ElementProperty;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.IModelParticle;
import org.eclipse.sapphire.modeling.ImpliedElementProperty;
import org.eclipse.sapphire.modeling.ListBindingImpl;
import org.eclipse.sapphire.modeling.ListProperty;
import org.eclipse.sapphire.modeling.ModelElement;
import org.eclipse.sapphire.modeling.ModelElementHandle;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.modeling.ModelElementType;
import org.eclipse.sapphire.modeling.ModelProperty;
import org.eclipse.sapphire.modeling.PropertyContentEvent;
import org.eclipse.sapphire.modeling.PropertyEnablementEvent;
import org.eclipse.sapphire.modeling.PropertyInitializationEvent;
import org.eclipse.sapphire.modeling.PropertyValidationEvent;
import org.eclipse.sapphire.modeling.ReferenceValue;
import org.eclipse.sapphire.modeling.Resource;
import org.eclipse.sapphire.modeling.Transient;
import org.eclipse.sapphire.modeling.TransientProperty;
import org.eclipse.sapphire.modeling.Value;
import org.eclipse.sapphire.modeling.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.DelegateImplementation;
import org.eclipse.sapphire.modeling.annotations.Derived;
import org.eclipse.sapphire.modeling.annotations.GenerateImpl;
import org.eclipse.sapphire.modeling.annotations.ReadOnly;
import org.eclipse.sapphire.modeling.annotations.Reference;
import org.eclipse.sapphire.modeling.annotations.Type;
import org.eclipse.sapphire.modeling.util.MiscUtil;
import org.eclipse.sapphire.modeling.util.NLS;
import org.eclipse.sapphire.sdk.build.processor.internal.SapphireAnnotationsProcessor;
import org.eclipse.sapphire.sdk.build.processor.internal.util.AccessModifier;
import org.eclipse.sapphire.sdk.build.processor.internal.util.Body;
import org.eclipse.sapphire.sdk.build.processor.internal.util.ClassModel;
import org.eclipse.sapphire.sdk.build.processor.internal.util.FieldModel;
import org.eclipse.sapphire.sdk.build.processor.internal.util.IndentingPrintWriter;
import org.eclipse.sapphire.sdk.build.processor.internal.util.MethodModel;
import org.eclipse.sapphire.sdk.build.processor.internal.util.MethodParameterModel;
import org.eclipse.sapphire.sdk.build.processor.internal.util.ParameterizedTypeReference;
import org.eclipse.sapphire.sdk.build.processor.internal.util.TypeReference;
import org.eclipse.sapphire.sdk.build.processor.internal.util.WildcardTypeReference;
import org.eclipse.sapphire.services.DerivedValueService;
import org.eclipse.sapphire.services.ValueNormalizationService;
import org.eclipse.sapphire.services.ValueSerializationMasterService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GenerateImplProcessor
extends SapphireAnnotationsProcessor {
    private static final String DATA_READ_METHOD = "read.method";
    private static final String DATA_WRITE_VALUE_METHOD = "write.value.method";
    private static final String DATA_WRITE_TRANSIENT_METHOD = "write.transient.method";
    private static final String DATA_REFRESH_METHOD = "refresh.method";
    private static final String DATA_DISPOSE_PROPERTIES_METHOD = "dispose.properties.method";
    private static final String DATA_HAS_CONTENTS = "has.contents";

    @Override
    public void process(AnnotationProcessorEnvironment env, Declaration annotatedEntity, AnnotationMirror annotation) {
        block7: {
            try {
                if (annotation == null || annotatedEntity == null) {
                    return;
                }
                if (!(annotatedEntity instanceof InterfaceDeclaration)) {
                    return;
                }
                InterfaceDeclaration interfaceDeclaration = (InterfaceDeclaration)annotatedEntity;
                ClassModel implClassModel = new ClassModel();
                this.process(env.getMessager(), implClassModel, interfaceDeclaration);
                if (implClassModel.isInvalid()) break block7;
                PrintWriter pw = env.getFiler().createSourceFile(implClassModel.getName().getQualifiedName());
                try {
                    implClassModel.write(new IndentingPrintWriter(pw));
                }
                finally {
                    pw.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected static boolean isInstanceOf(TypeMirror type, String interfaceOrClass) {
        if (type instanceof DeclaredType) {
            DeclaredType declaredType = (DeclaredType)type;
            return GenerateImplProcessor.isInstanceOf(declaredType.getDeclaration(), interfaceOrClass);
        }
        return false;
    }

    protected static boolean isInstanceOf(TypeDeclaration type, String interfaceOrClass) {
        if (type != null) {
            ClassType superClassType;
            if (type.getQualifiedName().equals(interfaceOrClass)) {
                return true;
            }
            if (type instanceof ClassDeclaration && (superClassType = ((ClassDeclaration)type).getSuperclass()) != null && GenerateImplProcessor.isInstanceOf((TypeDeclaration)superClassType.getDeclaration(), interfaceOrClass)) {
                return true;
            }
            for (InterfaceType superInterface : type.getSuperinterfaces()) {
                if (!GenerateImplProcessor.isInstanceOf((TypeMirror)superInterface, interfaceOrClass)) continue;
                return true;
            }
        }
        return false;
    }

    private void process(Messager messager, final ClassModel elImplClass, InterfaceDeclaration elInterface) {
        MethodModel mWriteTransient;
        MethodModel mWriteValue;
        MethodModel mRead;
        GenerateImpl generateImplAnnotation = (GenerateImpl)elInterface.getAnnotation(GenerateImpl.class);
        String implClassQualifiedName = ModelElementType.getImplClassName((String)GenerateImplProcessor.getQualifiedName((TypeDeclaration)elInterface), (GenerateImpl)generateImplAnnotation);
        elImplClass.setName(new TypeReference(implClassQualifiedName));
        elImplClass.addInterface(new TypeReference(elInterface.getQualifiedName()));
        elImplClass.setBaseClass(new TypeReference(ModelElement.class.getName()));
        MethodModel c1 = elImplClass.addConstructor();
        c1.addParameter(new MethodParameterModel("parent", IModelParticle.class));
        c1.addParameter(new MethodParameterModel("parentProperty", ModelProperty.class));
        c1.addParameter(new MethodParameterModel("resource", Resource.class));
        c1.getBody().append("super( TYPE, parent, parentProperty, resource );");
        MethodModel c2 = elImplClass.addConstructor();
        c2.addParameter(new MethodParameterModel("resource", Resource.class));
        c2.getBody().append("super( TYPE, null, null, resource );");
        elImplClass.addImport(PropertyInitializationEvent.class);
        elImplClass.addImport(PropertyContentEvent.class);
        elImplClass.addImport(PropertyValidationEvent.class);
        elImplClass.addImport(PropertyEnablementEvent.class);
        final TreeMap propFields = new TreeMap();
        Visitor<FieldDeclaration> fieldsVisitor = new Visitor<FieldDeclaration>(){

            @Override
            public void visit(FieldDeclaration field) {
                String fieldName = field.getSimpleName();
                if (fieldName != null && fieldName.startsWith("PROP_")) {
                    PropertyFieldDeclaration propFieldDeclaration = (PropertyFieldDeclaration)propFields.get(fieldName);
                    if (propFieldDeclaration == null) {
                        propFieldDeclaration = new PropertyFieldDeclaration();
                        propFieldDeclaration.name = fieldName;
                        propFieldDeclaration.propertyName = GenerateImplProcessor.preparePropName(fieldName);
                        propFields.put(fieldName, propFieldDeclaration);
                    }
                    propFieldDeclaration.declarations.addFirst(field);
                }
            }
        };
        GenerateImplProcessor.visitAllFields(elInterface, fieldsVisitor);
        for (PropertyFieldDeclaration field : propFields.values()) {
            if (GenerateImplProcessor.isInstanceOf(field.getType(), ValueProperty.class.getName())) {
                this.processValueProperty(messager, elImplClass, elInterface, field);
                continue;
            }
            if (GenerateImplProcessor.isInstanceOf(field.getType(), ElementProperty.class.getName())) {
                this.processElementProperty(messager, elImplClass, elInterface, field);
                continue;
            }
            if (GenerateImplProcessor.isInstanceOf(field.getType(), ListProperty.class.getName())) {
                this.processListProperty(messager, elImplClass, elInterface, field);
                continue;
            }
            if (!GenerateImplProcessor.isInstanceOf(field.getType(), TransientProperty.class.getName())) continue;
            this.processTransientProperty(messager, elImplClass, elInterface, field);
        }
        Visitor<MethodDeclaration> methodsVisitor = new Visitor<MethodDeclaration>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public void visit(MethodDeclaration method) {
                DelegateImplementation delegateImplementationAnnotation = (DelegateImplementation)method.getAnnotation(DelegateImplementation.class);
                if (delegateImplementationAnnotation != null) {
                    String methodName = method.getSimpleName();
                    TypeReference methodReturnType = GenerateImplProcessor.toTypeReference(method.getReturnType());
                    ArrayList<TypeReference> methodParametersList = new ArrayList<TypeReference>();
                    LinkedHashMap<String, TypeReference> methodParametersMap = new LinkedHashMap<String, TypeReference>();
                    for (ParameterDeclaration param : method.getParameters()) {
                        TypeReference type = GenerateImplProcessor.toTypeReference(param.getType());
                        methodParametersList.add(type);
                        methodParametersMap.put(param.getSimpleName(), type);
                    }
                    if (!elImplClass.hasMethod(methodName, methodParametersList)) {
                        void var8_12;
                        MethodModel m = elImplClass.addMethod(methodName);
                        m.setReturnType(methodReturnType);
                        for (Map.Entry entry : methodParametersMap.entrySet()) {
                            MethodParameterModel p = new MethodParameterModel();
                            p.setName((String)entry.getKey());
                            p.setType((TypeReference)entry.getValue());
                            m.addParameter(p);
                        }
                        Object var8_10 = null;
                        try {
                            delegateImplementationAnnotation.value();
                        }
                        catch (MirroredTypeException e) {
                            ClassDeclaration typeMirror = ((ClassType)e.getTypeMirror()).getDeclaration();
                            TypeReference typeReference = new TypeReference(typeMirror.getQualifiedName());
                        }
                        Body mb = m.getBody();
                        mb.append("synchronized( root() )");
                        mb.openBlock();
                        StringBuilder buf = new StringBuilder();
                        if (m.getReturnType() != TypeReference.VOID_TYPE) {
                            buf.append("return ");
                        }
                        buf.append(var8_12.getSimpleName()).append('.').append(m.getName()).append("( this");
                        for (MethodParameterModel param : m.getParameters()) {
                            buf.append(", ");
                            buf.append(param.getName());
                        }
                        buf.append(" );");
                        mb.append(buf.toString());
                        mb.closeBlock();
                        elImplClass.addImport((TypeReference)var8_12);
                    }
                }
            }
        };
        GenerateImplProcessor.visitAllMethods(elInterface, methodsVisitor);
        MethodModel mRefresh = GenerateImplProcessor.getRefreshMethod(elImplClass, false);
        if (mRefresh != null) {
            elImplClass.removeMethod(mRefresh);
            elImplClass.addMethod(mRefresh);
            mRefresh.getBody().closeBlock();
        }
        if ((mRead = GenerateImplProcessor.getReadMethod(elImplClass, false)) != null) {
            elImplClass.removeMethod(mRead);
            elImplClass.addMethod(mRead);
            mRead.getBody().appendEmptyLine();
            mRead.getBody().append("return super.read( property );");
        }
        if ((mWriteValue = GenerateImplProcessor.getValueWriteMethod(elImplClass, false)) != null) {
            elImplClass.removeMethod(mWriteValue);
            elImplClass.addMethod(mWriteValue);
            mWriteValue.getBody().appendEmptyLine();
            mWriteValue.getBody().append("super.write( property, value );");
        }
        if ((mWriteTransient = GenerateImplProcessor.getTransientWriteMethod(elImplClass, false)) != null) {
            elImplClass.removeMethod(mWriteTransient);
            elImplClass.addMethod(mWriteTransient);
            mWriteTransient.getBody().appendEmptyLine();
            mWriteTransient.getBody().append("super.write( property, object );");
        }
    }

    private void processValueProperty(Messager messager, ClassModel implClassModel, InterfaceDeclaration interfaceDeclaration, PropertyFieldDeclaration propField) {
        try {
            this.processValuePropertyInternal(messager, implClassModel, interfaceDeclaration, propField);
        }
        catch (AbortException abortException) {
            implClassModel.markInvalid();
        }
        catch (RuntimeException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            InterfaceDeclaration modelElementInterface = propField.getDeclaringType();
            pw.println();
            pw.println("RuntimeException encountered during processValueProperty() method call.");
            pw.println();
            pw.println("interfaceDeclaration : " + (modelElementInterface == null ? "null" : modelElementInterface.getQualifiedName()));
            pw.println("propField : " + propField.name);
            pw.println();
            e.printStackTrace(pw);
            pw.println();
            pw.flush();
            System.err.println(sw.getBuffer().toString());
            throw e;
        }
    }

    private void processValuePropertyInternal(Messager messager, ClassModel implClassModel, InterfaceDeclaration interfaceDeclaration, PropertyFieldDeclaration propField) {
        TypeReference baseType = null;
        ParameterizedTypeReference wrapperType = null;
        Type typeAnnotation = propField.getAnnotation(Type.class);
        if (typeAnnotation == null) {
            baseType = new TypeReference(String.class);
        } else {
            try {
                typeAnnotation.base();
            }
            catch (MirroredTypeException e) {
                baseType = GenerateImplProcessor.toTypeReference(e.getTypeMirror());
            }
        }
        Reference referenceAnnotation = propField.getAnnotation(Reference.class);
        if (referenceAnnotation != null) {
            try {
                referenceAnnotation.target();
            }
            catch (MirroredTypeException e) {
                TypeMirror mirror = e.getTypeMirror();
                TypeReference targetType = GenerateImplProcessor.toTypeReference(mirror);
                Collection typeParams = mirror instanceof TypeDeclaration ? ((TypeDeclaration)mirror).getFormalTypeParameters() : ((DeclaredType)mirror).getDeclaration().getFormalTypeParameters();
                if (!typeParams.isEmpty()) {
                    Object[] params = new TypeReference[typeParams.size()];
                    Arrays.fill(params, WildcardTypeReference.INSTANCE);
                    targetType = targetType.parameterize((TypeReference[])params);
                }
                wrapperType = new TypeReference(ReferenceValue.class).parameterize(baseType, targetType);
            }
        } else {
            wrapperType = new TypeReference(Value.class).parameterize(baseType);
        }
        boolean hasDerivedValueProviderAnnotation = propField.getAnnotation(Derived.class) != null;
        String variableName = String.valueOf(propField.propertyName.substring(0, 1).toLowerCase()) + propField.propertyName.substring(1);
        String getterMethodName = null;
        InterfaceDeclaration modelElementInterface = propField.getDeclaringType();
        String getterAlt1 = "get" + propField.propertyName;
        String getterAlt2 = "is" + propField.propertyName;
        MethodDeclaration getterMethodInInterface = GenerateImplProcessor.findMethodDeclaration(modelElementInterface, getterAlt1, new String[0]);
        if (getterMethodInInterface == null) {
            getterMethodInInterface = GenerateImplProcessor.findMethodDeclaration(modelElementInterface, getterAlt2, new String[0]);
        }
        if (getterMethodInInterface == null) {
            String msg = NLS.bind((String)Resources.unableToFindGetter, (Object[])new Object[]{modelElementInterface.getSimpleName(), propField.name});
            messager.printError(propField.getSourcePosition(), msg);
            throw new AbortException();
        }
        getterMethodName = getterMethodInInterface.getSimpleName();
        propField.setGetterMethodName(getterMethodName);
        FieldModel field = implClassModel.addField();
        field.setName(variableName);
        field.setType(wrapperType);
        Body rb = GenerateImplProcessor.prepareRefreshMethodBlock(implClassModel, propField);
        rb.append("if( this.#1 != null || force == true )", variableName);
        rb.openBlock();
        rb.append("final #2 oldValue = this.#1;", variableName, wrapperType.getSimpleName());
        rb.appendEmptyLine();
        if (hasDerivedValueProviderAnnotation) {
            rb.append("final String val = service( #1, DerivedValueService.class ).value();", propField.name);
            implClassModel.addImport(DerivedValueService.class);
        } else {
            rb.append("final String val = resource().binding( #1 ).read();", propField.name);
        }
        rb.appendEmptyLine();
        rb.append("this.#1 = new #2( this, #3, service( #3, ValueNormalizationService.class ).normalize( #3.encodeKeywords( val ) ) );\nthis.#1.init();\n\nfinal EnablementRefreshResult enablementRefreshResult = refreshPropertyEnablement( #3 );\n\nif( oldValue == null )\n{\n    broadcast( new PropertyInitializationEvent( this, #3 ) );\n}\nelse\n{\n    if( this.#1.equals( oldValue ) )\n    {\n        this.#1 = oldValue;\n    }\n    else\n    {\n        if( ! equal( this.#1.getText( false ), oldValue.getText( false ) ) || ! equal( this.#1.getDefaultText(), oldValue.getDefaultText() ) )\n        {\n            broadcast( new PropertyContentEvent( this, #3 ) );\n        }\n        \n        if( ! this.#1.validation().equals( oldValue.validation() ) )\n        {\n            broadcast( new PropertyValidationEvent( this, #3, oldValue.validation(), this.#1.validation() ) );\n        }\n    }\n    \n    if( enablementRefreshResult.changed() )\n    {\n        broadcast( new PropertyEnablementEvent( this, #3, enablementRefreshResult.before(), enablementRefreshResult.after() ) );\n    }\n}", variableName, wrapperType.getSimpleName(), propField.name);
        rb.closeBlock();
        rb.closeBlock();
        implClassModel.addImport(ValueNormalizationService.class);
        MethodModel getter = implClassModel.addMethod();
        getter.setName(getterMethodName);
        getter.setReturnType(wrapperType);
        Body gb = getter.getBody();
        gb.append("synchronized( root() )\n{\n    if( this.#1 == null )\n    {\n        refresh( #2, true );\n    }\n    \n    return this.#1;\n}", variableName, propField.name);
        if (!hasDerivedValueProviderAnnotation && propField.getAnnotation(ReadOnly.class) == null) {
            MethodDeclaration setterMethodInInterface = GenerateImplProcessor.findMethodDeclaration(modelElementInterface, "set" + propField.propertyName, "java.lang.String");
            if (setterMethodInInterface == null) {
                String msg = NLS.bind((String)Resources.unableToFindStringSetter, (Object[])new Object[]{modelElementInterface.getSimpleName(), propField.name});
                messager.printError(propField.getSourcePosition(), msg);
                throw new AbortException();
            }
            String setterMethodName = setterMethodInInterface.getSimpleName();
            propField.setSetterMethodName(setterMethodName);
            MethodModel setter = null;
            setter = implClassModel.addMethod();
            setter.setName(setterMethodName);
            MethodParameterModel setterParam = new MethodParameterModel("value", String.class);
            setterParam.setFinal(false);
            setter.addParameter(setterParam);
            Body sb = setter.getBody();
            sb.append("synchronized( root() )\n{\n    if( value != null && value.equals( MiscUtil.EMPTY_STRING ) )\n    {\n        value = null;\n    }\n    \n    value = #1.decodeKeywords( value );\n    value = service( #1, ValueNormalizationService.class ).normalize( value );\n    \n    refresh( #1, true );\n    \n    if( ! equal( this.#2.getText( false ), value ) )\n    {\n        resource().binding( #1 ).write( value );\n        refresh( #1, false );\n    }\n}\n", propField.name, variableName);
            implClassModel.addImport(MiscUtil.class);
            if (!baseType.getQualifiedName().equals(String.class.getName())) {
                MethodDeclaration typedSetterMethodInInterface = GenerateImplProcessor.findMethodDeclaration(modelElementInterface, "set" + propField.propertyName, baseType.getQualifiedName());
                if (typedSetterMethodInInterface == null) {
                    String msg = NLS.bind((String)Resources.unableToFindTypedSetter, (Object[])new Object[]{modelElementInterface.getSimpleName(), propField.name});
                    messager.printError(propField.getSourcePosition(), msg);
                    throw new AbortException();
                }
                String typeSetterMethodName = typedSetterMethodInInterface.getSimpleName();
                propField.setTypedSetterMethodName(typeSetterMethodName);
                MethodModel setterForTyped = implClassModel.addMethod();
                setterForTyped.setName(typeSetterMethodName);
                setterForTyped.addParameter(new MethodParameterModel("value", baseType));
                Body stb = setterForTyped.getBody();
                stb.append("#1( value != null ? service( #2, ValueSerializationMasterService.class ).encode( value ) : null );", setterMethodName, propField.name);
                implClassModel.addImport(ValueSerializationMasterService.class);
            }
            GenerateImplProcessor.contributeValueWriteMethodBlock(implClassModel, propField);
        } else {
            MethodDeclaration typedSetterMethodInInterface;
            MethodDeclaration setterMethodInInterface = GenerateImplProcessor.findMethodDeclaration(modelElementInterface, "set" + propField.propertyName, "java.lang.String");
            if (setterMethodInInterface != null) {
                String setterMethodName = setterMethodInInterface.getSimpleName();
                propField.setSetterMethodName(setterMethodName);
                MethodModel setter = null;
                setter = implClassModel.addMethod();
                setter.setName(setterMethodName);
                MethodParameterModel setterParam = new MethodParameterModel("value", String.class);
                setterParam.setFinal(false);
                setter.addParameter(setterParam);
                Body sb = setter.getBody();
                sb.append("throw new UnsupportedOperationException();");
            }
            if (!baseType.getQualifiedName().equals(String.class.getName()) && (typedSetterMethodInInterface = GenerateImplProcessor.findMethodDeclaration(modelElementInterface, "set" + propField.propertyName, baseType.getQualifiedName())) != null) {
                String typeSetterMethodName = typedSetterMethodInInterface.getSimpleName();
                propField.setTypedSetterMethodName(typeSetterMethodName);
                MethodModel setterForTyped = implClassModel.addMethod();
                setterForTyped.setName(typeSetterMethodName);
                setterForTyped.addParameter(new MethodParameterModel("value", baseType));
                Body stb = setterForTyped.getBody();
                stb.append("throw new UnsupportedOperationException();");
            }
        }
        GenerateImplProcessor.contributeReadMethodBlock(implClassModel, propField);
    }

    private void processElementProperty(Messager messager, ClassModel implClassModel, InterfaceDeclaration interfaceDeclaration, PropertyFieldDeclaration propField) {
        try {
            this.processElementPropertyInternal(messager, implClassModel, interfaceDeclaration, propField);
        }
        catch (AbortException abortException) {
            implClassModel.markInvalid();
        }
        catch (RuntimeException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            InterfaceDeclaration modelElementInterface = propField.getDeclaringType();
            pw.println();
            pw.println("RuntimeException encountered during processElementProperty() method call.");
            pw.println();
            pw.println("modelElementInterface : " + (modelElementInterface == null ? "null" : modelElementInterface.getQualifiedName()));
            pw.println("propField : " + propField.name);
            pw.println();
            e.printStackTrace(pw);
            pw.println();
            pw.flush();
            System.err.println(sw.getBuffer().toString());
            throw e;
        }
    }

    private void processElementPropertyInternal(Messager messager, ClassModel implClassModel, InterfaceDeclaration interfaceDeclaration, PropertyFieldDeclaration propField) {
        boolean isImplied = GenerateImplProcessor.isInstanceOf(propField.getType(), ImpliedElementProperty.class.getName());
        MethodDeclaration getterMethodInInterface = GenerateImplProcessor.findMethodDeclaration(interfaceDeclaration, "get" + propField.propertyName, new String[0]);
        if (getterMethodInInterface == null) {
            String msg = NLS.bind((String)Resources.unableToFindGetter, (Object[])new Object[]{interfaceDeclaration.getSimpleName(), propField.name});
            messager.printError(propField.getSourcePosition(), msg);
            throw new AbortException();
        }
        String getterMethodName = getterMethodInInterface.getSimpleName();
        propField.setGetterMethodName(getterMethodName);
        String variableName = String.valueOf(propField.propertyName.substring(0, 1).toLowerCase()) + propField.propertyName.substring(1);
        TypeReference memberType = null;
        Type typeAnnotation = propField.getAnnotation(Type.class);
        try {
            typeAnnotation.base();
        }
        catch (MirroredTypeException e) {
            InterfaceDeclaration typeMirror = ((InterfaceType)e.getTypeMirror()).getDeclaration();
            memberType = new TypeReference(typeMirror.getQualifiedName());
        }
        ParameterizedTypeReference handleType = new TypeReference(ModelElementHandle.class).parameterize(memberType);
        FieldModel field = implClassModel.addField();
        field.setName(variableName);
        field.setType(handleType);
        MethodModel g = implClassModel.addMethod();
        g.setName(getterMethodName);
        g.setReturnType(isImplied ? memberType : handleType);
        Body gb = g.getBody();
        gb.append("synchronized( root() )\n{\n    if( this.#1 == null )\n    {\n        refresh( #2, true );\n    }\n    \n    return this.#1#3;\n}", variableName, propField.name, isImplied ? ".element()" : "");
        Body rb = GenerateImplProcessor.prepareRefreshMethodBlock(implClassModel, propField);
        rb.append("if( this.#1 == null )\n{\n    if( force == true )\n    {\n        this.#1 = new ModelElementHandle<#3>( this, #2 );\n        this.#1.init();\n        refreshPropertyEnablement( #2 );\n        broadcast( new PropertyInitializationEvent( this, #2 ) );\n    }\n}\nelse\n{\n    final EnablementRefreshResult enablementRefreshResult = refreshPropertyEnablement( #2 );\n    final boolean notified = this.#1.refresh();\n    \n    if( ! notified && enablementRefreshResult.changed() )\n    {\n        broadcast( new PropertyEnablementEvent( this, #2, enablementRefreshResult.before(), enablementRefreshResult.after() ) );\n    }\n}", variableName, propField.name, memberType.getSimpleName());
        rb.closeBlock();
        Body db = GenerateImplProcessor.prepareDisposePropertiesMethodBlock(implClassModel);
        db.append("if( this.#1 != null )\n{\n    final IModelElement element = this.#1.element( false );\n    \n    if( element != null )\n    {\n        element.dispose();\n    }\n}", variableName);
        implClassModel.addImport(IModelElement.class);
        GenerateImplProcessor.contributeReadMethodBlock(implClassModel, propField);
    }

    private void processListProperty(Messager messager, ClassModel implClassModel, InterfaceDeclaration interfaceDeclaration, PropertyFieldDeclaration propField) {
        try {
            this.processListPropertyInternal(messager, implClassModel, interfaceDeclaration, propField);
        }
        catch (AbortException abortException) {
            implClassModel.markInvalid();
        }
        catch (RuntimeException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            InterfaceDeclaration modelElementInterface = propField.getDeclaringType();
            pw.println();
            pw.println("RuntimeException encountered during processListProperty() method call.");
            pw.println();
            pw.println("modelElementInterface : " + (modelElementInterface == null ? "null" : modelElementInterface.getQualifiedName()));
            pw.println("propField : " + propField.name);
            pw.println();
            e.printStackTrace(pw);
            pw.println();
            pw.flush();
            System.err.println(sw.getBuffer().toString());
            throw e;
        }
    }

    private void processListPropertyInternal(Messager messager, ClassModel implClassModel, InterfaceDeclaration interfaceDeclaration, PropertyFieldDeclaration propField) {
        MethodDeclaration getterMethodInInterface = GenerateImplProcessor.findMethodDeclaration(interfaceDeclaration, "get" + propField.propertyName, new String[0]);
        if (getterMethodInInterface == null) {
            String msg = NLS.bind((String)Resources.unableToFindGetter, (Object[])new Object[]{interfaceDeclaration.getSimpleName(), propField.name});
            messager.printError(propField.getSourcePosition(), msg);
            throw new AbortException();
        }
        String getterMethodName = getterMethodInInterface.getSimpleName();
        propField.setGetterMethodName(getterMethodName);
        String variableName = String.valueOf(propField.propertyName.substring(0, 1).toLowerCase()) + propField.propertyName.substring(1);
        TypeReference memberType = null;
        Type typeAnnotation = propField.getAnnotation(Type.class);
        try {
            typeAnnotation.base();
        }
        catch (MirroredTypeException e) {
            InterfaceDeclaration typeMirror = ((InterfaceType)e.getTypeMirror()).getDeclaration();
            memberType = new TypeReference(typeMirror.getQualifiedName());
        }
        ParameterizedTypeReference listType = new TypeReference(ModelElementList.class).parameterize(memberType);
        FieldModel field = implClassModel.addField();
        field.setName(variableName);
        field.setType(listType);
        MethodModel g = implClassModel.addMethod();
        g.setName(getterMethodName);
        g.setReturnType(listType);
        Body gb = g.getBody();
        gb.append("synchronized( root() )\n{\n    if( this.#1 == null )\n    {\n        refresh( #2, true );\n    }\n    \n    return this.#1;\n}", variableName, propField.name);
        Body rb = GenerateImplProcessor.prepareRefreshMethodBlock(implClassModel, propField);
        rb.append("if( this.#1 == null )\n{\n    if( force == true )\n    {\n        this.#1 = new ModelElementList<#3>( this, #2 );\n        final ListBindingImpl binding = resource().binding( #2 );\n        this.#1.init( binding );\n        refreshPropertyEnablement( #2 );\n        broadcast( new PropertyInitializationEvent( this, #2 ) );\n    }\n}\nelse\n{\n    final EnablementRefreshResult enablementRefreshResult = refreshPropertyEnablement( #2 );\n    final boolean notified = this.#1.refresh();\n    \n    if( ! notified && enablementRefreshResult.changed() )\n    {\n        broadcast( new PropertyEnablementEvent( this, #2, enablementRefreshResult.before(), enablementRefreshResult.after() ) );\n    }\n}", variableName, propField.name, memberType.getSimpleName());
        implClassModel.addImport(ListBindingImpl.class);
        rb.closeBlock();
        Body db = GenerateImplProcessor.prepareDisposePropertiesMethodBlock(implClassModel);
        db.append("if( this.#1 != null )\n{\n    for( IModelElement element : this.#1 )\n    {\n        element.dispose();\n    }\n}", variableName);
        implClassModel.addImport(IModelElement.class);
        GenerateImplProcessor.contributeReadMethodBlock(implClassModel, propField);
    }

    private void processTransientProperty(Messager messager, ClassModel implClassModel, InterfaceDeclaration interfaceDeclaration, PropertyFieldDeclaration propField) {
        try {
            this.processTransientPropertyInternal(messager, implClassModel, interfaceDeclaration, propField);
        }
        catch (AbortException abortException) {
            implClassModel.markInvalid();
        }
        catch (RuntimeException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            InterfaceDeclaration modelElementInterface = propField.getDeclaringType();
            pw.println();
            pw.println("RuntimeException encountered during processTransientProperty() method call.");
            pw.println();
            pw.println("interfaceDeclaration : " + (modelElementInterface == null ? "null" : modelElementInterface.getQualifiedName()));
            pw.println("propField : " + propField.name);
            pw.println();
            e.printStackTrace(pw);
            pw.println();
            pw.flush();
            System.err.println(sw.getBuffer().toString());
            throw e;
        }
    }

    private void processTransientPropertyInternal(Messager messager, ClassModel implClassModel, InterfaceDeclaration interfaceDeclaration, PropertyFieldDeclaration propField) {
        TypeReference baseType = null;
        ParameterizedTypeReference wrapperType = null;
        Type typeAnnotation = propField.getAnnotation(Type.class);
        if (typeAnnotation == null) {
            baseType = new TypeReference(Object.class);
        } else {
            try {
                typeAnnotation.base();
            }
            catch (MirroredTypeException e) {
                baseType = GenerateImplProcessor.toTypeReference(e.getTypeMirror());
            }
        }
        wrapperType = new TypeReference(Transient.class).parameterize(baseType);
        String variableName = String.valueOf(propField.propertyName.substring(0, 1).toLowerCase()) + propField.propertyName.substring(1);
        MethodDeclaration getterMethodInInterface = GenerateImplProcessor.findMethodDeclaration(interfaceDeclaration, "get" + propField.propertyName, new String[0]);
        if (getterMethodInInterface == null) {
            String msg = NLS.bind((String)Resources.unableToFindGetter, (Object[])new Object[]{interfaceDeclaration.getSimpleName(), propField.name});
            messager.printError(propField.getSourcePosition(), msg);
            throw new AbortException();
        }
        String getterMethodName = getterMethodInInterface.getSimpleName();
        propField.setGetterMethodName(getterMethodName);
        MethodDeclaration setterMethodInInterface = GenerateImplProcessor.findMethodDeclaration(interfaceDeclaration, "set" + propField.propertyName, baseType.getQualifiedName());
        if (setterMethodInInterface == null) {
            String msg = NLS.bind((String)Resources.unableToFindSetter, (Object[])new Object[]{interfaceDeclaration.getSimpleName(), propField.name});
            messager.printError(propField.getSourcePosition(), msg);
            throw new AbortException();
        }
        String setterMethodName = setterMethodInInterface.getSimpleName();
        propField.setSetterMethodName(setterMethodName);
        FieldModel field = implClassModel.addField();
        field.setName(variableName);
        field.setType(wrapperType);
        Body rb = GenerateImplProcessor.prepareRefreshMethodBlock(implClassModel, propField);
        rb.append("if( this.#1 == null )\n{\n    if( force == true )\n    {\n        #2( null );\n    }\n}\nelse\n{\n    #2( this.#1.content() );\n}", variableName, setterMethodName);
        rb.closeBlock();
        MethodModel getter = implClassModel.addMethod();
        getter.setName(getterMethodName);
        getter.setReturnType(wrapperType);
        Body gb = getter.getBody();
        gb.append("synchronized( root() )\n{\n    if( this.#1 == null )\n    {\n        refresh( #2, true );\n    }\n    \n    return this.#1;\n}", variableName, propField.name);
        MethodModel setter = implClassModel.addMethod();
        setter.setName(setterMethodName);
        MethodParameterModel param = new MethodParameterModel("object", baseType);
        setter.addParameter(param);
        Body sb = setter.getBody();
        sb.append("synchronized( root() )\n{\n    final #2 oldTransient = this.#1;\n    \n    this.#1 = new #2( this, #3, object );\n    this.#1.init();\n    \n    final EnablementRefreshResult enablementRefreshResult = refreshPropertyEnablement( #3 );\n    \n    if( oldTransient == null )\n    {\n        broadcast( new PropertyInitializationEvent( this, #3 ) );\n        \n        if( object != null )\n        {\n            broadcast( new PropertyContentEvent( this, #3 ) );\n        }\n    }\n    else\n    {\n        if( this.#1.equals( oldTransient ) )\n        {\n            this.#1 = oldTransient;\n        }\n        else\n        {\n            broadcast( new PropertyContentEvent( this, #3 ) );\n        }\n    }\n    \n    if( enablementRefreshResult.changed() )\n    {\n        broadcast( new PropertyEnablementEvent( this, #3, enablementRefreshResult.before(), enablementRefreshResult.after() ) );\n    }\n}", variableName, wrapperType.getSimpleName(), propField.name);
        GenerateImplProcessor.contributeReadMethodBlock(implClassModel, propField);
        GenerateImplProcessor.contributeTransientWriteMethodBlock(implClassModel, propField);
    }

    private static MethodDeclaration findMethodDeclaration(InterfaceDeclaration interfaceDeclaration, String methodName, String ... paramTypes) {
        for (MethodDeclaration method : interfaceDeclaration.getMethods()) {
            Collection params;
            if (!method.getSimpleName().equalsIgnoreCase(methodName) || (params = method.getParameters()).size() != paramTypes.length) continue;
            Iterator itr = params.iterator();
            boolean paramsMatch = true;
            String[] stringArray = paramTypes;
            int n = paramTypes.length;
            int n2 = 0;
            while (n2 < n) {
                TypeDeclaration actualParamTypeDeclaration;
                String expectedParamTypeName = stringArray[n2];
                TypeMirror actualParamType = ((ParameterDeclaration)itr.next()).getType();
                if (actualParamType instanceof DeclaredType && ((actualParamTypeDeclaration = ((DeclaredType)actualParamType).getDeclaration()) == null || !actualParamTypeDeclaration.getQualifiedName().equals(expectedParamTypeName))) {
                    paramsMatch = false;
                    break;
                }
                ++n2;
            }
            if (!paramsMatch) continue;
            return method;
        }
        for (InterfaceType superInterfaceType : interfaceDeclaration.getSuperinterfaces()) {
            MethodDeclaration method = GenerateImplProcessor.findMethodDeclaration(superInterfaceType.getDeclaration(), methodName, paramTypes);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    private static String preparePropName(String propFieldName) {
        StringBuilder buf = new StringBuilder();
        boolean seenFirstSegment = false;
        String[] stringArray = propFieldName.split("_");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            if (seenFirstSegment) {
                buf.append(segment.charAt(0));
                buf.append(segment.substring(1).toLowerCase());
            } else {
                seenFirstSegment = true;
            }
            ++n2;
        }
        return buf.toString();
    }

    private static void visitAllMethods(InterfaceDeclaration interfaceDeclaration, Visitor<MethodDeclaration> visitor) {
        GenerateImplProcessor.visitAllMethods(interfaceDeclaration, visitor, new HashSet<InterfaceDeclaration>());
    }

    private static void visitAllMethods(InterfaceDeclaration interfaceDeclaration, Visitor<MethodDeclaration> visitor, Set<InterfaceDeclaration> visited) {
        visited.add(interfaceDeclaration);
        for (MethodDeclaration method : interfaceDeclaration.getMethods()) {
            visitor.visit(method);
        }
        for (InterfaceType superInterface : interfaceDeclaration.getSuperinterfaces()) {
            InterfaceDeclaration superInterfaceDeclaration = superInterface.getDeclaration();
            if (visited.contains(superInterfaceDeclaration)) continue;
            GenerateImplProcessor.visitAllMethods(superInterfaceDeclaration, visitor, visited);
        }
    }

    private static void visitAllFields(InterfaceDeclaration interfaceDeclaration, Visitor<FieldDeclaration> visitor) {
        GenerateImplProcessor.visitAllFields(interfaceDeclaration, visitor, new HashSet<InterfaceDeclaration>());
    }

    private static void visitAllFields(InterfaceDeclaration interfaceDeclaration, Visitor<FieldDeclaration> visitor, Set<InterfaceDeclaration> visited) {
        visited.add(interfaceDeclaration);
        for (InterfaceType superInterface : interfaceDeclaration.getSuperinterfaces()) {
            InterfaceDeclaration superInterfaceDeclaration = superInterface.getDeclaration();
            if (visited.contains(superInterfaceDeclaration)) continue;
            GenerateImplProcessor.visitAllFields(superInterfaceDeclaration, visitor, visited);
        }
        for (FieldDeclaration field : interfaceDeclaration.getFields()) {
            visitor.visit(field);
        }
    }

    private static MethodModel getReadMethod(ClassModel implClassModel, boolean createIfNecessary) {
        MethodModel readMethod = (MethodModel)implClassModel.getData(DATA_READ_METHOD);
        if (readMethod == null && createIfNecessary) {
            readMethod = implClassModel.addMethod("read");
            readMethod.setReturnType(Object.class);
            readMethod.addParameter(new MethodParameterModel("property", ModelProperty.class, false));
            readMethod.setData(DATA_HAS_CONTENTS, Boolean.FALSE);
            implClassModel.setData(DATA_READ_METHOD, readMethod);
            Body rb = readMethod.getBody();
            rb.append("property = property.refine( this );");
            rb.appendEmptyLine();
        }
        return readMethod;
    }

    private static Body contributeReadMethodBlock(ClassModel implClassModel, PropertyFieldDeclaration propField) {
        boolean hasPriorContent;
        MethodModel readMethod = GenerateImplProcessor.getReadMethod(implClassModel, true);
        Body rb = readMethod.getBody();
        if (readMethod.getData(DATA_HAS_CONTENTS) == Boolean.TRUE) {
            hasPriorContent = true;
        } else {
            hasPriorContent = false;
            readMethod.setData(DATA_HAS_CONTENTS, Boolean.TRUE);
        }
        rb.append("#1if( property == #2 )\n{\n    return #3();\n}", hasPriorContent ? "else " : "", propField.name, propField.getGetterMethodName());
        return rb;
    }

    private static MethodModel getValueWriteMethod(ClassModel implClassModel, boolean createIfNecessary) {
        MethodModel writeMethod = (MethodModel)implClassModel.getData(DATA_WRITE_VALUE_METHOD);
        if (writeMethod == null && createIfNecessary) {
            writeMethod = implClassModel.addMethod("write");
            writeMethod.addParameter(new MethodParameterModel("property", ValueProperty.class, false));
            writeMethod.addParameter(new MethodParameterModel("value", Object.class));
            writeMethod.setData(DATA_HAS_CONTENTS, Boolean.FALSE);
            implClassModel.setData(DATA_WRITE_VALUE_METHOD, writeMethod);
            Body rb = writeMethod.getBody();
            rb.append("property = (ValueProperty) property.refine( this );");
            rb.appendEmptyLine();
        }
        return writeMethod;
    }

    private static Body contributeValueWriteMethodBlock(ClassModel implClassModel, PropertyFieldDeclaration propField) {
        boolean hasPriorContent;
        MethodModel writeMethod = GenerateImplProcessor.getValueWriteMethod(implClassModel, true);
        Body rb = writeMethod.getBody();
        if (writeMethod.getData(DATA_HAS_CONTENTS) == Boolean.TRUE) {
            hasPriorContent = true;
        } else {
            hasPriorContent = false;
            writeMethod.setData(DATA_HAS_CONTENTS, Boolean.TRUE);
        }
        Type typeAnnotation = propField.getAnnotation(Type.class);
        TypeReference type = null;
        if (typeAnnotation != null) {
            try {
                typeAnnotation.base();
            }
            catch (MirroredTypeException e) {
                type = GenerateImplProcessor.toTypeReference(e.getTypeMirror());
            }
        }
        rb.append("#1if( property == #2 )", hasPriorContent ? "else " : "", propField.name);
        rb.openBlock();
        if (type == null) {
            rb.append("#1( (String) value );\nreturn;", propField.getSetterMethodName());
        } else {
            rb.append("if( ! ( value instanceof String ) )\n{\n    #2( (#3) value );\n}\nelse\n{\n    #1( (String) value );\n}\n\nreturn;", propField.getSetterMethodName(), propField.getTypedSetterMethodName(), type.getSimpleName());
            implClassModel.addImport(type);
        }
        rb.closeBlock();
        return rb;
    }

    private static MethodModel getTransientWriteMethod(ClassModel implClassModel, boolean createIfNecessary) {
        MethodModel writeMethod = (MethodModel)implClassModel.getData(DATA_WRITE_TRANSIENT_METHOD);
        if (writeMethod == null && createIfNecessary) {
            writeMethod = implClassModel.addMethod("write");
            writeMethod.addParameter(new MethodParameterModel("property", TransientProperty.class, false));
            writeMethod.addParameter(new MethodParameterModel("object", Object.class));
            writeMethod.setData(DATA_HAS_CONTENTS, Boolean.FALSE);
            implClassModel.setData(DATA_WRITE_TRANSIENT_METHOD, writeMethod);
            Body rb = writeMethod.getBody();
            rb.append("property = (TransientProperty) property.refine( this );");
            rb.appendEmptyLine();
        }
        return writeMethod;
    }

    private static Body contributeTransientWriteMethodBlock(ClassModel implClassModel, PropertyFieldDeclaration propField) {
        boolean hasPriorContent;
        MethodModel writeMethod = GenerateImplProcessor.getTransientWriteMethod(implClassModel, true);
        Body rb = writeMethod.getBody();
        if (writeMethod.getData(DATA_HAS_CONTENTS) == Boolean.TRUE) {
            hasPriorContent = true;
        } else {
            hasPriorContent = false;
            writeMethod.setData(DATA_HAS_CONTENTS, Boolean.TRUE);
        }
        Type typeAnnotation = propField.getAnnotation(Type.class);
        TypeReference type = null;
        if (typeAnnotation != null) {
            try {
                typeAnnotation.base();
            }
            catch (MirroredTypeException e) {
                type = GenerateImplProcessor.toTypeReference(e.getTypeMirror());
            }
        }
        rb.append("#1if( property == #2 )", hasPriorContent ? "else " : "", propField.name);
        rb.openBlock();
        if (type == null) {
            rb.append("#1( object );", propField.getSetterMethodName());
        } else {
            rb.append("#1( (#2) object );", propField.getSetterMethodName(), type.getSimpleName());
        }
        rb.append("return;");
        rb.closeBlock();
        return rb;
    }

    private static MethodModel getRefreshMethod(ClassModel implClassModel, boolean createIfNecessary) {
        MethodModel refreshMethod = (MethodModel)implClassModel.getData(DATA_REFRESH_METHOD);
        if (refreshMethod == null && createIfNecessary) {
            refreshMethod = implClassModel.addMethod("refreshProperty");
            refreshMethod.setAccessModifier(AccessModifier.PROTECTED);
            refreshMethod.addParameter(new MethodParameterModel("property", ModelProperty.class, false));
            refreshMethod.addParameter(new MethodParameterModel("force", TypeReference.BOOLEAN_TYPE));
            refreshMethod.setData(DATA_HAS_CONTENTS, Boolean.FALSE);
            implClassModel.setData(DATA_REFRESH_METHOD, refreshMethod);
            Body rb = refreshMethod.getBody();
            rb.append("synchronized( root() )");
            rb.openBlock();
            rb.append("property = property.refine( this );");
            rb.appendEmptyLine();
        }
        return refreshMethod;
    }

    private static Body prepareRefreshMethodBlock(ClassModel implClassModel, PropertyFieldDeclaration propField) {
        boolean hasPriorContent;
        MethodModel refreshMethod = GenerateImplProcessor.getRefreshMethod(implClassModel, true);
        Body rb = refreshMethod.getBody();
        if (refreshMethod.getData(DATA_HAS_CONTENTS) == Boolean.TRUE) {
            hasPriorContent = true;
        } else {
            hasPriorContent = false;
            refreshMethod.setData(DATA_HAS_CONTENTS, Boolean.TRUE);
        }
        rb.append("#1if( property == #2 )", hasPriorContent ? "else " : "", propField.name);
        rb.openBlock();
        return rb;
    }

    private static MethodModel getDisposePropertiesMethod(ClassModel implClassModel, boolean createIfNecessary) {
        MethodModel disposePropertiesMethod = (MethodModel)implClassModel.getData(DATA_DISPOSE_PROPERTIES_METHOD);
        if (disposePropertiesMethod == null && createIfNecessary) {
            disposePropertiesMethod = implClassModel.addMethod("disposeProperties");
            disposePropertiesMethod.setAccessModifier(AccessModifier.PROTECTED);
            disposePropertiesMethod.setData(DATA_HAS_CONTENTS, Boolean.FALSE);
            implClassModel.setData(DATA_DISPOSE_PROPERTIES_METHOD, disposePropertiesMethod);
        }
        return disposePropertiesMethod;
    }

    private static Body prepareDisposePropertiesMethodBlock(ClassModel implClassModel) {
        MethodModel disposePropertiesMethod = GenerateImplProcessor.getDisposePropertiesMethod(implClassModel, true);
        Body db = disposePropertiesMethod.getBody();
        if (disposePropertiesMethod.getData(DATA_HAS_CONTENTS) == Boolean.TRUE) {
            db.appendEmptyLine();
        } else {
            disposePropertiesMethod.setData(DATA_HAS_CONTENTS, Boolean.TRUE);
        }
        return db;
    }

    private static TypeReference toTypeReference(TypeMirror typeMirror) {
        if (typeMirror instanceof VoidType) {
            return TypeReference.VOID_TYPE;
        }
        if (typeMirror instanceof PrimitiveType) {
            return TypeReference.PRIMITIVE_TYPES.get(((PrimitiveType)typeMirror).getKind());
        }
        if (typeMirror instanceof DeclaredType) {
            return new TypeReference(((DeclaredType)typeMirror).getDeclaration().getQualifiedName());
        }
        if (typeMirror instanceof ArrayType) {
            return GenerateImplProcessor.toTypeReference(((ArrayType)typeMirror).getComponentType()).array(1);
        }
        return new TypeReference(((TypeDeclaration)typeMirror).getQualifiedName());
    }

    private static String getQualifiedName(TypeDeclaration type) {
        StringBuilder qname = new StringBuilder();
        String pkg = type.getPackage().getQualifiedName();
        if (pkg.length() > 0) {
            qname.append(pkg);
            qname.append('.');
            qname.append(type.getQualifiedName().substring(pkg.length() + 1).replace('.', '$'));
        } else {
            qname.append(type.getQualifiedName().replace('.', '$'));
        }
        return qname.toString();
    }

    private static class AbortException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private AbortException() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PropertyFieldDeclaration {
        public String name;
        public String propertyName;
        public LinkedList<FieldDeclaration> declarations = new LinkedList();
        private String getterMethodName;
        private String setterMethodName;
        private String typedSetterMethodName;

        public boolean isElementProperty() {
            return GenerateImplProcessor.isInstanceOf(this.getType(), ElementProperty.class.getName());
        }

        public TypeMirror getType() {
            if (this.declarations.isEmpty()) {
                return null;
            }
            return this.declarations.getFirst().getType();
        }

        public InterfaceDeclaration getDeclaringType() {
            if (!this.declarations.isEmpty()) {
                TypeDeclaration declaringType = this.declarations.getFirst().getDeclaringType();
                if (declaringType instanceof InterfaceDeclaration) {
                    return (InterfaceDeclaration)declaringType;
                }
                if (declaringType instanceof InterfaceType) {
                    return ((InterfaceType)declaringType).getDeclaration();
                }
                throw new IllegalStateException();
            }
            return null;
        }

        public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            Annotation annotation = null;
            for (FieldDeclaration fd : this.declarations) {
                annotation = fd.getAnnotation(annotationType);
                if (annotation != null) break;
            }
            return (A)annotation;
        }

        public String getGetterMethodName() {
            return this.getterMethodName;
        }

        public void setGetterMethodName(String getterMethodName) {
            this.getterMethodName = getterMethodName;
        }

        public String getSetterMethodName() {
            return this.setterMethodName;
        }

        public void setSetterMethodName(String setterMethodName) {
            this.setterMethodName = setterMethodName;
        }

        public String getTypedSetterMethodName() {
            return this.typedSetterMethodName;
        }

        public void setTypedSetterMethodName(String typedSetterMethodName) {
            this.typedSetterMethodName = typedSetterMethodName;
        }

        public SourcePosition getSourcePosition() {
            return this.declarations.get(0).getPosition();
        }
    }

    private static final class Resources
    extends NLS {
        public static String unableToFindGetter;
        public static String unableToFindSetter;
        public static String unableToFindStringSetter;
        public static String unableToFindTypedSetter;

        static {
            Resources.initializeMessages((String)GenerateImplProcessor.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Visitor<T> {
        public void visit(T var1);
    }
}

