/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.gef.commands;

import org.eclipse.gef.commands.Command;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ModelElementList;
import org.eclipse.sapphire.ui.diagram.editor.DiagramConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramImplicitConnectionPart;
import org.eclipse.sapphire.ui.diagram.editor.DiagramNodePart;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramConnectionModel;
import org.eclipse.sapphire.ui.swt.gef.model.DiagramNodeModel;

public class ReconnectConnectionCommand
extends Command {
    private final DiagramConnectionModel connection;
    private final DiagramNodeModel oldSource;
    private final DiagramNodeModel oldTarget;
    private DiagramNodeModel newSource;
    private DiagramNodeModel newTarget;

    public ReconnectConnectionCommand(DiagramConnectionModel connection) {
        this.setLabel("connection creation");
        this.connection = connection;
        this.oldSource = connection.getSourceNode();
        this.oldTarget = connection.getTargetNode();
    }

    public boolean canExecute() {
        DiagramConnectionPart connectionPart = this.connection.getModelPart();
        if (connectionPart instanceof DiagramImplicitConnectionPart) {
            return false;
        }
        if (this.newSource != null) {
            return this.checkSourceReconnection();
        }
        if (this.newTarget != null) {
            return this.checkTargetReconnection();
        }
        return false;
    }

    private boolean checkSourceReconnection() {
        return !this.newSource.equals(this.oldTarget);
    }

    private boolean checkTargetReconnection() {
        return !this.newTarget.equals(this.oldSource);
    }

    public void execute() {
        DiagramConnectionPart connectionPart = this.connection.getModelPart();
        DiagramNodePart srcNode = this.newSource != null ? this.newSource.getModelPart() : this.oldSource.getModelPart();
        DiagramNodePart targetNode = this.newTarget != null ? this.newTarget.getModelPart() : this.oldTarget.getModelPart();
        DiagramConnectionPart newConnPart = connectionPart.getDiagramConnectionTemplate().createNewDiagramConnection(srcNode, targetNode);
        IModelElement oldConnElement = connectionPart.getLocalModelElement();
        newConnPart.getLocalModelElement().copy(oldConnElement);
        if (this.newSource != null) {
            newConnPart.resetEndpoint1(this.newSource.getModelPart());
        }
        if (this.newTarget != null) {
            newConnPart.resetEndpoint2(this.newTarget.getModelPart());
        }
        ModelElementList list = (ModelElementList)oldConnElement.parent();
        list.remove((Object)oldConnElement);
    }

    public void setNewTarget(DiagramNodeModel target) {
        if (target == null) {
            throw new IllegalArgumentException();
        }
        this.newTarget = target;
        this.newSource = null;
    }

    public void setNewSource(DiagramNodeModel source) {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        this.newSource = source;
        this.newTarget = null;
    }
}

