/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.IModelElement;
import org.eclipse.sapphire.modeling.ImageData;
import org.eclipse.sapphire.ui.ISapphirePart;
import org.eclipse.sapphire.ui.SapphireEditor;
import org.eclipse.sapphire.ui.SapphireEditorPagePart;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.SapphireRenderingContext;
import org.eclipse.sapphire.ui.renderers.swt.SwtRendererUtil;
import org.eclipse.sapphire.ui.swt.EditorPagePresentation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public abstract class SapphireEditorFormPage
extends FormPage
implements EditorPagePresentation {
    private final SapphireEditor editor;
    private final SapphireEditorPagePart part;
    private final Listener listener;

    public SapphireEditorFormPage(SapphireEditor editor, SapphireEditorPagePart editorPagePart) {
        super((FormEditor)editor, null, null);
        this.editor = editor;
        this.part = editorPagePart;
        this.listener = new Listener(){

            public void handle(Event event) {
                if (event instanceof SapphirePart.ImageChangedEvent) {
                    SapphireEditorFormPage.this.refreshImage();
                }
            }
        };
        this.part.attach(this.listener);
    }

    public final SapphireEditor getEditor() {
        return this.editor;
    }

    public SapphireEditorPagePart getPart() {
        return this.part;
    }

    public final IModelElement getModelElement() {
        return this.part.getModelElement();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.refreshImage();
    }

    private final void refreshImage() {
        if (this.getManagedForm() != null) {
            ImageData newImageData;
            ScrolledForm form = this.getManagedForm().getForm();
            Image oldImage = form.getImage();
            if (oldImage != null) {
                oldImage.dispose();
            }
            if ((newImageData = this.part.getPageHeaderImage()) == null) {
                form.setImage(null);
            } else {
                form.setImage(SwtRendererUtil.toImageDescriptor(newImageData).createImage());
            }
        }
    }

    public void dispose() {
        Image image;
        super.dispose();
        this.part.detach(this.listener);
        if (this.getManagedForm() != null && (image = this.getManagedForm().getForm().getImage()) != null) {
            image.dispose();
        }
    }

    public abstract String getId();

    protected static final class FormEditorRenderingContext
    extends SapphireRenderingContext {
        private final FormToolkit toolkit;

        public FormEditorRenderingContext(ISapphirePart part, IManagedForm managedForm) {
            this(part, managedForm.getForm().getBody(), managedForm.getToolkit());
        }

        public FormEditorRenderingContext(ISapphirePart part, Composite composite, FormToolkit toolkit) {
            super(part, composite);
            this.toolkit = toolkit;
        }

        public void adapt(Control control) {
            super.adapt(control);
            if (control instanceof Composite) {
                this.toolkit.adapt((Composite)control);
            } else if (control instanceof Label) {
                this.toolkit.adapt(control, false, false);
            } else {
                this.toolkit.adapt(control, true, true);
            }
        }
    }
}

