/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons;

import java.beans.IntrospectionException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.beans.FastBeanInfo;
import org.eclipse.scout.commons.beans.FastPropertyDescriptor;
import org.eclipse.scout.commons.beans.IPropertyFilter;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;

public final class BeanUtility {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(BeanUtility.class);
    private static final Object BEAN_INFO_CACHE_LOCK = new Object();
    private static final Map<CompositeObject, FastBeanInfo> BEAN_INFO_CACHE = new HashMap<CompositeObject, FastBeanInfo>();

    private BeanUtility() {
    }

    public static Map<String, Object> getProperties(Object from, Class<?> stopClazz, IPropertyFilter filter) throws ProcessingException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            FastPropertyDescriptor[] props = BeanUtility.getFastPropertyDescriptors(from.getClass(), stopClazz, filter);
            int i = 0;
            while (i < props.length) {
                FastPropertyDescriptor fromProp = props[i];
                Method readMethod = fromProp.getReadMethod();
                if (readMethod != null) {
                    Object value = readMethod.invoke(from, null);
                    map.put(fromProp.getName(), value);
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new ProcessingException("object: " + from, e);
        }
        return map;
    }

    public static void setProperties(Object to, Map<String, Object> map, boolean lenient, IPropertyFilter filter) throws ProcessingException {
        FastBeanInfo toInfo = BeanUtility.getFastBeanInfo(to.getClass(), null);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            try {
                Method writeMethod;
                FastPropertyDescriptor desc = toInfo.getPropertyDescriptor(name);
                if (desc == null || filter != null && !filter.accept(desc) || (writeMethod = desc.getWriteMethod()) == null) continue;
                writeMethod.invoke(to, TypeCastUtility.castValue(value, writeMethod.getParameterTypes()[0]));
            }
            catch (Exception e) {
                if (lenient) {
                    LOG.warn("property " + name + " with value " + value, e);
                    continue;
                }
                throw new ProcessingException("property " + name + " with value " + value, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FastBeanInfo getFastBeanInfo(Class<?> beanClass, Class<?> stopClass) {
        if (beanClass == null) {
            return new FastBeanInfo(beanClass, stopClass);
        }
        Object object = BEAN_INFO_CACHE_LOCK;
        synchronized (object) {
            CompositeObject key = new CompositeObject(beanClass, stopClass);
            FastBeanInfo info = BEAN_INFO_CACHE.get(key);
            if (info == null) {
                info = new FastBeanInfo(beanClass, stopClass);
                BEAN_INFO_CACHE.put(key, info);
            }
            return info;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearFastBeanInfoCache() {
        Object object = BEAN_INFO_CACHE_LOCK;
        synchronized (object) {
            BEAN_INFO_CACHE.clear();
        }
    }

    public static FastPropertyDescriptor[] getFastPropertyDescriptors(Class<?> clazz, Class<?> stopClazz, IPropertyFilter filter) throws IntrospectionException {
        FastBeanInfo info = BeanUtility.getFastBeanInfo(clazz, stopClazz);
        FastPropertyDescriptor[] a = info.getPropertyDescriptors();
        ArrayList<FastPropertyDescriptor> filteredProperties = new ArrayList<FastPropertyDescriptor>(a.length);
        int i = 0;
        while (i < a.length) {
            FastPropertyDescriptor pd = a[i];
            if (filter == null || filter.accept(pd)) {
                filteredProperties.add(pd);
            }
            ++i;
        }
        return filteredProperties.toArray(new FastPropertyDescriptor[filteredProperties.size()]);
    }
}

