/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;

public class ClassIdentifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Class<?>[] m_segments;

    public ClassIdentifier(Class<?> ... segments) throws IllegalArgumentException {
        if (segments == null || segments.length == 0) {
            throw new IllegalArgumentException("The given classes array must not be null or empty");
        }
        this.m_segments = segments;
    }

    public Class<?>[] getClasses() {
        return this.m_segments;
    }

    public Class<?> getLastSegment() {
        return this.m_segments[this.m_segments.length - 1];
    }

    public static ClassIdentifier[] convertClassArrayToClassIdentifierArray(Class<?> ... classes) {
        if (classes == null || classes.length == 0) {
            return new ClassIdentifier[0];
        }
        ArrayList<ClassIdentifier> result = new ArrayList<ClassIdentifier>();
        Class<?>[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> c = classArray[n2];
            if (c != null) {
                result.add(new ClassIdentifier(c));
            }
            ++n2;
        }
        return result.toArray(new ClassIdentifier[result.size()]);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.m_segments);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassIdentifier other = (ClassIdentifier)obj;
        return Arrays.equals(this.m_segments, other.m_segments);
    }
}

