/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import javax.swing.text.html.parser.ParserDelegator;
import javax.swing.tree.TreeNode;
import org.eclipse.scout.commons.CSSPatch;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.holders.IntegerHolder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;

public final class HTMLUtility {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(HTMLUtility.class);
    private static HashMap<String, CSS.Attribute> cssMap;

    static {
        CSSPatch.apply();
        cssMap = new HashMap();
        cssMap.put(CSS.Attribute.COLOR.toString(), CSS.Attribute.COLOR);
        cssMap.put(CSS.Attribute.BACKGROUND_COLOR.toString(), CSS.Attribute.BACKGROUND_COLOR);
        cssMap.put(CSS.Attribute.BORDER_COLOR.toString(), CSS.Attribute.BORDER_COLOR);
        cssMap.put(CSS.Attribute.FONT_SIZE.toString(), CSS.Attribute.FONT_SIZE);
        cssMap.put(CSS.Attribute.BACKGROUND_IMAGE.toString(), CSS.Attribute.BACKGROUND_IMAGE);
        cssMap.put(CSS.Attribute.LIST_STYLE_IMAGE.toString(), CSS.Attribute.LIST_STYLE_IMAGE);
    }

    private HTMLUtility() {
    }

    public static HTMLDocument toHtmlDocument(String htmlText) {
        Pattern[] metaPatterns;
        if (StringUtility.isNullOrEmpty(htmlText)) {
            return null;
        }
        HTMLEditorKit kit = new HTMLEditorKit();
        Pattern[] patternArray = metaPatterns = new Pattern[]{Pattern.compile("<meta\\s+[^>]*>"), Pattern.compile("<Meta\\s+[^>]*>"), Pattern.compile("<META\\s+[^>]*>"), Pattern.compile("</\\s*meta\\s*>"), Pattern.compile("</\\s*Meta\\s*>"), Pattern.compile("</\\s*META\\s*>")};
        int n = metaPatterns.length;
        int n2 = 0;
        while (n2 < n) {
            Pattern p = patternArray[n2];
            htmlText = p.matcher(htmlText).replaceAll("");
            ++n2;
        }
        htmlText = HTMLUtility.removeUnclosedStyleQuotes(htmlText, true);
        htmlText = HTMLUtility.removeUnclosedStyleQuotes(htmlText, false);
        htmlText = htmlText.replaceAll("/\\s+>", "/>");
        htmlText = htmlText.replaceAll("([^\\s])\\s+/>", "$1/>");
        if (System.getProperty("java.version", "1.5").substring(0, 3).compareTo("1.6") < 0) {
            htmlText = htmlText.replaceAll("/>", ">");
            htmlText = htmlText.replaceAll("</\\s*br\\s*>", "");
        }
        StyleSheet styleSheet = new StyleSheet();
        MutableHTMLDocument doc = new MutableHTMLDocument(styleSheet);
        try {
            doc.setParser(new ParserDelegator());
            doc.setTokenThreshold(100);
            doc.remove(0, doc.getLength());
            kit.read(new StringReader(htmlText), (Document)doc, 0);
        }
        catch (Exception e) {
            LOG.warn(null, e);
            return null;
        }
        return doc;
    }

    public static String toHtmlText(HTMLDocument doc) {
        String htmlText = "";
        if (doc == null) {
            return htmlText;
        }
        try {
            HTMLEditorKit kit = new HTMLEditorKit();
            StringWriter buf = new StringWriter();
            kit.write(buf, (Document)doc, 0, doc.getLength());
            htmlText = buf.toString();
        }
        catch (Throwable t) {
            LOG.error("failed to extract HTML text from HTML document", t);
        }
        return htmlText;
    }

    public static String cleanupHtml(String rawHtml, boolean ensureContentType, boolean cleanupCss, DefaultFont defaultFont) {
        rawHtml = StringUtility.nvl(rawHtml, "");
        try {
            HTMLDocument htmlDoc;
            Matcher matcherBodyEndTag;
            Matcher matcherBodyTag;
            Matcher matcherHeadEndTag;
            Matcher matcherHeadTag;
            Matcher matcherHtmlEndTag;
            Matcher matcherHtmlTag = HTMLUtility.createMatcherForTag(rawHtml, "html", false);
            if (!matcherHtmlTag.find()) {
                Matcher matcherFirstTag = Pattern.compile("<\\s*?[^!/][^>]*?>", 2).matcher(rawHtml);
                if (matcherFirstTag.find()) {
                    rawHtml = String.valueOf(rawHtml.substring(0, matcherFirstTag.start())) + "<html>" + rawHtml.substring(matcherFirstTag.start(), rawHtml.length());
                } else {
                    Matcher matcherComment = Pattern.compile("<\\![^>]+?>", 2).matcher(rawHtml);
                    int index = 0;
                    while (matcherComment.find()) {
                        index = matcherComment.end();
                    }
                    rawHtml = String.valueOf(rawHtml.substring(0, index)) + "<html>" + rawHtml.substring(index);
                }
            }
            if (!(matcherHtmlEndTag = HTMLUtility.createMatcherForTag(rawHtml, "html", true)).find()) {
                rawHtml = String.valueOf(rawHtml) + "</html>";
            }
            if (!(matcherHeadTag = HTMLUtility.createMatcherForTag(rawHtml, "head", false)).find()) {
                matcherHtmlTag = HTMLUtility.createMatcherForTag(rawHtml, "html", false);
                matcherHtmlTag.find();
                rawHtml = String.valueOf(rawHtml.substring(0, matcherHtmlTag.end())) + "<head>" + rawHtml.substring(matcherHtmlTag.end(), rawHtml.length());
            }
            if (!(matcherHeadEndTag = HTMLUtility.createMatcherForTag(rawHtml, "head", true)).find()) {
                matcherHeadTag = HTMLUtility.createMatcherForTag(rawHtml, "head", false);
                matcherHeadTag.find();
                rawHtml = String.valueOf(rawHtml.substring(0, matcherHeadTag.end())) + "</head>" + rawHtml.substring(matcherHeadTag.end(), rawHtml.length());
            }
            if (!cleanupCss && defaultFont != null) {
                rawHtml = HTMLUtility.ensureDefaultFont(rawHtml, defaultFont);
            }
            if (!(matcherBodyTag = HTMLUtility.createMatcherForTag(rawHtml, "body", false)).find()) {
                matcherHeadEndTag = HTMLUtility.createMatcherForTag(rawHtml, "head", true);
                matcherHeadEndTag.find();
                rawHtml = String.valueOf(rawHtml.substring(0, matcherHeadEndTag.end())) + "<body>" + rawHtml.substring(matcherHeadEndTag.end(), rawHtml.length());
            }
            if (!(matcherBodyEndTag = HTMLUtility.createMatcherForTag(rawHtml, "body", true)).find()) {
                matcherHtmlEndTag = HTMLUtility.createMatcherForTag(rawHtml, "html", true);
                matcherHtmlEndTag.find();
                rawHtml = String.valueOf(rawHtml.substring(0, matcherHtmlEndTag.start())) + "</body>" + rawHtml.substring(matcherHtmlEndTag.start(), rawHtml.length());
            }
            rawHtml = HTMLUtility.eliminateVerticalScrollbar(rawHtml);
            if (cleanupCss && (htmlDoc = HTMLUtility.toHtmlDocument(rawHtml)) != null) {
                htmlDoc = HTMLUtility.cleanupCss(htmlDoc, defaultFont);
                rawHtml = HTMLUtility.toHtmlText(htmlDoc);
            }
            if (ensureContentType) {
                rawHtml = HTMLUtility.addHtmlMetaElement("content-type", "text/html;charset=UTF-8", rawHtml);
            }
        }
        catch (Throwable t) {
            LOG.warn("failed to cleanup HTML document", t);
        }
        return rawHtml;
    }

    public static HTMLDocument cleanupCss(HTMLDocument htmlDoc, DefaultFont defaultFont) {
        if (htmlDoc == null) {
            return htmlDoc;
        }
        MutableHTMLDocument doc = (MutableHTMLDocument)htmlDoc;
        StyleSheet styleSheet = doc.getStyleSheet();
        Style style = styleSheet.getStyle("p");
        if (style == null) {
            style = styleSheet.addStyle("p", null);
            styleSheet.addCSSAttribute(style, CSS.Attribute.MARGIN_LEFT, "0");
            styleSheet.addCSSAttribute(style, CSS.Attribute.MARGIN_RIGHT, "0");
            styleSheet.addCSSAttribute(style, CSS.Attribute.MARGIN_TOP, "4");
            styleSheet.addCSSAttribute(style, CSS.Attribute.MARGIN_BOTTOM, "4");
            styleSheet.addCSSAttribute(style, CSS.Attribute.PADDING_LEFT, "0");
            styleSheet.addCSSAttribute(style, CSS.Attribute.PADDING_RIGHT, "0");
            styleSheet.addCSSAttribute(style, CSS.Attribute.PADDING_TOP, "0");
            styleSheet.addCSSAttribute(style, CSS.Attribute.PADDING_BOTTOM, "0");
        }
        if ((style = styleSheet.getStyle("a")) == null) {
            style = styleSheet.addStyle("a", null);
        }
        if (style.getAttribute(CSS.Attribute.COLOR) == null) {
            styleSheet.addCSSAttribute(style, CSS.Attribute.COLOR, "#3366cc");
        }
        if (style.getAttribute(CSS.Attribute.TEXT_DECORATION) == null) {
            styleSheet.addCSSAttribute(style, CSS.Attribute.TEXT_DECORATION, "underline");
        }
        if ((style = styleSheet.getStyle("body")) == null) {
            style = styleSheet.addStyle("body", null);
        }
        if (style.getAttribute(CSS.Attribute.MARGIN_TOP) == null) {
            styleSheet.addCSSAttribute(style, CSS.Attribute.MARGIN_TOP, "0");
        }
        if (style.getAttribute(CSS.Attribute.MARGIN_LEFT) == null) {
            styleSheet.addCSSAttribute(style, CSS.Attribute.MARGIN_LEFT, "0");
        }
        if (style.getAttribute(CSS.Attribute.MARGIN_BOTTOM) == null) {
            styleSheet.addCSSAttribute(style, CSS.Attribute.MARGIN_BOTTOM, "0");
        }
        if (style.getAttribute(CSS.Attribute.MARGIN_RIGHT) == null) {
            styleSheet.addCSSAttribute(style, CSS.Attribute.MARGIN_RIGHT, "0");
        }
        if (defaultFont != null) {
            HTMLUtility.setDefaultFont(styleSheet, "body", defaultFont);
            HTMLUtility.setDefaultFont(styleSheet, "p", defaultFont);
            HTMLUtility.setDefaultFont(styleSheet, "span", defaultFont);
            HTMLUtility.setDefaultFont(styleSheet, "th", defaultFont);
            HTMLUtility.setDefaultFont(styleSheet, "td", defaultFont);
        }
        Pattern fontSizeWithUnitPat = Pattern.compile("([0-9]+)([^0-9]+)");
        Pattern colorThreeDigitPat = Pattern.compile("#(.)(.)(.)");
        Enumeration<?> en = styleSheet.getStyleNames();
        while (en.hasMoreElements()) {
            String nm = (String)en.nextElement();
            style = styleSheet.getStyle(nm);
            Enumeration<?> en2 = style.getAttributeNames();
            while (en2.hasMoreElements()) {
                Matcher m;
                Object attKey = en2.nextElement();
                CSS.Attribute cssAtt = cssMap.get("" + attKey);
                String value = "" + style.getAttribute(attKey);
                if (cssAtt == null) continue;
                if (cssAtt == CSS.Attribute.FONT_SIZE) {
                    m = fontSizeWithUnitPat.matcher(value);
                    if (!m.matches()) continue;
                    value = m.group(1);
                    styleSheet.addCSSAttribute(style, cssAtt, value);
                    continue;
                }
                if (cssAtt != CSS.Attribute.COLOR && cssAtt != CSS.Attribute.BACKGROUND_COLOR && cssAtt != CSS.Attribute.BORDER_COLOR || !(m = colorThreeDigitPat.matcher(value)).matches()) continue;
                value = "#" + m.group(1) + m.group(1) + m.group(2) + m.group(2) + m.group(3) + m.group(3);
                styleSheet.addCSSAttribute(style, cssAtt, value);
            }
        }
        doc.writeLockEx();
        HTMLUtility.visitDocument(doc, new IDocumentVisitor(){

            @Override
            public void visitElement(Element elem) {
            }

            @Override
            public void visitAttribute(Element elem, AttributeSet atts, Object nm, Object value) {
                if ((nm == HTML.Attribute.FACE || nm == HTML.Attribute.SIZE || nm == CSS.Attribute.FONT_FAMILY || nm == CSS.Attribute.FONT_SIZE) && atts instanceof MutableAttributeSet) {
                    ((MutableAttributeSet)atts).removeAttribute(nm);
                }
            }
        });
        doc.writeUnlockEx();
        return htmlDoc;
    }

    public static HTMLDocument replaceContendIDs(HTMLDocument htmlDoc, final Map<String, URL> cidToUrlMapping) {
        if (htmlDoc == null) {
            return htmlDoc;
        }
        MutableHTMLDocument doc = (MutableHTMLDocument)htmlDoc;
        StyleSheet styleSheet = doc.getStyleSheet();
        final IntegerHolder changeCount = new IntegerHolder(0);
        Pattern cidPattern = Pattern.compile(".*url\\s*\\(\\s*cid:(.*)\\s*\\).*");
        Enumeration<?> en = styleSheet.getStyleNames();
        while (en.hasMoreElements()) {
            String nm = (String)en.nextElement();
            Style style = styleSheet.getStyle(nm);
            Enumeration<?> en2 = style.getAttributeNames();
            while (en2.hasMoreElements()) {
                String cid;
                URL url;
                Matcher m;
                Object attKey = en2.nextElement();
                CSS.Attribute cssAtt = cssMap.get("" + attKey);
                String value = "" + style.getAttribute(attKey);
                if (cssAtt == null || value.equals("null") || value.length() <= 0 || !(m = cidPattern.matcher(value)).matches() || (url = cidToUrlMapping.get(cid = m.group(1))) == null) continue;
                styleSheet.addCSSAttribute(style, cssAtt, "url(" + url.toExternalForm() + ")");
                changeCount.setValue((Integer)changeCount.getValue() + 1);
            }
        }
        doc.writeLockEx();
        HTMLUtility.visitDocument(doc, new IDocumentVisitor(){

            @Override
            public void visitElement(Element elem) {
            }

            @Override
            public void visitAttribute(Element elem, AttributeSet atts, Object nm, Object value) {
                String cid;
                URL url;
                String src;
                if ((nm == HTML.Attribute.SRC || nm == HTML.Attribute.HREF) && (src = "" + value).startsWith("cid:") && (url = (URL)cidToUrlMapping.get(cid = src.substring(4))) != null && atts instanceof MutableAttributeSet) {
                    ((MutableAttributeSet)atts).addAttribute(nm, url.toExternalForm());
                    changeCount.setValue((Integer)changeCount.getValue() + 1);
                }
            }
        });
        doc.writeUnlockEx();
        return htmlDoc;
    }

    public static HTMLDocument copyReferencedFilesToCache(HTMLDocument htmlDoc, final File cacheDir) {
        if (htmlDoc == null) {
            return htmlDoc;
        }
        MutableHTMLDocument doc = (MutableHTMLDocument)htmlDoc;
        final IntegerHolder changeCount = new IntegerHolder(0);
        doc.writeLockEx();
        HTMLUtility.visitDocument(doc, new IDocumentVisitor(){

            @Override
            public void visitElement(Element elem) {
            }

            @Override
            public void visitAttribute(Element elem, AttributeSet atts, Object nm, Object value) {
                if (nm == HTML.Attribute.SRC || nm == HTML.Attribute.HREF) {
                    String src = "" + value;
                    try {
                        URL url = new URL(src);
                        File f = new File(url.getFile());
                        if (f.exists() && !f.getParentFile().getAbsolutePath().equalsIgnoreCase(cacheDir.getAbsolutePath())) {
                            File cacheFile = new File(cacheDir, f.getName());
                            if (cacheFile.exists() && cacheFile.length() != f.length()) {
                                IOUtility.writeContent(new FileOutputStream(cacheFile), IOUtility.getContent(new FileInputStream(f)));
                            }
                            if (atts instanceof MutableAttributeSet) {
                                ((MutableAttributeSet)atts).addAttribute(nm, f.getName());
                                changeCount.setValue((Integer)changeCount.getValue() + 1);
                            }
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                    }
                    catch (Exception e) {
                        LOG.warn(null, e);
                    }
                }
            }
        });
        doc.writeUnlockEx();
        return htmlDoc;
    }

    public static String getPlainText(HTMLDocument htmlDoc) {
        if (htmlDoc == null) {
            return "";
        }
        try {
            return htmlDoc.getText(0, htmlDoc.getLength());
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    public static String getPlainText(String s) {
        if ((s = StringUtility.getTag(s, "body")) == null || s.length() == 0) {
            return s;
        }
        s = s.replaceAll("\n", " ");
        s = s.replaceAll("<br>|<br/>|</p>|<p/>|</tr>|</table>", "\n");
        s = Pattern.compile("<[^>]+>", 32).matcher(s).replaceAll(" ");
        s = s.replaceAll("[ ]+", " ");
        s = StringUtility.htmlDecode(s);
        s = s.trim();
        return s;
    }

    public static String encodeText(String s) {
        return StringUtility.htmlEncode(s, true);
    }

    public static String decodeText(String s) {
        return StringUtility.htmlDecode(s);
    }

    private static void visitDocument(HTMLDocument doc, IDocumentVisitor v) {
        HTMLUtility.visitElementRec(doc.getDefaultRootElement(), v);
    }

    private static void visitElementRec(Element elem, IDocumentVisitor v) {
        v.visitElement(elem);
        HTMLUtility.visitAttributeRec(elem, elem.getAttributes(), v);
        if (elem instanceof AbstractDocument.AbstractElement) {
            Enumeration<TreeNode> en = ((AbstractDocument.AbstractElement)elem).children();
            while (en != null && en.hasMoreElements()) {
                HTMLUtility.visitElementRec((Element)((Object)en.nextElement()), v);
            }
        }
    }

    private static void visitAttributeRec(Element elem, AttributeSet atts, IDocumentVisitor v) {
        Enumeration<?> en = atts.getAttributeNames();
        while (en.hasMoreElements()) {
            Object nm = en.nextElement();
            Object value = atts.getAttribute(nm);
            if (value instanceof AttributeSet) {
                HTMLUtility.visitAttributeRec(elem, (AttributeSet)value, v);
                continue;
            }
            v.visitAttribute(elem, atts, nm, value);
        }
    }

    private static void setDefaultFont(StyleSheet styleSheet, String styleName, DefaultFont defaultFont) {
        if (defaultFont == null) {
            return;
        }
        Style style = styleSheet.getStyle(styleName);
        if (style == null) {
            style = styleSheet.addStyle(styleName, null);
        }
        String family = defaultFont.getFamiliesConcatenated();
        if (style.getAttribute(CSS.Attribute.FONT_FAMILY) == null && family != null) {
            styleSheet.addCSSAttribute(style, CSS.Attribute.FONT_FAMILY, family);
        }
        if (style.getAttribute(CSS.Attribute.FONT_SIZE) == null && defaultFont.getSize() > 0 && defaultFont.getSizeUnit() != null) {
            styleSheet.addCSSAttribute(style, CSS.Attribute.FONT_SIZE, String.valueOf(defaultFont.getSize()) + defaultFont.getSizeUnit());
        }
    }

    private static String addHtmlMetaElement(String httpEquiv, String content, String rawHtml) {
        Matcher matcherHeadTag;
        if (StringUtility.isNullOrEmpty(rawHtml)) {
            return rawHtml;
        }
        String metaTagContentType = "<meta http-equiv=\"" + httpEquiv + "\" content=\"" + content + "\"/>";
        rawHtml = Pattern.compile("(<meta\\s*http-equiv=\"" + httpEquiv + "\"\\s*content=\"[^\"]+\"\\s*/>)", 2).matcher(rawHtml).replaceFirst(metaTagContentType);
        if (StringUtility.find(rawHtml, metaTagContentType) == -1 && (matcherHeadTag = HTMLUtility.createMatcherForTag(rawHtml, "head", false)).find()) {
            rawHtml = String.valueOf(rawHtml.substring(0, matcherHeadTag.end())) + metaTagContentType + rawHtml.substring(matcherHeadTag.end(), rawHtml.length());
        }
        return rawHtml;
    }

    private static String removeUnclosedStyleQuotes(String rawHtml, boolean singleStyleQuote) {
        char innerQuoteChar;
        char styleQuoteChar;
        if (singleStyleQuote) {
            styleQuoteChar = '\'';
            innerQuoteChar = '\"';
        } else {
            styleQuoteChar = '\"';
            innerQuoteChar = '\'';
        }
        String regex = "(<[^>]+?style[\\s]*=[\\s]*" + styleQuoteChar + ")([^" + styleQuoteChar + ">]*?" + innerQuoteChar + "[^" + styleQuoteChar + ">]*?)(" + styleQuoteChar + "[^>]*?>)";
        Pattern pattern = Pattern.compile(regex, 34);
        Matcher matcher = pattern.matcher(rawHtml);
        while (matcher.find()) {
            String preStyleContent = matcher.group(1);
            String styleContent = matcher.group(2);
            String postStyleContent = matcher.group(3);
            int numOfTokens = ("prefix" + styleContent + "suffix").split(String.valueOf(innerQuoteChar)).length;
            if (numOfTokens % 2 != 0) continue;
            styleContent = styleContent.replaceAll(String.valueOf(innerQuoteChar), "");
            rawHtml = matcher.replaceAll(String.valueOf(preStyleContent) + styleContent + postStyleContent);
        }
        return rawHtml;
    }

    private static Matcher createMatcherForTag(String rawHtml, String tag, boolean endTag) {
        String regex = "<\\s*" + (endTag ? "\\/" : "") + "\\s*" + tag + ".*?>";
        return Pattern.compile(regex, 34).matcher(rawHtml);
    }

    private static String eliminateVerticalScrollbar(String rawHtml) {
        try {
            Matcher matcherBodyTag = HTMLUtility.createMatcherForTag(rawHtml, "body", false);
            if (!matcherBodyTag.find()) {
                return rawHtml;
            }
            String contentBodyTag = matcherBodyTag.group();
            Pattern pattern = Pattern.compile("style[\\s]*=[\\s]*([\"'])", 34);
            Matcher matcherStyleTag = pattern.matcher(contentBodyTag);
            if (matcherStyleTag.find()) {
                String styleQuoteChar = matcherStyleTag.group(1);
                pattern = Pattern.compile("(.+?style[\\s]*=[\\s]*" + styleQuoteChar + ")([^" + styleQuoteChar + ">]*?)(" + styleQuoteChar + ".*)", 34);
                matcherStyleTag = pattern.matcher(contentBodyTag);
                matcherStyleTag.find();
                String preStyleContent = matcherStyleTag.group(1);
                String styleContent = matcherStyleTag.group(2);
                String postStyleContent = matcherStyleTag.group(3);
                if (!styleContent.toLowerCase().contains("overflow")) {
                    if (styleContent.trim().length() > 0 && !styleContent.endsWith(";")) {
                        styleContent = String.valueOf(styleContent) + ";";
                    }
                    styleContent = String.valueOf(styleContent) + "overflow:auto;";
                    rawHtml = matcherBodyTag.replaceFirst(String.valueOf(preStyleContent) + styleContent + postStyleContent);
                }
            } else {
                int endBracket = contentBodyTag.lastIndexOf(">");
                contentBodyTag = String.valueOf(contentBodyTag.substring(0, endBracket)) + " style=\"overflow:auto;\">";
                rawHtml = matcherBodyTag.replaceAll(contentBodyTag);
            }
        }
        catch (Throwable e) {
            LOG.warn("failed to eliminate vertical scrollbar", e);
        }
        return rawHtml;
    }

    private static String ensureDefaultFont(String rawHtml, DefaultFont defaultFont) {
        String[] tags;
        if (defaultFont == null || rawHtml == null) {
            return rawHtml;
        }
        Matcher matcherStyleTag = HTMLUtility.createMatcherForTag(rawHtml, "style", false);
        if (matcherStyleTag.find()) {
            String styleTag = matcherStyleTag.group();
            if (!StringUtility.contains(styleTag, "type\\s*=\\s*['\"]text/css['\"]")) {
                rawHtml = matcherStyleTag.replaceFirst("<style type=\"text/css\">");
            }
        } else {
            Matcher matcherHeadTag = HTMLUtility.createMatcherForTag(rawHtml, "head", false);
            matcherHeadTag.find();
            rawHtml = String.valueOf(rawHtml.substring(0, matcherHeadTag.end())) + "<style type=\"text/css\"></style>" + rawHtml.substring(matcherHeadTag.end());
        }
        matcherStyleTag = HTMLUtility.createMatcherForTag(rawHtml, "style", false);
        matcherStyleTag.find();
        Matcher matcherStyleEndTag = HTMLUtility.createMatcherForTag(rawHtml, "style", true);
        if (!matcherStyleEndTag.find()) {
            LOG.warn("No closing </style> tag found");
            return rawHtml;
        }
        String[] stringArray = tags = new String[]{"body", "table", "tr", "th", "td", "span", "p"};
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            rawHtml = HTMLUtility.ensureDefaultFontForHtmlTag(rawHtml, defaultFont, tag);
            ++n2;
        }
        return rawHtml;
    }

    private static String ensureDefaultFontForHtmlTag(String rawHtml, DefaultFont defaultFont, String htmlTag) {
        int fontSize;
        if (StringUtility.isNullOrEmpty(rawHtml) || StringUtility.isNullOrEmpty(htmlTag) || defaultFont == null) {
            return rawHtml;
        }
        Matcher matcherStyleTag = HTMLUtility.createMatcherForTag(rawHtml, "style", false);
        if (!matcherStyleTag.find()) {
            return rawHtml;
        }
        Matcher matcherStyleEndTag = HTMLUtility.createMatcherForTag(rawHtml, "style", true);
        if (!matcherStyleEndTag.find()) {
            return rawHtml;
        }
        String styleContent = rawHtml.substring(matcherStyleTag.end(), matcherStyleEndTag.start());
        Pattern patternTagStyle = Pattern.compile("(.*?" + htmlTag + "[^\\{]*?\\s*\\{)\\s*([^\\}]*?)\\s*(\\}.*)", 42);
        Matcher matcherTagStyle = patternTagStyle.matcher(styleContent);
        if (!matcherTagStyle.find()) {
            styleContent = StringUtility.join("", styleContent, String.valueOf(htmlTag) + "{}");
        }
        matcherTagStyle = patternTagStyle.matcher(styleContent);
        matcherTagStyle.find();
        String preTagStyleContent = matcherTagStyle.group(1);
        String tagStyleContent = StringUtility.trim(StringUtility.nvl(matcherTagStyle.group(2), ""));
        String postTagStyleContent = matcherTagStyle.group(3);
        if (tagStyleContent.contains("font:")) {
            return rawHtml;
        }
        String fontFamily = defaultFont.getFamiliesConcatenated();
        if (fontFamily != null && !StringUtility.contains(tagStyleContent, "font-family")) {
            if (StringUtility.hasText(tagStyleContent) && !tagStyleContent.endsWith(";")) {
                tagStyleContent = String.valueOf(tagStyleContent) + ";";
            }
            tagStyleContent = String.valueOf(tagStyleContent) + "font-family:" + defaultFont.getFamiliesConcatenated() + ";";
        }
        if ((fontSize = defaultFont.getSize()) > 0 && !StringUtility.contains(tagStyleContent, "font-size")) {
            if (StringUtility.hasText(tagStyleContent) && !tagStyleContent.endsWith(";")) {
                tagStyleContent = String.valueOf(tagStyleContent) + ";";
            }
            tagStyleContent = String.valueOf(tagStyleContent) + "font-size:" + StringUtility.join("", String.valueOf(defaultFont.getSize()), defaultFont.getSizeUnit()) + ";";
        }
        if (!StringUtility.contains(tagStyleContent, "[\\s;]color:")) {
            if (StringUtility.hasText(tagStyleContent) && !tagStyleContent.endsWith(";")) {
                tagStyleContent = String.valueOf(tagStyleContent) + ";";
            }
            String fgHex = Integer.toHexString(defaultFont.getForegroundColor());
            tagStyleContent = String.valueOf(tagStyleContent) + "color:#" + StringUtility.lpad(fgHex, "0", 6) + ";";
        }
        styleContent = String.valueOf(preTagStyleContent) + tagStyleContent + postTagStyleContent;
        matcherStyleTag = HTMLUtility.createMatcherForTag(rawHtml, "style", false);
        matcherStyleTag.find();
        matcherStyleEndTag = HTMLUtility.createMatcherForTag(rawHtml, "style", true);
        matcherStyleEndTag.find();
        return String.valueOf(rawHtml.substring(0, matcherStyleTag.end())) + styleContent + rawHtml.substring(matcherStyleEndTag.start());
    }

    public static class DefaultFont {
        private String[] m_families = new String[]{"sans-serif"};
        private int m_size = 12;
        private String m_sizeUnit = "pt";
        private int m_foregroundColor = 0;

        public String[] getFamilies() {
            if (this.m_families == null) {
                return new String[0];
            }
            return this.m_families;
        }

        public void setFamilies(String[] families) {
            this.m_families = families;
        }

        public String getFamiliesConcatenated() {
            String familyString = null;
            String[] stringArray = this.getFamilies();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String familiy = stringArray[n2];
                if (StringUtility.hasText(familiy)) {
                    if (familiy.matches(".*\\s.*")) {
                        familiy = "'" + familiy + "'";
                    }
                    familyString = StringUtility.join(",", familyString, familiy);
                }
                ++n2;
            }
            return familyString;
        }

        public int getSize() {
            return this.m_size;
        }

        public void setSize(int size) {
            this.m_size = size;
        }

        public String getSizeUnit() {
            return this.m_sizeUnit;
        }

        public void setSizeUnit(String sizeUnit) {
            this.m_sizeUnit = sizeUnit;
        }

        public int getForegroundColor() {
            return this.m_foregroundColor;
        }

        public void setForegroundColor(int foregroundColor) {
            this.m_foregroundColor = foregroundColor;
        }
    }

    private static interface IDocumentVisitor {
        public void visitElement(Element var1);

        public void visitAttribute(Element var1, AttributeSet var2, Object var3, Object var4);
    }

    private static class MutableHTMLDocument
    extends HTMLDocument {
        private static final long serialVersionUID = 1L;

        public MutableHTMLDocument() {
        }

        public MutableHTMLDocument(StyleSheet styles) {
            super(styles);
        }

        public MutableHTMLDocument(AbstractDocument.Content c, StyleSheet styles) {
            super(c, styles);
        }

        public void writeLockEx() {
            this.writeLock();
        }

        public void writeUnlockEx() {
            this.writeUnlock();
        }
    }
}

