/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.eventlistprofiler;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.scout.commons.eventlistprofiler.IEventListenerSnapshot;

public class EventListenerSnapshot
implements IEventListenerSnapshot {
    private HashMap<String, List<Object>> m_map = new HashMap();

    @Override
    public void add(Class<?> listenerType, String context, Object listener) {
        List<Object> list;
        if (listener == null) {
            return;
        }
        String key = listenerType.getName();
        if (context != null) {
            key = String.valueOf(key) + "#" + context;
        }
        if ((list = this.m_map.get(key)) == null) {
            list = new ArrayList<Object>();
            this.m_map.put(key, list);
        }
        list.add(listener);
    }

    public void dump(PrintWriter out) {
        out.println("DUMP AT " + new Date());
        for (Map.Entry<String, List<Object>> e : this.m_map.entrySet()) {
            String key = e.getKey();
            List<Object> list = e.getValue();
            out.println("TYPE " + key + " " + list.size());
            TreeMap<String, Integer> types = new TreeMap<String, Integer>();
            for (Object object : list) {
                String c = object.getClass().getName();
                Integer i = (Integer)types.get(c);
                if (i == null) {
                    i = 0;
                }
                types.put(c, i + 1);
            }
            for (Map.Entry entry : types.entrySet()) {
                out.println("  " + (String)entry.getKey() + ": " + entry.getValue());
            }
        }
        out.println();
    }
}

