/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons.xmlparser;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.xmlparser.ScoutXmlException;
import org.eclipse.scout.commons.xmlparser.ScoutXmlParser;
import org.eclipse.scout.commons.xmlparser.ScoutXmlQName;
import org.xml.sax.Attributes;

public class ScoutXmlDocument {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ScoutXmlDocument.class);
    private static final boolean DEFAULT_ACCEPT_REGEX_QUERIES = false;
    private static final boolean DEFAULT_IGNORE_INDENT_WHITESPACE = false;
    private static final boolean DEFAULT_IGNORE_QUERY_CASE = false;
    private static final String DEFAULT_INDENT = "  ";
    private static final boolean DEFAULT_PRETTY_PRINT = true;
    private static final boolean DEFAULT_STRICTLY_CHECKING = true;
    private static final String DEFAULT_XML_ENCODING = "UTF-8";
    private static final String DEFAULT_XML_VERSION = "1.0";
    private static final int INITIAL_ATTRIBUTE_LIST_SIZE = 5;
    private static final int INITIAL_CONTENT_LIST_SIZE = 10;
    private static final int INITIAL_NAMESPACE_MAP_SIZE = 5;
    public static final Hashtable<String, String> XML_ENTITIES = new Hashtable();
    private P_Registry m_nameRegistry = new P_Registry();
    private P_Registry m_textRegistry = new P_Registry();
    private P_Registry m_attvRegistry = new P_Registry();
    private boolean m_acceptRegExQueries;
    private boolean m_ignoreQueryCase;
    private boolean m_ignoreIndentWhitespace;
    private String m_indent;
    private String m_externalDtdPublicId;
    private String m_externalDtdLocation;
    private boolean m_prettyPrint;
    private ScoutXmlElement m_root;
    private boolean m_strictlyChecking;
    private String m_xmlEncoding;
    private String m_xmlVersion;

    static {
        XML_ENTITIES.put("&", "&amp;");
        XML_ENTITIES.put("\"", "&quot;");
        XML_ENTITIES.put("'", "&apos;");
        XML_ENTITIES.put("<", "&lt;");
        XML_ENTITIES.put(">", "&gt;");
    }

    public ScoutXmlDocument() {
        this.setAcceptRegExQueries(false);
        this.setIgnoreIndentWhitespace(false);
        this.setIgnoreQueryCase(false);
        this.setIndent(DEFAULT_INDENT);
        this.setPrettyPrint(true);
        this.setStrictlyChecking(true);
        this.setXmlEncoding(DEFAULT_XML_ENCODING);
        this.setXmlVersion(DEFAULT_XML_VERSION);
        this.setExternalDTD(null, null);
    }

    public ScoutXmlDocument(File file) {
        this();
        try {
            new ScoutXmlParser(this).parse(file);
        }
        catch (Exception exception) {
            LOG.error("Could not parse the given file.", exception);
        }
    }

    public ScoutXmlDocument(InputStream stream) {
        this();
        try {
            new ScoutXmlParser(this).parse(stream);
        }
        catch (Exception exception) {
            LOG.error("Could not parse the given stream.", exception);
        }
    }

    public ScoutXmlDocument(InputStream stream, String systemID) {
        this();
        try {
            new ScoutXmlParser(this).parse(stream, systemID);
        }
        catch (Exception exception) {
            LOG.error("Could not parse the given stream.", exception);
        }
    }

    public ScoutXmlDocument(ScoutXmlElement root) {
        this();
        this.setRoot(root);
    }

    public ScoutXmlDocument(String source) {
        this();
        try {
            new ScoutXmlParser(this).parse(source);
        }
        catch (Exception exception) {
            LOG.error("Could not parse the given source.", exception);
        }
    }

    public ScoutXmlDocument(String source, String systemID) {
        this();
        try {
            new ScoutXmlParser(this).parse(source, systemID);
        }
        catch (Exception exception) {
            LOG.error("Could not parse the given file.", exception);
        }
    }

    public ScoutXmlDocument(URL url) {
        this();
        try {
            new ScoutXmlParser(this).parse(url);
        }
        catch (Exception exception) {
            LOG.error("Could not parse the given file.", exception);
        }
    }

    public boolean equalsSemantically(Object object) {
        if (object == null) {
            return false;
        }
        try {
            boolean oldSetting = this.isPrettyPrint();
            this.setPrettyPrint(false);
            String string = this.getRoot().toString();
            this.setPrettyPrint(oldSetting);
            if (object instanceof ScoutXmlDocument) {
                oldSetting = ((ScoutXmlDocument)object).isPrettyPrint();
                ((ScoutXmlDocument)object).setPrettyPrint(false);
                boolean result = string.equals(((ScoutXmlDocument)object).getRoot().toString());
                ((ScoutXmlDocument)object).setPrettyPrint(oldSetting);
                return result;
            }
            if (object instanceof String) {
                return string.equals(object);
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public ScoutXmlElement getChild(String name) {
        String n = null;
        n = this.getRoot().getNameExpanded();
        if (name.startsWith(n)) {
            if (name.equals(n)) {
                return this.getRoot();
            }
            return this.getRoot().getChild(name.replaceFirst(n, ""));
        }
        n = this.getRoot().getNamePrefixed();
        if (name.startsWith(n)) {
            if (name.equals(n)) {
                return this.getRoot();
            }
            return this.getRoot().getChild(name.replaceFirst(n, ""));
        }
        return null;
    }

    public String getExternalDtdLocation() {
        return this.m_externalDtdLocation;
    }

    public String getExternalDtdPublicId() {
        return this.m_externalDtdLocation;
    }

    public String getIndent() {
        return this.m_indent;
    }

    public ScoutXmlElement getRoot() {
        return this.m_root;
    }

    public String getXmlEncoding() {
        return this.m_xmlEncoding;
    }

    public String getXmlVersion() {
        return this.m_xmlVersion;
    }

    public boolean hasExternalDTD() {
        return this.m_externalDtdLocation != null;
    }

    public boolean hasRoot() {
        return this.m_root != null;
    }

    public boolean isAcceptRegExQueries() {
        return this.m_acceptRegExQueries;
    }

    public boolean isEmpty() {
        return this.m_root == null && this.m_externalDtdLocation == null && this.m_externalDtdPublicId == null;
    }

    public boolean isIgnoreIndentWhitespace() {
        return this.m_ignoreIndentWhitespace;
    }

    public boolean isIgnoreQueryCase() {
        return this.m_ignoreQueryCase;
    }

    public boolean isPrettyPrint() {
        return this.m_prettyPrint;
    }

    public boolean isStrictlyChecking() {
        return this.m_strictlyChecking;
    }

    public void setAcceptRegExQueries(boolean acceptRegEx) {
        this.m_acceptRegExQueries = acceptRegEx;
    }

    public void setExternalDTD(String publicID, String dtdLocation) {
        this.m_externalDtdPublicId = publicID;
        this.m_externalDtdLocation = dtdLocation;
    }

    public void setIgnoreIndentWhitespace(boolean indentWhitespace) {
        this.m_ignoreIndentWhitespace = indentWhitespace;
    }

    public void setIgnoreQueryCase(boolean ignoreCase) {
        this.m_ignoreQueryCase = ignoreCase;
    }

    public void setIndent(String indent) {
        this.m_indent = indent;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.m_prettyPrint = prettyPrint;
        if (prettyPrint) {
            this.setIndent(DEFAULT_INDENT);
        } else {
            this.setIndent("");
        }
    }

    public void setRoot(ScoutXmlElement root) {
        if (root.getDocument().equals(this)) {
            this.m_root = root;
        } else {
            this.m_root = null;
            try {
                new ScoutXmlParser(this).parse(root.toString());
            }
            catch (Exception exception) {}
        }
    }

    public ScoutXmlElement setRoot(String name) {
        this.m_root = new ScoutXmlElement(name);
        return this.m_root;
    }

    public void setStrictlyChecking(boolean strictlyChecking) {
        this.m_strictlyChecking = strictlyChecking;
    }

    public void setXmlEncoding(String encoding) {
        this.m_xmlEncoding = encoding;
    }

    public void setXmlVersion(String xmlVersion) {
        this.m_xmlVersion = xmlVersion;
    }

    public ArrayList[] toData() {
        ArrayList[] data = null;
        ScoutXmlElement rowElement = null;
        ScoutXmlElement colElement = null;
        try {
            int noRows = this.getChild("ArrayList").countChildren();
            data = new ArrayList[noRows];
            int rowNr = 0;
            while (rowNr < noRows) {
                rowElement = this.getChild("ArrayList").getChild(rowNr);
                data[rowNr] = new ArrayList(rowElement.countChildren());
                int colNr = 0;
                while (colNr < rowElement.countChildren()) {
                    colElement = this.getChild("ArrayList").getChild(rowNr).getChild(colNr);
                    data[rowNr].add(Class.forName(colElement.getAttribute("type")).getConstructor(String.class).newInstance(colElement.getText()));
                    ++colNr;
                }
                ++rowNr;
            }
        }
        catch (Exception exception) {
            LOG.error("Could not create ArrayList[].", exception);
        }
        return data;
    }

    public String toString() {
        try {
            StringWriter writer = new StringWriter();
            this.write(writer);
            writer.close();
            return writer.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public File write(File file) throws IOException {
        this.write(new FileOutputStream(file));
        return file;
    }

    public void write(OutputStream stream) throws IOException {
        this.write(new BufferedWriter(new OutputStreamWriter(stream, this.m_xmlEncoding)));
    }

    private void write(Writer writer) throws IOException {
        BufferedWriter bufferedWriter = null;
        bufferedWriter = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
        bufferedWriter.write("<?xml version=\"" + this.m_xmlVersion + "\" encoding=\"" + this.m_xmlEncoding + "\"?>");
        if (this.isPrettyPrint()) {
            bufferedWriter.newLine();
        }
        if (this.m_root != null) {
            if (this.m_externalDtdLocation != null) {
                bufferedWriter.write("<!DOCTYPE");
                bufferedWriter.write(32);
                bufferedWriter.write(this.m_root.getNamePrefixed());
                bufferedWriter.write(32);
                if (this.m_externalDtdPublicId == null) {
                    bufferedWriter.write("SYSTEM \"" + this.m_externalDtdLocation);
                } else {
                    bufferedWriter.write("PUBLIC \"" + this.m_externalDtdPublicId + "\" \"" + this.m_externalDtdLocation);
                }
                bufferedWriter.write("\">");
                if (this.isPrettyPrint()) {
                    bufferedWriter.newLine();
                }
            }
            this.m_root.write(bufferedWriter);
        }
        bufferedWriter.flush();
    }

    private abstract class P_AbstractNode {
        protected int m_nameID;

        private P_AbstractNode() {
        }

        public abstract ScoutXmlQName getName();

        public String getNameExpanded() {
            return this.getName().getExpandedForm();
        }

        public String getNamePrefixed() {
            return ScoutXmlDocument.this.m_nameRegistry.getValueAsString(this.m_nameID);
        }

        public abstract String getNamespace(String var1);

        public void setName(String name) {
            if (ScoutXmlDocument.this.isStrictlyChecking() && ScoutXmlQName.isPrefixed(name) && this.getNamespace(ScoutXmlQName.extractPrefix(name)) == null) {
                throw new ScoutXmlException("Unbound prefix: " + ScoutXmlQName.extractPrefix(name));
            }
            this.m_nameID = ScoutXmlDocument.this.m_nameRegistry.getID(name, true);
        }

        public abstract void write(Writer var1) throws IOException;
    }

    private abstract class P_AbstractNodeVisitor {
        private int m_mode = 0;
        private String m_stringToCompare;

        protected P_AbstractNodeVisitor(String name) {
            if (name.matches("(\\*)|(\\{\\*\\}\\*)|(\\*:\\*)")) {
                this.m_mode = 0;
                this.m_stringToCompare = null;
            } else if (name.matches("(\\{\\*\\}.*)|(\\*:.*)")) {
                this.m_mode = 1;
                this.m_stringToCompare = ScoutXmlQName.extractLocalName(name);
            } else if (name.matches("\\{.*\\}\\*")) {
                this.m_mode = 2;
                this.m_stringToCompare = ScoutXmlQName.extractNamespace(name);
            } else if (name.matches(".*:\\*")) {
                this.m_mode = 3;
                this.m_stringToCompare = ScoutXmlQName.extractPrefix(name);
            } else if (name.matches("\\{.*\\}.*")) {
                this.m_mode = 4;
                this.m_stringToCompare = name.replaceAll("\\{\\}", "");
            } else {
                this.m_mode = 5;
                this.m_stringToCompare = name;
            }
        }

        protected void visit(P_AbstractNode node) {
            String string = "";
            switch (this.m_mode) {
                case 0: {
                    this.nameMatched(node);
                    return;
                }
                case 1: {
                    string = node.getName().getLocalName();
                    break;
                }
                case 2: {
                    string = node.getName().getNamespace();
                    break;
                }
                case 3: {
                    string = node.getName().getPrefix();
                    break;
                }
                case 4: {
                    string = node.getNameExpanded();
                    break;
                }
                case 5: {
                    string = node.getNamePrefixed();
                }
            }
            if (ScoutXmlDocument.this.isAcceptRegExQueries()) {
                string = string.replace('{', ' ').replace('}', ' ');
                String stringToCompare = this.m_stringToCompare.replace('{', ' ').replace('}', ' ');
                if (ScoutXmlDocument.this.m_ignoreQueryCase) {
                    string = string.toUpperCase();
                    stringToCompare = stringToCompare.toUpperCase();
                }
                if (string.matches(stringToCompare)) {
                    this.nameMatched(node);
                }
            } else if (ScoutXmlDocument.this.m_ignoreQueryCase && string.equalsIgnoreCase(this.m_stringToCompare)) {
                this.nameMatched(node);
            } else if (string.equals(this.m_stringToCompare)) {
                this.nameMatched(node);
            }
        }

        protected abstract void nameMatched(P_AbstractNode var1);

        protected abstract boolean isNotDoneYet();

        protected abstract Object getResult();
    }

    private class P_NodeCounter
    extends P_AbstractNodeVisitor {
        private int m_counter;

        public P_NodeCounter(String name) {
            super(name);
            this.m_counter = 0;
        }

        @Override
        public Object getResult() {
            return new Integer(this.m_counter);
        }

        @Override
        public boolean isNotDoneYet() {
            return true;
        }

        @Override
        protected void nameMatched(P_AbstractNode element) {
            ++this.m_counter;
        }
    }

    private class P_NodeExistenceChecker
    extends P_AbstractNodeVisitor {
        private boolean m_nodeFound;

        public P_NodeExistenceChecker(String name) {
            super(name);
            this.m_nodeFound = false;
        }

        @Override
        public Object getResult() {
            return new Boolean(this.m_nodeFound);
        }

        @Override
        public boolean isNotDoneYet() {
            return !this.m_nodeFound;
        }

        @Override
        protected void nameMatched(P_AbstractNode node) {
            this.m_nodeFound = true;
        }
    }

    private class P_NodeSelectorMulti
    extends P_AbstractNodeVisitor {
        private List m_selectedNodes;
        private String[] m_requiredAttributeNames;
        private String[] m_requiredAttributeValues;

        public P_NodeSelectorMulti(String name) {
            super(name);
            this.m_selectedNodes = new ArrayList();
            this.m_requiredAttributeNames = null;
            this.m_requiredAttributeValues = null;
        }

        public P_NodeSelectorMulti(String name, String[] requiredAttributeNames, String[] requiredAttributeValues) {
            super(name);
            this.m_selectedNodes = new ArrayList();
            this.m_requiredAttributeNames = null;
            this.m_requiredAttributeValues = null;
            this.m_requiredAttributeNames = requiredAttributeNames;
            this.m_requiredAttributeValues = requiredAttributeValues;
        }

        @Override
        public Object getResult() {
            return this.m_selectedNodes;
        }

        @Override
        public boolean isNotDoneYet() {
            return true;
        }

        @Override
        protected void nameMatched(P_AbstractNode node) {
            if (this.m_requiredAttributeNames != null) {
                int i = 0;
                while (i < this.m_requiredAttributeNames.length) {
                    try {
                        if (!((ScoutXmlElement)node).hasAttribute(this.m_requiredAttributeNames[i], this.m_requiredAttributeValues[i])) {
                            return;
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        return;
                    }
                    ++i;
                }
            }
            this.m_selectedNodes.add(node);
        }
    }

    private class P_NodeSelectorSingle
    extends P_AbstractNodeVisitor {
        private P_AbstractNode m_selectedNode;
        private String[] m_requiredAttributeNames;
        private String[] m_requiredAttributeValues;

        public P_NodeSelectorSingle(String name) {
            super(name);
            this.m_selectedNode = null;
            this.m_requiredAttributeNames = null;
            this.m_requiredAttributeValues = null;
        }

        public P_NodeSelectorSingle(String name, String[] requiredAttributeNames, String[] requiredAttributeValues) {
            super(name);
            this.m_selectedNode = null;
            this.m_requiredAttributeNames = null;
            this.m_requiredAttributeValues = null;
            this.m_requiredAttributeNames = requiredAttributeNames;
            this.m_requiredAttributeValues = requiredAttributeValues;
        }

        @Override
        public Object getResult() {
            return this.m_selectedNode;
        }

        @Override
        public boolean isNotDoneYet() {
            return this.m_selectedNode == null;
        }

        @Override
        protected void nameMatched(P_AbstractNode node) {
            if (this.m_requiredAttributeNames != null) {
                int i = 0;
                while (i < this.m_requiredAttributeNames.length) {
                    try {
                        if (!((ScoutXmlElement)node).hasAttribute(this.m_requiredAttributeNames[i], this.m_requiredAttributeValues[i])) {
                            return;
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        return;
                    }
                    ++i;
                }
            }
            this.m_selectedNode = node;
        }
    }

    private class P_Registry {
        private static final int INITIAL_SIZE = 50;
        private List m_values = new ArrayList(50);
        private Map m_valuesReverse = new Hashtable(50);

        public int getID(Object value, boolean addValueIfNotExists) {
            if (value != null) {
                if (this.m_valuesReverse.containsKey(value)) {
                    return (Integer)this.m_valuesReverse.get(value);
                }
                if (addValueIfNotExists) {
                    this.m_values.add(value);
                    this.m_valuesReverse.put(value, new Integer(this.m_values.size() - 1));
                    return this.m_values.size() - 1;
                }
            }
            return -1;
        }

        public Object getValue(int valueID) {
            return this.m_values.get(valueID);
        }

        public Object getValue(Integer valueID) {
            return this.getValue((int)valueID);
        }

        public String getValueAsString(int valueID) {
            return (String)this.getValue(valueID);
        }

        public String getValueAsString(Integer valueID) {
            return (String)this.getValue(valueID);
        }
    }

    public class ScoutXmlElement
    extends P_AbstractNode {
        private List m_attributes = null;
        private Object m_content = null;
        private Map m_namespaces = null;
        private ScoutXmlElement m_parent = null;

        protected ScoutXmlElement() {
        }

        protected ScoutXmlElement(String name) {
            this();
            super.setName(name);
        }

        public ScoutXmlElement addChild() {
            ScoutXmlElement child = new ScoutXmlElement();
            child.setParent(this);
            this.addChild(child);
            return child;
        }

        public ScoutXmlElement addChild(String name) {
            ScoutXmlElement child = this.addChild();
            child.setName(name);
            return child;
        }

        public ScoutXmlElement addChild(ScoutXmlDocument document) {
            return this.addChild(document, -1);
        }

        public ScoutXmlElement addChild(ScoutXmlDocument document, int position) {
            return this.addChild(document.getRoot(), position);
        }

        public ScoutXmlElement addChild(ScoutXmlElement child) {
            return this.addChild(child, -1);
        }

        public ScoutXmlElement addChild(ScoutXmlElement child, int position) {
            if (child.getDocument().equals(ScoutXmlDocument.this)) {
                child.setParent(this);
                if (this.m_content == null) {
                    this.m_content = child;
                } else if (this.m_content instanceof List) {
                    if (position == -1) {
                        ((List)this.m_content).add(child);
                    } else {
                        ((List)this.m_content).add(position, child);
                    }
                } else {
                    ArrayList<Object> newContent = new ArrayList<Object>(10);
                    newContent.add(this.m_content);
                    newContent.add(child);
                    this.m_content = newContent;
                }
            } else {
                try {
                    new ScoutXmlParser(ScoutXmlDocument.this, this).parse(child.toString());
                }
                catch (Exception exception) {}
            }
            return child;
        }

        public void addChildren(List children) {
            int i = 0;
            while (i < children.size()) {
                this.addChild((ScoutXmlElement)children.get(i));
                ++i;
            }
        }

        public void addContent(Object content) {
            if (content instanceof ScoutXmlElement) {
                this.addChild((ScoutXmlElement)content);
            } else {
                this.addText(content.toString());
            }
        }

        public void addText(String text) {
            if (text != null && !text.equals("")) {
                Integer textID = new Integer(ScoutXmlDocument.this.m_textRegistry.getID(text, true));
                if (this.m_content == null) {
                    this.m_content = textID;
                } else if (this.m_content instanceof List) {
                    ((List)this.m_content).add(textID);
                } else {
                    ArrayList<Object> newContent = new ArrayList<Object>(5);
                    newContent.add(this.m_content);
                    newContent.add(textID);
                    this.m_content = newContent;
                }
            }
        }

        public int countAttributes() {
            if (this.m_attributes != null) {
                return this.m_attributes.size();
            }
            return 0;
        }

        public int countAttributes(String name) {
            return (Integer)this.visitAttributes(new P_NodeCounter(name));
        }

        public int countChildren() {
            if (this.m_content instanceof List) {
                Iterator iterator = ((List)this.m_content).iterator();
                int noChildren = 0;
                while (iterator.hasNext()) {
                    if (!(iterator.next() instanceof ScoutXmlElement)) continue;
                    ++noChildren;
                }
                return noChildren;
            }
            if (this.m_content instanceof ScoutXmlElement) {
                return 1;
            }
            return 0;
        }

        public int countChildren(String name) {
            return (Integer)this.visitChildren(new P_NodeCounter(name));
        }

        public int countDescendants() {
            return this.countDescendants("*");
        }

        public int countDescendants(String name) {
            return (Integer)this.visitDescendants(new P_NodeCounter(name));
        }

        public int countSiblings() {
            return this.countSiblings("*");
        }

        public int countSiblings(String name) {
            if (this.hasParent()) {
                return (Integer)this.getParent().visitChildren(new P_NodeCounter(name)) - 1;
            }
            return 0;
        }

        public int countNamespaces() {
            if (this.hasNamespace()) {
                return this.m_namespaces.size();
            }
            return 0;
        }

        public String getAttribute(String name) {
            try {
                return this.getAttributeNode(name).getValueAsString();
            }
            catch (NullPointerException nullPointerException) {
                throw new ScoutXmlException("Attribute '" + name + "' does not exist for '" + this.getPath() + "'");
            }
        }

        public String getAttribute(String name, String defaultValue) {
            try {
                return this.getAttributeNode(name).getValueAsString();
            }
            catch (Exception exception) {
                return defaultValue;
            }
        }

        public boolean getAttributeAsBoolean(String name) {
            try {
                return this.getAttributeNode(name).getValueAsBoolean();
            }
            catch (NullPointerException nullPointerException) {
                throw new ScoutXmlException("Attribute '" + name + "' does not exist for '" + this.getPath() + "'");
            }
        }

        public boolean getAttributeAsBoolean(String name, boolean defaultValue) {
            try {
                return this.getAttributeNode(name).getValueAsBoolean();
            }
            catch (Exception exception) {
                return defaultValue;
            }
        }

        public Date getAttributeAsDate(String name, String format) {
            try {
                return this.getAttributeNode(name).getValueAsDate(format);
            }
            catch (NullPointerException nullPointerException) {
                throw new ScoutXmlException("Attribute '" + name + "' does not exist for '" + this.getPath() + "'");
            }
        }

        public Date getAttributeAsDate(String name, String format, Date defaultValue) {
            try {
                return this.getAttributeNode(name).getValueAsDate(format);
            }
            catch (Exception exception) {
                return defaultValue;
            }
        }

        public double getAttributeAsDouble(String name) {
            try {
                return this.getAttributeNode(name).getValueAsDouble();
            }
            catch (NullPointerException nullPointerException) {
                throw new ScoutXmlException("Attribute '" + name + "' does not exist for '" + this.getPath() + "'");
            }
        }

        public double getAttributeAsDouble(String name, double defaultValue) {
            try {
                return this.getAttributeNode(name).getValueAsDouble();
            }
            catch (Exception exception) {
                return defaultValue;
            }
        }

        public int getAttributeAsInt(String name) {
            try {
                return this.getAttributeNode(name).getValueAsInt();
            }
            catch (NullPointerException nullPointerException) {
                throw new ScoutXmlException("Attribute '" + name + "' does not exist for '" + this.getPath() + "'");
            }
        }

        public int getAttributeAsInt(String name, int defaultValue) {
            try {
                return this.getAttributeNode(name).getValueAsInt();
            }
            catch (Exception exception) {
                return defaultValue;
            }
        }

        public long getAttributeAsLong(String name) {
            try {
                return this.getAttributeNode(name).getValueAsLong();
            }
            catch (NullPointerException nullPointerException) {
                throw new ScoutXmlException("Attribute '" + name + "' does not exist for '" + this.getPath() + "'");
            }
        }

        public long getAttributeAsLong(String name, long defaultValue) {
            try {
                return this.getAttributeNode(name).getValueAsLong();
            }
            catch (Exception exception) {
                return defaultValue;
            }
        }

        public short getAttributeAsShort(String name) {
            return this.getAttributeNode(name).getValueAsShort();
        }

        public short getAttributeAsShort(String name, short defaultValue) {
            try {
                return this.getAttributeNode(name).getValueAsShort();
            }
            catch (Exception exception) {
                return defaultValue;
            }
        }

        private P_Attribute getAttributeNode(String name) {
            return (P_Attribute)this.visitAttributes(new P_NodeSelectorSingle(name));
        }

        private Collection getAttributeNodes(String name) {
            return (Collection)this.visitAttributes(new P_NodeSelectorMulti(name));
        }

        public int getIndex() {
            if (this.hasParent()) {
                return this.getParent().getChildren().indexOf(this);
            }
            return 0;
        }

        @Override
        public String getNamespace(String prefix) {
            if (prefix != null) {
                if (this.hasNamespace(prefix)) {
                    return (String)this.m_namespaces.get(prefix);
                }
                if (this.hasParent()) {
                    return this.getParent().getNamespace(prefix);
                }
                return null;
            }
            return null;
        }

        public Map getNamespaces() {
            return this.m_namespaces;
        }

        public ScoutXmlElement getChild(int index) {
            try {
                if (index == 0 && this.m_content instanceof ScoutXmlElement) {
                    return (ScoutXmlElement)this.m_content;
                }
                return (ScoutXmlElement)this.getChildren().get(index);
            }
            catch (Exception exception) {
                throw new ScoutXmlException("Child with index " + index + " does not exist for '" + this.getPath() + "'");
            }
        }

        public ScoutXmlElement getChild(String name) {
            return (ScoutXmlElement)this.visitChildren(new P_NodeSelectorSingle(name));
        }

        public ScoutXmlElement getChild(String name, String requiredAttributeName, String requiredAttributeValue) {
            return this.getChild(name, new String[]{requiredAttributeName}, new String[]{requiredAttributeValue});
        }

        public ScoutXmlElement getChild(String name, String[] requiredAttributeNames, String[] requiredAttributeValues) {
            return (ScoutXmlElement)this.visitChildren(new P_NodeSelectorSingle(name, requiredAttributeNames, requiredAttributeValues));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public List getChildren() {
            ArrayList<Object> children = new ArrayList<Object>();
            if (this.m_content instanceof List) {
                if (!this.hasText()) return (List)this.m_content;
                int i = 0;
                while (i < ((List)this.m_content).size()) {
                    Object o = ((List)this.m_content).get(i);
                    if (o instanceof ScoutXmlElement) {
                        children.add(o);
                    }
                    ++i;
                }
                return children;
            } else {
                if (!(this.m_content instanceof ScoutXmlElement)) return children;
                children.add(this.m_content);
            }
            return children;
        }

        public List getChildren(String name) {
            return (List)this.visitChildren(new P_NodeSelectorMulti(name));
        }

        public ScoutXmlElement getDescendant(String name) {
            return (ScoutXmlElement)this.visitDescendants(new P_NodeSelectorSingle(name));
        }

        public List getDescendants(String name) {
            return (List)this.visitDescendants(new P_NodeSelectorMulti(name));
        }

        public ScoutXmlDocument getDocument() {
            return ScoutXmlDocument.this;
        }

        public boolean hasAttribute(String name) {
            try {
                return (Boolean)this.visitAttributes(new P_NodeExistenceChecker(name));
            }
            catch (Exception exception) {
                return false;
            }
        }

        public boolean hasAttribute(String name, String value) {
            return this.hasAttribute(name) && this.getAttribute(name).equals(value);
        }

        public boolean hasAttributeExact(String name) {
            if (this.hasAttributes()) {
                Iterator iterator = this.m_attributes.iterator();
                int i = 0;
                while (iterator.hasNext()) {
                    if (((P_Attribute)iterator.next()).getNamePrefixed().equals(name)) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }

        public boolean hasAttributes() {
            return this.m_attributes != null && !this.m_attributes.isEmpty();
        }

        public boolean hasChild(String name) {
            return (Boolean)this.visitChildren(new P_NodeExistenceChecker(name));
        }

        public boolean hasChildren() {
            if (this.m_content instanceof ScoutXmlElement) {
                return true;
            }
            if (this.m_content instanceof List) {
                Iterator iterator = ((List)this.m_content).iterator();
                while (iterator.hasNext()) {
                    if (!(iterator.next() instanceof ScoutXmlElement)) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean hasContent() {
            return this.m_content != null;
        }

        public boolean hasNamespace() {
            if (this.m_namespaces != null) {
                return !this.m_namespaces.isEmpty();
            }
            return false;
        }

        public boolean hasNamespace(String prefix) {
            if (this.hasNamespace() && prefix != null) {
                return this.m_namespaces.containsKey(prefix);
            }
            return false;
        }

        public boolean hasParent() {
            return this.getParent() != null;
        }

        public boolean hasName() {
            return this.m_nameID != -1;
        }

        public boolean hasText() {
            if (this.m_content instanceof Integer) {
                return true;
            }
            if (this.m_content instanceof String) {
                return !((String)this.m_content).equals("");
            }
            if (this.m_content instanceof List) {
                for (Object contentPart : (List)this.m_content) {
                    if (!(contentPart instanceof String) && !(contentPart instanceof Integer)) continue;
                    return true;
                }
            }
            return false;
        }

        public boolean isRoot() {
            return !this.hasParent();
        }

        protected void optimize() {
            if (this.m_content instanceof List) {
                if (((List)this.m_content).size() == 0) {
                    this.m_content = null;
                } else {
                    ((ArrayList)this.m_content).trimToSize();
                }
            }
            if (this.m_attributes != null) {
                if (this.m_attributes.isEmpty()) {
                    this.m_attributes = null;
                } else {
                    ((ArrayList)this.m_attributes).trimToSize();
                }
            }
            if (this.m_namespaces != null && this.m_namespaces.isEmpty()) {
                this.m_namespaces = null;
            }
        }

        public String getText() {
            return this.getText("");
        }

        public String getText(String defaultValue) {
            String text = null;
            if (this.m_content instanceof Integer) {
                text = ScoutXmlDocument.this.m_textRegistry.getValueAsString((Integer)this.m_content);
            } else if (this.m_content instanceof String) {
                text = (String)this.m_content;
            } else if (this.m_content instanceof List) {
                StringBuffer stringBuffer = new StringBuffer();
                int i = 0;
                while (i < ((List)this.m_content).size()) {
                    Object contentPart = ((List)this.m_content).get(i);
                    if (contentPart instanceof String) {
                        stringBuffer.append((String)contentPart);
                    } else if (contentPart instanceof Integer) {
                        stringBuffer.append(ScoutXmlDocument.this.m_textRegistry.getValueAsString((Integer)contentPart));
                    }
                    ++i;
                }
                text = stringBuffer.toString();
            }
            if (text != null) {
                if (ScoutXmlDocument.this.isIgnoreIndentWhitespace()) {
                    return text.replaceAll("\n *", "\n").replaceAll("\n\t*", "\n");
                }
                return text;
            }
            return defaultValue;
        }

        public boolean getTextAsBoolean() {
            try {
                return Boolean.valueOf(this.getText());
            }
            catch (Exception exception) {
                throw new ScoutXmlException("The text '" + this.getText() + "' is not a valid 'boolean' value (" + this.getPath() + ")");
            }
        }

        public boolean getTextAsBoolean(boolean defaultValue) {
            try {
                return Boolean.valueOf(this.getText());
            }
            catch (Exception exception) {
                return defaultValue;
            }
        }

        public Date getTextAsDate(String format) {
            try {
                return new SimpleDateFormat(format).parse(this.getText());
            }
            catch (Exception exception) {
                throw new ScoutXmlException("The text '" + this.getText() + "' is not a valid 'Date' value (" + this.getPath() + ")");
            }
        }

        public Date getTextAsDate(String format, Date defaultValue) {
            try {
                return new SimpleDateFormat(format).parse(this.getText());
            }
            catch (Exception exception) {
                return defaultValue;
            }
        }

        public double getTextAsDouble() {
            try {
                return Double.valueOf(this.getText());
            }
            catch (Exception exception) {
                throw new ScoutXmlException("The text '" + this.getText() + "' is not a valid 'double' value (" + this.getPath() + ")");
            }
        }

        public double getTextAsDouble(double defaultValue) {
            try {
                return Double.valueOf(this.getText());
            }
            catch (Exception exception) {
                return defaultValue;
            }
        }

        public int getTextAsInt() {
            try {
                return Integer.valueOf(this.getText());
            }
            catch (Exception exception) {
                throw new ScoutXmlException("The text '" + this.getText() + "' is not a valid 'int' value (" + this.getPath() + ")");
            }
        }

        public int getTextAsInt(int defaultValue) {
            try {
                return Integer.valueOf(this.getText());
            }
            catch (Exception exception) {
                return defaultValue;
            }
        }

        public long getTextAsLong() {
            try {
                return Long.valueOf(this.getText());
            }
            catch (Exception exception) {
                throw new ScoutXmlException("The text '" + this.getText() + "' is not a valid 'long' value (" + this.getPath() + ")");
            }
        }

        public long getTextAsLong(long defaultValue) {
            try {
                return Long.valueOf(this.getText());
            }
            catch (Exception exception) {
                return defaultValue;
            }
        }

        public short getTextAsShort() {
            try {
                return Short.valueOf(this.getText());
            }
            catch (Exception exception) {
                throw new ScoutXmlException("The text '" + this.getText() + "' is not a valid 'short' value (" + this.getPath() + ")");
            }
        }

        public short getTextAsShort(short defaultValue) {
            try {
                return Short.valueOf(this.getText());
            }
            catch (Exception exception) {
                return defaultValue;
            }
        }

        public String getLocalName() {
            String name = ScoutXmlDocument.this.m_nameRegistry.getValueAsString(this.m_nameID);
            String localName = ScoutXmlQName.extractLocalName(name);
            return localName;
        }

        public String getNamePrefix() {
            String name = ScoutXmlDocument.this.m_nameRegistry.getValueAsString(this.m_nameID);
            String prefix = ScoutXmlQName.extractPrefix(name);
            return prefix;
        }

        public String getNameNamespace() {
            String name = ScoutXmlDocument.this.m_nameRegistry.getValueAsString(this.m_nameID);
            String prefix = ScoutXmlQName.extractPrefix(name);
            return this.getNamespace(prefix);
        }

        @Override
        public ScoutXmlQName getName() {
            String name = ScoutXmlDocument.this.m_nameRegistry.getValueAsString(this.m_nameID);
            String prefix = ScoutXmlQName.extractPrefix(name);
            String localName = ScoutXmlQName.extractLocalName(name);
            return new ScoutXmlQName(this.getNamespace(prefix), prefix, localName);
        }

        public ScoutXmlElement getParent() {
            return this.m_parent;
        }

        public String getPath() {
            StringBuffer buffer = new StringBuffer();
            ScoutXmlElement element = this;
            while (element.hasParent()) {
                if (element.countSiblings(element.getNameExpanded()) > 0) {
                    buffer.insert(0, ']');
                    buffer.insert(0, element.getIndex());
                    buffer.insert(0, '[');
                }
                buffer.insert(0, element.getNameExpanded());
                buffer.insert(0, '/');
                element = element.getParent();
            }
            buffer.insert(0, element.getNameExpanded());
            return buffer.toString();
        }

        public ScoutXmlElement getRoot() {
            if (this.hasParent()) {
                return this.getParent().getRoot();
            }
            return this;
        }

        public void removeAttribute(String name) {
            try {
                this.m_attributes.remove(this.getAttributeNode(name));
            }
            catch (Exception exception) {}
        }

        public void removeAttributes() {
            this.m_attributes = null;
        }

        public void removeAttributes(String name) {
            try {
                this.m_attributes.removeAll(this.getAttributeNodes(name));
            }
            catch (Exception exception) {}
        }

        public void removeChild(int index) {
            try {
                this.removeChild(this.getChild(index));
            }
            catch (Exception exception) {}
        }

        public void removeChild(ScoutXmlElement child) {
            try {
                if (this.m_content.equals(child)) {
                    this.m_content = null;
                } else {
                    ((List)this.m_content).remove(child);
                }
            }
            catch (Exception exception) {}
        }

        public void removeChild(String name) {
            try {
                this.removeChild(this.getChild(name));
            }
            catch (Exception exception) {}
        }

        public void removeChildren() {
            this.m_content = null;
        }

        public void removeChildren(Collection children) {
            try {
                ((List)this.m_content).removeAll(children);
            }
            catch (Exception exception) {}
        }

        public void removeChildren(String name) {
            try {
                this.removeChildren(this.getChildren(name));
            }
            catch (Exception exception) {}
        }

        public void removeContent() {
            this.m_content = null;
        }

        public void removeNamespace(String prefix) {
            if (this.hasNamespace(prefix)) {
                this.m_namespaces.remove(prefix);
            } else {
                LOG.warn("Namespace with prefix '" + prefix + "' not removed, it doesn't exist for element '" + this.getNamePrefixed() + "'.");
            }
        }

        public void removeNamespaces() {
            this.m_namespaces = null;
        }

        public void removeText() {
            if (this.m_content instanceof Integer) {
                this.m_content = null;
            } else if (this.m_content instanceof String) {
                this.m_content = null;
            } else if (this.m_content instanceof List) {
                int i = 0;
                while (i < ((List)this.m_content).size()) {
                    Object contentPart = ((List)this.m_content).get(i);
                    if (contentPart instanceof String) {
                        ((List)this.m_content).remove(contentPart);
                    } else if (contentPart instanceof Integer) {
                        ((List)this.m_content).remove(contentPart);
                    }
                    ++i;
                }
            }
        }

        public void setAttribute(String name, boolean value) {
            this.setAttribute(name, String.valueOf(value));
        }

        public void setAttribute(String name, Date value, String dateFormat) {
            this.setAttribute(name, new SimpleDateFormat(dateFormat).format(value));
        }

        public void setAttribute(String name, double value) {
            this.setAttribute(name, String.valueOf(value));
        }

        public void setAttribute(String name, int value) {
            this.setAttribute(name, String.valueOf(value));
        }

        public void setAttribute(String name, long value) {
            this.setAttribute(name, String.valueOf(value));
        }

        public void setAttribute(String name, short value) {
            this.setAttribute(name, String.valueOf(value));
        }

        public void setAttribute(String name, String value) {
            if (value != null) {
                if (this.m_attributes == null) {
                    this.m_attributes = new ArrayList(5);
                }
                P_Attribute newAttribute = new P_Attribute(name, value);
                if (ScoutXmlDocument.this.isStrictlyChecking() && this.hasAttribute(newAttribute.getNameExpanded())) {
                    this.getAttributeNode(newAttribute.getNameExpanded()).setValue(value);
                }
                this.m_attributes.add(newAttribute);
            }
        }

        protected void setAttributes(Attributes attributes) {
            if (attributes.getLength() > 0) {
                if (this.m_attributes == null) {
                    this.m_attributes = new ArrayList(attributes.getLength());
                }
                int i = 0;
                while (i < attributes.getLength()) {
                    if (attributes.getValue(i) != null && !attributes.getValue(i).equals("")) {
                        this.m_attributes.add(new P_Attribute(attributes.getQName(i), attributes.getValue(i)));
                    }
                    ++i;
                }
            }
        }

        public void setNamespace(String prefix, String namespaceURI) {
            if (this.m_namespaces == null) {
                this.m_namespaces = new Hashtable(5);
            }
            this.m_namespaces.put(prefix != null ? prefix : "", namespaceURI);
        }

        protected void setNamespaces(Map namespaces) {
            if (this.m_namespaces == null) {
                this.m_namespaces = new Hashtable(namespaces.size());
            }
            this.m_namespaces.putAll(namespaces);
        }

        public void setParent(ScoutXmlElement parent) {
            this.m_parent = parent;
        }

        public String export() {
            try {
                StringWriter stringWriter = new StringWriter();
                this.write(stringWriter);
                return stringWriter.toString();
            }
            catch (IOException iOException) {
                return null;
            }
        }

        public String toString() {
            return this.export();
        }

        protected Object visitAttributes(P_AbstractNodeVisitor visitor) {
            if (this.hasAttributes()) {
                Iterator iterator = this.m_attributes.iterator();
                while (iterator.hasNext() && visitor.isNotDoneYet()) {
                    visitor.visit((P_Attribute)iterator.next());
                }
                return visitor.getResult();
            }
            return null;
        }

        protected Object visitChildren(P_AbstractNodeVisitor visitor) {
            Iterator iterator = this.getChildren().iterator();
            while (iterator.hasNext() && visitor.isNotDoneYet()) {
                visitor.visit((ScoutXmlElement)iterator.next());
            }
            return visitor.getResult();
        }

        protected Object visitDescendants(P_AbstractNodeVisitor visitor) {
            Iterator iterator = this.getChildren().iterator();
            ScoutXmlElement child = null;
            while (iterator.hasNext() && visitor.isNotDoneYet()) {
                child = (ScoutXmlElement)iterator.next();
                visitor.visit(child);
                child.visitDescendants(visitor);
            }
            return visitor.getResult();
        }

        @Override
        public void write(Writer writer) throws IOException {
            BufferedWriter bufferedWriter = null;
            bufferedWriter = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
            this.write(bufferedWriter, "");
            bufferedWriter.flush();
        }

        private void write(BufferedWriter bufferedWriter, String currentIndent) throws IOException {
            if (this.hasName()) {
                Iterator<Object> iterator;
                bufferedWriter.write(currentIndent);
                bufferedWriter.write(60);
                bufferedWriter.write(this.getNamePrefixed());
                if (this.hasAttributes()) {
                    iterator = this.m_attributes.iterator();
                    while (iterator.hasNext()) {
                        bufferedWriter.write(32);
                        ((P_Attribute)iterator.next()).write(bufferedWriter);
                    }
                }
                if (this.hasNamespace()) {
                    iterator = this.m_namespaces.keySet().iterator();
                    String prefix = null;
                    while (iterator.hasNext()) {
                        prefix = (String)iterator.next();
                        bufferedWriter.write(" xmlns");
                        if (!prefix.equals("")) {
                            bufferedWriter.write(58);
                            bufferedWriter.write(prefix);
                        }
                        bufferedWriter.write(61);
                        bufferedWriter.write(34);
                        this.writeEncoded(bufferedWriter, this.getNamespace(prefix));
                        bufferedWriter.write(34);
                    }
                }
                if (this.hasContent()) {
                    bufferedWriter.write(62);
                    if (this.m_content instanceof List) {
                        if (ScoutXmlDocument.this.isPrettyPrint()) {
                            bufferedWriter.newLine();
                        }
                        int i = 0;
                        while (i < ((List)this.m_content).size()) {
                            Object o = ((List)this.m_content).get(i);
                            if (o instanceof ScoutXmlElement) {
                                ((ScoutXmlElement)o).write(bufferedWriter, String.valueOf(currentIndent) + ScoutXmlDocument.this.getIndent());
                            } else if (o instanceof Integer) {
                                bufferedWriter.write(String.valueOf(currentIndent) + ScoutXmlDocument.this.getIndent());
                                this.writeEncoded(bufferedWriter, ScoutXmlDocument.this.m_textRegistry.getValueAsString((int)((Integer)o)));
                                if (ScoutXmlDocument.this.isPrettyPrint()) {
                                    bufferedWriter.newLine();
                                }
                            }
                            ++i;
                        }
                        bufferedWriter.write(currentIndent);
                    } else if (this.m_content instanceof ScoutXmlElement) {
                        if (ScoutXmlDocument.this.isPrettyPrint()) {
                            bufferedWriter.newLine();
                        }
                        ((ScoutXmlElement)this.m_content).write(bufferedWriter, String.valueOf(currentIndent) + ScoutXmlDocument.this.getIndent());
                        bufferedWriter.write(currentIndent);
                    } else if (this.m_content instanceof Integer) {
                        this.writeEncoded(bufferedWriter, ScoutXmlDocument.this.m_textRegistry.getValueAsString((Integer)this.m_content));
                    }
                    bufferedWriter.write(60);
                    bufferedWriter.write(47);
                    bufferedWriter.write(this.getNamePrefixed());
                    bufferedWriter.write(62);
                } else {
                    bufferedWriter.write(47);
                    bufferedWriter.write(62);
                }
                if (ScoutXmlDocument.this.isPrettyPrint()) {
                    bufferedWriter.newLine();
                }
            } else {
                throw new ScoutXmlException("Can't write this element because it has no name.");
            }
        }

        protected void writeEncoded(BufferedWriter bufferedWriter, String string) throws IOException {
            if (string != null) {
                int i = 0;
                while (i < string.length()) {
                    String ch = "" + string.charAt(i);
                    String escaped = XML_ENTITIES.get(ch);
                    if (escaped != null) {
                        bufferedWriter.write(escaped);
                    } else {
                        bufferedWriter.write(ch);
                    }
                    ++i;
                }
            }
        }

        private class P_Attribute
        extends P_AbstractNode {
            private int m_valueID;

            public P_Attribute(String name, String value) {
                super.setName(name);
                this.setValue(value);
            }

            public boolean equals(Object object) {
                if (object == null) {
                    return false;
                }
                try {
                    P_Attribute attribute = (P_Attribute)object;
                    return this.getName().equals(attribute.getName()) && this.getValueAsString().equals(attribute.getValueAsString());
                }
                catch (Exception exception) {
                    return false;
                }
            }

            public int hashCode() {
                return this.getName().hashCode() ^ this.getValueAsString().hashCode();
            }

            public ScoutXmlDocument getDocument() {
                return ScoutXmlDocument.this;
            }

            @Override
            public ScoutXmlQName getName() {
                String name = ScoutXmlDocument.this.m_nameRegistry.getValueAsString(this.m_nameID);
                String prefix = ScoutXmlQName.extractPrefix(name);
                String localName = ScoutXmlQName.extractLocalName(name);
                return new ScoutXmlQName(this.getNamespace(prefix), prefix, localName);
            }

            @Override
            public String getNamespace(String prefix) {
                return ScoutXmlElement.this.getNamespace(prefix);
            }

            public Object getValue() {
                return ScoutXmlDocument.this.m_nameRegistry.getValue(this.m_valueID);
            }

            public boolean getValueAsBoolean() {
                return Boolean.valueOf(this.getValueAsString());
            }

            public Date getValueAsDate(String format) {
                try {
                    return new SimpleDateFormat(format).parse(this.getValueAsString());
                }
                catch (Exception exception) {
                    throw new ScoutXmlException("Attribute value '" + this.getValueAsString() + "' is not a valid 'Date' value (" + ScoutXmlElement.this.getPath() + "/@" + this.getNameExpanded() + ")");
                }
            }

            public double getValueAsDouble() {
                try {
                    return Double.valueOf(this.getValueAsString());
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ScoutXmlException("Attribute value '" + this.getValueAsString() + "' is not a valid 'double' value (" + ScoutXmlElement.this.getPath() + "/@" + this.getNameExpanded() + ")");
                }
            }

            public int getValueAsInt() {
                try {
                    return Integer.valueOf(this.getValueAsString());
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ScoutXmlException("Attribute value '" + this.getValueAsString() + "' is not a valid 'int' value (" + ScoutXmlElement.this.getPath() + "/@" + this.getNameExpanded() + ")");
                }
            }

            public long getValueAsLong() {
                try {
                    return Long.valueOf(this.getValueAsString());
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ScoutXmlException("Attribute value '" + this.getValueAsString() + "' is not a valid 'long' value (" + ScoutXmlElement.this.getPath() + "/@" + this.getNameExpanded() + ")");
                }
            }

            public short getValueAsShort() {
                try {
                    return Short.valueOf(this.getValueAsString());
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ScoutXmlException("Attribute value '" + this.getValueAsString() + "' is not a valid 'short' value (" + ScoutXmlElement.this.getPath() + "/@" + this.getNameExpanded() + ")");
                }
            }

            public String getValueAsString() {
                return ScoutXmlDocument.this.m_attvRegistry.getValueAsString(this.m_valueID);
            }

            public void setValue(String value) {
                this.m_valueID = ScoutXmlDocument.this.m_attvRegistry.getID(value, true);
            }

            public String toString() {
                try {
                    StringWriter stringWriter = new StringWriter();
                    this.write(stringWriter);
                    return stringWriter.toString();
                }
                catch (IOException iOException) {
                    return null;
                }
            }

            @Override
            public void write(Writer writer) throws IOException {
                BufferedWriter bufferedWriter = null;
                bufferedWriter = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
                bufferedWriter.write(ScoutXmlDocument.this.m_nameRegistry.getValueAsString(this.m_nameID));
                bufferedWriter.write(61);
                bufferedWriter.write(34);
                ScoutXmlElement.this.writeEncoded(bufferedWriter, this.getValueAsString());
                bufferedWriter.write(34);
                bufferedWriter.flush();
            }
        }
    }
}

