/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.http.servletfilter.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.scout.http.servletfilter.internal.Activator;
import org.eclipse.scout.http.servletfilter.internal.FilterConfigImpl;
import org.osgi.framework.Bundle;

public final class ServletFilterExtensionPoint {
    private static Object filtersLock = new Object();
    private static List<FilterConfigImpl> filters;

    private ServletFilterExtensionPoint() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<FilterConfigImpl> getExtensions() {
        if (filters == null) {
            Object object = filtersLock;
            synchronized (object) {
                TreeMap<Double, FilterConfigImpl> tempMap = new TreeMap<Double, FilterConfigImpl>();
                IExtensionRegistry reg = Platform.getExtensionRegistry();
                reg.addListener(new IRegistryEventListener(){

                    public void added(IExtension[] extensions) {
                        ServletFilterExtensionPoint.notifyExtensionPointChanged();
                    }

                    public void removed(IExtension[] extensions) {
                        ServletFilterExtensionPoint.notifyExtensionPointChanged();
                    }

                    public void added(IExtensionPoint[] extensionPoints) {
                        ServletFilterExtensionPoint.notifyExtensionPointChanged();
                    }

                    public void removed(IExtensionPoint[] extensionPoints) {
                        ServletFilterExtensionPoint.notifyExtensionPointChanged();
                    }
                }, "org.eclipse.scout.http.servletfilter.filters");
                IExtensionPoint xp = reg.getExtensionPoint("org.eclipse.scout.http.servletfilter", "filters");
                IExtension[] extensions = xp.getExtensions();
                double index = 0.0;
                IExtension[] iExtensionArray = extensions;
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement[] serviceElements;
                    IExtension extension = iExtensionArray[n2];
                    Bundle contributorBundle = Platform.getBundle((String)extension.getContributor().getName());
                    IConfigurationElement[] iConfigurationElementArray = serviceElements = extension.getConfigurationElements();
                    int n3 = serviceElements.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement serviceElement = iConfigurationElementArray[n4];
                        String className = serviceElement.getAttribute("class");
                        String runOrderText = serviceElement.getAttribute("ranking");
                        try {
                            double runOrder = 0.0;
                            if (runOrderText != null && runOrderText.length() > 0) {
                                runOrder = Double.parseDouble(runOrderText);
                            }
                            String[] stringArray = serviceElement.getAttribute("aliases").split("[ ,;]");
                            int n5 = stringArray.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                String alias = stringArray[n6];
                                if ((alias = alias.trim()).length() > 0) {
                                    FilterConfigImpl ref = new FilterConfigImpl(alias, serviceElement, contributorBundle);
                                    tempMap.put(runOrder + index * 1.0E-6, ref);
                                    index += 1.0;
                                }
                                ++n6;
                            }
                        }
                        catch (Throwable t) {
                            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.scout.http.servletfilter", "create filter: " + className, t));
                        }
                        ++n4;
                    }
                    ++n2;
                }
                filters = new ArrayList(tempMap.values());
            }
        }
        return filters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyExtensionPointChanged() {
        System.out.println("#ExtensionPointChanged(filters)");
        Object object = filtersLock;
        synchronized (object) {
            if (filters != null) {
                for (FilterConfigImpl ref : filters) {
                    ref.destroy();
                }
            }
            filters = null;
        }
    }
}

