/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.jaxws.internal.servlet;

import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.server.PortAddressResolver;
import com.sun.xml.internal.ws.api.server.WSEndpoint;
import com.sun.xml.internal.ws.api.server.WebServiceContextDelegate;
import com.sun.xml.internal.ws.transport.http.HttpAdapter;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceException;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.jaxws.internal.servlet.JaxWsHelper;

public class ServletContextDelegate
implements WebServiceContextDelegate {
    private HttpAdapter m_servletAdapter;
    private HttpServletRequest m_request;

    public ServletContextDelegate(HttpAdapter servletAdapter, HttpServletRequest request) {
        this.m_servletAdapter = servletAdapter;
        this.m_request = request;
    }

    public Principal getUserPrincipal(Packet packet) {
        return this.m_request.getUserPrincipal();
    }

    public boolean isUserInRole(Packet packet, String role) {
        return this.m_request.isUserInRole(role);
    }

    public String getEPRAddress(Packet packet, WSEndpoint endpoint) {
        QName portQName;
        QName serviceQName;
        String baseAddress = JaxWsHelper.getBaseAddress(this.m_request, true);
        PortAddressResolver resolver = this.m_servletAdapter.owner.createPortAddressResolver(baseAddress);
        String address = resolver.getAddressFor(serviceQName = endpoint.getServiceName(), (portQName = endpoint.getPortName()).getLocalPart());
        if (address == null) {
            throw new WebServiceException("Failed to find address for port '" + portQName + "'");
        }
        return address;
    }

    public String getWSDLAddress(Packet packet, WSEndpoint endpoint) {
        if (this.m_servletAdapter.getEndpoint().getPort() != null) {
            return StringUtility.join((String)"", (String[])new String[]{this.getEPRAddress(packet, endpoint), "?wsdl"});
        }
        return null;
    }
}

