/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.jaxws.tool;

import com.sun.tools.internal.ws.processor.model.Model;
import com.sun.tools.internal.ws.processor.model.Port;
import com.sun.tools.internal.ws.processor.model.Service;
import com.sun.tools.internal.ws.processor.modeler.wsdl.WSDLModeler;
import com.sun.tools.internal.ws.wscompile.AbortException;
import com.sun.tools.internal.ws.wscompile.ErrorReceiver;
import com.sun.tools.internal.ws.wscompile.WsimportOptions;
import com.sun.tools.internal.ws.wscompile.WsimportTool;
import com.sun.tools.internal.ws.wsdl.parser.InternalizationLogic;
import com.sun.tools.internal.ws.wsdl.parser.MetadataFinder;
import com.sun.tools.internal.ws.wsdl.parser.WSDLInternalizationLogic;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import org.eclipse.core.runtime.Path;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.FileUtility;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.commons.StringUtility;
import org.xml.sax.SAXParseException;

public class JaxWsStubGenerator {
    private static final int ARG_OUT_DIR = 0;
    private static final int ARG_WSDL_FILE = 1;
    private static final int ARG_APPLY_PATCH = 2;
    private static final String FILE_PATH_SEPARATOR = System.getProperty("file.separator");
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public static void main(String[] args) throws Exception {
        boolean createJarFile;
        if (args.length > 0 && CompareUtility.equals((Object)args[0], (Object)"help") || args.length < 3) {
            JaxWsStubGenerator.logInfo("Usage:");
            JaxWsStubGenerator.logInfo("arg[0] output directory where to place generated files. This might be a project relative or an absolute path. If it is a file of the type jar, the generated files are put into that archive.");
            JaxWsStubGenerator.logInfo("arg[1] project relative path to WSDL");
            JaxWsStubGenerator.logInfo("arg[2] apply patches to stub source");
            JaxWsStubGenerator.logInfo("arg[..] other options");
            JaxWsStubGenerator.logInfo("[options supported in build file]");
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            new WsimportTool((OutputStream)os).run(new String[]{"-help"});
            JaxWsStubGenerator.logInfo(os);
            return;
        }
        String wsdlLocation = args[1];
        if (wsdlLocation.startsWith(FILE_PATH_SEPARATOR)) {
            wsdlLocation = wsdlLocation.substring(1);
        }
        String outDir = null;
        String jarFileName = null;
        Path outPath = new Path(args[0]);
        File tempOutDir = null;
        String suffix = outPath.getFileExtension();
        if (suffix != null && suffix.equalsIgnoreCase("jar")) {
            jarFileName = outPath.lastSegment();
            outDir = outPath.removeLastSegments(1).toPortableString();
        } else {
            outDir = outPath.toPortableString();
        }
        new File(outDir).mkdirs();
        LinkedList<String> properties = new LinkedList<String>();
        properties.add("-wsdllocation");
        properties.add(wsdlLocation);
        boolean noCompile = false;
        int i = 3;
        while (i < args.length) {
            String[] property;
            String key;
            String directive = args[i];
            if (directive != null && directive.trim().length() != 0 && !(key = (property = directive.split("=", 2))[0].trim()).equals("s") && !key.equals("d")) {
                if (key.equals("Xnocompile")) {
                    noCompile = true;
                }
                String param = "-" + key;
                if (property.length == 2 && property[1].trim().length() > 0) {
                    String value = property[1].trim();
                    properties.add(param);
                    properties.add(value);
                    JaxWsStubGenerator.logInfo("JAX-WS option: " + StringUtility.join((String)" ", (String[])new String[]{param, value}));
                } else {
                    properties.add(param);
                    JaxWsStubGenerator.logInfo("JAX-WS directive: " + param);
                }
            }
            ++i;
        }
        boolean bl = createJarFile = jarFileName != null;
        if (createJarFile) {
            tempOutDir = IOUtility.createTempDirectory(null);
            properties.add("-d");
            properties.add(tempOutDir.getAbsolutePath());
        } else {
            properties.add("-d");
            properties.add(outDir);
        }
        properties.add("-Xnocompile");
        properties.add(wsdlLocation);
        String[] propertyArray = properties.toArray(new String[properties.size()]);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        boolean status = new WsimportTool((OutputStream)bos).run(propertyArray);
        if (status) {
            File stubOutDir = createJarFile ? tempOutDir : new File(outDir);
            if (stubOutDir == null || stubOutDir.list() == null || stubOutDir.list().length == 0) {
                JaxWsStubGenerator.logError("No JAX-WS stub files generated");
                throw new Exception("No JAX-WS stub files generated.");
            }
            if (Integer.valueOf(args[2]) > 0) {
                JaxWsStubGenerator.patchSourceCodeWsdlResources(stubOutDir);
            }
            if (!noCompile) {
                JaxWsStubGenerator.compile(stubOutDir);
            }
            if (createJarFile) {
                JaxWsStubGenerator.createJarArchive(stubOutDir, outDir, jarFileName);
            }
        } else {
            JaxWsStubGenerator.logInfo("JAX-WS stub generation failed.");
            JaxWsStubGenerator.logError(bos);
            throw new Exception("JAX-WS stub generation failed.");
        }
        JaxWsStubGenerator.logInfo("JAX-WS stub generation completed. For debugging purpose, please see the following debug output.");
        JaxWsStubGenerator.logInfo(bos);
        JaxWsStubGenerator.printModelInformation(propertyArray);
    }

    private static void patchSourceCodeWsdlResources(File folder) {
        File[] javaFiles;
        Pattern pattern = Pattern.compile("\\.class\\.getResource\\(\\s*\"\\.\"\\s*\\)");
        File[] fileArray = javaFiles = JaxWsStubGenerator.getAllJavaFiles(folder);
        int n = javaFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File javaFile = fileArray[n2];
            try {
                String content = IOUtility.getContent((Reader)new FileReader(javaFile), (boolean)true);
                Matcher matcher = pattern.matcher(content);
                if (matcher.find()) {
                    content = matcher.replaceAll(".class.getResource(\"/\")");
                    IOUtility.writeContent((Writer)new FileWriter(javaFile), (String)content);
                    JaxWsStubGenerator.logInfo("Code fix (WSDL resource finding) applied to " + javaFile.getName());
                }
            }
            catch (Throwable t) {
                JaxWsStubGenerator.logError("Failed to apply code fix (WSDL resource finding) in '" + javaFile.getName() + "'", t);
            }
            ++n2;
        }
    }

    private static void createJarArchive(File tempOutDir, String outDirPath, String jarFileName) {
        if (jarFileName == null) {
            return;
        }
        try {
            File jarFile;
            if (!outDirPath.endsWith(FILE_PATH_SEPARATOR)) {
                outDirPath = String.valueOf(outDirPath) + FILE_PATH_SEPARATOR;
            }
            if ((jarFile = IOUtility.toFile((String)(String.valueOf(outDirPath) + jarFileName))).exists()) {
                jarFile.delete();
            }
            jarFile.createNewFile();
            File metaInfFolder = new File(tempOutDir, "META-INF");
            metaInfFolder.mkdir();
            File manifestFile = new File(metaInfFolder, "MANIFEST.MF");
            manifestFile.createNewFile();
            FileWriter fileWriter = new FileWriter(manifestFile);
            fileWriter.write("Manifest-Version: 1.0");
            fileWriter.flush();
            fileWriter.close();
            FileUtility.compressArchive((File)tempOutDir, (File)jarFile);
            JaxWsStubGenerator.logInfo("Stub JAR-file '" + jarFileName + "' created");
        }
        catch (Throwable t) {
            JaxWsStubGenerator.logError("Failed to create stub JAR-file '" + jarFileName + "'", t);
        }
    }

    private static void compile(File folder) {
        try {
            File[] javaFiles = JaxWsStubGenerator.getAllJavaFiles(folder);
            File classesDictionary = IOUtility.createTempFile((String)"classes", null, null);
            FileWriter fileWriter = new FileWriter(classesDictionary);
            int i = 0;
            while (i < javaFiles.length) {
                if (i > 0) {
                    fileWriter.write(LINE_SEPARATOR);
                }
                fileWriter.write(javaFiles[i].getAbsolutePath());
                ++i;
            }
            fileWriter.flush();
            fileWriter.close();
            File optionsDictionary = IOUtility.createTempFile((String)"options", null, null);
            fileWriter = new FileWriter(optionsDictionary);
            fileWriter.flush();
            fileWriter.close();
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            int status = compiler.run(System.in, System.out, System.err, "@" + optionsDictionary.getAbsolutePath(), "@" + classesDictionary.getAbsolutePath());
            if (status == 0) {
                JaxWsStubGenerator.logInfo("All the " + javaFiles.length + " stub files compiled");
            } else {
                JaxWsStubGenerator.logError("Failed to compile JAX-WS stub files");
            }
        }
        catch (Throwable t) {
            JaxWsStubGenerator.logError("Failed to compile JAX-WS stub files", t);
        }
    }

    private static File[] getAllJavaFiles(File folder) {
        File[] ff;
        ArrayList<File> files = new ArrayList<File>();
        if (!folder.isDirectory()) {
            return new File[0];
        }
        File[] fileArray = ff = folder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return new File(dir, name).isDirectory() || name.endsWith(".java");
            }
        });
        int n = ff.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                files.addAll(Arrays.asList(JaxWsStubGenerator.getAllJavaFiles(f)));
            } else {
                files.add(f);
            }
            ++n2;
        }
        return files.toArray(new File[files.size()]);
    }

    private static void printModelInformation(String[] properties) {
        try {
            WsimportOptions options = new WsimportOptions();
            options.parseArguments(properties);
            ErrorReceiver receiver = new ErrorReceiver(){

                public void warning(SAXParseException saxparseexception) throws AbortException {
                    JaxWsStubGenerator.logInfo(saxparseexception.toString());
                }

                public void info(SAXParseException saxparseexception) {
                    JaxWsStubGenerator.logInfo(saxparseexception.toString());
                }

                public void fatalError(SAXParseException saxparseexception) throws AbortException {
                    JaxWsStubGenerator.logError(saxparseexception.toString());
                }

                public void error(SAXParseException saxparseexception) throws AbortException {
                    JaxWsStubGenerator.logError(saxparseexception.toString());
                }

                public void debug(SAXParseException saxparseexception) {
                }
            };
            MetadataFinder forest = new MetadataFinder((InternalizationLogic)new WSDLInternalizationLogic(), options, receiver);
            WSDLModeler wsdlModeler = JaxWsStubGenerator.createWsdlModeler(options, receiver, forest);
            if (wsdlModeler == null) {
                JaxWsStubGenerator.logInfo("WSDLModeler could not be created to display service properties");
                return;
            }
            Model wsdlModel = wsdlModeler.buildModel();
            if (wsdlModel == null) {
                JaxWsStubGenerator.logInfo("WSDL model could not be parsed to display service properties");
                return;
            }
            if (wsdlModel.getName() != null) {
                JaxWsStubGenerator.logInfo("wsdl model name=" + wsdlModel.getName().getLocalPart());
            }
            JaxWsStubGenerator.logInfo("targetNamespace=" + wsdlModel.getTargetNamespaceURI());
            List services = wsdlModel.getServices();
            for (Service service : services) {
                JaxWsStubGenerator.logInfo("service=" + service.getName());
                List ports = service.getPorts();
                for (Port port : ports) {
                    JaxWsStubGenerator.logInfo("  port=" + port.getName());
                }
            }
        }
        catch (Throwable e) {
            JaxWsStubGenerator.logError("WSDL model could not be parsed to display service properties: " + e.getMessage());
        }
    }

    private static WSDLModeler createWsdlModeler(WsimportOptions options, ErrorReceiver receiver, MetadataFinder forest) {
        Constructor<?>[] constructorArray = WSDLModeler.class.getConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> c = constructorArray[n2];
            try {
                Class<?>[] paramTypes = c.getParameterTypes();
                if (paramTypes.length == 2 && paramTypes[0].isAssignableFrom(WsimportOptions.class) && paramTypes[1].isAssignableFrom(ErrorReceiver.class)) {
                    return (WSDLModeler)c.newInstance(options, receiver);
                }
                if (paramTypes.length == 3 && paramTypes[0].isAssignableFrom(WsimportOptions.class) && paramTypes[1].isAssignableFrom(ErrorReceiver.class) && paramTypes[2].isAssignableFrom(MetadataFinder.class)) {
                    return (WSDLModeler)c.newInstance(options, receiver, forest);
                }
            }
            catch (Exception e) {
                JaxWsStubGenerator.logError("Error creating WSDLModeler: " + e.getMessage());
            }
            ++n2;
        }
        return null;
    }

    private static void logInfo(String message) {
        System.out.println("[INFO] " + message);
    }

    private static void logInfo(ByteArrayOutputStream os) {
        System.out.println("[INFO] " + JaxWsStubGenerator.convertToString(os));
    }

    private static void logError(String message) {
        System.err.println("[ERROR] " + message);
    }

    private static void logError(ByteArrayOutputStream os) {
        System.err.println("[ERROR] " + JaxWsStubGenerator.convertToString(os));
    }

    private static void logError(String message, Throwable t) {
        if (message != null) {
            System.err.println("[ERROR] " + JaxWsStubGenerator.getStacktrace(t));
        } else {
            System.err.println("[ERROR] " + message + LINE_SEPARATOR + JaxWsStubGenerator.getStacktrace(t));
        }
    }

    private static String convertToString(ByteArrayOutputStream os) {
        try {
            return os.toString("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "Could not access log message due to unsupported encoding.";
        }
    }

    private static String getStacktrace(Throwable t) {
        if (t == null) {
            return null;
        }
        StringWriter writer = new StringWriter();
        t.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }
}

