/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.simple.operations;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.scout.nls.sdk.simple.operations.NewNlsFileOperationDesc;
import org.eclipse.scout.sdk.util.ResourcesUtility;

public abstract class AbstractCreateNlsProjectOperation
extends Job {
    protected final String NL;
    protected static final String NLS_RUNNTIME_PLUGIN = "org.eclipse.scout.commons";
    private final NewNlsFileOperationDesc m_desc;

    protected AbstractCreateNlsProjectOperation(NewNlsFileOperationDesc desc) {
        super("Create new NLS Project...");
        this.m_desc = desc;
        this.NL = ResourcesUtility.getLineSeparator((IResource)this.m_desc.getPlugin());
    }

    public final IStatus runSync() {
        return this.run((IProgressMonitor)new NullProgressMonitor());
    }

    protected NewNlsFileOperationDesc getDesc() {
        return this.m_desc;
    }

    protected void createJavaClass(IProject plugin, IPath srcContainer, String packageName, String javaClassName, byte[] classContent, IProgressMonitor monitor) throws CoreException {
        IJavaProject jp = JavaCore.create((IProject)plugin);
        IPackageFragmentRoot root = jp.findPackageFragmentRoot(srcContainer);
        IPackageFragment fragment = root.createPackageFragment(packageName, true, monitor);
        String className = javaClassName;
        if (!className.endsWith(".java")) {
            className = String.valueOf(className) + ".java";
        }
        ICompilationUnit unit = fragment.createCompilationUnit(className, "", true, monitor);
        Assert.isTrue((boolean)(unit.getUnderlyingResource() instanceof IFile));
        IFile classFile = (IFile)unit.getUnderlyingResource();
        classFile.setContents((InputStream)new ByteArrayInputStream(classContent), true, false, monitor);
    }
}

