/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.ui.action;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.scout.nls.sdk.internal.NlsCore;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProject;
import org.eclipse.scout.nls.sdk.util.concurrent.AbstractJob;

public class RemoveAction
extends Action {
    private INlsProject m_nlsProject;
    private IStatus m_status;
    private final INlsEntry[] m_entries;

    public RemoveAction(String name, INlsProject project, INlsEntry entry) {
        this(name, project, new INlsEntry[]{entry});
    }

    public RemoveAction(String name, INlsProject project, INlsEntry[] entries) {
        super(name);
        this.m_nlsProject = project;
        this.m_entries = entries;
        this.setImageDescriptor(NlsCore.getImageDescriptor("text_remove"));
    }

    public void run() {
        AbstractJob job = new AbstractJob("update translations"){

            protected IStatus run(IProgressMonitor monitor) {
                return RemoveAction.this.m_nlsProject.removeEntries(RemoveAction.this.m_entries, monitor);
            }
        };
        job.setUser(false);
        job.schedule();
        try {
            job.join();
            this.m_status = job.getResult();
        }
        catch (InterruptedException e) {
            NlsCore.logError("cold not remove the row key: " + RemoveAction.getVerbose(this.m_entries) + " in translation resources", e);
        }
    }

    private static String getVerbose(INlsEntry[] entries) {
        if (entries == null) {
            return "[no entries]";
        }
        StringBuilder builder = new StringBuilder("[");
        int i = 0;
        while (i < entries.length) {
            builder.append("'" + entries[i].getKey() + "'");
            if (i + 1 != entries.length) {
                builder.append(", ");
            }
            ++i;
        }
        builder.append("]");
        return builder.toString();
    }

    public IStatus getStatus() {
        return this.m_status;
    }
}

