/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.servicetunnel.http.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.job.JobEx;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.osgi.BundleInspector;
import org.eclipse.scout.rt.client.ClientJob;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.servicetunnel.AbstractServiceTunnel;
import org.eclipse.scout.rt.client.servicetunnel.http.internal.ClientNotificationPollingJob;
import org.eclipse.scout.rt.client.servicetunnel.http.internal.HttpBackgroundJob;
import org.eclipse.scout.rt.shared.ScoutTexts;
import org.eclipse.scout.rt.shared.services.common.processing.IServerProcessingCancelService;
import org.eclipse.scout.rt.shared.servicetunnel.DefaultServiceTunnelContentHandler;
import org.eclipse.scout.rt.shared.servicetunnel.IServiceTunnelContentHandler;
import org.eclipse.scout.rt.shared.servicetunnel.ServiceTunnelRequest;
import org.eclipse.scout.rt.shared.servicetunnel.ServiceTunnelResponse;

public class InternalHttpServiceTunnel
extends AbstractServiceTunnel {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(InternalHttpServiceTunnel.class);
    private IServiceTunnelContentHandler m_contentHandler;
    private ClientNotificationPollingJob m_pollingJob;
    private final Object m_pollingJobLock = new Object();

    public InternalHttpServiceTunnel(IClientSession session, String url) throws ProcessingException {
        this(session, url, null);
    }

    public InternalHttpServiceTunnel(IClientSession session, String url, String version) throws ProcessingException {
        super(session, version);
        try {
            if (url != null) {
                this.setServerURL(new URL(url));
            }
        }
        catch (MalformedURLException e) {
            throw new ProcessingException(url, (Throwable)e);
        }
    }

    @Override
    public void setAnalyzeNetworkLatency(boolean b) {
        super.setAnalyzeNetworkLatency(b);
        this.updatePollingJobInternal();
    }

    @Override
    public void setClientNotificationPollInterval(long intervallMillis) {
        super.setClientNotificationPollInterval(intervallMillis);
        this.updatePollingJobInternal();
    }

    protected URLConnection createURLConnection(ServiceTunnelRequest call, byte[] callData) throws IOException {
        if (this.getServerURL().getProtocol().startsWith("file")) {
            throw new IOException("File connection is not supporting HTTP: " + this.getServerURL());
        }
        URLConnection urlConn = this.getServerURL().openConnection();
        String contentType = "text/xml";
        urlConn.setRequestProperty("Content-type", contentType);
        urlConn.setDoOutput(true);
        urlConn.setDoInput(true);
        urlConn.setDefaultUseCaches(false);
        urlConn.setUseCaches(false);
        this.addCustomHeaders(urlConn, "POST");
        OutputStream httpOut = urlConn.getOutputStream();
        httpOut.write(callData);
        httpOut.close();
        httpOut = null;
        return urlConn;
    }

    protected void addCustomHeaders(URLConnection urlConn, String method) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePollingJobInternal() {
        Object object = this.m_pollingJobLock;
        synchronized (object) {
            long p = this.getClientNotificationPollInterval();
            boolean b = this.isAnalyzeNetworkLatency();
            if (p > 0L) {
                if (this.m_pollingJob == null) {
                    this.m_pollingJob = new ClientNotificationPollingJob(this.getClientSession(), p, b);
                    this.m_pollingJob.schedule();
                } else {
                    this.m_pollingJob.updatePollingValues(p, b);
                }
            } else if (this.m_pollingJob != null) {
                this.m_pollingJob.cancel();
                this.m_pollingJob = null;
            }
        }
    }

    public IServiceTunnelContentHandler getContentHandler() {
        return this.m_contentHandler;
    }

    public void setContentHandler(IServiceTunnelContentHandler e) {
        this.m_contentHandler = e;
    }

    @Override
    public Object invokeService(Class serviceInterfaceClass, Method operation, Object[] callerArgs) throws ProcessingException {
        if (this.m_contentHandler == null) {
            this.m_contentHandler = new DefaultServiceTunnelContentHandler();
            String prefix = this.getClientSession().getClass().getPackage().getName().replaceAll("^(.*\\.)(client|shared|server)(\\.core)?.*$", "$1");
            this.m_contentHandler.initialize(BundleInspector.getOrderedBundleList((String[])new String[]{prefix, "org.eclipse.scout."}), this.getClientSession().getClass().getClassLoader());
        }
        return super.invokeService(serviceInterfaceClass, operation, callerArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ServiceTunnelResponse tunnelOnline(ServiceTunnelRequest req) {
        if (ClientJob.isCurrentJobCanceled()) {
            return new ServiceTunnelResponse(null, null, (Throwable)new InterruptedException(ScoutTexts.get((String)"UserInterrupted", (String[])new String[0])));
        }
        Object backgroundLock = new Object();
        HttpBackgroundJob backgroundJob = new HttpBackgroundJob(ScoutTexts.get((String)"ServerCallProcessing", (String[])new String[0]), req, backgroundLock, this);
        this.decorateBackgroundJob(req, (Job)backgroundJob);
        ServiceTunnelResponse res = null;
        boolean cancelled = false;
        boolean sentCancelRequest = false;
        Object object = backgroundLock;
        synchronized (object) {
            backgroundJob.schedule();
            while ((res = backgroundJob.getResponse()) == null) {
                IProgressMonitor mon = backgroundJob.getMonitor();
                if (!sentCancelRequest && JobEx.isCurrentJobCanceled() || mon != null && mon.isCanceled()) {
                    sentCancelRequest = true;
                    boolean success = this.sendCancelRequest(req.getRequestSequence());
                    if (success) {
                        cancelled = true;
                        break;
                    }
                }
                if (backgroundJob.getState() == 0) break;
                try {
                    backgroundLock.wait(500L);
                    continue;
                }
                catch (InterruptedException interruptedException) {}
                break;
            }
        }
        if (res == null || cancelled) {
            return new ServiceTunnelResponse(null, null, (Throwable)new InterruptedException(ScoutTexts.get((String)"UserInterrupted", (String[])new String[0])));
        }
        return res;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean sendCancelRequest(long requestSequence) {
        try {
            ServiceTunnelRequest cancelCall = new ServiceTunnelRequest(this.getVersion(), IServerProcessingCancelService.class, IServerProcessingCancelService.class.getMethod("cancel", Long.TYPE), new Object[]{requestSequence});
            cancelCall.setClientSubject(this.getClientSession().getSubject());
            cancelCall.setVirtualSessionId(this.getClientSession().getVirtualSessionId());
            cancelCall.setUserAgent(this.getClientSession().getUserAgent().createIdentifier());
            HttpBackgroundJob cancelHttpJob = new HttpBackgroundJob(ScoutTexts.get((String)"ServerCallCancelProcessing", (String[])new String[0]), cancelCall, new Object(), this);
            cancelHttpJob.setSystem(true);
            cancelHttpJob.schedule();
            try {
                cancelHttpJob.join(10000L);
                ServiceTunnelResponse cancelResult = cancelHttpJob.getResponse();
                if (cancelResult == null) {
                    return false;
                }
                if (cancelResult.getException() != null) {
                    LOG.warn("cancel failed", cancelResult.getException());
                    return false;
                }
                Boolean result = (Boolean)cancelResult.getData();
                return result != null && result != false;
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        catch (Throwable e) {
            LOG.warn("failed to cancel server processing", e);
            return false;
        }
    }

    protected void decorateBackgroundJob(ServiceTunnelRequest call, Job backgroundJob) {
        backgroundJob.setUser(false);
        backgroundJob.setSystem(true);
    }

    protected void preprocessHttpRepsonse(URLConnection urlConn, ServiceTunnelRequest call, int httpCode) {
    }
}

