/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.CompositeObject;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.ClientUIPreferences;
import org.eclipse.scout.rt.client.ui.basic.table.AbstractTable;
import org.eclipse.scout.rt.client.ui.basic.table.HeaderCell;
import org.eclipse.scout.rt.client.ui.basic.table.TableEvent;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IStringColumn;
import org.eclipse.scout.rt.shared.data.basic.table.SortSpec;

public class ColumnSet {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ColumnSet.class);
    private final AbstractTable m_table;
    private final IColumn[] m_columns;
    private final ArrayList<IColumn> m_userSortColumns;
    private final ArrayList<IColumn> m_permanentHeadSortColumns;
    private final ArrayList<IColumn> m_permanentTailSortColumns;
    private int[] m_keyIndexes = new int[0];
    private int[] m_displayableIndexes = new int[0];
    private int[] m_visibleIndexes = new int[0];
    private final HashMap<Class, IColumn> m_classIndexes = new HashMap();
    private final HashMap<String, IColumn> m_idIndexes = new HashMap();

    public ColumnSet(AbstractTable table, Collection<IColumn> columns) {
        this.m_table = table;
        this.m_columns = new IColumn[columns.size()];
        this.m_userSortColumns = new ArrayList();
        this.m_permanentHeadSortColumns = new ArrayList();
        this.m_permanentTailSortColumns = new ArrayList();
        PropertyChangeListener columnListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                IColumn c = (IColumn)e.getSource();
                if (!"viewColumnIndexHint".equals(e.getPropertyName())) {
                    if ("viewOrder".equals(e.getPropertyName())) {
                        ColumnSet.this.resetColumnsViewOrder();
                    } else {
                        ColumnSet.this.updateColumnStructure(c);
                    }
                }
            }
        };
        int index = 0;
        for (IColumn col : columns) {
            if (col instanceof AbstractColumn) {
                ((AbstractColumn)col).setColumnIndexInternal(index);
                ((AbstractColumn)col).setTableInternal(this.m_table);
            }
            this.rebuildHeaderCell(col);
            this.m_columns[index] = col;
            this.m_classIndexes.put(col.getClass(), col);
            this.m_idIndexes.put(col.getColumnId(), col);
            col.addPropertyChangeListener(columnListener);
            ++index;
        }
        this.reorganizeIndexes();
    }

    /*
     * WARNING - void declaration
     */
    public void initialize() {
        IColumn col2;
        void var5_6;
        ClientUIPreferences prefs = ClientUIPreferences.getInstance();
        int n = this.getColumnCount();
        TreeMap<CompositeObject, Object> sortMap = new TreeMap<CompositeObject, Object>();
        int viewIndex = 0;
        boolean bl = false;
        while (var5_6 < n) {
            IColumn col2 = this.getColumn((int)var5_6);
            double viewHint = col2.getVisibleColumnIndexHint();
            if (viewHint < 0.0) {
                viewHint = col2.getViewOrder();
            }
            if (viewHint < 0.0) {
                viewHint = viewIndex;
            }
            sortMap.put(new CompositeObject(new Object[]{viewHint, viewIndex}), col2);
            ++viewIndex;
            ++var5_6;
        }
        viewIndex = 0;
        for (Map.Entry entry : sortMap.entrySet()) {
            ((IColumn)entry.getValue()).setVisibleColumnIndexHint(viewIndex);
            ++viewIndex;
        }
        this.reorganizeIndexes();
        sortMap.clear();
        boolean bl2 = false;
        IColumn[] iColumnArray = this.getColumns();
        int n2 = iColumnArray.length;
        int n4 = 0;
        while (n4 < n2) {
            void var5_9;
            col2 = iColumnArray[n4];
            int sortIndex = -1;
            if (col2.isInitialAlwaysIncludeSortAtBegin()) {
                sortIndex = col2.getInitialSortIndex();
                if (sortIndex < 0) {
                    LOG.warn("AlwaysIncludeSortAtBegin is set but no sort index configured. Table: " + this.m_table.getClass().getName());
                }
            } else if (col2.isInitialAlwaysIncludeSortAtEnd()) {
                sortIndex = col2.getInitialSortIndex();
                if (sortIndex < 0) {
                    LOG.warn("AlwaysIncludeSortAtEnd is set but no sort index configured. Table: " + this.m_table.getClass().getName());
                }
            } else {
                sortIndex = prefs.getTableColumnSortIndex(col2, col2.getInitialSortIndex());
            }
            if (sortIndex >= 0) {
                sortMap.put(new CompositeObject(new Object[]{sortIndex, (int)var5_9}), col2);
            }
            ++var5_9;
            ++n4;
        }
        this.clearSortColumns();
        this.clearPermanentHeadSortColumns();
        this.clearPermanentTailSortColumns();
        for (IColumn col2 : sortMap.values()) {
            boolean asc;
            if (col2.isInitialAlwaysIncludeSortAtBegin()) {
                asc = col2.isInitialSortAscending();
                this.addPermanentHeadSortColumn(col2, asc);
                continue;
            }
            if (col2.isInitialAlwaysIncludeSortAtEnd()) {
                asc = col2.isInitialSortAscending();
                this.addPermanentTailSortColumn(col2, asc);
                continue;
            }
            asc = prefs.getTableColumnSortAscending(col2, col2.isInitialSortAscending());
            this.addSortColumn(col2, asc);
        }
        iColumnArray = this.getUserSortColumns();
        n2 = iColumnArray.length;
        int n3 = 0;
        while (n3 < n2) {
            col2 = iColumnArray[n3];
            Boolean explicit = prefs.getTableColumnSortExplicit(col2);
            if (explicit != null) {
                HeaderCell cell = (HeaderCell)col2.getHeaderCell();
                cell.setSortExplicit(explicit);
            }
            ++n3;
        }
        if (this.getVisibleColumnCount() == 0) {
            viewIndex = 0;
            iColumnArray = this.getColumns();
            n2 = iColumnArray.length;
            n3 = 0;
            while (n3 < n2) {
                IColumn c = iColumnArray[n3];
                if (c.isDisplayable() && c.isInitialVisible()) {
                    c.setVisible(true);
                } else {
                    c.setVisible(false);
                }
                c.setWidth(c.getInitialWidth());
                c.setVisibleColumnIndexHint(viewIndex);
                prefs.removeTableColumnPreferences(c);
                ++viewIndex;
                ++n3;
            }
            this.reorganizeIndexes();
        }
        this.checkMultiline();
    }

    public int getColumnCount() {
        return this.m_columns.length;
    }

    public int getKeyColumnCount() {
        return this.m_keyIndexes.length;
    }

    public int getDisplayableColumnCount() {
        return this.m_displayableIndexes.length;
    }

    public int getVisibleColumnCount() {
        return this.m_visibleIndexes.length;
    }

    public int[] getKeyColumnIndexes() {
        int[] a = new int[this.m_keyIndexes.length];
        System.arraycopy(this.m_keyIndexes, 0, a, 0, a.length);
        return a;
    }

    public int[] getAllColumnIndexes() {
        int[] a = new int[this.m_columns.length];
        int i = 0;
        while (i < a.length) {
            a[i] = i;
            ++i;
        }
        return a;
    }

    public IColumn[] getAllColumnsInUserOrder() {
        double[] visibleOrdersSorted = new double[this.getVisibleColumnCount()];
        IColumn[] visibleCols = this.getVisibleColumns();
        int i = 0;
        while (i < visibleOrdersSorted.length) {
            visibleOrdersSorted[i] = visibleCols[i].getViewOrder();
            ++i;
        }
        Arrays.sort(visibleOrdersSorted);
        int counter = 0;
        TreeMap<CompositeObject, IColumn> sortMap = new TreeMap<CompositeObject, IColumn>();
        int i2 = 0;
        while (i2 < visibleCols.length) {
            sortMap.put(new CompositeObject(new Object[]{visibleOrdersSorted[i2], counter++}), visibleCols[i2]);
            ++i2;
        }
        IColumn[] iColumnArray = this.getColumns();
        int n = iColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            IColumn column = iColumnArray[n2];
            if (!column.isDisplayable() || !column.isVisible()) {
                sortMap.put(new CompositeObject(new Object[]{column.getViewOrder(), counter++}), column);
            }
            ++n2;
        }
        return sortMap.values().toArray(new IColumn[sortMap.size()]);
    }

    public int[] getDisplayableColumnIndexes() {
        int[] a = new int[this.m_displayableIndexes.length];
        System.arraycopy(this.m_displayableIndexes, 0, a, 0, a.length);
        return a;
    }

    public int[] getVisibleColumnIndexes() {
        int[] a = new int[this.m_visibleIndexes.length];
        System.arraycopy(this.m_visibleIndexes, 0, a, 0, a.length);
        return a;
    }

    public int getKeyColumnIndex(int keyIndex) {
        return this.m_keyIndexes[keyIndex];
    }

    public int getDisplayableColumnIndex(int displayableIndex) {
        return this.m_displayableIndexes[displayableIndex];
    }

    public int getVisibleColumnIndex(int visibleIndex) {
        return this.m_visibleIndexes[visibleIndex];
    }

    public IColumn getColumn(int index) {
        if (index >= 0 && index < this.m_columns.length) {
            return this.m_columns[index];
        }
        return null;
    }

    public <T extends IColumn> T getColumnByClass(Class<T> c) {
        IColumn col = this.m_classIndexes.get(c);
        return (T)col;
    }

    public <T extends IColumn> T getColumnById(String id) {
        return (T)this.m_idIndexes.get(id);
    }

    public IColumn getDisplayableColumn(int index) {
        if (index >= 0 && index < this.m_displayableIndexes.length) {
            return this.m_columns[this.m_displayableIndexes[index]];
        }
        return null;
    }

    public IColumn getVisibleColumn(int index) {
        if (index >= 0 && index < this.m_visibleIndexes.length) {
            return this.m_columns[this.m_visibleIndexes[index]];
        }
        return null;
    }

    public IColumn[] getColumns() {
        IColumn[] a = new IColumn[this.m_columns.length];
        System.arraycopy(this.m_columns, 0, a, 0, this.m_columns.length);
        return a;
    }

    public IColumn[] getKeyColumns() {
        IColumn[] a = new IColumn[this.m_keyIndexes.length];
        int i = 0;
        while (i < this.m_keyIndexes.length) {
            a[i] = this.getColumn(this.m_keyIndexes[i]);
            ++i;
        }
        return a;
    }

    public IColumn[] getDisplayableColumns() {
        IColumn[] a = new IColumn[this.m_displayableIndexes.length];
        int i = 0;
        while (i < this.m_displayableIndexes.length) {
            a[i] = this.getColumn(this.m_displayableIndexes[i]);
            ++i;
        }
        return a;
    }

    public IColumn[] getVisibleColumns() {
        IColumn[] a = new IColumn[this.m_visibleIndexes.length];
        int i = 0;
        while (i < this.m_visibleIndexes.length) {
            a[i] = this.getColumn(this.m_visibleIndexes[i]);
            ++i;
        }
        return a;
    }

    public IColumn getFirstVisibleColumn() {
        if (this.m_visibleIndexes.length > 0) {
            return this.m_columns[this.m_visibleIndexes[0]];
        }
        return null;
    }

    public IColumn getFirstDefinedVisibileColumn() {
        int colIdx = this.m_columns.length;
        int i = 0;
        while (i < this.m_visibleIndexes.length) {
            if (CompareUtility.compareTo((Comparable)Integer.valueOf(this.m_visibleIndexes[i]), (Comparable)Integer.valueOf(colIdx)) < 0) {
                colIdx = this.m_visibleIndexes[i];
            }
            ++i;
        }
        if (colIdx != this.m_columns.length) {
            return this.m_columns[colIdx];
        }
        return null;
    }

    public IColumn[] getSummaryColumns() {
        ArrayList<IColumn> list = new ArrayList<IColumn>();
        IColumn[] iColumnArray = this.getColumns();
        int n = iColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            IColumn c = iColumnArray[n2];
            if (c.isSummary()) {
                list.add(c);
            }
            ++n2;
        }
        return list.toArray(new IColumn[0]);
    }

    public int getIndexFor(IColumn column) {
        int i = 0;
        while (i < this.m_columns.length) {
            if (this.m_columns[i] == column) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void moveColumnToVisibleIndex(int fromIndex, int toVisibleIndex) {
        int fromVisibleIndex = this.modelToVisibleIndex(fromIndex);
        if (fromVisibleIndex >= 0 && toVisibleIndex >= 0) {
            this.moveVisibleColumnToVisibleIndex(fromVisibleIndex, toVisibleIndex);
        }
    }

    public void moveVisibleColumnToVisibleIndex(int fromVisibleIndex, int toVisibleIndex) {
        if (fromVisibleIndex != toVisibleIndex) {
            IColumn fromCol = this.getVisibleColumn(fromVisibleIndex);
            IColumn toCol = this.getVisibleColumn(toVisibleIndex);
            if (fromCol != null && toCol != null) {
                boolean traversedFrom = false;
                ArrayList<IColumn> list = new ArrayList<IColumn>();
                IColumn[] iColumnArray = this.getAllColumnsInUserOrder();
                int n = iColumnArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IColumn c = iColumnArray[n2];
                    if (c == fromCol) {
                        traversedFrom = true;
                    } else if (c == toCol) {
                        if (traversedFrom) {
                            list.add(c);
                            list.add(fromCol);
                        } else {
                            list.add(fromCol);
                            list.add(c);
                        }
                    } else {
                        list.add(c);
                    }
                    ++n2;
                }
                int viewHint = 0;
                for (IColumn c : list) {
                    c.setVisibleColumnIndexHint(viewHint);
                    ++viewHint;
                }
                this.reorganizeIndexes();
                this.fireColumnOrderChanged();
            }
        }
    }

    public void setVisibleColumns(IColumn[] columns) {
        try {
            this.m_table.setTableChanging(true);
            IColumn[] resolvedColumns = this.resolveColumns(columns);
            if (resolvedColumns.length > 0) {
                IColumn[] a;
                ArrayList<IColumn> newColumns = new ArrayList<IColumn>();
                IColumn[] iColumnArray = columns;
                int n = columns.length;
                int n2 = 0;
                while (n2 < n) {
                    IColumn col = iColumnArray[n2];
                    if (col.isDisplayable()) {
                        if (col.getInitialWidth() == 0 && col.getWidth() == 0) {
                            col.setInitialWidth(60);
                            col.setWidth(60);
                        }
                        newColumns.add(col);
                    }
                    ++n2;
                }
                int viewHint = 0;
                int nextNewIndex = 0;
                IColumn[] iColumnArray2 = this.getAllColumnsInUserOrder();
                int n3 = iColumnArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IColumn col = iColumnArray2[n4];
                    if (newColumns.contains(col)) {
                        IColumn nextSortedCol = (IColumn)newColumns.get(nextNewIndex);
                        ++nextNewIndex;
                        nextSortedCol.setVisible(true);
                        nextSortedCol.setVisibleColumnIndexHint(viewHint);
                    } else {
                        col.setVisible(false);
                        col.setVisibleColumnIndexHint(viewHint);
                    }
                    ++viewHint;
                    ++n4;
                }
                this.reorganizeIndexes();
                IColumn[] iColumnArray3 = a = this.getDisplayableColumns();
                int n5 = a.length;
                n3 = 0;
                while (n3 < n5) {
                    IColumn col = iColumnArray3[n3];
                    this.rebuildHeaderCell(col);
                    ++n3;
                }
                this.fireColumnHeadersUpdated(a);
                this.fireColumnStructureChanged();
                this.checkMultiline();
            }
        }
        finally {
            this.m_table.setTableChanging(false);
        }
    }

    private int visibleToModelIndex(int visibleIndex) {
        if (visibleIndex < 0 || visibleIndex >= this.m_visibleIndexes.length) {
            LOG.warn("viewIndex " + visibleIndex + " out of range [" + 0 + "," + (this.m_visibleIndexes.length - 1) + "]");
            return -1;
        }
        return this.m_visibleIndexes[visibleIndex];
    }

    private int keyToModelIndex(int keyIndex) {
        if (keyIndex < 0 || keyIndex >= this.m_keyIndexes.length) {
            LOG.warn("keyIndex " + keyIndex + " out of range [" + 0 + "," + (this.m_keyIndexes.length - 1) + "]");
            return -1;
        }
        return this.m_keyIndexes[keyIndex];
    }

    private int modelToVisibleIndex(int index) {
        int i = 0;
        while (i < this.m_visibleIndexes.length) {
            if (this.m_visibleIndexes[i] == index) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public IColumn resolveColumn(IColumn c) {
        if (c.getTable() == this.m_table) {
            return c;
        }
        return null;
    }

    public IColumn[] resolveColumns(IColumn[] a) {
        ArrayList<IColumn> list = new ArrayList<IColumn>();
        if (a != null) {
            IColumn[] iColumnArray = a;
            int n = a.length;
            int n2 = 0;
            while (n2 < n) {
                IColumn col = iColumnArray[n2];
                IColumn resolvedCol = this.resolveColumn(col);
                if (resolvedCol != null) {
                    list.add(resolvedCol);
                }
                ++n2;
            }
        }
        return list.toArray(new IColumn[0]);
    }

    public void handleSortEvent(IColumn col, boolean multiSort) {
        if ((col = this.resolveColumn(col)) == null) {
            return;
        }
        try {
            this.m_table.setTableChanging(true);
            if (multiSort) {
                if (this.isSortColumn(col) && col.isSortExplicit()) {
                    this.toggleSortColumn(col);
                } else {
                    this.addSortColumn(col, true);
                }
            } else {
                int explicitCount = 0;
                for (IColumn c : this.m_userSortColumns) {
                    if (!c.isSortExplicit()) continue;
                    ++explicitCount;
                }
                if (this.isSortColumn(col) && col.isSortExplicit() && explicitCount == 1) {
                    this.toggleSortColumn(col);
                } else {
                    this.setSortColumn(col, true, 5);
                }
            }
        }
        finally {
            this.m_table.setTableChanging(false);
        }
    }

    public int getSortColumnCount() {
        return this.m_userSortColumns.size() + this.m_permanentHeadSortColumns.size() + this.m_permanentTailSortColumns.size();
    }

    public IColumn[] getSortColumns() {
        ArrayList<IColumn> list = new ArrayList<IColumn>(this.getSortColumnCount());
        list.addAll(this.m_permanentHeadSortColumns);
        list.addAll(this.m_userSortColumns);
        list.addAll(this.m_permanentTailSortColumns);
        return list.toArray(new IColumn[list.size()]);
    }

    public IColumn<?>[] getUserSortColumns() {
        return this.m_userSortColumns.toArray(new IColumn[this.m_userSortColumns.size()]);
    }

    public IColumn<?>[] getPermanentHeadSortColumns() {
        return this.m_permanentHeadSortColumns.toArray(new IColumn[this.m_permanentHeadSortColumns.size()]);
    }

    public IColumn<?>[] getPermanentTailSortColumns() {
        return this.m_permanentTailSortColumns.toArray(new IColumn[this.m_permanentTailSortColumns.size()]);
    }

    public SortSpec getSortSpec() {
        ArrayList<IColumn> sortColumns = new ArrayList<IColumn>();
        IColumn[] iColumnArray = this.getSortColumns();
        int n = iColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            IColumn c = iColumnArray[n2];
            if (c.isSortExplicit()) {
                sortColumns.add(c);
            }
            ++n2;
        }
        if (sortColumns.size() > 0) {
            int[] indexes = new int[sortColumns.size()];
            boolean[] asc = new boolean[sortColumns.size()];
            int i = 0;
            while (i < sortColumns.size()) {
                indexes[i] = ((IColumn)sortColumns.get(i)).getColumnIndex();
                asc[i] = ((IColumn)sortColumns.get(i)).isSortAscending();
                ++i;
            }
            return new SortSpec(indexes, asc);
        }
        return null;
    }

    public void setSortSpec(SortSpec spec) {
        if (spec != null) {
            for (IColumn col : this.m_userSortColumns) {
                HeaderCell cell = (HeaderCell)col.getHeaderCell();
                cell.setSortActive(false);
                cell.setSortAscending(false);
                cell.setSortExplicit(false);
            }
            this.m_userSortColumns.clear();
            ArrayList<IColumn> colList = new ArrayList<IColumn>();
            int i = 0;
            while (i < spec.size()) {
                IColumn col = this.getColumn(spec.getColumnIndex(i));
                if (col != null && !this.isSortColumn(col)) {
                    HeaderCell cell = (HeaderCell)col.getHeaderCell();
                    cell.setSortActive(true);
                    cell.setSortExplicit(true);
                    cell.setSortAscending(spec.isColumnAscending(i));
                    colList.add(col);
                }
                ++i;
            }
            this.m_userSortColumns.addAll(colList);
            for (IColumn col : colList) {
                this.rebuildHeaderCell(col);
            }
            this.fireColumnHeadersUpdated(colList.toArray(new IColumn[0]));
        } else {
            this.clearSortColumns();
        }
    }

    public boolean isSortColumn(IColumn col) {
        return this.m_permanentHeadSortColumns.contains(col) || this.m_userSortColumns.contains(col) || this.m_permanentTailSortColumns.contains(col);
    }

    public boolean isUserSortColumn(IColumn<?> col) {
        return this.m_userSortColumns.contains(col);
    }

    public boolean isPermanentHeadSortColumn(IColumn<?> col) {
        return this.m_permanentHeadSortColumns.contains(col);
    }

    public boolean isPermanentTailSortColumn(IColumn<?> col) {
        return this.m_permanentTailSortColumns.contains(col);
    }

    public int getSortColumnIndex(IColumn col) {
        if (this.isPermanentHeadSortColumn(col)) {
            return this.m_permanentHeadSortColumns.indexOf(col);
        }
        if (this.isUserSortColumn(col)) {
            return this.m_permanentHeadSortColumns.size() + this.m_userSortColumns.indexOf(col);
        }
        if (this.isPermanentTailSortColumn(col)) {
            return this.m_permanentHeadSortColumns.size() + this.m_userSortColumns.size() + this.m_permanentTailSortColumns.indexOf(col);
        }
        return -1;
    }

    public void setSortColumn(IColumn col, boolean ascending, int keepHistoryCount) {
        if ((col = this.resolveColumn(col)) != null) {
            this.m_userSortColumns.remove(col);
            if (!this.isSortColumn(col)) {
                while (this.m_userSortColumns.size() > keepHistoryCount) {
                    IColumn c = this.m_userSortColumns.remove(this.m_userSortColumns.size() - 1);
                    HeaderCell cell = (HeaderCell)c.getHeaderCell();
                    cell.setSortActive(false);
                    cell.setSortExplicit(false);
                    cell.setSortAscending(false);
                    this.rebuildHeaderCell(c);
                }
                for (IColumn c : this.m_userSortColumns) {
                    HeaderCell cell = (HeaderCell)c.getHeaderCell();
                    cell.setSortExplicit(false);
                    this.rebuildHeaderCell(c);
                }
                HeaderCell cell = (HeaderCell)col.getHeaderCell();
                cell.setSortActive(true);
                cell.setSortExplicit(true);
                cell.setSortAscending(ascending);
                this.m_userSortColumns.add(0, col);
                this.rebuildHeaderCell(col);
                this.fireColumnHeadersUpdated(new IColumn[]{col});
            }
        }
    }

    public void addSortColumn(IColumn col, boolean ascending) {
        if ((col = this.resolveColumn(col)) != null) {
            this.m_userSortColumns.remove(col);
            if (!this.isSortColumn(col)) {
                Iterator<IColumn> it = this.m_userSortColumns.iterator();
                while (it.hasNext()) {
                    IColumn c = it.next();
                    if (c.isSortExplicit()) continue;
                    it.remove();
                    HeaderCell cell = (HeaderCell)c.getHeaderCell();
                    cell.setSortActive(false);
                    cell.setSortExplicit(false);
                    cell.setSortAscending(false);
                    this.rebuildHeaderCell(c);
                }
                HeaderCell cell = (HeaderCell)col.getHeaderCell();
                cell.setSortActive(true);
                cell.setSortExplicit(true);
                cell.setSortAscending(ascending);
                this.m_userSortColumns.add(col);
                this.rebuildHeaderCell(col);
                this.fireColumnHeadersUpdated(new IColumn[]{col});
            }
        }
    }

    public void toggleSortColumn(IColumn col) {
        if ((col = this.resolveColumn(col)) != null && this.isSortColumn(col) && !col.isSortPermanent()) {
            HeaderCell cell;
            cell.setSortAscending(!(cell = (HeaderCell)col.getHeaderCell()).isSortAscending());
            this.rebuildHeaderCell(col);
            this.fireColumnHeadersUpdated(new IColumn[]{col});
        }
    }

    private void updateColumnStructure(IColumn column) {
        this.reorganizeIndexes();
        this.checkMultiline();
        this.fireColumnStructureChanged();
    }

    private void resetColumnsViewOrder() {
        IColumn[] iColumnArray = this.getColumns();
        int n = iColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            IColumn c = iColumnArray[n2];
            c.setVisibleColumnIndexHint(-1);
            ++n2;
        }
        this.reorganizeIndexes();
        this.fireColumnOrderChanged();
    }

    public void updateColumn(IColumn column) {
        this.checkMultiline();
        this.fireColumnHeadersUpdated(new IColumn[]{column});
    }

    public void removeSortColumn(IColumn col) {
        if ((col = this.resolveColumn(col)) != null) {
            this.m_userSortColumns.remove(col);
            if (!this.isSortColumn(col)) {
                HeaderCell cell = (HeaderCell)col.getHeaderCell();
                cell.setSortActive(false);
                cell.setSortExplicit(false);
                this.rebuildHeaderCell(col);
                this.fireColumnHeadersUpdated(new IColumn[]{col});
            }
        }
    }

    public void clearSortColumns() {
        if (this.m_userSortColumns.size() == 0) {
            return;
        }
        IColumn[] a = this.m_userSortColumns.toArray(new IColumn[this.m_userSortColumns.size()]);
        this.m_userSortColumns.clear();
        IColumn[] iColumnArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            IColumn col = iColumnArray[n2];
            HeaderCell cell = (HeaderCell)col.getHeaderCell();
            cell.setSortActive(false);
            cell.setSortExplicit(false);
            ++n2;
        }
        iColumnArray = a;
        n = a.length;
        n2 = 0;
        while (n2 < n) {
            IColumn c = iColumnArray[n2];
            this.rebuildHeaderCell(c);
            ++n2;
        }
        this.fireColumnHeadersUpdated(a);
    }

    public void clearPermanentHeadSortColumns() {
        if (this.m_permanentHeadSortColumns.size() == 0) {
            return;
        }
        IColumn[] a = this.m_permanentHeadSortColumns.toArray(new IColumn[this.m_permanentHeadSortColumns.size()]);
        this.m_permanentHeadSortColumns.clear();
        IColumn[] iColumnArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            IColumn col = iColumnArray[n2];
            HeaderCell cell = (HeaderCell)col.getHeaderCell();
            cell.setSortActive(false);
            cell.setSortExplicit(false);
            cell.setSortPermanent(false);
            ++n2;
        }
        int i = 0;
        while (i < a.length) {
            this.rebuildHeaderCell(a[i]);
            ++i;
        }
        this.fireColumnHeadersUpdated(a);
    }

    public void clearPermanentTailSortColumns() {
        if (this.m_permanentTailSortColumns.size() == 0) {
            return;
        }
        IColumn[] a = this.m_permanentTailSortColumns.toArray(new IColumn[this.m_permanentTailSortColumns.size()]);
        this.m_permanentTailSortColumns.clear();
        IColumn[] iColumnArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            IColumn col = iColumnArray[n2];
            HeaderCell cell = (HeaderCell)col.getHeaderCell();
            cell.setSortActive(false);
            cell.setSortExplicit(false);
            cell.setSortPermanent(false);
            ++n2;
        }
        int i = 0;
        while (i < a.length) {
            this.rebuildHeaderCell(a[i]);
            ++i;
        }
        this.fireColumnHeadersUpdated(a);
    }

    public void addPermanentHeadSortColumn(IColumn col, boolean ascending) {
        if ((col = this.resolveColumn(col)) != null) {
            this.m_permanentHeadSortColumns.remove(col);
            HeaderCell cell = (HeaderCell)col.getHeaderCell();
            cell.setSortActive(true);
            cell.setSortExplicit(true);
            cell.setSortPermanent(true);
            cell.setSortAscending(ascending);
            this.m_permanentHeadSortColumns.add(col);
            this.rebuildHeaderCell(col);
            this.fireColumnHeadersUpdated(new IColumn[]{col});
        }
    }

    public void addPermanentTailSortColumn(IColumn col, boolean ascending) {
        if ((col = this.resolveColumn(col)) != null) {
            this.m_permanentTailSortColumns.remove(col);
            HeaderCell cell = (HeaderCell)col.getHeaderCell();
            cell.setSortActive(true);
            cell.setSortExplicit(true);
            cell.setSortPermanent(true);
            cell.setSortAscending(ascending);
            this.m_permanentTailSortColumns.add(col);
            this.rebuildHeaderCell(col);
            this.fireColumnHeadersUpdated(new IColumn[]{col});
        }
    }

    private void reorganizeIndexes() {
        Object col;
        int n = this.getColumnCount();
        int viewIndex = 0;
        TreeMap<CompositeObject, Integer> sortMap = new TreeMap<CompositeObject, Integer>();
        int modelIndex = 0;
        while (modelIndex < n) {
            col = this.getColumn(modelIndex);
            if (col.isDisplayable()) {
                sortMap.put(new CompositeObject(new Object[]{modelIndex}), modelIndex);
            }
            ++modelIndex;
        }
        this.m_displayableIndexes = new int[sortMap.size()];
        viewIndex = 0;
        col = sortMap.values().iterator();
        while (col.hasNext()) {
            modelIndex = (Integer)col.next();
            this.m_displayableIndexes[viewIndex++] = modelIndex;
        }
        viewIndex = 0;
        sortMap = new TreeMap();
        modelIndex = 0;
        while (modelIndex < n) {
            col = this.getColumn(modelIndex);
            if (col.isDisplayable() && col.isVisible()) {
                double viewHint = col.getVisibleColumnIndexHint();
                if (viewHint < 0.0) {
                    viewHint = col.getViewOrder();
                }
                if (viewHint < 0.0) {
                    viewHint = viewIndex;
                }
                sortMap.put(new CompositeObject(new Object[]{viewHint, viewIndex}), modelIndex);
                ++viewIndex;
            }
            ++modelIndex;
        }
        this.m_visibleIndexes = new int[sortMap.size()];
        viewIndex = 0;
        col = sortMap.values().iterator();
        while (col.hasNext()) {
            modelIndex = (Integer)col.next();
            this.m_visibleIndexes[viewIndex++] = modelIndex;
        }
        n = this.getColumnCount();
        ArrayList<Integer> keyIndexes = new ArrayList<Integer>();
        int modelIndex2 = 0;
        while (modelIndex2 < n) {
            IColumn col2 = this.getColumn(modelIndex2);
            if (col2.isPrimaryKey()) {
                keyIndexes.add(modelIndex2);
            }
            ++modelIndex2;
        }
        this.m_keyIndexes = new int[keyIndexes.size()];
        viewIndex = 0;
        Iterator iterator = keyIndexes.iterator();
        while (iterator.hasNext()) {
            modelIndex2 = (Integer)iterator.next();
            this.m_keyIndexes[viewIndex++] = modelIndex2;
        }
    }

    private void rebuildHeaderCell(IColumn col) {
        col.decorateHeaderCell();
    }

    private void fireColumnHeadersUpdated(IColumn[] a) {
        TableEvent e = new TableEvent(this.m_table, 780);
        e.setColumns(a);
        this.m_table.fireTableEventInternal(e);
    }

    private void fireColumnOrderChanged() {
        TableEvent e = new TableEvent(this.m_table, 770);
        this.m_table.fireTableEventInternal(e);
    }

    private void fireColumnStructureChanged() {
        TableEvent e = new TableEvent(this.m_table, 1);
        this.m_table.fireTableEventInternal(e);
    }

    private void checkMultiline() {
        if (this.m_table != null && !this.m_table.isInitialMultilineText() && !ConfigurationUtility.isMethodOverwrite(AbstractTable.class, (String)"getConfiguredMultilineText", null, this.getClass())) {
            boolean m = false;
            IColumn[] iColumnArray = this.getVisibleColumns();
            int n = iColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                IColumn col = iColumnArray[n2];
                if (col instanceof IStringColumn && ((IStringColumn)col).isTextWrap()) {
                    m = true;
                    break;
                }
                ++n2;
            }
            this.m_table.setMultilineText(m);
        }
    }
}

