/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table;

import java.security.Permission;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.BooleanUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.dnd.JavaTransferObject;
import org.eclipse.scout.commons.dnd.TransferObject;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.exception.VetoException;
import org.eclipse.scout.rt.client.services.common.bookmark.internal.BookmarkUtility;
import org.eclipse.scout.rt.client.ui.ClientUIPreferences;
import org.eclipse.scout.rt.client.ui.action.keystroke.AbstractKeyStroke;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.basic.table.AbstractSortOrderColumn;
import org.eclipse.scout.rt.client.ui.basic.table.AbstractTable;
import org.eclipse.scout.rt.client.ui.basic.table.IHeaderCell;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.TableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columnfilter.ITableColumnFilter;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractBooleanColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractStringColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.table.customizer.ICustomColumn;
import org.eclipse.scout.rt.client.ui.basic.table.menus.ResetColumnsMenu;
import org.eclipse.scout.rt.client.ui.form.AbstractForm;
import org.eclipse.scout.rt.client.ui.form.AbstractFormHandler;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractCancelButton;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractLinkButton;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractOkButton;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.tablefield.AbstractTableField;
import org.eclipse.scout.rt.shared.TEXTS;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.scout.rt.shared.security.CreateCustomColumnPermission;
import org.eclipse.scout.rt.shared.security.DeleteCustomColumnPermission;
import org.eclipse.scout.rt.shared.security.UpdateCustomColumnPermission;
import org.eclipse.scout.rt.shared.services.common.bookmark.TableColumnState;

public class OrganizeColumnsForm
extends AbstractForm {
    ITable m_table;

    public OrganizeColumnsForm(ITable table) throws ProcessingException {
        super(false);
        this.m_table = table;
        this.callInitializer();
    }

    @Override
    protected String getConfiguredTitle() {
        return TEXTS.get((String)"OrganizeTableColumnsTitle");
    }

    public MainBox.GroupBox.ViewBox.AddCustomColumnButton getAddCustomColumnButton() {
        return this.getFieldByClass(MainBox.GroupBox.ViewBox.AddCustomColumnButton.class);
    }

    public MainBox.GroupBox.ColumnSortingBox.AscendingButton getAscendingButton() {
        return this.getFieldByClass(MainBox.GroupBox.ColumnSortingBox.AscendingButton.class);
    }

    public MainBox.CancelButton getCancelButton() {
        return this.getFieldByClass(MainBox.CancelButton.class);
    }

    public void startModify() throws ProcessingException {
        this.startInternal(new ModifyHandler());
    }

    public MainBox.GroupBox.ColumnSortingBox getColumnSortingBox() {
        return this.getFieldByClass(MainBox.GroupBox.ColumnSortingBox.class);
    }

    public MainBox.GroupBox.ColumnsTableField getColumnsTableField() {
        return this.getFieldByClass(MainBox.GroupBox.ColumnsTableField.class);
    }

    public MainBox.GroupBox.ColumnSortingBox.DescendingButton getDescendingButton() {
        return this.getFieldByClass(MainBox.GroupBox.ColumnSortingBox.DescendingButton.class);
    }

    public MainBox.GroupBox.ViewBox.DeselectAllButton getDeselectAllButton() {
        return this.getFieldByClass(MainBox.GroupBox.ViewBox.DeselectAllButton.class);
    }

    public MainBox.GroupBox.FilterBox.EditFilterButton getEditFilterButton() {
        return this.getFieldByClass(MainBox.GroupBox.FilterBox.EditFilterButton.class);
    }

    public MainBox.GroupBox.FilterBox.RemoveFilterButton getRemoveFilterButton() {
        return this.getFieldByClass(MainBox.GroupBox.FilterBox.RemoveFilterButton.class);
    }

    public MainBox.GroupBox.FilterBox getFilterBox() {
        return this.getFieldByClass(MainBox.GroupBox.FilterBox.class);
    }

    public MainBox.GroupBox getGroupBox() {
        return this.getFieldByClass(MainBox.GroupBox.class);
    }

    public MainBox getMainBox() {
        return this.getFieldByClass(MainBox.class);
    }

    public MainBox.GroupBox.ViewBox.ModifyCustomColumnButton getModifyCustomColumnButton() {
        return this.getFieldByClass(MainBox.GroupBox.ViewBox.ModifyCustomColumnButton.class);
    }

    public MainBox.GroupBox.ViewBox.MoveDownButton getMoveDownButton() {
        return this.getFieldByClass(MainBox.GroupBox.ViewBox.MoveDownButton.class);
    }

    public MainBox.GroupBox.ViewBox.MoveUpButton getMoveUpButton() {
        return this.getFieldByClass(MainBox.GroupBox.ViewBox.MoveUpButton.class);
    }

    public MainBox.OkButton getOkButton() {
        return this.getFieldByClass(MainBox.OkButton.class);
    }

    public MainBox.GroupBox.ViewBox.RemoveCustomColumnButton getRemoveCustomColumnButton() {
        return this.getFieldByClass(MainBox.GroupBox.ViewBox.RemoveCustomColumnButton.class);
    }

    public MainBox.GroupBox.ResetBox.ResetAllButton getResetAllButton() {
        return this.getFieldByClass(MainBox.GroupBox.ResetBox.ResetAllButton.class);
    }

    public MainBox.GroupBox.ResetBox getResetBox() {
        return this.getFieldByClass(MainBox.GroupBox.ResetBox.class);
    }

    public MainBox.GroupBox.ResetBox.ResetColumnFiltersButton getResetColumnFilters() {
        return this.getFieldByClass(MainBox.GroupBox.ResetBox.ResetColumnFiltersButton.class);
    }

    public MainBox.GroupBox.ResetBox.ResetSortingButton getResetSortingButton() {
        return this.getFieldByClass(MainBox.GroupBox.ResetBox.ResetSortingButton.class);
    }

    public MainBox.GroupBox.ResetBox.ResetViewButton getResetViewButton() {
        return this.getFieldByClass(MainBox.GroupBox.ResetBox.ResetViewButton.class);
    }

    public MainBox.GroupBox.ViewBox.SelectAllButton getSelectAllButton() {
        return this.getFieldByClass(MainBox.GroupBox.ViewBox.SelectAllButton.class);
    }

    public MainBox.GroupBox.ViewBox getViewBox() {
        return this.getFieldByClass(MainBox.GroupBox.ViewBox.class);
    }

    public MainBox.GroupBox.ColumnSortingBox.WithoutButton getWithoutButton() {
        return this.getFieldByClass(MainBox.GroupBox.ColumnSortingBox.WithoutButton.class);
    }

    private void updateColumnVisibilityAndOrder() {
        IColumn[] visibleColumns = (IColumn[])((MainBox.GroupBox.ColumnsTableField.Table)this.getColumnsTableField().getTable()).getKeyColumn().getValues(((MainBox.GroupBox.ColumnsTableField.Table)this.getColumnsTableField().getTable()).getVisibleColumn().findRows(true));
        this.m_table.getColumnSet().setVisibleColumns(visibleColumns);
    }

    private void setColumnVisible(ITableRow row, Boolean visible) throws ProcessingException {
        ((MainBox.GroupBox.ColumnsTableField.Table)this.getColumnsTableField().getTable()).getVisibleColumn().setValue(row, visible);
        ((IColumn)((MainBox.GroupBox.ColumnsTableField.Table)this.getColumnsTableField().getTable()).getKeyColumn().getValue(row)).setVisible(visible);
        this.updateColumnVisibilityAndOrder();
    }

    private void moveUp(ITableRow row) {
        if (row != null && row.getRowIndex() - 1 >= 0) {
            ((MainBox.GroupBox.ColumnsTableField.Table)this.getColumnsTableField().getTable()).moveRow(row.getRowIndex(), row.getRowIndex() - 1);
        }
        this.updateColumnVisibilityAndOrder();
    }

    private void moveDown(ITableRow row) {
        if (row != null && row.getRowIndex() + 1 < ((MainBox.GroupBox.ColumnsTableField.Table)this.getColumnsTableField().getTable()).getRowCount()) {
            ((MainBox.GroupBox.ColumnsTableField.Table)this.getColumnsTableField().getTable()).moveRow(row.getRowIndex(), row.getRowIndex() + 1);
        }
        this.updateColumnVisibilityAndOrder();
    }

    private void validateButtons() {
        ITableRow selectedRow = ((MainBox.GroupBox.ColumnsTableField.Table)this.getColumnsTableField().getTable()).getSelectedRow();
        boolean selectedRowExists = selectedRow != null;
        boolean isCustomColumn = selectedRow != null && ((MainBox.GroupBox.ColumnsTableField.Table)this.getColumnsTableField().getTable()).getKeyColumn().getValue(selectedRow) instanceof ICustomColumn;
        boolean selectedRowHasFilter = selectedRowExists && ((IColumn)((MainBox.GroupBox.ColumnsTableField.Table)this.getColumnsTableField().getTable()).getKeyColumn().getValue(selectedRow)).isColumnFilterActive();
        boolean sortEnabled = this.m_table.isSortEnabled();
        this.getModifyCustomColumnButton().setEnabled(isCustomColumn);
        this.getRemoveCustomColumnButton().setEnabled(isCustomColumn);
        this.getMoveDownButton().setEnabled(selectedRowExists);
        this.getMoveUpButton().setEnabled(selectedRowExists);
        this.getAscendingButton().setEnabled(sortEnabled && selectedRowExists);
        this.getDescendingButton().setEnabled(sortEnabled && selectedRowExists);
        this.getWithoutButton().setEnabled(sortEnabled && selectedRowExists);
        this.getEditFilterButton().setEnabled(selectedRowExists);
        this.getRemoveFilterButton().setEnabled(selectedRowHasFilter);
    }

    private void doResetAction(Class<? extends IMenu> action) throws ProcessingException {
        ResetColumnsMenu menu = new ResetColumnsMenu(this.m_table);
        List childs = menu.getChildActions();
        for (IMenu child : childs) {
            if (!child.getClass().equals(action)) continue;
            child.doAction();
        }
        this.getColumnsTableField().reloadTableData();
    }

    private void setSort(Boolean ascending) throws ProcessingException {
        ITableRow row = ((MainBox.GroupBox.ColumnsTableField.Table)this.getColumnsTableField().getTable()).getSelectedRow();
        if (row == null) {
            return;
        }
        try {
            ((MainBox.GroupBox.ColumnsTableField.Table)this.getColumnsTableField().getTable()).setTableChanging(true);
            IColumn selectedCol = (IColumn)((MainBox.GroupBox.ColumnsTableField.Table)this.getColumnsTableField().getTable()).getKeyColumn().getValue(row);
            if (ascending == null) {
                this.m_table.getColumnSet().removeSortColumn(selectedCol);
            } else if (this.m_table.getColumnSet().isSortColumn(selectedCol)) {
                this.m_table.getColumnSet().handleSortEvent(selectedCol, true);
            } else {
                this.m_table.getColumnSet().addSortColumn(selectedCol, ascending);
            }
            this.m_table.sort();
            this.getColumnsTableField().reloadTableData();
            ((MainBox.GroupBox.ColumnsTableField.Table)this.getColumnsTableField().getTable()).selectRow(row.getRowIndex());
        }
        finally {
            ((MainBox.GroupBox.ColumnsTableField.Table)this.getColumnsTableField().getTable()).setTableChanging(false);
        }
    }

    @Override
    public void validateForm() throws ProcessingException {
        boolean oneColumnIsVisble = false;
        Boolean[] booleanArray = (Boolean[])((MainBox.GroupBox.ColumnsTableField.Table)this.getColumnsTableField().getTable()).getVisibleColumn().getValues();
        int n = booleanArray.length;
        int n2 = 0;
        while (n2 < n) {
            Boolean visible = booleanArray[n2];
            if (BooleanUtility.nvl((Boolean)visible)) {
                oneColumnIsVisble = true;
                break;
            }
            ++n2;
        }
        if (!oneColumnIsVisble) {
            throw new VetoException(TEXTS.get((String)"OrganizeTableColumnsMinimalColumnCountMessage"));
        }
    }

    static /* synthetic */ void access$3(OrganizeColumnsForm organizeColumnsForm) {
        organizeColumnsForm.updateColumnVisibilityAndOrder();
    }

    @Order(value=10.0)
    public class MainBox
    extends AbstractGroupBox {
        @Override
        protected int getConfiguredGridColumnCount() {
            return 3;
        }

        @Override
        protected int getConfiguredGridW() {
            return 2;
        }

        @Override
        protected int getConfiguredWidthInPixel() {
            return 520;
        }

        @Order(value=30.0)
        public class CancelButton
        extends AbstractCancelButton {
        }

        @Order(value=10.0)
        public class GroupBox
        extends AbstractGroupBox {
            @Override
            protected int getConfiguredGridW() {
                return 1;
            }

            @Order(value=30.0)
            public class ColumnSortingBox
            extends AbstractGroupBox {
                @Override
                protected int getConfiguredGridColumnCount() {
                    return 1;
                }

                @Override
                protected int getConfiguredGridW() {
                    return 1;
                }

                @Override
                protected String getConfiguredLabel() {
                    return TEXTS.get((String)"ColumnSorting");
                }

                @Order(value=10.0)
                public class AscendingButton
                extends AbstractLinkButton {
                    @Override
                    protected String getConfiguredLabel() {
                        return TEXTS.get((String)"Ascending");
                    }

                    @Override
                    protected boolean getConfiguredProcessButton() {
                        return false;
                    }

                    @Override
                    protected void execClickAction() throws ProcessingException {
                        OrganizeColumnsForm.this.setSort(true);
                    }
                }

                @Order(value=20.0)
                public class DescendingButton
                extends AbstractLinkButton {
                    @Override
                    protected String getConfiguredLabel() {
                        return TEXTS.get((String)"Descending");
                    }

                    @Override
                    protected boolean getConfiguredProcessButton() {
                        return false;
                    }

                    @Override
                    protected void execClickAction() throws ProcessingException {
                        OrganizeColumnsForm.this.setSort(false);
                    }
                }

                @Order(value=30.0)
                public class WithoutButton
                extends AbstractLinkButton {
                    @Override
                    protected String getConfiguredLabel() {
                        return TEXTS.get((String)"Without");
                    }

                    @Override
                    protected boolean getConfiguredProcessButton() {
                        return false;
                    }

                    @Override
                    protected void execClickAction() throws ProcessingException {
                        OrganizeColumnsForm.this.setSort(null);
                    }
                }
            }

            @Order(value=10.0)
            public class ColumnsTableField
            extends AbstractTableField<Table> {
                @Override
                protected int getConfiguredGridH() {
                    return 5;
                }

                @Override
                protected int getConfiguredGridW() {
                    return 2;
                }

                @Override
                protected String getConfiguredLabel() {
                    return TEXTS.get((String)"Columns");
                }

                @Override
                protected boolean getConfiguredLabelVisible() {
                    return false;
                }

                @Override
                protected void execReloadTableData() throws ProcessingException {
                    ArrayList<TableRow> rowList = new ArrayList<TableRow>();
                    IColumn[] iColumnArray = ((MainBox)((GroupBox)GroupBox.this).MainBox.this).OrganizeColumnsForm.this.m_table.getColumnSet().getAllColumnsInUserOrder();
                    int n = iColumnArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IColumn col = iColumnArray[n2];
                        if (col.isDisplayable() && (col.isVisible() || col.isVisibleGranted())) {
                            IHeaderCell headerCell = col.getHeaderCell();
                            TableRow row = new TableRow(((Table)this.getTable()).getColumnSet());
                            ((Table)this.getTable()).getKeyColumn().setValue(row, col);
                            ((Table)this.getTable()).getVisibleColumn().setValue(row, Boolean.valueOf(col.isVisible()));
                            String columnTitle = headerCell.getText();
                            if (StringUtility.isNullOrEmpty((String)columnTitle)) {
                                columnTitle = headerCell.getTooltipText();
                                row.setFont(FontSpec.parse((String)"ITALIC"));
                            }
                            ((Table)this.getTable()).getTitleColumn().setValue(row, columnTitle);
                            if (Platform.inDevelopmentMode() && col.isSortActive()) {
                                ((Table)this.getTable()).getTitleColumn().setValue(row, String.valueOf(columnTitle) + " (" + col.getSortIndex() + ")");
                            }
                            if (col instanceof ICustomColumn) {
                                row.getCellForUpdate(((Table)this.getTable()).getCustomColumnColumn().getColumnIndex()).setIconId("table_custom_column");
                            }
                            ((Table)this.getTable()).getSortingColumn().setValue(row, col);
                            if (col.isSortActive()) {
                                row.getCellForUpdate(((Table)this.getTable()).getSortingColumn().getColumnIndex()).setIconId(col.isSortAscending() ? "table_sort_asc" : "table_sort_desc");
                            }
                            if (col.isColumnFilterActive()) {
                                row.getCellForUpdate(((Table)this.getTable()).getFilterColumn().getColumnIndex()).setIconId("table_column_filter_active");
                            }
                            rowList.add(row);
                        }
                        ++n2;
                    }
                    try {
                        ((Table)this.getTable()).setTableChanging(true);
                        ((Table)this.getTable()).discardAllRows();
                        ((Table)this.getTable()).addRows(rowList.toArray(new ITableRow[rowList.size()]));
                    }
                    finally {
                        ((Table)this.getTable()).setTableChanging(false);
                    }
                }

                @Order(value=10.0)
                public class Table
                extends AbstractTable {
                    @Override
                    protected int getConfiguredDragType() {
                        return 2;
                    }

                    @Override
                    protected int getConfiguredDropType() {
                        return 2;
                    }

                    @Override
                    protected TransferObject execDrag(ITableRow[] rows) throws ProcessingException {
                        return new JavaTransferObject((Object)rows);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Override
                    protected void execDrop(ITableRow row, TransferObject transfer) throws ProcessingException {
                        block5: {
                            if (transfer == null || !(transfer instanceof JavaTransferObject) || (localObject = ((JavaTransferObject)transfer).getLocalObject()) == null || !(localObject instanceof ITableRow[]) || (draggedRows = (ITableRow[])localObject) == null || draggedRows.length <= 0 || (draggedRow = draggedRows[0]).getRowIndex() == row.getRowIndex()) break block5;
                            try {
                                block6: {
                                    ((Table)ColumnsTableField.this.getTable()).setTableChanging(true);
                                    if (draggedRow.getRowIndex() >= row.getRowIndex()) ** GOTO lbl10
                                    while (draggedRow.getRowIndex() <= row.getRowIndex()) {
                                        OrganizeColumnsForm.access$2(MainBox.access$0(GroupBox.access$0(ColumnsTableField.access$0(ColumnsTableField.this))), draggedRow);
                                    }
                                    break block6;
lbl-1000:
                                    // 1 sources

                                    {
                                        OrganizeColumnsForm.access$1(MainBox.access$0(GroupBox.access$0(ColumnsTableField.access$0(ColumnsTableField.this))), draggedRow);
lbl10:
                                        // 2 sources

                                        ** while (draggedRow.getRowIndex() >= row.getRowIndex())
                                    }
                                }
                                OrganizeColumnsForm.access$3(MainBox.access$0(GroupBox.access$0(ColumnsTableField.access$0(ColumnsTableField.this))));
                            }
                            finally {
                                ((Table)ColumnsTableField.this.getTable()).setTableChanging(false);
                            }
                        }
                    }

                    @Override
                    protected boolean getConfiguredAutoResizeColumns() {
                        return true;
                    }

                    @Override
                    protected boolean getConfiguredMultiSelect() {
                        return false;
                    }

                    @Override
                    protected boolean getConfiguredHeaderVisible() {
                        return false;
                    }

                    public KeyColumn getKeyColumn() {
                        return this.getColumnSet().getColumnByClass(KeyColumn.class);
                    }

                    public SortingColumn getSortingColumn() {
                        return this.getColumnSet().getColumnByClass(SortingColumn.class);
                    }

                    public FilterColumn getFilterColumn() {
                        return this.getColumnSet().getColumnByClass(FilterColumn.class);
                    }

                    public CustomColumnColumn getCustomColumnColumn() {
                        return this.getColumnSet().getColumnByClass(CustomColumnColumn.class);
                    }

                    public TitleColumn getTitleColumn() {
                        return this.getColumnSet().getColumnByClass(TitleColumn.class);
                    }

                    public VisibleColumn getVisibleColumn() {
                        return this.getColumnSet().getColumnByClass(VisibleColumn.class);
                    }

                    @Override
                    protected void execRowClick(ITableRow row) throws ProcessingException {
                        if (row != null && this.getContextColumn() == this.getVisibleColumn() && this.getKeyColumn().getValue(row) != null) {
                            Boolean oldValue = (Boolean)this.getVisibleColumn().getValue(row);
                            OrganizeColumnsForm.this.setColumnVisible(row, oldValue == false);
                        }
                    }

                    @Override
                    protected void execRowsSelected(ITableRow[] rows) throws ProcessingException {
                        OrganizeColumnsForm.this.validateButtons();
                    }

                    @Order(value=60.0)
                    public class CustomColumnColumn
                    extends AbstractStringColumn {
                        @Override
                        protected int getConfiguredWidth() {
                            return 20;
                        }
                    }

                    @Order(value=30.0)
                    public class DownKeyStroke
                    extends AbstractKeyStroke {
                        @Override
                        protected String getConfiguredKeyStroke() {
                            return "alt-down";
                        }

                        @Override
                        protected void execAction() throws ProcessingException {
                            OrganizeColumnsForm.this.moveDown(Table.this.getSelectedRow());
                        }
                    }

                    @Order(value=50.0)
                    public class FilterColumn
                    extends AbstractStringColumn {
                        @Override
                        protected String getConfiguredHeaderText() {
                            return TEXTS.get((String)"ResetTableColumnFilter");
                        }

                        @Override
                        protected int getConfiguredWidth() {
                            return 20;
                        }
                    }

                    @Order(value=10.0)
                    public class KeyColumn
                    extends AbstractColumn<IColumn<?>> {
                        @Override
                        protected boolean getConfiguredPrimaryKey() {
                            return true;
                        }

                        @Override
                        protected boolean getConfiguredDisplayable() {
                            return false;
                        }
                    }

                    @Order(value=40.0)
                    public class SortingColumn
                    extends AbstractSortOrderColumn {
                        @Override
                        protected String getConfiguredHeaderText() {
                            return TEXTS.get((String)"ColumnSorting");
                        }

                        @Override
                        protected int getConfiguredWidth() {
                            return 20;
                        }
                    }

                    @Order(value=10.0)
                    public class SpaceKeyStroke
                    extends AbstractKeyStroke {
                        @Override
                        protected String getConfiguredKeyStroke() {
                            return "space";
                        }

                        @Override
                        protected void execAction() throws ProcessingException {
                            ITableRow[] iTableRowArray = Table.this.getSelectedRows();
                            int n = iTableRowArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                ITableRow row = iTableRowArray[n2];
                                Boolean oldValue = BooleanUtility.nvl((Boolean)((Boolean)Table.this.getVisibleColumn().getValue(row)));
                                OrganizeColumnsForm.this.setColumnVisible(row, oldValue == false);
                                ++n2;
                            }
                        }
                    }

                    @Order(value=30.0)
                    public class TitleColumn
                    extends AbstractStringColumn {
                        @Override
                        protected String getConfiguredHeaderText() {
                            return TEXTS.get((String)"Title");
                        }

                        @Override
                        protected int getConfiguredWidth() {
                            return 200;
                        }
                    }

                    @Order(value=20.0)
                    public class UpKeyStroke
                    extends AbstractKeyStroke {
                        @Override
                        protected String getConfiguredKeyStroke() {
                            return "alt-up";
                        }

                        @Override
                        protected void execAction() throws ProcessingException {
                            OrganizeColumnsForm.this.moveUp(Table.this.getSelectedRow());
                        }
                    }

                    @Order(value=20.0)
                    public class VisibleColumn
                    extends AbstractBooleanColumn {
                        @Override
                        protected String getConfiguredHeaderText() {
                            return TEXTS.get((String)"Visible");
                        }

                        @Override
                        protected int getConfiguredWidth() {
                            return 20;
                        }
                    }
                }
            }

            @Order(value=40.0)
            public class FilterBox
            extends AbstractGroupBox {
                @Override
                protected int getConfiguredGridColumnCount() {
                    return 1;
                }

                @Override
                protected int getConfiguredGridW() {
                    return 1;
                }

                @Override
                protected String getConfiguredLabel() {
                    return TEXTS.get((String)"ResetTableColumnFilter");
                }

                @Order(value=10.0)
                public class EditFilterButton
                extends AbstractLinkButton {
                    @Override
                    protected String getConfiguredLabel() {
                        return TEXTS.get((String)"EditFilterMenu");
                    }

                    @Override
                    protected boolean getConfiguredProcessButton() {
                        return false;
                    }

                    @Override
                    protected void execClickAction() throws ProcessingException {
                        Integer selectedIndex = null;
                        if (((MainBox)((GroupBox)((FilterBox)FilterBox.this).GroupBox.this).MainBox.this).OrganizeColumnsForm.this.m_table != null && ((ColumnsTableField.Table)OrganizeColumnsForm.this.getColumnsTableField().getTable()).getSelectedRow() != null) {
                            IColumn col;
                            selectedIndex = ((ColumnsTableField.Table)OrganizeColumnsForm.this.getColumnsTableField().getTable()).getSelectedRow().getRowIndex();
                            if (((MainBox)((GroupBox)((FilterBox)FilterBox.this).GroupBox.this).MainBox.this).OrganizeColumnsForm.this.m_table.getColumnFilterManager() != null && (col = (IColumn)((ColumnsTableField.Table)OrganizeColumnsForm.this.getColumnsTableField().getTable()).getKeyColumn().getValue(((ColumnsTableField.Table)OrganizeColumnsForm.this.getColumnsTableField().getTable()).getSelectedRow())) != null) {
                                ((MainBox)((GroupBox)((FilterBox)FilterBox.this).GroupBox.this).MainBox.this).OrganizeColumnsForm.this.m_table.getColumnFilterManager().showFilterForm(col, false);
                            }
                        }
                        OrganizeColumnsForm.this.getColumnsTableField().reloadTableData();
                        if (selectedIndex != null) {
                            ((ColumnsTableField.Table)OrganizeColumnsForm.this.getColumnsTableField().getTable()).selectRow(selectedIndex);
                        }
                    }
                }

                @Order(value=20.0)
                public class RemoveFilterButton
                extends AbstractLinkButton {
                    @Override
                    protected String getConfiguredLabel() {
                        return TEXTS.get((String)"Remove");
                    }

                    @Override
                    protected boolean getConfiguredProcessButton() {
                        return false;
                    }

                    @Override
                    protected void execClickAction() throws ProcessingException {
                        Integer selectedIndex = null;
                        if (((MainBox)((GroupBox)((FilterBox)FilterBox.this).GroupBox.this).MainBox.this).OrganizeColumnsForm.this.m_table != null && ((ColumnsTableField.Table)OrganizeColumnsForm.this.getColumnsTableField().getTable()).getSelectedRow() != null) {
                            IColumn col;
                            selectedIndex = ((ColumnsTableField.Table)OrganizeColumnsForm.this.getColumnsTableField().getTable()).getSelectedRow().getRowIndex();
                            if (((MainBox)((GroupBox)((FilterBox)FilterBox.this).GroupBox.this).MainBox.this).OrganizeColumnsForm.this.m_table.getColumnFilterManager() != null && (col = (IColumn)((ColumnsTableField.Table)OrganizeColumnsForm.this.getColumnsTableField().getTable()).getKeyColumn().getValue(((ColumnsTableField.Table)OrganizeColumnsForm.this.getColumnsTableField().getTable()).getSelectedRow())) != null) {
                                ITableColumnFilter filter = ((MainBox)((GroupBox)((FilterBox)FilterBox.this).GroupBox.this).MainBox.this).OrganizeColumnsForm.this.m_table.getColumnFilterManager().getFilter(col);
                                ((MainBox)((GroupBox)((FilterBox)FilterBox.this).GroupBox.this).MainBox.this).OrganizeColumnsForm.this.m_table.getColumnFilterManager().getFilters().remove(filter);
                                ((MainBox)((GroupBox)((FilterBox)FilterBox.this).GroupBox.this).MainBox.this).OrganizeColumnsForm.this.m_table.applyRowFilters();
                            }
                        }
                        OrganizeColumnsForm.this.getColumnsTableField().reloadTableData();
                        if (selectedIndex != null) {
                            ((ColumnsTableField.Table)OrganizeColumnsForm.this.getColumnsTableField().getTable()).selectRow(selectedIndex);
                        }
                    }
                }
            }

            @Order(value=50.0)
            public class ResetBox
            extends AbstractGroupBox {
                @Override
                protected int getConfiguredGridColumnCount() {
                    return 1;
                }

                @Override
                protected int getConfiguredGridW() {
                    return 1;
                }

                @Override
                protected String getConfiguredLabel() {
                    return TEXTS.get((String)"FormReset");
                }

                @Order(value=10.0)
                public class ResetAllButton
                extends AbstractLinkButton {
                    @Override
                    protected String getConfiguredLabel() {
                        return TEXTS.get((String)"ResetTableColumnsAll");
                    }

                    @Override
                    protected boolean getConfiguredProcessButton() {
                        return false;
                    }

                    @Override
                    protected void execClickAction() throws ProcessingException {
                        OrganizeColumnsForm.this.doResetAction(ResetColumnsMenu.ResetAllMenu.class);
                    }
                }

                @Order(value=40.0)
                public class ResetColumnFiltersButton
                extends AbstractLinkButton {
                    @Override
                    protected String getConfiguredLabel() {
                        return TEXTS.get((String)"ResetTableColumnFilter");
                    }

                    @Override
                    protected boolean getConfiguredProcessButton() {
                        return false;
                    }

                    @Override
                    protected void execClickAction() throws ProcessingException {
                        OrganizeColumnsForm.this.doResetAction(ResetColumnsMenu.ResetColumnFiltersMenu.class);
                    }
                }

                @Order(value=30.0)
                public class ResetSortingButton
                extends AbstractLinkButton {
                    @Override
                    protected String getConfiguredLabel() {
                        return TEXTS.get((String)"ColumnSorting");
                    }

                    @Override
                    protected boolean getConfiguredProcessButton() {
                        return false;
                    }

                    @Override
                    protected void execClickAction() throws ProcessingException {
                        OrganizeColumnsForm.this.doResetAction(ResetColumnsMenu.ResetSortingMenu.class);
                    }
                }

                @Order(value=20.0)
                public class ResetViewButton
                extends AbstractLinkButton {
                    @Override
                    protected String getConfiguredLabel() {
                        return TEXTS.get((String)"ResetTableColumnsView");
                    }

                    @Override
                    protected boolean getConfiguredProcessButton() {
                        return false;
                    }

                    @Override
                    protected void execClickAction() throws ProcessingException {
                        OrganizeColumnsForm.this.doResetAction(ResetColumnsMenu.ResetViewMenu.class);
                    }
                }
            }

            @Order(value=20.0)
            public class ViewBox
            extends AbstractGroupBox {
                @Override
                protected int getConfiguredGridColumnCount() {
                    return 1;
                }

                @Override
                protected int getConfiguredGridW() {
                    return 1;
                }

                @Override
                protected String getConfiguredLabel() {
                    return TEXTS.get((String)"ResetTableColumnsView");
                }

                @Order(value=50.0)
                public class AddCustomColumnButton
                extends AbstractLinkButton {
                    @Override
                    protected String getConfiguredLabel() {
                        return TEXTS.get((String)"AddCustomColumnMenu");
                    }

                    @Override
                    protected boolean getConfiguredProcessButton() {
                        return false;
                    }

                    @Override
                    protected void execInitField() throws ProcessingException {
                        this.setVisiblePermission((Permission)new CreateCustomColumnPermission());
                        this.setVisible(((MainBox)((GroupBox)((ViewBox)ViewBox.this).GroupBox.this).MainBox.this).OrganizeColumnsForm.this.m_table.getTableCustomizer() != null);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Override
                    protected void execClickAction() throws ProcessingException {
                        block9: {
                            if (MainBox.access$0((MainBox)GroupBox.access$0((GroupBox)ViewBox.access$0((ViewBox)ViewBox.this))).m_table == null || MainBox.access$0((MainBox)GroupBox.access$0((GroupBox)ViewBox.access$0((ViewBox)ViewBox.this))).m_table.getTableCustomizer() == null) break block9;
                            existingColumns = new ArrayList<String>();
                            var5_2 = MainBox.access$0((MainBox)GroupBox.access$0((GroupBox)ViewBox.access$0((ViewBox)ViewBox.this))).m_table.getColumns();
                            var4_4 = var5_2.length;
                            var3_5 = 0;
                            while (var3_5 < var4_4) {
                                c = var5_2[var3_5];
                                existingColumns.add(c.getColumnId());
                                ++var3_5;
                            }
                            MainBox.access$0((MainBox)GroupBox.access$0((GroupBox)ViewBox.access$0((ViewBox)ViewBox.this))).m_table.getTableCustomizer().addColumn();
                            targetOrderRow = ((ColumnsTableField.Table)MainBox.access$0(GroupBox.access$0(ViewBox.access$0(ViewBox.this))).getColumnsTableField().getTable()).getSelectedRow();
                            if (targetOrderRow == null && ((ColumnsTableField.Table)MainBox.access$0(GroupBox.access$0(ViewBox.access$0(ViewBox.this))).getColumnsTableField().getTable()).getRowCount() > 0) {
                                targetOrderRow = ((ColumnsTableField.Table)MainBox.access$0(GroupBox.access$0(ViewBox.access$0(ViewBox.this))).getColumnsTableField().getTable()).getRow(0);
                            }
                            if (targetOrderRow == null) {
                                return;
                            }
                            MainBox.access$0(GroupBox.access$0(ViewBox.access$0(ViewBox.this))).getColumnsTableField().reloadTableData();
                            var6_8 = ((ColumnsTableField.Table)MainBox.access$0(GroupBox.access$0(ViewBox.access$0(ViewBox.this))).getColumnsTableField().getTable()).getRows();
                            var5_3 = var6_8.length;
                            var4_4 = 0;
                            while (var4_4 < var5_3) {
                                block10: {
                                    newColumnRow = var6_8[var4_4];
                                    if (existingColumns.contains(((IColumn)((ColumnsTableField.Table)MainBox.access$0(GroupBox.access$0(ViewBox.access$0(ViewBox.this))).getColumnsTableField().getTable()).getKeyColumn().getValue(newColumnRow)).getColumnId())) break block10;
                                    try {
                                        block11: {
                                            ((ColumnsTableField.Table)MainBox.access$0(GroupBox.access$0(ViewBox.access$0(ViewBox.this))).getColumnsTableField().getTable()).setTableChanging(true);
                                            if (newColumnRow.getRowIndex() >= targetOrderRow.getRowIndex()) ** GOTO lbl33
                                            while (newColumnRow.getRowIndex() < targetOrderRow.getRowIndex()) {
                                                OrganizeColumnsForm.access$2(MainBox.access$0(GroupBox.access$0(ViewBox.access$0(ViewBox.this))), newColumnRow);
                                            }
                                            break block11;
lbl-1000:
                                            // 1 sources

                                            {
                                                OrganizeColumnsForm.access$1(MainBox.access$0(GroupBox.access$0(ViewBox.access$0(ViewBox.this))), newColumnRow);
lbl33:
                                                // 2 sources

                                                ** while (newColumnRow.getRowIndex() > targetOrderRow.getRowIndex())
                                            }
                                        }
                                        OrganizeColumnsForm.access$3(MainBox.access$0(GroupBox.access$0(ViewBox.access$0(ViewBox.this))));
                                        ((ColumnsTableField.Table)MainBox.access$0(GroupBox.access$0(ViewBox.access$0(ViewBox.this))).getColumnsTableField().getTable()).selectRow(newColumnRow);
                                        break;
                                    }
                                    finally {
                                        ((ColumnsTableField.Table)MainBox.access$0(GroupBox.access$0(ViewBox.access$0(ViewBox.this))).getColumnsTableField().getTable()).setTableChanging(false);
                                    }
                                }
                                ++var4_4;
                            }
                        }
                    }
                }

                @Order(value=20.0)
                public class DeselectAllButton
                extends AbstractLinkButton {
                    @Override
                    protected String getConfiguredLabel() {
                        return TEXTS.get((String)"ButtonDeselectAll");
                    }

                    @Override
                    protected boolean getConfiguredProcessButton() {
                        return false;
                    }

                    @Override
                    protected void execClickAction() throws ProcessingException {
                        ITableRow[] iTableRowArray = ((ColumnsTableField.Table)OrganizeColumnsForm.this.getColumnsTableField().getTable()).getRows();
                        int n = iTableRowArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ITableRow row = iTableRowArray[n2];
                            OrganizeColumnsForm.this.setColumnVisible(row, false);
                            ++n2;
                        }
                    }
                }

                @Order(value=60.0)
                public class ModifyCustomColumnButton
                extends AbstractLinkButton {
                    @Override
                    protected String getConfiguredLabel() {
                        return TEXTS.get((String)"SC_Label_Change");
                    }

                    @Override
                    protected boolean getConfiguredProcessButton() {
                        return false;
                    }

                    @Override
                    protected void execInitField() throws ProcessingException {
                        this.setVisiblePermission((Permission)new UpdateCustomColumnPermission());
                    }

                    @Override
                    protected void execClickAction() throws ProcessingException {
                        IColumn selectedCol;
                        if (((MainBox)((GroupBox)((ViewBox)ViewBox.this).GroupBox.this).MainBox.this).OrganizeColumnsForm.this.m_table != null && ((MainBox)((GroupBox)((ViewBox)ViewBox.this).GroupBox.this).MainBox.this).OrganizeColumnsForm.this.m_table.getTableCustomizer() != null && ((ColumnsTableField.Table)OrganizeColumnsForm.this.getColumnsTableField().getTable()).getSelectedRow() != null && (selectedCol = (IColumn)((ColumnsTableField.Table)OrganizeColumnsForm.this.getColumnsTableField().getTable()).getKeyColumn().getValue(((ColumnsTableField.Table)OrganizeColumnsForm.this.getColumnsTableField().getTable()).getSelectedRow())) instanceof ICustomColumn) {
                            ((MainBox)((GroupBox)((ViewBox)ViewBox.this).GroupBox.this).MainBox.this).OrganizeColumnsForm.this.m_table.getTableCustomizer().modifyColumn((ICustomColumn)selectedCol);
                        }
                        OrganizeColumnsForm.this.getColumnsTableField().reloadTableData();
                    }
                }

                @Order(value=40.0)
                public class MoveDownButton
                extends AbstractLinkButton {
                    @Override
                    protected String getConfiguredLabel() {
                        return TEXTS.get((String)"ButtonMoveDown");
                    }

                    @Override
                    protected boolean getConfiguredProcessButton() {
                        return false;
                    }

                    @Override
                    protected void execClickAction() {
                        OrganizeColumnsForm.this.moveDown(((ColumnsTableField.Table)OrganizeColumnsForm.this.getColumnsTableField().getTable()).getSelectedRow());
                    }
                }

                @Order(value=30.0)
                public class MoveUpButton
                extends AbstractLinkButton {
                    @Override
                    protected String getConfiguredLabel() {
                        return TEXTS.get((String)"ButtonMoveUp");
                    }

                    @Override
                    protected boolean getConfiguredProcessButton() {
                        return false;
                    }

                    @Override
                    protected void execClickAction() throws ProcessingException {
                        OrganizeColumnsForm.this.moveUp(((ColumnsTableField.Table)OrganizeColumnsForm.this.getColumnsTableField().getTable()).getSelectedRow());
                    }
                }

                @Order(value=70.0)
                public class RemoveCustomColumnButton
                extends AbstractLinkButton {
                    @Override
                    protected String getConfiguredLabel() {
                        return TEXTS.get((String)"Remove");
                    }

                    @Override
                    protected boolean getConfiguredProcessButton() {
                        return false;
                    }

                    @Override
                    protected void execInitField() throws ProcessingException {
                        this.setVisiblePermission((Permission)new DeleteCustomColumnPermission());
                    }

                    @Override
                    protected void execClickAction() throws ProcessingException {
                        IColumn selectedCol;
                        if (((MainBox)((GroupBox)((ViewBox)ViewBox.this).GroupBox.this).MainBox.this).OrganizeColumnsForm.this.m_table != null && ((MainBox)((GroupBox)((ViewBox)ViewBox.this).GroupBox.this).MainBox.this).OrganizeColumnsForm.this.m_table.getTableCustomizer() != null && ((ColumnsTableField.Table)OrganizeColumnsForm.this.getColumnsTableField().getTable()).getSelectedRow() != null && (selectedCol = (IColumn)((ColumnsTableField.Table)OrganizeColumnsForm.this.getColumnsTableField().getTable()).getKeyColumn().getValue(((ColumnsTableField.Table)OrganizeColumnsForm.this.getColumnsTableField().getTable()).getSelectedRow())) instanceof ICustomColumn) {
                            ((MainBox)((GroupBox)((ViewBox)ViewBox.this).GroupBox.this).MainBox.this).OrganizeColumnsForm.this.m_table.getTableCustomizer().removeColumn((ICustomColumn)selectedCol);
                        }
                        OrganizeColumnsForm.this.getColumnsTableField().reloadTableData();
                    }
                }

                @Order(value=10.0)
                public class SelectAllButton
                extends AbstractLinkButton {
                    @Override
                    protected String getConfiguredLabel() {
                        return TEXTS.get((String)"ButtonSelectAll");
                    }

                    @Override
                    protected boolean getConfiguredProcessButton() {
                        return false;
                    }

                    @Override
                    protected void execClickAction() throws ProcessingException {
                        ITableRow[] iTableRowArray = ((ColumnsTableField.Table)OrganizeColumnsForm.this.getColumnsTableField().getTable()).getRows();
                        int n = iTableRowArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ITableRow row = iTableRowArray[n2];
                            OrganizeColumnsForm.this.setColumnVisible(row, true);
                            ++n2;
                        }
                    }
                }
            }
        }

        @Order(value=20.0)
        public class OkButton
        extends AbstractOkButton {
        }
    }

    public class ModifyHandler
    extends AbstractFormHandler {
        private List<TableColumnState> m_oldColumns;

        @Override
        protected void execLoad() throws ProcessingException {
            this.m_oldColumns = BookmarkUtility.backupTableColumns(OrganizeColumnsForm.this.m_table);
            OrganizeColumnsForm.this.getColumnsTableField().reloadTableData();
        }

        @Override
        protected void execPostLoad() throws ProcessingException {
            OrganizeColumnsForm.this.validateButtons();
        }

        @Override
        protected void execStore() throws ProcessingException {
            ClientUIPreferences.getInstance().setAllTableColumnPreferences(OrganizeColumnsForm.this.m_table);
        }

        @Override
        protected void execFinally() throws ProcessingException {
            if (!OrganizeColumnsForm.this.isFormStored() && OrganizeColumnsForm.this.isSaveNeeded()) {
                try {
                    OrganizeColumnsForm.this.m_table.setTableChanging(true);
                    BookmarkUtility.restoreTableColumns(OrganizeColumnsForm.this.m_table, this.m_oldColumns);
                }
                finally {
                    OrganizeColumnsForm.this.m_table.setTableChanging(false);
                }
            }
        }
    }
}

