/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.columns;

import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IStringColumn;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.stringfield.AbstractStringField;

public abstract class AbstractStringColumn
extends AbstractColumn<String>
implements IStringColumn {
    private boolean m_inputMasked;
    private String m_format;
    private boolean m_wrap;

    @ConfigProperty(value="INTEGER")
    @Order(value=130.0)
    @ConfigPropertyValue(value="4000")
    protected int getConfiguredMaxLength() {
        return 4000;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=140.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredInputMasked() {
        return false;
    }

    @ConfigProperty(value="STRING")
    @Order(value=150.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredDisplayFormat() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=160.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredTextWrap() {
        return false;
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setInputMasked(this.getConfiguredInputMasked());
        this.setDisplayFormat(this.getConfiguredDisplayFormat());
        this.setTextWrap(this.getConfiguredTextWrap());
    }

    @Override
    public void setInputMasked(boolean b) {
        this.m_inputMasked = b;
    }

    @Override
    public boolean isInputMasked() {
        return this.m_inputMasked;
    }

    @Override
    public void setDisplayFormat(String s) {
        this.m_format = s;
    }

    @Override
    public String getDisplayFormat() {
        return this.m_format;
    }

    @Override
    public void setTextWrap(boolean b) {
        this.m_wrap = b;
    }

    @Override
    public boolean isTextWrap() {
        return this.m_wrap;
    }

    @Override
    public boolean isEmpty() {
        ITable table = this.getTable();
        if (table != null) {
            int i = 0;
            int ni = table.getRowCount();
            while (i < ni) {
                String value = (String)this.getValue(table.getRow(i));
                if (value != null && value.length() > 0) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    @Override
    protected String parseValueInternal(ITableRow row, Object rawValue) throws ProcessingException {
        String validValue = null;
        validValue = rawValue == null ? null : (rawValue instanceof String ? (String)rawValue : rawValue.toString());
        return validValue;
    }

    @Override
    protected IFormField prepareEditInternal(ITableRow row) throws ProcessingException {
        AbstractStringField f = new AbstractStringField(){};
        f.setMaxLength(this.getConfiguredMaxLength());
        f.setInputMasked(this.isInputMasked());
        boolean multi = this.getTable() != null ? this.getTable().isMultilineText() : this.isTextWrap();
        f.setMultilineText(multi);
        f.setWrapText(true);
        return f;
    }

    @Override
    protected void decorateCellInternal(Cell cell, ITableRow row) {
        super.decorateCellInternal(cell, row);
        if (this.m_format != null && cell.getValue() != null) {
            if ("a".equals(this.m_format)) {
                cell.setText(((String)cell.getValue()).toLowerCase());
            } else if ("A".equals(this.m_format)) {
                cell.setText(((String)cell.getValue()).toUpperCase());
            }
        } else {
            cell.setText((String)cell.getValue());
        }
    }

    @Override
    public int compareTableRows(ITableRow r1, ITableRow r2) {
        String s1 = (String)this.getValue(r1);
        String s2 = (String)this.getValue(r2);
        return StringUtility.compareIgnoreCase((String)s1, (String)s2);
    }
}

