/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.tree;

import java.net.URL;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.EventListenerList;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.beans.AbstractPropertyObserver;
import org.eclipse.scout.commons.dnd.TransferObject;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.IEventHistory;
import org.eclipse.scout.rt.client.ui.action.ActionFinder;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.action.keystroke.KeyStroke;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.MenuSeparator;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.tree.AbstractTreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.DefaultTreeEventHistory;
import org.eclipse.scout.rt.client.ui.basic.tree.ITree;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNodeFilter;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeUIFacade;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeVisitor;
import org.eclipse.scout.rt.client.ui.basic.tree.IVirtualTreeNode;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeAdapter;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeEvent;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeListener;
import org.eclipse.scout.rt.client.ui.basic.tree.TreeUtility;
import org.eclipse.scout.rt.client.ui.profiler.DesktopProfiler;
import org.eclipse.scout.rt.shared.data.form.fields.treefield.AbstractTreeFieldData;
import org.eclipse.scout.rt.shared.data.form.fields.treefield.TreeNodeData;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.rt.shared.services.common.security.IAccessControlService;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractTree
extends AbstractPropertyObserver
implements ITree {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractTree.class);
    private final EventListenerList m_listenerList = new EventListenerList();
    private ITreeUIFacade m_uiFacade;
    private IMenu[] m_menus;
    private boolean m_enabledGranted;
    private boolean m_enabledProperty;
    private ITreeNode m_rootNode;
    private int m_treeChanging;
    private boolean m_autoDiscardOnDelete;
    private boolean m_autoTitle;
    private final HashMap<Object, ITreeNode> m_deletedNodes;
    private ArrayList<TreeEvent> m_treeEventBuffer = new ArrayList();
    private HashSet<ITreeNode> m_nodeDecorationBuffer = new HashSet();
    private HashSet<ITreeNode> m_selectedNodes = new HashSet();
    private final ArrayList<ITreeNodeFilter> m_nodeFilters;
    private final int m_uiProcessorCount = 0;
    private IKeyStroke[] m_baseKeyStrokes;
    private IEventHistory<TreeEvent> m_eventHistory;
    private int m_processChangeBufferLoopDetection;

    public AbstractTree() {
        if (DesktopProfiler.getInstance().isEnabled()) {
            DesktopProfiler.getInstance().registerTree(this);
        }
        this.m_deletedNodes = new HashMap();
        this.m_nodeFilters = new ArrayList(1);
        this.initConfig();
    }

    @ConfigProperty(value="TEXT")
    @Order(value=10.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredTitle() {
        return null;
    }

    @ConfigProperty(value="ICON_ID")
    @Order(value=20.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredIconId() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=30.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredAutoTitle() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=40.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredMultiSelect() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=42.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredMultiCheck() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=45.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredCheckable() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=50.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredDragEnabled() {
        return false;
    }

    @ConfigProperty(value="DRAG_AND_DROP_TYPE")
    @Order(value=51.0)
    @ConfigPropertyValue(value="0")
    protected int getConfiguredDragType() {
        return 0;
    }

    @ConfigProperty(value="DRAG_AND_DROP_TYPE")
    @Order(value=52.0)
    @ConfigPropertyValue(value="0")
    protected int getConfiguredDropType() {
        return 0;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=60.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredAutoDiscardOnDelete() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=70.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredRootNodeVisible() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=71.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredRootHandlesVisible() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=80.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredScrollToSelection() {
        return false;
    }

    private Class<? extends IKeyStroke>[] getConfiguredKeyStrokes() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        return ConfigurationUtility.filterClasses((Class[])dca, IKeyStroke.class);
    }

    private Class<? extends IMenu>[] getConfiguredMenus() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        return ConfigurationUtility.sortFilteredClassesByOrderAnnotation((Class[])dca, IMenu.class);
    }

    @ConfigOperation
    @Order(value=10.0)
    protected void execInitTree() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=15.0)
    protected void execDisposeTree() throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=18.0)
    protected void execHyperlinkAction(URL url, String path, boolean local) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=20.0)
    protected TransferObject execDrag(ITreeNode node) throws ProcessingException {
        return null;
    }

    @ConfigOperation
    @Order(value=30.0)
    protected TransferObject execDrag(ITreeNode[] nodes) throws ProcessingException {
        return null;
    }

    @ConfigOperation
    @Order(value=40.0)
    protected void execDrop(ITreeNode node, TransferObject t) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=50.0)
    protected void execDecorateCell(ITreeNode node, Cell cell) throws ProcessingException {
        if (cell.getIconId() == null && this.getIconId() != null) {
            cell.setIconId(this.getIconId());
        }
        node.decorateCell();
    }

    @ConfigOperation
    @Order(value=60.0)
    protected void execNodesSelected(TreeEvent e) throws ProcessingException {
    }

    @ConfigOperation
    @Order(value=70.0)
    protected void execNodeClick(ITreeNode node) throws ProcessingException {
        TreeEvent e = new TreeEvent((ITree)this, 820, node);
        this.fireTreeEventInternal(e);
    }

    @ConfigOperation
    @Order(value=80.0)
    protected void execNodeAction(ITreeNode node) throws ProcessingException {
        TreeEvent e = new TreeEvent((ITree)this, 705, node);
        this.fireTreeEventInternal(e);
    }

    protected void initConfig() {
        this.m_enabledGranted = true;
        this.m_eventHistory = this.createEventHistory();
        this.m_uiFacade = new P_UIFacade();
        this.setTitle(this.getConfiguredTitle());
        this.setIconId(this.getConfiguredIconId());
        this.setAutoTitle(this.getConfiguredAutoTitle());
        this.setCheckable(this.getConfiguredCheckable());
        this.setMultiCheck(this.getConfiguredMultiCheck());
        this.setMultiSelect(this.getConfiguredMultiSelect());
        this.setAutoDiscardOnDelete(this.getConfiguredAutoDiscardOnDelete());
        this.setDragEnabled(this.getConfiguredDragEnabled());
        this.setDragType(this.getConfiguredDragType());
        this.setDropType(this.getConfiguredDropType());
        this.setRootNodeVisible(this.getConfiguredRootNodeVisible());
        this.setRootHandlesVisible(this.getConfiguredRootHandlesVisible());
        this.setScrollToSelection(this.getConfiguredScrollToSelection());
        this.setRootNode(new AbstractTreeNode(){});
        this.addTreeListener(new TreeAdapter(){

            @Override
            public void treeChanged(TreeEvent e) {
                IEventHistory<TreeEvent> h = AbstractTree.this.getEventHistory();
                if (h != null) {
                    h.notifyEvent(e);
                }
                switch (e.getType()) {
                    case 730: {
                        if (e.getDragObject() != null) break;
                        try {
                            TransferObject transferObject = AbstractTree.this.execDrag(e.getNode());
                            if (transferObject == null) {
                                transferObject = AbstractTree.this.execDrag(e.getNodes());
                            }
                            e.setDragObject(transferObject);
                        }
                        catch (Throwable t) {
                            LOG.error("Drag", t);
                        }
                        break;
                    }
                    case 740: {
                        if (e.getDropObject() == null) break;
                        try {
                            AbstractTree.this.execDrop(e.getNode(), e.getDropObject());
                        }
                        catch (Throwable t) {
                            LOG.error("Drop", t);
                        }
                        break;
                    }
                    case 40: {
                        AbstractTree.this.rebuildKeyStrokesInternal();
                    }
                }
            }
        });
        ArrayList<IKeyStroke> ksList = new ArrayList<IKeyStroke>();
        Class<? extends IKeyStroke>[] shortcutArray = this.getConfiguredKeyStrokes();
        int i = 0;
        while (i < shortcutArray.length) {
            try {
                IKeyStroke ks = (IKeyStroke)ConfigurationUtility.newInnerInstance((Object)this, shortcutArray[i]);
                ksList.add(ks);
            }
            catch (Throwable t) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("keyStroke: " + shortcutArray[i].getName(), t));
            }
            ++i;
        }
        if (ConfigurationUtility.isMethodOverwrite(AbstractTree.class, (String)"execNodeAction", (Class[])new Class[]{ITreeNode.class}, this.getClass())) {
            ksList.add(new KeyStroke("ENTER"){

                @Override
                protected void execAction() throws ProcessingException {
                    AbstractTree.this.fireNodeAction(AbstractTree.this.getSelectedNode());
                }
            });
        }
        this.m_baseKeyStrokes = ksList.toArray(new IKeyStroke[ksList.size()]);
        this.setKeyStrokesInternal(this.m_baseKeyStrokes);
        ArrayList<IMenu> menuList = new ArrayList<IMenu>();
        Class<? extends IMenu>[] ma = this.getConfiguredMenus();
        int i2 = 0;
        while (i2 < ma.length) {
            try {
                IMenu menu = (IMenu)ConfigurationUtility.newInnerInstance((Object)this, ma[i2]);
                menuList.add(menu);
            }
            catch (Exception e) {
                LOG.error("Exception occured while creating a new instance of " + ma[i2].getName(), (Throwable)e);
            }
            ++i2;
        }
        try {
            this.injectMenusInternal(menuList);
        }
        catch (Exception e) {
            LOG.error("Error occured while dynamically contributing menus.", (Throwable)e);
        }
        this.m_menus = menuList.toArray(new IMenu[0]);
    }

    @Override
    public final void initTree() throws ProcessingException {
        this.initTreeInternal();
        this.execInitTree();
    }

    protected void initTreeInternal() throws ProcessingException {
    }

    @Override
    public final void disposeTree() {
        this.disposeTreeInternal();
        try {
            this.execDisposeTree();
        }
        catch (Throwable t) {
            LOG.warn(this.getClass().getName(), t);
        }
    }

    protected void disposeTreeInternal() {
    }

    protected void injectMenusInternal(List<IMenu> menuList) {
    }

    @Override
    public IMenu[] getMenus() {
        return this.m_menus;
    }

    @Override
    public void setMenus(IMenu[] a) {
        this.m_menus = a;
    }

    @Override
    public <T extends IMenu> T getMenu(Class<T> menuType) throws ProcessingException {
        return (T)((IMenu)new ActionFinder().findAction(this.getMenus(), menuType));
    }

    @Override
    public boolean hasNodeFilters() {
        return this.m_nodeFilters.size() > 0;
    }

    @Override
    public ITreeNodeFilter[] getNodeFilters() {
        return this.m_nodeFilters.toArray(new ITreeNodeFilter[this.m_nodeFilters.size()]);
    }

    @Override
    public void addNodeFilter(ITreeNodeFilter filter) {
        if (filter != null) {
            boolean exists = false;
            for (ITreeNodeFilter existingFilter : this.m_nodeFilters) {
                if (existingFilter != filter) continue;
                exists = true;
                break;
            }
            if (!exists) {
                this.m_nodeFilters.add(filter);
            }
            this.applyNodeFilters();
        }
    }

    @Override
    public void removeNodeFilter(ITreeNodeFilter filter) {
        if (filter != null) {
            this.m_nodeFilters.remove(filter);
            this.applyNodeFilters();
        }
    }

    @Override
    public void applyNodeFilters() {
        this.applyNodeFiltersRecInternal(this.getRootNode(), true, 0);
        this.fireNodeFilterChanged();
    }

    private void applyNodeFiltersRecInternal(ITreeNode inode, boolean parentAccepted, int level) {
        if (inode == null) {
            return;
        }
        inode.setFilterAccepted(true);
        if (this.m_nodeFilters.size() > 0) {
            for (ITreeNodeFilter filter : this.m_nodeFilters) {
                if (filter.accept(inode, level)) continue;
                inode.setFilterAccepted(false);
                break;
            }
        }
        if (!parentAccepted && inode.isFilterAccepted()) {
            ITreeNode tmp = inode.getParentNode();
            while (tmp != null) {
                if (tmp instanceof AbstractTreeNode) {
                    ((AbstractTreeNode)tmp).setFilterAccepted(true);
                }
                tmp = tmp.getParentNode();
            }
        }
        ITreeNode[] iTreeNodeArray = inode.getChildNodes();
        int n = iTreeNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITreeNode child = iTreeNodeArray[n2];
            this.applyNodeFiltersRecInternal(child, inode.isFilterAccepted(), level + 1);
            ++n2;
        }
    }

    @Override
    public void requestFocus() {
        this.fireRequestFocus();
    }

    @Override
    public ITreeNode getRootNode() {
        return this.m_rootNode;
    }

    @Override
    public String getTitle() {
        return this.propertySupport.getPropertyString("title");
    }

    @Override
    public void setTitle(String s) {
        this.propertySupport.setPropertyString("title", s);
    }

    @Override
    public boolean isAutoTitle() {
        return this.m_autoTitle;
    }

    @Override
    public void setAutoTitle(boolean b) {
        this.m_autoTitle = b;
    }

    @Override
    public String getIconId() {
        String iconId = this.propertySupport.getPropertyString("iconId");
        if (iconId != null && iconId.length() == 0) {
            iconId = null;
        }
        return iconId;
    }

    @Override
    public void setIconId(String iconId) {
        this.propertySupport.setPropertyString("iconId", iconId);
    }

    @Override
    public boolean isCheckable() {
        return this.propertySupport.getPropertyBool("checkable");
    }

    @Override
    public void setCheckable(boolean b) {
        this.propertySupport.setPropertyBool("checkable", b);
    }

    @Override
    public boolean isDragEnabled() {
        return this.propertySupport.getPropertyBool("dragEnabled");
    }

    @Override
    public void setDragEnabled(boolean b) {
        this.propertySupport.setPropertyBool("dragEnabled", b);
    }

    @Override
    public void setDragType(int dragType) {
        this.propertySupport.setPropertyInt("dragType", dragType);
    }

    @Override
    public int getDragType() {
        return this.propertySupport.getPropertyInt("dragType");
    }

    @Override
    public void setDropType(int dropType) {
        this.propertySupport.setPropertyInt("dropType", dropType);
    }

    @Override
    public int getDropType() {
        return this.propertySupport.getPropertyInt("dropType");
    }

    @Override
    public void setEnabledPermission(Permission p) {
        boolean b = p != null ? ((IAccessControlService)SERVICES.getService(IAccessControlService.class)).checkPermission(p) : true;
        this.setEnabledGranted(b);
    }

    @Override
    public boolean isEnabledGranted() {
        return this.m_enabledGranted;
    }

    @Override
    public void setEnabledGranted(boolean b) {
        this.m_enabledGranted = b;
        this.calculateEnabled();
    }

    @Override
    public void setEnabled(boolean b) {
        this.m_enabledProperty = b;
        this.calculateEnabled();
    }

    @Override
    public boolean isEnabled() {
        return this.propertySupport.getPropertyBool("enabled");
    }

    private void calculateEnabled() {
        this.propertySupport.setPropertyBool("enabled", this.m_enabledGranted && this.m_enabledProperty);
    }

    @Override
    public String getPathText(ITreeNode selectedNode) {
        return this.getPathText(selectedNode, " - ");
    }

    @Override
    public String getPathText(ITreeNode selectedNode, String delimiter) {
        ITreeNode root = this.getRootNode();
        StringBuffer pathStr = new StringBuffer("");
        ITreeNode node = selectedNode;
        while (node != null) {
            if (node != root || this.isRootNodeVisible()) {
                if (pathStr.length() != 0) {
                    pathStr.insert(0, delimiter);
                }
                pathStr.insert(0, node.getCell().getText());
            }
            node = node.getParentNode();
        }
        return pathStr.toString();
    }

    private void rebuildTitleInternal() {
        this.setTitle(this.getPathText(this.getSelectedNode()));
    }

    private void rebuildKeyStrokesInternal() {
        IMenu[] menus;
        try {
            ITreeNode[] nodes = this.resolveVirtualNodes(this.getSelectedNodes());
            menus = this.fetchMenusForNodesInternal(nodes);
        }
        catch (ProcessingException e) {
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
            menus = new IMenu[]{};
        }
        ArrayList<IKeyStroke> ksList = new ArrayList<IKeyStroke>(Arrays.asList(this.m_baseKeyStrokes));
        IMenu[] iMenuArray = menus;
        int n = menus.length;
        int n2 = 0;
        while (n2 < n) {
            IMenu menu = iMenuArray[n2];
            if (menu.getKeyStroke() != null) {
                KeyStroke ks = new KeyStroke(menu.getKeyStroke(), menu);
                ksList.add(ks);
            }
            ++n2;
        }
        this.setKeyStrokesInternal(ksList.toArray(new IKeyStroke[ksList.size()]));
    }

    @Override
    public ITreeNode findNode(Object primaryKey) {
        ITreeNode[] a = this.findNodes(new Object[]{primaryKey});
        if (a != null && a.length > 0) {
            return a[0];
        }
        return null;
    }

    @Override
    public ITreeNode[] findNodes(Object[] primaryKeys) {
        if (primaryKeys == null || primaryKeys.length <= 0) {
            return new ITreeNode[0];
        }
        final HashSet<Object> keySet = new HashSet<Object>(Arrays.asList(primaryKeys));
        P_AbstractCollectingTreeVisitor v = new P_AbstractCollectingTreeVisitor(){

            @Override
            public boolean visit(ITreeNode node) {
                if (keySet.remove(node.getPrimaryKey())) {
                    this.addNodeToList(node);
                }
                return !keySet.isEmpty();
            }
        };
        this.visitNode(this.getRootNode(), v);
        return v.getNodes();
    }

    @Override
    public void setRootNode(ITreeNode root) {
        if (this.m_rootNode != null) {
            this.m_rootNode.setTreeInternal(null, true);
            root.nodeRemovedNotify();
        }
        this.m_rootNode = root;
        if (this.m_rootNode != null) {
            this.m_rootNode.setTreeInternal(this, true);
            this.m_rootNode.nodeAddedNotify();
            if (!this.isRootNodeVisible()) {
                try {
                    this.m_rootNode.ensureChildrenLoaded();
                }
                catch (ProcessingException e) {
                    LOG.error("expanding root node of " + this.getTitle(), (Throwable)e);
                }
            }
        }
    }

    @Override
    public boolean isRootNodeVisible() {
        return this.propertySupport.getPropertyBool("rootNodeVisible");
    }

    @Override
    public void setRootNodeVisible(boolean b) {
        this.propertySupport.setPropertyBool("rootNodeVisible", b);
    }

    @Override
    public boolean isRootHandlesVisible() {
        return this.propertySupport.getPropertyBool("rootHandlesVisible");
    }

    @Override
    public void setRootHandlesVisible(boolean b) {
        this.propertySupport.setPropertyBool("rootHandlesVisible", b);
    }

    @Override
    public boolean isTreeChanging() {
        return this.m_treeChanging > 0;
    }

    @Override
    public void setTreeChanging(boolean b) {
        if (b) {
            ++this.m_treeChanging;
            if (this.m_treeChanging == 1) {
                this.propertySupport.setPropertiesChanging(true);
            }
        } else if (this.m_treeChanging > 0) {
            --this.m_treeChanging;
            if (this.m_treeChanging == 0) {
                try {
                    this.processChangeBuffer();
                }
                finally {
                    this.propertySupport.setPropertiesChanging(false);
                }
            }
        }
    }

    @Override
    public boolean isNodeExpanded(ITreeNode node) {
        if (node != null) {
            return node.isExpanded();
        }
        return false;
    }

    @Override
    public void setNodeExpanded(ITreeNode node, boolean b) {
        if ((node = this.resolveNode(node)) != null && node.isExpanded() != b) {
            try {
                if (b) {
                    node.ensureChildrenLoaded();
                    this.ensureParentExpanded(node.getParentNode());
                }
                node.setExpandedInternal(b);
                this.fireNodeExpanded(node, b);
            }
            catch (ProcessingException e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
            }
        }
    }

    @Override
    public boolean isAncestorNodeOf(ITreeNode parent, ITreeNode child) {
        ITreeNode t = child;
        while (t != null && t != parent) {
            t = t.getParentNode();
        }
        return t == parent;
    }

    @Override
    public boolean isAutoDiscardOnDelete() {
        return this.m_autoDiscardOnDelete;
    }

    @Override
    public void setAutoDiscardOnDelete(boolean on) {
        this.m_autoDiscardOnDelete = on;
    }

    @Override
    public void setNodeEnabledPermission(ITreeNode node, Permission p) {
        if ((node = this.resolveNode(node)) != null) {
            boolean oldValue = node.isEnabled();
            node.setEnabledPermissionInternal(p);
            boolean newValue = node.isEnabled();
            if (oldValue != newValue) {
                this.fireNodesUpdated(node.getParentNode(), new ITreeNode[]{node});
            }
        }
    }

    @Override
    public boolean isNodeEnabled(ITreeNode node) {
        if (node != null) {
            return node.isEnabled();
        }
        return false;
    }

    @Override
    public boolean isNodeEnabledGranted(ITreeNode node) {
        if (node != null) {
            return node.isEnabledGranted();
        }
        return false;
    }

    @Override
    public void setNodeEnabled(ITreeNode node, boolean b) {
        if ((node = this.resolveNode(node)) != null) {
            boolean oldValue = node.isEnabled();
            node.setEnabledInternal(b);
            boolean newValue = node.isEnabled();
            if (oldValue != newValue) {
                this.fireNodesUpdated(node.getParentNode(), new ITreeNode[]{node});
            }
        }
    }

    @Override
    public void setNodeEnabledGranted(ITreeNode node, boolean b) {
        if ((node = this.resolveNode(node)) != null) {
            boolean oldValue = node.isEnabled();
            node.setEnabledGrantedInternal(b);
            boolean newValue = node.isEnabled();
            if (oldValue != newValue) {
                this.fireNodesUpdated(node.getParentNode(), new ITreeNode[]{node});
            }
        }
    }

    @Override
    public void setNodeVisiblePermission(ITreeNode node, Permission p) {
        if ((node = this.resolveNode(node)) != null) {
            boolean oldValue = node.isVisible();
            node.setVisiblePermissionInternal(p);
            boolean bl = node.isVisible();
        }
    }

    @Override
    public boolean isNodeVisible(ITreeNode node) {
        if (node != null) {
            return node.isVisible();
        }
        return false;
    }

    @Override
    public boolean isNodeVisibleGranted(ITreeNode node) {
        if (node != null) {
            return node.isVisibleGranted();
        }
        return false;
    }

    @Override
    public void setNodeVisible(ITreeNode node, boolean b) {
        if ((node = this.resolveNode(node)) != null) {
            boolean oldValue = node.isVisible();
            node.setVisibleInternal(b);
            boolean bl = node.isVisible();
        }
    }

    @Override
    public void setNodeVisibleGranted(ITreeNode node, boolean b) {
        if ((node = this.resolveNode(node)) != null) {
            boolean oldValue = node.isVisible();
            node.setVisibleGrantedInternal(b);
            boolean bl = node.isVisible();
        }
    }

    @Override
    public boolean isNodeLeaf(ITreeNode node) {
        if (node != null) {
            return node.isLeaf();
        }
        return false;
    }

    @Override
    public void setNodeLeaf(ITreeNode node, boolean b) {
        if ((node = this.resolveNode(node)) != null && node.isLeaf() != b) {
            node.setLeafInternal(b);
            this.fireNodesUpdated(node.getParentNode(), new ITreeNode[]{node});
        }
    }

    @Override
    public boolean isNodeChecked(ITreeNode node) {
        if (node != null) {
            return node.isChecked();
        }
        return false;
    }

    @Override
    public void setNodeChecked(ITreeNode node, boolean b) {
        if ((node = this.resolveNode(node)) != null && node.isChecked() != b) {
            ArrayList<ITreeNode> changedNodes = new ArrayList<ITreeNode>();
            node.setCheckedInternal(b);
            changedNodes.add(node);
            ITreeNode commonParent = node.getParentNode();
            if (b && !this.isMultiCheck()) {
                ITreeNode[] iTreeNodeArray = this.getCheckedNodes();
                int n = iTreeNodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ITreeNode cn = iTreeNodeArray[n2];
                    if (cn != node) {
                        cn.setCheckedInternal(false);
                        changedNodes.add(cn);
                    }
                    ++n2;
                }
                commonParent = TreeUtility.findLowestCommonAncestorNode(changedNodes);
            }
            this.fireNodesUpdated(commonParent, changedNodes.toArray(new ITreeNode[changedNodes.size()]));
        }
    }

    @Override
    public int getNodeStatus(ITreeNode node) {
        if (node != null) {
            return node.getStatus();
        }
        return 0;
    }

    @Override
    public void setNodeStatus(ITreeNode node, int status) {
        if ((node = this.resolveNode(node)) != null && node.getStatus() != status) {
            node.setStatusInternal(status);
            this.fireNodesUpdated(node.getParentNode(), new ITreeNode[]{node});
        }
    }

    private void ensureParentExpanded(ITreeNode parent) {
        if (parent != null) {
            this.ensureParentExpanded(parent.getParentNode());
            if (!parent.isExpanded()) {
                this.setNodeExpanded(parent, true);
            }
        }
    }

    @Override
    public void ensureVisible(ITreeNode node) {
        this.fireNodeEnsureVisible(node);
    }

    @Override
    public void expandAll(ITreeNode parent) {
        this.expandAllRec(parent, 0);
    }

    private void expandAllRec(ITreeNode parent, int level) {
        this.setNodeExpanded(parent, true);
        if (level >= 32) {
            LOG.warn("detected loop on tree node " + parent);
        } else {
            ITreeNode[] children = parent.getChildNodes();
            int i = 0;
            while (i < children.length) {
                this.expandAllRec(children[i], level + 1);
                ++i;
            }
        }
    }

    @Override
    public void collapseAll(ITreeNode parent) {
        try {
            this.setTreeChanging(true);
            ArrayList<ITreeNode> list = new ArrayList<ITreeNode>();
            this.fetchAllCollapsingNodesRec(parent, 0, list);
            int n = list.size();
            int i = n - 1;
            while (i >= 0) {
                this.setNodeExpanded(list.get(i), false);
                --i;
            }
        }
        finally {
            this.setTreeChanging(false);
        }
    }

    private void fetchAllCollapsingNodesRec(ITreeNode parent, int level, List<ITreeNode> list) {
        if (level >= 32) {
            LOG.warn("detected loop on tree node " + parent);
        } else if (parent.isExpanded()) {
            list.add(parent);
            ITreeNode[] children = parent.getChildNodes();
            int i = 0;
            while (i < children.length) {
                this.fetchAllCollapsingNodesRec(children[i], level + 1, list);
                ++i;
            }
        }
    }

    @Override
    public IKeyStroke[] getKeyStrokes() {
        IKeyStroke[] keyStrokes = (IKeyStroke[])this.propertySupport.getProperty("keyStroks");
        if (keyStrokes == null) {
            keyStrokes = new IKeyStroke[]{};
        }
        return keyStrokes;
    }

    @Override
    public void setKeyStrokes(IKeyStroke[] keyStrokes) {
        this.m_baseKeyStrokes = keyStrokes;
        this.rebuildKeyStrokesInternal();
    }

    private void setKeyStrokesInternal(IKeyStroke[] keyStrokes) {
        this.propertySupport.setProperty("keyStroks", (Object)keyStrokes);
    }

    @Override
    public void addChildNode(ITreeNode parent, ITreeNode child) {
        if (child != null) {
            this.addChildNodes(parent, new ITreeNode[]{child});
        }
    }

    @Override
    public void addChildNode(int startIndex, ITreeNode parent, ITreeNode child) {
        if (child != null) {
            this.addChildNodes(startIndex, parent, new ITreeNode[]{child});
        }
    }

    @Override
    public void addChildNodes(ITreeNode parent, ITreeNode[] children) {
        this.addChildNodes(parent.getChildNodeCount(), parent, children);
    }

    @Override
    public void addChildNodes(int startIndex, ITreeNode parent, ITreeNode[] children) {
        if (children == null || children.length == 0) {
            return;
        }
        try {
            int n;
            ITreeNode[] iTreeNodeArray;
            this.setTreeChanging(true);
            parent = this.resolveNode(parent);
            ((AbstractTreeNode)parent).addChildNodesInternal(startIndex, children, true);
            int revokeCount = 0;
            ITreeNode[] iTreeNodeArray2 = children;
            int n2 = children.length;
            int n3 = 0;
            while (n3 < n2) {
                ITreeNode child = iTreeNodeArray2[n3];
                if (child.getParentNode() == null) {
                    ++revokeCount;
                }
                ++n3;
            }
            if (revokeCount > 0) {
                ITreeNode[] newChildren = new ITreeNode[children.length - revokeCount];
                int index = 0;
                iTreeNodeArray = children;
                n = children.length;
                int n4 = 0;
                while (n4 < n) {
                    ITreeNode child = iTreeNodeArray[n4];
                    if (child.getParentNode() != null) {
                        newChildren[index++] = child;
                    }
                    ++n4;
                }
                children = newChildren;
            }
            this.decorateAffectedNodeCells(parent, children);
            int level = 0;
            ITreeNode tmp = parent;
            while (tmp != null) {
                tmp = tmp.getParentNode();
                ++level;
            }
            iTreeNodeArray = children;
            n = children.length;
            int n5 = 0;
            while (n5 < n) {
                ITreeNode child = iTreeNodeArray[n5];
                this.applyNodeFiltersRecInternal(child, parent.isFilterAccepted(), level);
                ++n5;
            }
            this.fireNodesInserted(parent, children);
        }
        finally {
            this.setTreeChanging(false);
        }
    }

    @Override
    public void updateNode(ITreeNode node) {
        this.updateChildNodes(node.getParentNode(), new ITreeNode[]{node});
    }

    @Override
    public void updateChildNodes(ITreeNode parent, ITreeNode[] children) {
        try {
            this.setTreeChanging(true);
            parent = this.resolveNode(parent);
            children = this.resolveNodes(children);
            this.decorateAffectedNodeCells(parent, children);
            this.fireNodesUpdated(parent, children);
        }
        finally {
            this.setTreeChanging(false);
        }
    }

    @Override
    public void updateChildNodeOrder(ITreeNode parent, ITreeNode[] newChildren) {
        try {
            this.setTreeChanging(true);
            parent = this.resolveNode(parent);
            ITreeNode[] newChildrenResolved = this.resolveNodes(newChildren);
            if (newChildren.length > 0 && newChildrenResolved.length == newChildren.length) {
                ((AbstractTreeNode)parent).setChildNodeOrderInternal(newChildrenResolved);
                this.decorateAffectedNodeCells(parent, newChildrenResolved);
                this.fireChildNodeOrderChanged(parent, newChildrenResolved);
            }
        }
        finally {
            this.setTreeChanging(false);
        }
    }

    @Override
    public void removeNode(ITreeNode node) {
        ITreeNode parent = node.getParentNode();
        ITreeNode child = node;
        this.removeChildNode(parent, child);
    }

    @Override
    public void removeChildNode(ITreeNode parent, ITreeNode child) {
        this.removeChildNodes(parent, new ITreeNode[]{child});
    }

    @Override
    public void removeChildNodes(ITreeNode parent, ITreeNode[] children) {
        if (children == null || children.length == 0) {
            return;
        }
        try {
            this.setTreeChanging(true);
            parent = this.resolveNode(parent);
            if (parent == null) {
                return;
            }
            children = this.resolveNodes(children);
            this.deselectNodes(children);
            ((AbstractTreeNode)parent).removeChildNodesInternal(children, true);
            this.decorateAffectedNodeCells(parent, parent.getChildNodes());
            if (!this.isAutoDiscardOnDelete()) {
                int i = 0;
                while (i < children.length) {
                    if (children[i].getStatus() != 1) {
                        children[i].setStatusInternal(3);
                        this.m_deletedNodes.put(children[i].getPrimaryKey(), children[i]);
                    }
                    ++i;
                }
            }
            int level = 0;
            ITreeNode tmp = parent;
            while (tmp != null) {
                tmp = tmp.getParentNode();
                ++level;
            }
            ITreeNode[] iTreeNodeArray = parent.getChildNodes();
            int n = iTreeNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeNode child = iTreeNodeArray[n2];
                this.applyNodeFiltersRecInternal(child, parent.isFilterAccepted(), level);
                ++n2;
            }
            this.fireNodesDeleted(parent, children);
        }
        finally {
            this.setTreeChanging(false);
        }
    }

    @Override
    public void removeAllChildNodes(ITreeNode parent) {
        if (parent != null) {
            this.removeChildNodes(parent, parent.getChildNodes());
        }
    }

    @Override
    public void clearDeletedNodes() {
        Iterator<ITreeNode> it = this.m_deletedNodes.values().iterator();
        while (it.hasNext()) {
            it.next().setTreeInternal(null, true);
        }
        this.m_deletedNodes.clear();
    }

    @Override
    public ITreeNode[] resolveVirtualNodes(ITreeNode[] nodes) throws ProcessingException {
        if (nodes == null) {
            return new ITreeNode[0];
        }
        try {
            this.setTreeChanging(true);
            ArrayList<ITreeNode> resolvedNodes = new ArrayList<ITreeNode>(nodes.length);
            int i = 0;
            while (i < nodes.length) {
                ITreeNode resolvedNode = this.resolveVirtualNode(nodes[i]);
                if (resolvedNode != null) {
                    resolvedNodes.add(resolvedNode);
                }
                ++i;
            }
            ITreeNode[] iTreeNodeArray = resolvedNodes.toArray(new ITreeNode[resolvedNodes.size()]);
            return iTreeNodeArray;
        }
        finally {
            this.setTreeChanging(false);
        }
    }

    @Override
    public ITreeNode resolveVirtualNode(ITreeNode node) throws ProcessingException {
        if (node instanceof IVirtualTreeNode) {
            IVirtualTreeNode vnode = (IVirtualTreeNode)node;
            if (vnode.getResolvedNode() != null && vnode.getResolvedNode().getTree() == this) {
                return vnode.getResolvedNode();
            }
            if (vnode.getTree() != this) {
                return null;
            }
            ITreeNode parentNode = vnode.getParentNode();
            if (parentNode == null) {
                return null;
            }
            try {
                this.setTreeChanging(true);
                ITreeNode resolvedNode = parentNode.resolveVirtualChildNode(vnode);
                if (resolvedNode != vnode && vnode.getResolvedNode() == null) {
                    vnode.setResolvedNode(resolvedNode);
                }
                ITreeNode iTreeNode = resolvedNode;
                return iTreeNode;
            }
            finally {
                this.setTreeChanging(false);
            }
        }
        return node;
    }

    @Override
    public boolean visitTree(ITreeVisitor v) {
        return this.visitNodeRec(this.getRootNode(), v);
    }

    @Override
    public boolean visitNode(ITreeNode node, ITreeVisitor v) {
        return this.visitNodeRec(node, v);
    }

    private boolean visitNodeRec(ITreeNode node, ITreeVisitor v) {
        if (node == null) {
            return true;
        }
        boolean b = v.visit(node);
        if (!b) {
            return b;
        }
        ITreeNode[] a = node.getChildNodes();
        int i = 0;
        while (i < a.length) {
            if (a[i].getTree() != null && !(b = this.visitNodeRec(a[i], v))) {
                return b;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean visitVisibleTree(ITreeVisitor v) {
        return this.visitVisibleNodeRec(this.getRootNode(), v, this.isRootNodeVisible());
    }

    private boolean visitVisibleNodeRec(ITreeNode node, ITreeVisitor v, boolean includeParent) {
        if (node.isVisible()) {
            boolean b;
            if (includeParent && !(b = v.visit(node))) {
                return b;
            }
            if (node.isExpanded()) {
                ITreeNode[] a = node.getFilteredChildNodes();
                int i = 0;
                while (i < a.length) {
                    boolean b2;
                    if (a[i].getTree() != null && !(b2 = this.visitVisibleNodeRec(a[i], v, true))) {
                        return b2;
                    }
                    ++i;
                }
            }
        }
        return true;
    }

    @Override
    public int getDeletedNodeCount() {
        return this.m_deletedNodes.size();
    }

    @Override
    public ITreeNode[] getDeletedNodes() {
        return this.m_deletedNodes.values().toArray(new ITreeNode[0]);
    }

    @Override
    public int getInsertedNodeCount() {
        P_AbstractCountingTreeVisitor v = new P_AbstractCountingTreeVisitor(){

            @Override
            public boolean visit(ITreeNode node) {
                if (node.isStatusInserted()) {
                    this.addCount(1);
                }
                return true;
            }
        };
        this.visitNode(this.getRootNode(), v);
        return v.getCount();
    }

    @Override
    public ITreeNode[] getInsertedNodes() {
        P_AbstractCollectingTreeVisitor v = new P_AbstractCollectingTreeVisitor(){

            @Override
            public boolean visit(ITreeNode node) {
                if (node.isStatusInserted()) {
                    this.addNodeToList(node);
                }
                return true;
            }
        };
        this.visitNode(this.getRootNode(), v);
        return v.getNodes();
    }

    @Override
    public int getUpdatedNodeCount() {
        P_AbstractCountingTreeVisitor v = new P_AbstractCountingTreeVisitor(){

            @Override
            public boolean visit(ITreeNode node) {
                if (node.isStatusUpdated()) {
                    this.addCount(1);
                }
                return true;
            }
        };
        this.visitNode(this.getRootNode(), v);
        return v.getCount();
    }

    @Override
    public ITreeNode[] getUpdatedNodes() {
        P_AbstractCollectingTreeVisitor v = new P_AbstractCollectingTreeVisitor(){

            @Override
            public boolean visit(ITreeNode node) {
                if (node.isStatusUpdated()) {
                    this.addNodeToList(node);
                }
                return true;
            }
        };
        this.visitNode(this.getRootNode(), v);
        return v.getNodes();
    }

    @Override
    public int getSelectedNodeCount() {
        return this.m_selectedNodes.size();
    }

    @Override
    public ITreeNode getSelectedNode() {
        if (this.m_selectedNodes.size() > 0) {
            return this.m_selectedNodes.iterator().next();
        }
        return null;
    }

    @Override
    public ITreeNode[] getSelectedNodes() {
        return this.m_selectedNodes.toArray(new ITreeNode[0]);
    }

    @Override
    public boolean isSelectedNode(ITreeNode node) {
        if ((node = this.resolveNode(node)) != null) {
            return this.m_selectedNodes.contains(node);
        }
        return false;
    }

    @Override
    public void selectNode(ITreeNode node) {
        this.selectNode(node, false);
    }

    @Override
    public void selectNode(ITreeNode node, boolean append) {
        if (node != null) {
            this.selectNodes(new ITreeNode[]{node}, append);
        } else {
            this.selectNodes(new ITreeNode[0], append);
        }
    }

    @Override
    public void selectNodes(ITreeNode[] nodes, boolean append) {
        nodes = this.resolveNodes(nodes);
        try {
            nodes = this.resolveVirtualNodes(nodes);
        }
        catch (ProcessingException e) {
            LOG.warn("could not resolve virtual nodes.", (Throwable)e);
        }
        if (nodes == null) {
            nodes = new ITreeNode[]{};
        }
        HashSet<ITreeNode> newSelection = new HashSet<ITreeNode>();
        if (append) {
            newSelection.addAll(this.m_selectedNodes);
            newSelection.addAll(Arrays.asList(nodes));
        } else {
            newSelection.addAll(Arrays.asList(nodes));
        }
        if (newSelection.size() > 1 && !this.isMultiSelect()) {
            ITreeNode first = (ITreeNode)newSelection.iterator().next();
            newSelection.clear();
            newSelection.add(first);
        }
        if (!this.m_selectedNodes.equals(newSelection) || !this.m_selectedNodes.containsAll(Arrays.asList(nodes))) {
            HashSet<ITreeNode> oldSelection = this.m_selectedNodes;
            this.fireBeforeNodesSelected(oldSelection, newSelection);
            this.m_selectedNodes = newSelection;
            this.fireNodesSelected(oldSelection, this.m_selectedNodes);
        }
    }

    @Override
    public void selectNextNode() {
        final ITreeNode current = this.getSelectedNode();
        if (current != null) {
            final Holder foundVisited = new Holder(ITreeNode.class);
            ITreeVisitor v = new ITreeVisitor(){
                boolean foundCurrent;

                @Override
                public boolean visit(ITreeNode node) {
                    if (this.foundCurrent) {
                        if (node.isFilterAccepted()) {
                            foundVisited.setValue((Object)node);
                        }
                        return foundVisited.getValue() == null;
                    }
                    if (node == current) {
                        this.foundCurrent = true;
                    }
                    return true;
                }
            };
            this.visitVisibleTree(v);
            if (foundVisited.getValue() != null) {
                this.selectNode((ITreeNode)foundVisited.getValue());
            }
        } else {
            this.selectFirstNode();
        }
    }

    @Override
    public void selectPreviousNode() {
        final ITreeNode current = this.getSelectedNode();
        if (current != null) {
            final Holder foundVisited = new Holder(ITreeNode.class);
            ITreeVisitor v = new ITreeVisitor(){
                boolean foundCurrent;

                @Override
                public boolean visit(ITreeNode node) {
                    if (this.foundCurrent) {
                        return false;
                    }
                    if (node == current) {
                        this.foundCurrent = true;
                    } else if (node.isFilterAccepted()) {
                        foundVisited.setValue((Object)node);
                    }
                    return true;
                }
            };
            this.visitVisibleTree(v);
            if (foundVisited.getValue() != null) {
                this.selectNode((ITreeNode)foundVisited.getValue());
            }
        } else {
            this.selectLastNode();
        }
    }

    @Override
    public void selectFirstNode() {
        if (!this.isRootNodeVisible()) {
            try {
                this.getRootNode().ensureChildrenLoaded();
            }
            catch (ProcessingException e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
            }
        }
        final Holder foundVisited = new Holder(ITreeNode.class);
        ITreeVisitor v = new ITreeVisitor(){

            @Override
            public boolean visit(ITreeNode node) {
                if (foundVisited.getValue() != null) {
                    return false;
                }
                if (node.isFilterAccepted()) {
                    foundVisited.setValue((Object)node);
                }
                return true;
            }
        };
        this.visitVisibleTree(v);
        if (foundVisited.getValue() != null) {
            this.selectNode((ITreeNode)foundVisited.getValue());
        }
    }

    @Override
    public void selectLastNode() {
        if (!this.isRootNodeVisible()) {
            try {
                this.getRootNode().ensureChildrenLoaded();
            }
            catch (ProcessingException e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
            }
        }
        final Holder foundVisited = new Holder(ITreeNode.class);
        ITreeVisitor v = new ITreeVisitor(){

            @Override
            public boolean visit(ITreeNode node) {
                if (node.isFilterAccepted()) {
                    foundVisited.setValue((Object)node);
                }
                return true;
            }
        };
        this.visitVisibleTree(v);
        if (foundVisited.getValue() != null) {
            this.selectNode((ITreeNode)foundVisited.getValue());
        }
    }

    @Override
    public void selectNextChildNode() {
        ITreeNode current = this.getSelectedNode();
        if (current != null) {
            current.setExpanded(true);
        }
        this.selectNextNode();
    }

    @Override
    public void selectPreviousParentNode() {
        ITreeNode n = this.getSelectedNode();
        if (n != null) {
            ITreeNode parent = n.getParentNode();
            while (parent != null) {
                if ((parent != this.getRootNode() || this.isRootNodeVisible()) && parent.isFilterAccepted()) {
                    this.selectNode(parent);
                    return;
                }
                parent = parent.getParentNode();
            }
        } else {
            this.selectFirstNode();
        }
    }

    @Override
    public void deselectNode(ITreeNode node) {
        if (node != null) {
            this.deselectNodes(new ITreeNode[]{node});
        } else {
            this.deselectNodes(new ITreeNode[0]);
        }
    }

    @Override
    public void deselectNodes(ITreeNode[] nodes) {
        if ((nodes = this.resolveNodes(nodes)) != null && nodes.length > 0) {
            HashSet<ITreeNode> oldSelection = new HashSet<ITreeNode>(this.m_selectedNodes);
            HashSet<ITreeNode> newSelection = new HashSet<ITreeNode>();
            if (this.m_selectedNodes != null) {
                for (ITreeNode selChild : this.m_selectedNodes) {
                    boolean accept = true;
                    ITreeNode[] iTreeNodeArray = nodes;
                    int n = nodes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ITreeNode delParent = iTreeNodeArray[n2];
                        if (this.isAncestorNodeOf(delParent, selChild)) {
                            accept = false;
                            break;
                        }
                        ++n2;
                    }
                    if (!accept) continue;
                    newSelection.add(selChild);
                }
            }
            if (oldSelection.size() != newSelection.size()) {
                this.fireBeforeNodesSelected(oldSelection, newSelection);
                this.m_selectedNodes = newSelection;
                this.fireNodesSelected(oldSelection, this.m_selectedNodes);
            }
        }
    }

    @Override
    public ITreeNode[] getCheckedNodes() {
        final ArrayList list = new ArrayList();
        this.visitTree(new ITreeVisitor(){

            @Override
            public boolean visit(ITreeNode node) {
                if (node.isChecked()) {
                    list.add(node);
                }
                return true;
            }
        });
        return list.toArray(new ITreeNode[list.size()]);
    }

    @Override
    public boolean isScrollToSelection() {
        return this.propertySupport.getPropertyBool("scrollToSelection");
    }

    @Override
    public void setScrollToSelection(boolean b) {
        this.propertySupport.setPropertyBool("scrollToSelection", b);
    }

    @Override
    public void scrollToSelection() {
        this.fireTreeEventInternal(new TreeEvent(this, 830));
    }

    private ITreeNode resolveNode(ITreeNode node) {
        if (node instanceof IVirtualTreeNode && ((IVirtualTreeNode)node).getResolvedNode() != null) {
            node = ((IVirtualTreeNode)node).getResolvedNode();
        }
        if (node == null) {
            return null;
        }
        if (node.getTree() == this) {
            return node;
        }
        return null;
    }

    private ITreeNode[] resolveNodes(ITreeNode[] nodes) {
        if (nodes == null) {
            return new ITreeNode[0];
        }
        int mismatchCount = 0;
        int i = 0;
        while (i < nodes.length) {
            if (this.resolveNode(nodes[i]) == null) {
                ++mismatchCount;
            }
            ++i;
        }
        if (mismatchCount > 0) {
            ITreeNode[] resolvedNodes = new ITreeNode[nodes.length - mismatchCount];
            int index = 0;
            int i2 = 0;
            while (i2 < nodes.length) {
                if (this.resolveNode(nodes[i2]) != null) {
                    resolvedNodes[index] = nodes[i2];
                    ++index;
                }
                ++i2;
            }
            nodes = resolvedNodes;
        }
        return nodes;
    }

    @Override
    public void addTreeListener(TreeListener listener) {
        this.m_listenerList.add(TreeListener.class, (EventListener)listener);
    }

    @Override
    public void removeTreeListener(TreeListener listener) {
        this.m_listenerList.remove(TreeListener.class, (EventListener)listener);
    }

    @Override
    public void addUITreeListener(TreeListener listener) {
        this.m_listenerList.insertAtFront(TreeListener.class, (EventListener)listener);
    }

    protected IEventHistory<TreeEvent> createEventHistory() {
        return new DefaultTreeEventHistory(5000L);
    }

    @Override
    public IEventHistory<TreeEvent> getEventHistory() {
        return this.m_eventHistory;
    }

    private void fireNodesInserted(ITreeNode parent, ITreeNode[] children) {
        if (children.length > 0) {
            this.fireTreeEventInternal(new TreeEvent(this, 10, parent, children));
        }
    }

    private void fireNodesUpdated(ITreeNode parent, ITreeNode[] children) {
        if (children.length > 0) {
            this.fireTreeEventInternal(new TreeEvent(this, 20, parent, children));
        }
    }

    private void fireNodeFilterChanged() {
        this.fireTreeEventInternal(new TreeEvent((ITree)this, 400, this.getRootNode()));
    }

    private void fireNodesDeleted(ITreeNode parent, ITreeNode[] children) {
        if (children.length > 0) {
            this.fireTreeEventInternal(new TreeEvent(this, 30, parent, children));
        }
    }

    private void fireChildNodeOrderChanged(ITreeNode parent, ITreeNode[] children) {
        if (children.length > 0) {
            this.fireTreeEventInternal(new TreeEvent(this, 50, parent, children));
        }
    }

    private void fireBeforeNodesSelected(Set<ITreeNode> oldSelection, Set<ITreeNode> newSelection) {
        ITreeNode[] nodes = newSelection.toArray(new ITreeNode[newSelection.size()]);
        TreeEvent e = new TreeEvent((ITree)this, 35, nodes);
        HashSet<ITreeNode> deselectedNodes = new HashSet<ITreeNode>(oldSelection);
        deselectedNodes.removeAll(newSelection);
        e.setDeselectedNodes(deselectedNodes.toArray(new ITreeNode[deselectedNodes.size()]));
        HashSet<ITreeNode> newSelectedNodes = new HashSet<ITreeNode>(newSelection);
        newSelectedNodes.removeAll(oldSelection);
        e.setNewSelectedNodes(newSelectedNodes.toArray(new ITreeNode[newSelectedNodes.size()]));
        this.fireTreeEventInternal(e);
    }

    private void fireNodesSelected(Set<ITreeNode> oldSelection, Set<ITreeNode> newSelection) {
        if (this.isAutoTitle()) {
            this.rebuildTitleInternal();
        }
        ITreeNode[] nodes = newSelection.toArray(new ITreeNode[newSelection.size()]);
        TreeEvent e = new TreeEvent((ITree)this, 40, nodes);
        HashSet<ITreeNode> deselectedNodes = new HashSet<ITreeNode>(oldSelection);
        deselectedNodes.removeAll(newSelection);
        e.setDeselectedNodes(deselectedNodes.toArray(new ITreeNode[deselectedNodes.size()]));
        HashSet<ITreeNode> newSelectedNodes = new HashSet<ITreeNode>(newSelection);
        newSelectedNodes.removeAll(oldSelection);
        e.setNewSelectedNodes(newSelectedNodes.toArray(new ITreeNode[newSelectedNodes.size()]));
        try {
            this.execNodesSelected(e);
        }
        catch (ProcessingException ex) {
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(ex);
        }
        catch (Throwable t) {
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Unexpected", t));
        }
        this.fireTreeEventInternal(e);
    }

    private void fireNodeExpanded(ITreeNode node, boolean b) {
        if (node != null) {
            if (b) {
                this.fireTreeEventInternal(new TreeEvent((ITree)this, 100, node));
            } else {
                this.fireTreeEventInternal(new TreeEvent((ITree)this, 101, node));
            }
        }
    }

    @Override
    public IMenu[] fetchMenusForNodesInternal(ITreeNode[] nodes) {
        TreeEvent e = new TreeEvent((ITree)this, 700, nodes);
        this.addLocalPopupMenus(e);
        this.fireTreeEventInternal(e);
        ArrayList<IMenu> nodeMenus = new ArrayList<IMenu>();
        ArrayList<IMenu> emptySpaceMenus = new ArrayList<IMenu>();
        IMenu[] iMenuArray = e.getPopupMenus();
        int n = iMenuArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMenu menu = iMenuArray[n2];
            if (menu.isVisible()) {
                if (menu.isEmptySpaceAction()) {
                    emptySpaceMenus.add(menu);
                } else {
                    nodeMenus.add(menu);
                }
            }
            ++n2;
        }
        if (nodeMenus.size() > 0 && emptySpaceMenus.size() > 0) {
            nodeMenus.add(0, new MenuSeparator());
        }
        nodeMenus.addAll(0, emptySpaceMenus);
        return nodeMenus.toArray(new IMenu[nodeMenus.size()]);
    }

    private void fireNodeClick(ITreeNode node) {
        if (node != null) {
            try {
                this.interceptNodeClickSingleObserver(node);
                this.execNodeClick(node);
            }
            catch (ProcessingException ex) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(ex);
            }
            catch (Throwable t) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Unexpected", t));
            }
        }
    }

    protected void interceptNodeClickSingleObserver(ITreeNode node) {
        if (this.isCheckable() && node.isEnabled() && this.isEnabled()) {
            node.setChecked(!node.isChecked());
        }
    }

    private void fireNodeAction(ITreeNode node) {
        if (node != null && node.isLeaf()) {
            try {
                this.execNodeAction(node);
            }
            catch (ProcessingException ex) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(ex);
            }
            catch (Throwable t) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("Unexpected", t));
            }
        }
    }

    private void fireRequestFocus() {
        TreeEvent e = new TreeEvent(this, 800);
        this.fireTreeEventInternal(e);
    }

    private void addLocalPopupMenus(TreeEvent e) {
        IMenu m;
        int selectionCount = e.getNodes().length;
        ArrayList<IMenu> list = new ArrayList<IMenu>();
        IMenu[] iMenuArray = this.getMenus();
        int n = iMenuArray.length;
        int n2 = 0;
        while (n2 < n) {
            m = iMenuArray[n2];
            if (!m.isInheritAccessibility() || this.isEnabled()) {
                m.prepareAction();
                if (m.isVisible()) {
                    list.add(m);
                }
            }
            ++n2;
        }
        if (e.getNode() != null) {
            iMenuArray = e.getNode().getMenus();
            n = iMenuArray.length;
            n2 = 0;
            while (n2 < n) {
                m = iMenuArray[n2];
                if (!m.isInheritAccessibility() || e.getNode().isEnabled() && this.isEnabled()) {
                    m.prepareAction();
                    if (m.isVisible()) {
                        list.add(m);
                    }
                }
                ++n2;
            }
        }
        for (IMenu menu : list) {
            if (selectionCount > 1 && menu.isMultiSelectionAction()) {
                e.addPopupMenu(menu);
                continue;
            }
            if (selectionCount == 1 && menu.isSingleSelectionAction()) {
                e.addPopupMenu(menu);
                continue;
            }
            if (selectionCount != 0 || !menu.isEmptySpaceAction()) continue;
            e.addPopupMenu(menu);
        }
    }

    private TransferObject fireNodesDragRequest(ITreeNode[] nodes) {
        if (nodes != null && nodes.length > 0) {
            TreeEvent e = new TreeEvent((ITree)this, 730, nodes);
            this.fireTreeEventInternal(e);
            return e.getDragObject();
        }
        return null;
    }

    private void fireNodeDropAction(ITreeNode node, TransferObject dropData) {
        TreeEvent e = new TreeEvent((ITree)this, 740, node);
        e.setDropObject(dropData);
        this.fireTreeEventInternal(e);
    }

    private void fireNodeRequestFocus(ITreeNode node) {
        TreeEvent e = new TreeEvent((ITree)this, 200, node);
        this.fireTreeEventInternal(e);
    }

    private void fireNodeEnsureVisible(ITreeNode node) {
        TreeEvent e = new TreeEvent((ITree)this, 300, node);
        this.fireTreeEventInternal(e);
    }

    protected void fireTreeEventInternal(TreeEvent e) {
        if (this.isTreeChanging()) {
            this.m_treeEventBuffer.add(e);
        } else {
            EventListener[] listeners = this.m_listenerList.getListeners(TreeListener.class);
            if (listeners != null && listeners.length > 0) {
                int i = 0;
                while (i < listeners.length) {
                    try {
                        ((TreeListener)listeners[i]).treeChanged(e);
                    }
                    catch (Throwable t) {
                        LOG.error("fire " + e, t);
                    }
                    ++i;
                }
            }
        }
    }

    private void fireTreeEventBatchInternal(TreeEvent[] batch) {
        if (batch.length == 0) {
            return;
        }
        EventListener[] listeners = this.m_listenerList.getListeners(TreeListener.class);
        if (listeners != null && listeners.length > 0) {
            int i = 0;
            while (i < listeners.length) {
                ((TreeListener)listeners[i]).treeChangedBatch(batch);
                ++i;
            }
        }
    }

    private void decorateAffectedNodeCells(ITreeNode parent, ITreeNode[] children) {
        this.decorateAffectedNodeCellsOnPathToRoot(parent);
        ITreeNode[] iTreeNodeArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ITreeNode child = iTreeNodeArray[n2];
            this.decorateAffectedNodeCellsOnSubtree(child);
            ++n2;
        }
    }

    private void decorateAffectedNodeCellsOnPathToRoot(ITreeNode node) {
        ITreeNode tmp = node;
        while (tmp != null) {
            this.m_nodeDecorationBuffer.add(tmp);
            tmp = tmp.getParentNode();
        }
    }

    private void decorateAffectedNodeCellsOnSubtree(ITreeNode node) {
        this.m_nodeDecorationBuffer.add(node);
        ITreeNode[] iTreeNodeArray = node.getChildNodes();
        int n = iTreeNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITreeNode child = iTreeNodeArray[n2];
            this.decorateAffectedNodeCellsOnSubtree(child);
            ++n2;
        }
    }

    private void processChangeBuffer() {
        block14: {
            try {
                ++this.m_processChangeBufferLoopDetection;
                if (this.m_processChangeBufferLoopDetection > 100) {
                    LOG.error("LOOP DETECTION in " + this.getClass() + ". see stack trace for more details.", (Throwable)new Exception("LOOP DETECTION"));
                    return;
                }
                if (this.m_nodeDecorationBuffer.size() > 0) {
                    HashSet<ITreeNode> set = this.m_nodeDecorationBuffer;
                    this.m_nodeDecorationBuffer = new HashSet();
                    for (ITreeNode node : set) {
                        if (node.getTree() == null) continue;
                        try {
                            this.execDecorateCell(node, node.getCellForUpdate());
                        }
                        catch (Throwable t) {
                            LOG.warn("node " + node.getClass() + " " + node.getCell().getText(), t);
                        }
                    }
                }
                if (this.m_treeEventBuffer.size() <= 0) break block14;
                ArrayList<TreeEvent> list = this.m_treeEventBuffer;
                this.m_treeEventBuffer = new ArrayList();
                boolean foundSelectionEvent = false;
                ListIterator<TreeEvent> it = list.listIterator(list.size());
                while (it.hasPrevious()) {
                    if (it.previous().getType() != 40) continue;
                    if (!foundSelectionEvent) {
                        foundSelectionEvent = true;
                        continue;
                    }
                    it.remove();
                }
                try {
                    this.setTreeChanging(true);
                    this.fireTreeEventBatchInternal(list.toArray(new TreeEvent[list.size()]));
                }
                finally {
                    this.setTreeChanging(false);
                }
            }
            finally {
                --this.m_processChangeBufferLoopDetection;
            }
        }
    }

    @Override
    public boolean isMultiSelect() {
        return this.propertySupport.getPropertyBool("multiSelect");
    }

    @Override
    public void setMultiSelect(boolean b) {
        this.propertySupport.setPropertyBool("multiSelect", b);
    }

    @Override
    public boolean isMultiCheck() {
        return this.propertySupport.getPropertyBool("multiCheck");
    }

    @Override
    public void setMultiCheck(boolean b) {
        this.propertySupport.setPropertyBool("multiCheck", b);
    }

    @Override
    public void unloadNode(ITreeNode node) throws ProcessingException {
        try {
            this.setTreeChanging(true);
            this.setNodeExpanded(node, false);
            this.removeAllChildNodes(node);
            node.setChildrenLoaded(false);
        }
        finally {
            this.setTreeChanging(false);
        }
    }

    @Override
    public void doHyperlinkAction(ITreeNode node, URL url) throws ProcessingException {
        if (node != null) {
            this.selectNode(node);
            this.execHyperlinkAction(url, url.getPath(), url != null && url.getHost().equals("local"));
        }
    }

    @Override
    public void exportTreeData(AbstractTreeFieldData target) throws ProcessingException {
        this.exportTreeNodeDataRec(this.getRootNode().getChildNodes(), target, null);
    }

    private void exportTreeNodeDataRec(ITreeNode[] nodes, AbstractTreeFieldData treeData, TreeNodeData parentNodeData) throws ProcessingException {
        ArrayList<TreeNodeData> nodeDataList = new ArrayList<TreeNodeData>();
        ITreeNode[] iTreeNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            ITreeNode node = iTreeNodeArray[n2];
            TreeNodeData nodeData = this.exportTreeNodeData(node, treeData);
            if (nodeData != null) {
                this.exportTreeNodeDataRec(node.getChildNodes(), treeData, nodeData);
                nodeDataList.add(nodeData);
            }
            ++n2;
        }
        if (parentNodeData != null) {
            parentNodeData.setChildNodes(nodeDataList);
        } else {
            treeData.setRoots(nodeDataList);
        }
    }

    protected TreeNodeData exportTreeNodeData(ITreeNode node, AbstractTreeFieldData treeData) throws ProcessingException {
        TreeNodeData nodeData = new TreeNodeData();
        return nodeData;
    }

    @Override
    public void importTreeData(AbstractTreeFieldData source) throws ProcessingException {
        if (source.isValueSet()) {
            try {
                this.setTreeChanging(true);
                this.removeAllChildNodes(this.getRootNode());
                this.importTreeNodeDataRec(this.getRootNode(), source, source.getRoots());
            }
            finally {
                this.setTreeChanging(false);
            }
        }
    }

    private void importTreeNodeDataRec(ITreeNode parentNode, AbstractTreeFieldData treeData, List<TreeNodeData> nodeDataList) throws ProcessingException {
        if (nodeDataList != null) {
            for (TreeNodeData nodeData : nodeDataList) {
                ITreeNode node = this.importTreeNodeData(parentNode, treeData, nodeData);
                if (node == null) continue;
                this.importTreeNodeDataRec(node, treeData, nodeData.getChildNodes());
            }
        }
    }

    protected ITreeNode importTreeNodeData(ITreeNode parentNode, AbstractTreeFieldData treeData, TreeNodeData nodeData) throws ProcessingException {
        return null;
    }

    @Override
    public ITreeUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    private abstract class P_AbstractCollectingTreeVisitor
    implements ITreeVisitor {
        private final ArrayList<ITreeNode> m_list = new ArrayList();

        private P_AbstractCollectingTreeVisitor() {
        }

        protected void addNodeToList(ITreeNode node) {
            this.m_list.add(node);
        }

        public ITreeNode[] getNodes() {
            return this.m_list.toArray(new ITreeNode[0]);
        }
    }

    private abstract class P_AbstractCountingTreeVisitor
    implements ITreeVisitor {
        private int m_count;

        private P_AbstractCountingTreeVisitor() {
        }

        protected void addCount(int n) {
            this.m_count += n;
        }

        public int getCount() {
            return this.m_count;
        }
    }

    private class P_UIFacade
    implements ITreeUIFacade {
        private int m_uiProcessorCount = 0;

        private P_UIFacade() {
        }

        protected void pushUIProcessor() {
            ++this.m_uiProcessorCount;
        }

        protected void popUIProcessor() {
            --this.m_uiProcessorCount;
        }

        @Override
        public boolean isUIProcessing() {
            return this.m_uiProcessorCount > 0;
        }

        @Override
        public void setNodeExpandedFromUI(ITreeNode node, boolean on) {
            try {
                try {
                    this.pushUIProcessor();
                    try {
                        AbstractTree.this.setTreeChanging(true);
                        node = AbstractTree.this.resolveNode(node);
                        node = AbstractTree.this.resolveVirtualNode(node);
                        if (node != null && node.isExpanded() != on) {
                            if (on && (node.isChildrenDirty() || node.isChildrenVolatile())) {
                                node.loadChildren();
                            }
                            AbstractTree.this.setNodeExpanded(node, on);
                        }
                    }
                    finally {
                        AbstractTree.this.setTreeChanging(false);
                    }
                }
                catch (ProcessingException se) {
                    se.addContextMessage(node.getCell().getText());
                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(se);
                    this.popUIProcessor();
                }
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void setNodeSelectedAndExpandedFromUI(ITreeNode node) {
            try {
                try {
                    this.pushUIProcessor();
                    try {
                        AbstractTree.this.setTreeChanging(true);
                        node = AbstractTree.this.resolveNode(node);
                        node = AbstractTree.this.resolveVirtualNode(node);
                        if (node != null) {
                            if (node.isChildrenDirty() || node.isChildrenVolatile()) {
                                node.loadChildren();
                            }
                            AbstractTree.this.setNodeExpanded(node, true);
                            AbstractTree.this.selectNode(node, false);
                            if (!AbstractTree.this.isScrollToSelection()) {
                                AbstractTree.this.scrollToSelection();
                            }
                        }
                    }
                    finally {
                        AbstractTree.this.setTreeChanging(false);
                    }
                }
                catch (ProcessingException se) {
                    se.addContextMessage(node.getCell().getText());
                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(se);
                    this.popUIProcessor();
                }
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void setNodesSelectedFromUI(ITreeNode[] nodes) {
            try {
                try {
                    this.pushUIProcessor();
                    try {
                        AbstractTree.this.setTreeChanging(true);
                        HashSet<ITreeNode> requestedNodes = new HashSet<ITreeNode>(Arrays.asList(AbstractTree.this.resolveVirtualNodes(AbstractTree.this.resolveNodes(nodes))));
                        for (ITreeNode node : requestedNodes) {
                            if (!node.isChildrenLoaded() || !node.isChildrenDirty() && !node.isChildrenVolatile()) continue;
                            node.loadChildren();
                        }
                        ArrayList<ITreeNode> validNodes = new ArrayList<ITreeNode>();
                        if (AbstractTree.this.isMultiSelect()) {
                            ITreeNode[] iTreeNodeArray = AbstractTree.this.getSelectedNodes();
                            int n = iTreeNodeArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                ITreeNode node = iTreeNodeArray[n2];
                                if (!node.isFilterAccepted()) {
                                    validNodes.add(node);
                                }
                                ++n2;
                            }
                            requestedNodes.removeAll(validNodes);
                            for (ITreeNode node : requestedNodes) {
                                validNodes.add(node);
                            }
                        } else {
                            for (ITreeNode node : requestedNodes) {
                                if (!node.isFilterAccepted()) continue;
                                validNodes.add(node);
                            }
                        }
                        AbstractTree.this.selectNodes(validNodes.toArray(new ITreeNode[validNodes.size()]), false);
                    }
                    finally {
                        AbstractTree.this.setTreeChanging(false);
                    }
                }
                catch (ProcessingException se) {
                    se.addContextMessage(Arrays.asList(nodes).toString());
                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(se);
                    this.popUIProcessor();
                }
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public IMenu[] fireNodePopupFromUI() {
            try {
                this.pushUIProcessor();
                ITreeNode[] nodes = AbstractTree.this.resolveVirtualNodes(AbstractTree.this.getSelectedNodes());
                IMenu[] iMenuArray = AbstractTree.this.fetchMenusForNodesInternal(nodes);
                return iMenuArray;
            }
            catch (ProcessingException e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
                IMenu[] iMenuArray = new IMenu[]{};
                return iMenuArray;
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public IMenu[] fireEmptySpacePopupFromUI() {
            try {
                this.pushUIProcessor();
                IMenu[] iMenuArray = AbstractTree.this.fetchMenusForNodesInternal(new ITreeNode[0]);
                return iMenuArray;
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void fireNodeClickFromUI(ITreeNode node) {
            try {
                try {
                    this.pushUIProcessor();
                    node = AbstractTree.this.resolveNode(node);
                    node = AbstractTree.this.resolveVirtualNode(node);
                    if (node != null) {
                        AbstractTree.this.fireNodeClick(node);
                    }
                }
                catch (ProcessingException e) {
                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
                    this.popUIProcessor();
                }
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void fireNodeActionFromUI(ITreeNode node) {
            try {
                try {
                    this.pushUIProcessor();
                    node = AbstractTree.this.resolveNode(node);
                    node = AbstractTree.this.resolveVirtualNode(node);
                    if (node != null) {
                        AbstractTree.this.fireNodeAction(node);
                    }
                }
                catch (ProcessingException e) {
                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
                    this.popUIProcessor();
                }
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public boolean getNodesDragEnabledFromUI() {
            return AbstractTree.this.isDragEnabled();
        }

        @Override
        public TransferObject fireNodesDragRequestFromUI() {
            try {
                this.pushUIProcessor();
                ITreeNode[] nodes = AbstractTree.this.resolveVirtualNodes(AbstractTree.this.getSelectedNodes());
                TransferObject transferObject = AbstractTree.this.fireNodesDragRequest(nodes);
                return transferObject;
            }
            catch (ProcessingException e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
                return null;
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void fireNodeDropActionFromUI(ITreeNode node, TransferObject dropData) {
            try {
                try {
                    this.pushUIProcessor();
                    node = AbstractTree.this.resolveNode(node);
                    node = AbstractTree.this.resolveVirtualNode(node);
                    if (node != null) {
                        AbstractTree.this.fireNodeDropAction(node, dropData);
                    }
                }
                catch (ProcessingException e) {
                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
                    this.popUIProcessor();
                }
            }
            finally {
                this.popUIProcessor();
            }
        }

        @Override
        public void fireHyperlinkActionFromUI(ITreeNode node, URL url) {
            try {
                try {
                    this.pushUIProcessor();
                    node = AbstractTree.this.resolveNode(node);
                    node = AbstractTree.this.resolveVirtualNode(node);
                    if (node != null) {
                        AbstractTree.this.doHyperlinkAction(node, url);
                    }
                }
                catch (ProcessingException e) {
                    ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
                    this.popUIProcessor();
                }
            }
            finally {
                this.popUIProcessor();
            }
        }
    }
}

